/*
 * Decompiled with CFR 0.152.
 */
package com.ti.pagetableviewer;

import com.ti.debug.engine.IDspValue;
import java.util.List;

public interface IPageTableViewer {
    public MMUMode currentMode() throws PageTableViewerException;

    public AddressLookup lookupAddress(IDspValue var1) throws PageTableViewerException;

    public Summary summary() throws PageTableViewerException;

    public PageTableEntriesLookup lookupPageTableEntries(int var1, int[] var2, int var3, int var4) throws PageTableViewerException;

    public AddressLookup reverseLookup(IDspValue var1) throws PageTableViewerException;

    public List<AddressLookup> reverseLookupAll(IDspValue var1) throws PageTableViewerException;

    public static class PageTableViewerException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public PageTableViewerException(String message) {
            super(message);
        }
    }

    public static class Summary {
        private PageTableEntriesLookup rootPageTableEntries;
        private String toStringValue = null;
        private MMUMode mmuMode;

        public Summary(MMUMode mode, PageTableEntriesLookup pageTableEntries) {
            this.rootPageTableEntries = pageTableEntries;
            this.mmuMode = mode;
        }

        public PageTableEntriesLookup getPageTableAttributes() {
            return this.rootPageTableEntries;
        }

        public int getNumOfRootTables() {
            return this.rootPageTableEntries.getEnteries().size();
        }

        public String toString() {
            if (this.toStringValue == null) {
                StringBuilder sb = new StringBuilder();
                String summaryFormatString = "MMU mode is %s %n Number of root page tables is %s %n";
                sb.append(String.format(summaryFormatString, new Object[]{this.mmuMode, this.getNumOfRootTables()}));
                sb.append(this.rootPageTableEntries.toString());
                this.toStringValue = sb.toString();
            }
            return this.toStringValue;
        }
    }

    public static class PageTableEntriesLookup {
        private List<List<IDisplayAttribute>> entries;
        private String toStringValue = null;

        public PageTableEntriesLookup(List<List<IDisplayAttribute>> entries) {
            this.entries = entries;
        }

        public List<List<IDisplayAttribute>> getEnteries() {
            return this.entries;
        }

        public String toString() {
            if (this.toStringValue == null) {
                StringBuilder sb = new StringBuilder();
                String summaryFormatString = "%s=%s";
                for (List<IDisplayAttribute> entries : this.getEnteries()) {
                    for (IDisplayAttribute attribute : entries) {
                        sb.append(String.format(summaryFormatString, attribute.getDisplayName(), attribute.getDisplayValue()));
                        sb.append(" ");
                    }
                    sb.append(String.format("%n", new Object[0]));
                }
                this.toStringValue = sb.toString();
            }
            return this.toStringValue;
        }
    }

    public static class AddressLookup {
        private IDspValue virtualAddress;
        private IDspValue physicalAddress;
        private List<IDisplayAttribute> attributes;
        boolean succeded;
        private String toStringValue = null;
        private boolean reverse;

        public AddressLookup(IDspValue virtualAddress, IDspValue physicalAddress, List<IDisplayAttribute> PageTableEntryAttributes, boolean success, boolean reverse) {
            this.virtualAddress = virtualAddress;
            this.physicalAddress = physicalAddress;
            this.attributes = PageTableEntryAttributes;
            this.succeded = success;
            this.reverse = reverse;
        }

        private String getLookupString() {
            StringBuilder sb = new StringBuilder();
            String mappingFormatString = "Virtual Address = %s --> Physical Address = %s %n";
            if (this.succeded()) {
                sb.append(String.format(mappingFormatString, this.getVirtualAddress().toStringCStyleHex(), this.getPhysicalAddress().toStringCStyleHex()));
            } else {
                sb.append(String.format(mappingFormatString, this.getVirtualAddress().toStringCStyleHex(), "Not mapped"));
            }
            String attributeFormatString = "%s = %s %n";
            for (IDisplayAttribute attribute : this.getAttributes()) {
                sb.append(String.format(attributeFormatString, attribute.getDisplayName(), attribute.getDisplayValue()));
                if (!attribute.IsLevelMarker()) continue;
                attributeFormatString = "    " + attributeFormatString;
            }
            return sb.toString();
        }

        private String getReverseLookupString() {
            StringBuilder sb = new StringBuilder();
            String mappingFormatString = "Physical Address = %s --> Virtual Address = %s %n";
            if (this.succeded()) {
                sb.append(String.format(mappingFormatString, this.getPhysicalAddress().toStringCStyleHex(), this.getVirtualAddress().toStringCStyleHex()));
            } else {
                sb.append(String.format(mappingFormatString, this.getPhysicalAddress().toStringCStyleHex(), "Not mapped"));
            }
            return sb.toString();
        }

        public IDspValue getVirtualAddress() {
            return this.virtualAddress;
        }

        public IDspValue getPhysicalAddress() {
            return this.physicalAddress;
        }

        public List<IDisplayAttribute> getAttributes() {
            return this.attributes;
        }

        public boolean succeded() {
            return this.succeded;
        }

        public String toString() {
            if (this.toStringValue == null) {
                this.toStringValue = this.reverse ? this.getReverseLookupString() : this.getLookupString();
            }
            return this.toStringValue;
        }
    }

    public static interface IDisplayAttribute {
        public String getDisplayName();

        public String getDisplayValue();

        public boolean IsLevelMarker();
    }

    public static enum MMUMode {
        Short,
        Long;


        public String toString() {
            switch (this) {
                case Short: {
                    return "Short Format ( 32 Bit ) ";
                }
                case Long: {
                    return "Long Format ( 64 Bit LPAE Mode )";
                }
            }
            return "Unknown";
        }
    }
}

