/*
 * Decompiled with CFR 0.152.
 */
package com.ti.pagetableviewer.impl;

import com.ti.debug.engine.IDspTask;
import com.ti.debug.engine.IDspValue;
import com.ti.pagetableviewer.IPageTableViewer;
import com.ti.pagetableviewer.impl.common.FormatFactory;
import com.ti.pagetableviewer.impl.common.IPageTable;
import com.ti.pagetableviewer.impl.common.IPageTableEntry;
import com.ti.pagetableviewer.impl.target.Target;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class PageTableViewer
implements IPageTableViewer {
    Target target;
    private static HashMap<IDspTask, IPageTableViewer> taskViewerMap = new HashMap();

    private PageTableViewer(IDspTask dspTask) {
        this.target = new Target(dspTask);
    }

    @Override
    public IPageTableViewer.MMUMode currentMode() throws IPageTableViewer.PageTableViewerException {
        if (FormatFactory.isLongFormat(this.target)) {
            return IPageTableViewer.MMUMode.Long;
        }
        return IPageTableViewer.MMUMode.Short;
    }

    @Override
    public IPageTableViewer.AddressLookup lookupAddress(IDspValue virtualAddress) throws IPageTableViewer.PageTableViewerException {
        ArrayList<IPageTableViewer.IDisplayAttribute> attributesList = new ArrayList<IPageTableViewer.IDisplayAttribute>();
        FormatFactory factory = FormatFactory.create(this.target);
        IPageTable pageTable = factory.getRootPageTable();
        IPageTableEntry entry = null;
        IDspValue physicalAddress = null;
        boolean found = true;
        try {
            do {
                attributesList.add(new IPageTableViewer.IDisplayAttribute(){

                    @Override
                    public String getDisplayValue() {
                        return ">";
                    }

                    @Override
                    public String getDisplayName() {
                        return "";
                    }

                    @Override
                    public boolean IsLevelMarker() {
                        return true;
                    }
                });
                entry = pageTable.getEntry(virtualAddress);
                entry.getAttributes(attributesList);
            } while ((pageTable = entry.nextLevelPageTable()) != null);
            physicalAddress = entry.getPhysicalAddress(virtualAddress);
        }
        catch (IPageTableEntry.InvalidEntryException exception) {
            found = false;
        }
        IPageTableViewer.AddressLookup result = new IPageTableViewer.AddressLookup(virtualAddress, physicalAddress, attributesList, found, false);
        return result;
    }

    @Override
    public IPageTableViewer.PageTableEntriesLookup lookupPageTableEntries(int TTBRNum, int[] parentLevelIndices, int beginIndex, int endIndex) throws IPageTableViewer.PageTableViewerException {
        IPageTable rootPageTable = FormatFactory.create(this.target).getRootPageTable();
        IPageTable pageTable = FormatFactory.getPageTable(rootPageTable, TTBRNum, parentLevelIndices);
        List<IPageTableEntry> pageTableEntries = pageTable.getEntries(beginIndex, endIndex);
        ArrayList<List<IPageTableViewer.IDisplayAttribute>> entriesDisplayAttributes = new ArrayList<List<IPageTableViewer.IDisplayAttribute>>();
        for (IPageTableEntry entry : pageTableEntries) {
            if (!entry.isValid()) continue;
            ArrayList<IPageTableViewer.IDisplayAttribute> attributesList = new ArrayList<IPageTableViewer.IDisplayAttribute>();
            entry.getAttributes(attributesList);
            entriesDisplayAttributes.add(attributesList);
        }
        return new IPageTableViewer.PageTableEntriesLookup(entriesDisplayAttributes);
    }

    @Override
    public IPageTableViewer.AddressLookup reverseLookup(IDspValue physicalAddress) throws IPageTableViewer.PageTableViewerException {
        List<IPageTableEntry> mappingEntries = this.reverseLookup(physicalAddress, false);
        if (mappingEntries.size() > 0) {
            return this.createReverseAddressLookup(mappingEntries.get(0), physicalAddress);
        }
        return new IPageTableViewer.AddressLookup(null, physicalAddress, null, false, true);
    }

    @Override
    public List<IPageTableViewer.AddressLookup> reverseLookupAll(IDspValue physicalAddress) throws IPageTableViewer.PageTableViewerException {
        ArrayList<IPageTableViewer.AddressLookup> lookup = new ArrayList<IPageTableViewer.AddressLookup>();
        List<IPageTableEntry> mappingEntries = this.reverseLookup(physicalAddress, true);
        if (mappingEntries.size() > 0) {
            for (IPageTableEntry entry : mappingEntries) {
                lookup.add(this.createReverseAddressLookup(entry, physicalAddress));
            }
        } else {
            lookup.add(new IPageTableViewer.AddressLookup(null, physicalAddress, null, false, true));
        }
        return lookup;
    }

    private IPageTableViewer.AddressLookup createReverseAddressLookup(IPageTableEntry entry, IDspValue physicalAddress) throws IPageTableViewer.PageTableViewerException {
        long virtualAddress = 0L;
        virtualAddress = entry.getBaseVirtualAddress().toLongLong() | entry.getPhysicalSegmentIndex(physicalAddress);
        IPageTableViewer.AddressLookup lookup = new IPageTableViewer.AddressLookup(this.target.createAddress(virtualAddress), physicalAddress, null, true, true);
        return lookup;
    }

    private List<IPageTableEntry> reverseLookup(IDspValue physicalAddress, boolean all) throws IPageTableViewer.PageTableViewerException {
        FormatFactory factory = FormatFactory.create(this.target);
        IPageTable rootPageTable = factory.getRootPageTable();
        ArrayList<IPageTableEntry> mappingEntries = new ArrayList<IPageTableEntry>();
        this.reverseLookup(physicalAddress, rootPageTable, mappingEntries, all);
        return mappingEntries;
    }

    private boolean reverseLookup(IDspValue physicalAddress, IPageTable pageTable, List<IPageTableEntry> mappingEntries, boolean all) throws IPageTableViewer.PageTableViewerException {
        boolean found = false;
        for (IPageTableEntry entry : pageTable.getEntries(pageTable.getTableBeginIndex(), pageTable.getTableEndIndex())) {
            if (entry.isTerminating()) {
                if (entry.isPhysicalAddressInRange(physicalAddress)) {
                    mappingEntries.add(entry);
                    found = true;
                }
            } else {
                found = this.reverseLookup(physicalAddress, entry.nextLevelPageTable(), mappingEntries, all);
            }
            if (!found || all) continue;
            break;
        }
        return found;
    }

    public static IPageTableViewer getPageTableViewer(IDspTask dspTask) {
        IPageTableViewer pageTableViewer = taskViewerMap.get(dspTask);
        if (pageTableViewer == null) {
            pageTableViewer = new PageTableViewer(dspTask);
            taskViewerMap.put(dspTask, pageTableViewer);
        }
        return pageTableViewer;
    }

    @Override
    public IPageTableViewer.Summary summary() throws IPageTableViewer.PageTableViewerException {
        FormatFactory factory = FormatFactory.create(this.target);
        IPageTable rootPageTable = factory.getRootPageTable();
        List<IPageTableEntry> pageTableEntries = rootPageTable.getEntries(rootPageTable.getTableBeginIndex(), rootPageTable.getTableEndIndex());
        ArrayList<List<IPageTableViewer.IDisplayAttribute>> entriesDisplayAttributes = new ArrayList<List<IPageTableViewer.IDisplayAttribute>>();
        for (IPageTableEntry entry : pageTableEntries) {
            ArrayList<IPageTableViewer.IDisplayAttribute> attributesList = new ArrayList<IPageTableViewer.IDisplayAttribute>();
            entry.getAttributes(attributesList);
            entriesDisplayAttributes.add(attributesList);
        }
        return new IPageTableViewer.Summary(this.currentMode(), new IPageTableViewer.PageTableEntriesLookup(entriesDisplayAttributes));
    }

    public static class TargetReadException
    extends IPageTableViewer.PageTableViewerException {
        private static final long serialVersionUID = 1L;

        public TargetReadException(String message) {
            super(message);
        }
    }
}

