/*
 * Decompiled with CFR 0.152.
 */
package com.ti.pagetableviewer.impl.common;

public abstract class BitOperator {
    public static long apply(long encodedData, IBitOperation op) {
        if (op.getNumBits() == 0) {
            return encodedData;
        }
        long attributeMask = -1L >>> 64 - op.getNumBits();
        long decodedData = encodedData & (attributeMask <<= op.getStartingBit());
        if (op.shouldShiftRight()) {
            decodedData >>>= op.getStartingBit();
        }
        return decodedData;
    }

    public static class IndexOperation
    extends AddressOperation {
        public IndexOperation(int startingBit, int numBits) {
            super(startingBit, numBits);
        }

        @Override
        public boolean shouldShiftRight() {
            return true;
        }
    }

    public static class AddressOperation
    implements IBitOperation {
        int startingBit;
        int numBits;

        public AddressOperation(int startingBit, int numBits) {
            this.startingBit = startingBit;
            this.numBits = numBits;
        }

        @Override
        public int getStartingBit() {
            return this.startingBit;
        }

        @Override
        public int getNumBits() {
            return this.numBits;
        }

        @Override
        public boolean shouldShiftRight() {
            return false;
        }

        public boolean shouldPreShiftLeft() {
            return false;
        }
    }

    public static interface IBitOperation {
        public int getStartingBit();

        public int getNumBits();

        public boolean shouldShiftRight();
    }
}

