/*
 * Decompiled with CFR 0.152.
 */
package com.ti.pagetableviewer.impl.common;

import com.ti.pagetableviewer.IPageTableViewer;
import com.ti.pagetableviewer.impl.common.BitOperator;
import com.ti.pagetableviewer.impl.common.IPageTable;
import com.ti.pagetableviewer.impl.common.IPageTableEntry;
import com.ti.pagetableviewer.impl.longformat.LongFormatFactory;
import com.ti.pagetableviewer.impl.shortformat.ShortFormatFactory;
import com.ti.pagetableviewer.impl.target.Target;

public abstract class FormatFactory {
    public abstract IPageTable getRootPageTable() throws IPageTableViewer.PageTableViewerException;

    public static IPageTable getPageTable(IPageTable rootTable, int TTBRNum, int[] parentLevelIndices) throws IPageTableViewer.PageTableViewerException {
        IPageTable pageTable = rootTable.getEntry(TTBRNum).nextLevelPageTable();
        IPageTableEntry entry = null;
        for (int i = 0; i < parentLevelIndices.length; ++i) {
            entry = pageTable.getEntry(parentLevelIndices[i]);
            if ((pageTable = entry.nextLevelPageTable()) != null) continue;
            throw new IPageTableViewer.PageTableViewerException("Entry at index " + parentLevelIndices[i] + " at Level " + (i + 1) + " page table does not point to a page table");
        }
        return pageTable;
    }

    public static FormatFactory create(Target target) {
        if (FormatFactory.isLongFormat(target)) {
            return new LongFormatFactory(target);
        }
        return new ShortFormatFactory(target);
    }

    public static boolean isLongFormat(Target target) {
        boolean isLongFormat = false;
        try {
            BitOperator.IndexOperation op = new BitOperator.IndexOperation(31, 1);
            isLongFormat = BitOperator.apply(target.getMMUConfig().getTTBCRReg(), op) != 0L;
        }
        catch (IPageTableViewer.PageTableViewerException pageTableViewerException) {
            // empty catch block
        }
        return isLongFormat;
    }
}

