/*
 * Decompiled with CFR 0.152.
 */
package com.ti.pagetableviewer.impl.common;

import com.ti.debug.engine.IDspValue;
import com.ti.pagetableviewer.IPageTableViewer;
import com.ti.pagetableviewer.impl.PageTableViewer;
import com.ti.pagetableviewer.impl.common.BitOperator;
import com.ti.pagetableviewer.impl.common.IPageTable;
import com.ti.pagetableviewer.impl.common.IPageTableEntry;
import com.ti.pagetableviewer.impl.common.LevelPageTableEntry;
import com.ti.pagetableviewer.impl.target.Target;
import java.util.ArrayList;
import java.util.List;

public abstract class LevelPageTable
implements IPageTable {
    protected IDspValue baseAddress;
    protected IDspValue virtualBaseAddress;
    protected Target target;
    IPageTableEntry parent;
    int entrySize;

    public LevelPageTable(Target target, IDspValue baseAddress, IDspValue virtualBaseAddress, IPageTableEntry parent, int entrySize) {
        this.target = target;
        this.baseAddress = baseAddress;
        this.parent = parent;
        this.entrySize = entrySize;
        this.virtualBaseAddress = virtualBaseAddress;
    }

    @Override
    public IPageTableEntry getParentEntry() {
        return this.parent;
    }

    @Override
    public LevelPageTableEntry getEntry(IDspValue virtualAddress) throws IPageTableViewer.PageTableViewerException {
        return this.getEntry(this.getIndexIntoTable(virtualAddress), this.target.getSingleEntryPageTableDataAccess(this.entrySize));
    }

    @Override
    public LevelPageTableEntry getEntry(int index) throws IPageTableViewer.PageTableViewerException {
        return this.getEntry(index, this.target.getSingleEntryPageTableDataAccess(this.entrySize));
    }

    @Override
    public List<IPageTableEntry> getEntries(int beginIndex, int endIndex) throws PageTableViewer.TargetReadException {
        if (beginIndex < this.getTableBeginIndex() || endIndex > this.getTableEndIndex()) {
            throw new PageTableViewer.TargetReadException("Invalid beginIndex or endIndex. Index must be between " + this.getTableBeginIndex() + " and " + this.getTableEndIndex());
        }
        ArrayList<IPageTableEntry> entries = new ArrayList<IPageTableEntry>();
        int numEntries = endIndex - beginIndex + 1;
        long address = this.getEntryAddress(beginIndex);
        IPageTableData pageTableData = this.target.getMultiEntryPageTableDataAccess(address, numEntries, this.entrySize);
        for (int i = beginIndex; i <= endIndex; ++i) {
            LevelPageTableEntry entry = this.getEntry(i, pageTableData);
            entries.add(entry);
        }
        return entries;
    }

    @Override
    public int getTableBeginIndex() {
        return 0;
    }

    @Override
    public int getTableEndIndex() {
        return this.getTableSize() - 1;
    }

    @Override
    public int getIndexIntoTable(IDspValue virtualAddress) {
        return (int)BitOperator.apply(virtualAddress.toLongLong(), this.getIndexOperation());
    }

    @Override
    public IDspValue getBaseVirtualAddress() {
        return this.virtualBaseAddress;
    }

    protected abstract LevelPageTableEntry createEntry(long var1, int var3);

    protected abstract BitOperator.IBitOperation getIndexOperation();

    private long getEntryAddress(int index) {
        long entryOffset = index * (this.entrySize / 8);
        long address = this.baseAddress.toLongLong() + entryOffset;
        return address;
    }

    private LevelPageTableEntry getEntry(int index, IPageTableData data) throws PageTableViewer.TargetReadException {
        long address = this.getEntryAddress(index);
        long entry = data.getEntry(address);
        LevelPageTableEntry pageTableEntry = this.createEntry(entry, index);
        return pageTableEntry;
    }

    public static interface IPageTableData {
        public long getEntry(long var1) throws PageTableViewer.TargetReadException;
    }
}

