/*
 * Decompiled with CFR 0.152.
 */
package com.ti.pagetableviewer.impl.common;

import com.ti.debug.engine.IDspValue;
import com.ti.pagetableviewer.IPageTableViewer;
import com.ti.pagetableviewer.impl.common.BitOperator;
import com.ti.pagetableviewer.impl.common.DisplayAttribute;
import com.ti.pagetableviewer.impl.common.IPageTable;
import com.ti.pagetableviewer.impl.common.IPageTableEntry;
import com.ti.pagetableviewer.impl.common.NumericDisplayAttribute;
import com.ti.pagetableviewer.impl.common.PageTableEntryAttribute;
import com.ti.pagetableviewer.impl.target.Target;
import java.util.ArrayList;
import java.util.List;

public abstract class LevelPageTableEntry
implements IPageTableEntry {
    protected List<PageTableEntryAttribute> attributesToRead = new ArrayList<PageTableEntryAttribute>();
    protected List<IPageTableViewer.IDisplayAttribute> additionalDisplayAttributes = new ArrayList<IPageTableViewer.IDisplayAttribute>();
    protected long entry;
    protected Target target;
    protected int index;
    private boolean attributesRead = false;
    IPageTable parent;
    private IDspValue virtualBaseAddress = null;

    protected LevelPageTableEntry(long entry, Target target, int index, IPageTable parent) {
        this.entry = entry;
        this.target = target;
        this.index = index;
        this.parent = parent;
    }

    @Override
    public IPageTable getParentEntry() {
        return this.parent;
    }

    @Override
    public void getAttributes(List<IPageTableViewer.IDisplayAttribute> attributes) {
        if (!this.attributesRead) {
            this.attributesToRead.addAll(this.getAttributesToRead());
            this.readAttributes(this.attributesToRead, this.entry);
            this.additionalDisplayAttributes.add(new DisplayAttribute("Type", this.getEntryTypeString(), false));
            this.additionalDisplayAttributes.add(new NumericDisplayAttribute("Index", this.index, false));
            try {
                this.additionalDisplayAttributes.add(new NumericDisplayAttribute("Min VA", this.getBaseVirtualAddress().toLongLong(), false));
                if (this.isTerminating()) {
                    this.additionalDisplayAttributes.add(new NumericDisplayAttribute("Min PA", this.getPhysicalAddress(0L), false));
                    this.additionalDisplayAttributes.add(new NumericDisplayAttribute("Region Size", this.getRegionSize(), false));
                } else {
                    this.additionalDisplayAttributes.add(new NumericDisplayAttribute("Next Level Table", this.getPhysicalAddress(0L), false));
                }
            }
            catch (IPageTableViewer.PageTableViewerException pageTableViewerException) {
                // empty catch block
            }
        }
        attributes.addAll(this.additionalDisplayAttributes);
        attributes.addAll(this.attributesToRead);
    }

    @Override
    public IDspValue getPhysicalAddress(IDspValue virtualAddress) throws IPageTableEntry.NonTerminatingEntryException, IPageTableEntry.InvalidEntryException {
        long index = BitOperator.apply(virtualAddress.toLongLong(), this.getPhysicalRegionIndexOp());
        long physicalAddress = this.getPhysicalAddress(index);
        return this.target.createAddress(physicalAddress);
    }

    @Override
    public long getPhysicalSegmentIndex(IDspValue address) throws IPageTableEntry.NonTerminatingEntryException, IPageTableEntry.InvalidEntryException {
        return BitOperator.apply(address.toLongLong(), this.getPhysicalRegionIndexOp());
    }

    @Override
    public boolean isPhysicalAddressInRange(IDspValue physicalAddress) throws IPageTableEntry.NonTerminatingEntryException {
        if (this.getPhysicalRegionSize() == 0L) {
            return false;
        }
        long minPhysAdd = 0L;
        long maxPhysAdd = 0L;
        try {
            minPhysAdd = this.getPhysicalAddress(0L);
            maxPhysAdd = this.getPhysicalAddress(this.getPhysicalRegionSize() - 1L);
        }
        catch (IPageTableEntry.InvalidEntryException e) {
            // empty catch block
        }
        long longPhyAddress = physicalAddress.toLongLong();
        return longPhyAddress >= minPhysAdd && longPhyAddress <= maxPhysAdd;
    }

    protected abstract List<PageTableEntryAttribute> getAttributesToRead();

    protected abstract BitOperator.IBitOperation getPhysicalRegionIndexOp() throws IPageTableEntry.NonTerminatingEntryException, IPageTableEntry.InvalidEntryException;

    protected abstract BitOperator.IBitOperation getBaseAddressOp() throws IPageTableEntry.InvalidEntryException, IPageTableEntry.NonTerminatingEntryException;

    protected abstract String getEntryTypeString();

    protected abstract long getPhysicalRegionSize();

    protected long getBaseAddress() throws IPageTableViewer.PageTableViewerException {
        return BitOperator.apply(this.entry, this.getBaseAddressOp());
    }

    private void readAttributes(List<PageTableEntryAttribute> attributes, long entryValue) {
        long rawEntry = entryValue;
        for (PageTableEntryAttribute att : attributes) {
            long value = BitOperator.apply(rawEntry, att);
            att.setValue((int)value);
        }
    }

    private long getPhysicalAddress(long index) throws IPageTableEntry.InvalidEntryException, IPageTableEntry.NonTerminatingEntryException {
        long baseAddress = BitOperator.apply(this.entry, this.getBaseAddressOp());
        long physicalAddress = baseAddress | index;
        return physicalAddress;
    }

    @Override
    public IDspValue getBaseVirtualAddress() {
        if (this.virtualBaseAddress == null) {
            long va = 0L;
            long tableVA = this.getParentEntry().getBaseVirtualAddress().toLongLong();
            va = tableVA + this.getParentEntry().getMinimumEntryRegionSize() * (long)this.index;
            if (this.getRegionSize() != this.getParentEntry().getMinimumEntryRegionSize()) {
                long regionBitMask = this.getRegionSize();
                regionBitMask = (regionBitMask ^ 0xFFFFFFFFFFFFFFFFL) + 1L;
                va &= regionBitMask;
            }
            this.virtualBaseAddress = this.target.createAddress(va);
        }
        return this.virtualBaseAddress;
    }
}

