/*
 * Decompiled with CFR 0.152.
 */
package com.ti.pagetableviewer.impl.common;

import com.ti.pagetableviewer.impl.common.BitOperator;
import com.ti.pagetableviewer.impl.common.NumericDisplayAttribute;

public class PageTableEntryAttribute
extends NumericDisplayAttribute
implements BitOperator.IBitOperation {
    int numBits;
    int startingBit;

    public PageTableEntryAttribute(String name, int startingBit, int numBits) {
        super(name, 0L, false);
        this.startingBit = startingBit;
        this.numBits = numBits;
    }

    @Override
    public String getDisplayName() {
        String displayName = super.getDisplayName();
        int numBits = this.getNumBits();
        if (numBits > 1) {
            displayName = displayName + "[" + (numBits - 1) + ":0]";
        }
        return displayName;
    }

    @Override
    public int getStartingBit() {
        return this.startingBit;
    }

    @Override
    public int getNumBits() {
        return this.numBits;
    }

    @Override
    public boolean shouldShiftRight() {
        return true;
    }

    public boolean shouldPreShiftLeft() {
        return false;
    }
}

