/*
 * Decompiled with CFR 0.152.
 */
package com.ti.pagetableviewer.impl.longformat;

import com.ti.pagetableviewer.IPageTableViewer;
import com.ti.pagetableviewer.impl.common.BitOperator;
import com.ti.pagetableviewer.impl.common.IPageTableEntry;
import com.ti.pagetableviewer.impl.common.LevelPageTable;
import com.ti.pagetableviewer.impl.common.LevelPageTableEntry;
import com.ti.pagetableviewer.impl.common.PageTableEntryAttribute;
import com.ti.pagetableviewer.impl.longformat.LongFormatFactory;
import com.ti.pagetableviewer.impl.target.Target;
import java.util.ArrayList;
import java.util.List;

public abstract class L1L2PageTableEntry
extends LevelPageTableEntry {
    L1L2EntryDescriptor descriptor;
    private BitOperator.IBitOperation phyRegionIndexOp = null;
    private BitOperator.IBitOperation baAddressOp = null;

    protected L1L2PageTableEntry(Target target, long entry, int index, LevelPageTable parent) {
        super(entry, target, index, parent);
        this.descriptor = L1L2EntryDescriptor.getDescriptor(entry);
    }

    @Override
    public boolean isTerminating() throws IPageTableViewer.PageTableViewerException {
        return this.descriptor.isTerminating();
    }

    protected abstract int getDescriptorNValue();

    @Override
    protected List<PageTableEntryAttribute> getAttributesToRead() {
        return this.descriptor.createAttributes();
    }

    @Override
    protected BitOperator.IBitOperation getPhysicalRegionIndexOp() throws IPageTableEntry.NonTerminatingEntryException, IPageTableEntry.InvalidEntryException {
        if (this.phyRegionIndexOp == null) {
            this.phyRegionIndexOp = this.descriptor.createIndexOp(this.getDescriptorNValue());
        }
        return this.phyRegionIndexOp;
    }

    @Override
    protected BitOperator.IBitOperation getBaseAddressOp() throws IPageTableEntry.InvalidEntryException {
        if (this.baAddressOp == null) {
            this.baAddressOp = this.descriptor.createBaseAddressOp(this.getDescriptorNValue());
        }
        return this.baAddressOp;
    }

    @Override
    protected long getPhysicalRegionSize() {
        if (this.descriptor != L1L2EntryDescriptor.INVALID) {
            return 1 << this.getDescriptorNValue();
        }
        return 0L;
    }

    @Override
    public boolean isValid() {
        return this.descriptor != L1L2EntryDescriptor.INVALID;
    }

    static enum L1L2EntryDescriptor {
        INVALID,
        BLOCK,
        PAGETABLE;


        static L1L2EntryDescriptor getDescriptor(long entry) {
            BitOperator.IndexOperation op = new BitOperator.IndexOperation(0, 2);
            int typeBits = (int)BitOperator.apply(entry, op);
            switch (typeBits) {
                case 1: {
                    return BLOCK;
                }
                case 3: {
                    return PAGETABLE;
                }
            }
            return INVALID;
        }

        BitOperator.IBitOperation createBaseAddressOp(int n) throws IPageTableEntry.InvalidEntryException {
            switch (this) {
                case PAGETABLE: {
                    return new BitOperator.AddressOperation(12, 28);
                }
                case BLOCK: {
                    return new BitOperator.AddressOperation(n, 40 - n);
                }
            }
            throw new IPageTableEntry.InvalidEntryException();
        }

        BitOperator.IBitOperation createIndexOp(int n) throws IPageTableEntry.NonTerminatingEntryException, IPageTableEntry.InvalidEntryException {
            switch (this) {
                case BLOCK: {
                    return new BitOperator.IndexOperation(0, n);
                }
                case PAGETABLE: {
                    throw new IPageTableEntry.NonTerminatingEntryException();
                }
            }
            throw new IPageTableEntry.InvalidEntryException();
        }

        public List<PageTableEntryAttribute> createAttributes() {
            ArrayList<PageTableEntryAttribute> attributes = new ArrayList<PageTableEntryAttribute>();
            switch (this) {
                case BLOCK: {
                    attributes.addAll(LongFormatFactory.getLowerBlockPageAttributes());
                    attributes.addAll(LongFormatFactory.getUpperBlockPageAttributes());
                    break;
                }
                case PAGETABLE: {
                    attributes.addAll(LongFormatFactory.getPageTableAttributes());
                    break;
                }
            }
            return attributes;
        }

        public String toString() {
            switch (this) {
                case PAGETABLE: {
                    return "Page Table";
                }
                case BLOCK: {
                    return "Block";
                }
            }
            return "Invalid";
        }

        public boolean isTerminating() {
            switch (this) {
                case PAGETABLE: {
                    return false;
                }
            }
            return true;
        }
    }
}

