/*
 * Decompiled with CFR 0.152.
 */
package com.ti.pagetableviewer.impl.longformat;

import com.ti.debug.engine.IDspValue;
import com.ti.pagetableviewer.impl.common.BitOperator;
import com.ti.pagetableviewer.impl.common.IPageTableEntry;
import com.ti.pagetableviewer.impl.common.LevelPageTable;
import com.ti.pagetableviewer.impl.common.LevelPageTableEntry;
import com.ti.pagetableviewer.impl.longformat.L1PageTableEntry;
import com.ti.pagetableviewer.impl.longformat.LongFormatFactory;
import com.ti.pagetableviewer.impl.target.Target;

public class L1PageTable
extends LevelPageTable {
    int n;
    BitOperator.IndexOperation tableIndexOperation;
    int numOfIndexBits = 0;

    public L1PageTable(Target target, IDspValue baseAddress, IDspValue virtualBaseAddress, IPageTableEntry entry, int n) {
        super(target, baseAddress, virtualBaseAddress, entry, LongFormatFactory.ENTRY_SIZE);
        this.n = n;
        this.numOfIndexBits = n - 3;
        this.tableIndexOperation = new BitOperator.IndexOperation(30, this.numOfIndexBits);
    }

    @Override
    protected LevelPageTableEntry createEntry(long entryValue, int index) {
        return new L1PageTableEntry(this.target, entryValue, index, this);
    }

    @Override
    protected BitOperator.IBitOperation getIndexOperation() {
        return this.tableIndexOperation;
    }

    @Override
    public int getTableSize() {
        return 1 << this.numOfIndexBits;
    }

    @Override
    public long getMinimumEntryRegionSize() {
        return 0x40000000L;
    }
}

