/*
 * Decompiled with CFR 0.152.
 */
package com.ti.pagetableviewer.impl.longformat;

import com.ti.debug.engine.IDspValue;
import com.ti.pagetableviewer.impl.common.BitOperator;
import com.ti.pagetableviewer.impl.common.IPageTableEntry;
import com.ti.pagetableviewer.impl.common.LevelPageTable;
import com.ti.pagetableviewer.impl.common.LevelPageTableEntry;
import com.ti.pagetableviewer.impl.longformat.L2PageTableEntry;
import com.ti.pagetableviewer.impl.longformat.LongFormatFactory;
import com.ti.pagetableviewer.impl.target.Target;

public class L2PageTable
extends LevelPageTable {
    int n;
    int numOfIndexBits;
    BitOperator.IndexOperation tableIndexOperation;
    boolean isRootTable;

    public L2PageTable(Target target, IDspValue baseAddress, IDspValue virtualBaseAddress, IPageTableEntry parent, int n, boolean isRootTable) {
        super(target, baseAddress, virtualBaseAddress, parent, LongFormatFactory.ENTRY_SIZE);
        this.n = n;
        this.numOfIndexBits = n - 3;
        this.tableIndexOperation = new BitOperator.IndexOperation(21, this.numOfIndexBits);
        this.isRootTable = isRootTable;
    }

    @Override
    protected LevelPageTableEntry createEntry(long entryValue, int index) {
        return new L2PageTableEntry(this.target, entryValue, index, this, this.isRootTable);
    }

    @Override
    protected BitOperator.IBitOperation getIndexOperation() {
        return this.tableIndexOperation;
    }

    @Override
    public int getTableSize() {
        return 1 << this.numOfIndexBits;
    }

    @Override
    public long getMinimumEntryRegionSize() {
        return 0x200000L;
    }
}

