/*
 * Decompiled with CFR 0.152.
 */
package com.ti.pagetableviewer.impl.longformat;

import com.ti.pagetableviewer.IPageTableViewer;
import com.ti.pagetableviewer.impl.common.BitOperator;
import com.ti.pagetableviewer.impl.common.IPageTableEntry;
import com.ti.pagetableviewer.impl.common.LevelPageTable;
import com.ti.pagetableviewer.impl.common.LevelPageTableEntry;
import com.ti.pagetableviewer.impl.common.PageTableEntryAttribute;
import com.ti.pagetableviewer.impl.longformat.LongFormatFactory;
import com.ti.pagetableviewer.impl.target.Target;
import java.util.ArrayList;
import java.util.List;

public class L3PageTableEntry
extends LevelPageTableEntry {
    boolean isInvalid = false;
    private BitOperator.IBitOperation phyRegionIndexOp = null;
    private BitOperator.IBitOperation baOp = null;

    protected L3PageTableEntry(long entry, Target target, int index, LevelPageTable parent) {
        super(entry, target, index, parent);
        BitOperator.IndexOperation op = new BitOperator.IndexOperation(0, 2);
        int type = (int)BitOperator.apply(entry, op);
        this.isInvalid = type == 0 || type == 2;
    }

    private void assertValid() throws IPageTableEntry.InvalidEntryException {
        if (this.isInvalid) {
            throw new IPageTableEntry.InvalidEntryException();
        }
    }

    @Override
    public boolean isTerminating() throws IPageTableViewer.PageTableViewerException {
        return true;
    }

    @Override
    public LevelPageTable nextLevelPageTable() throws IPageTableViewer.PageTableViewerException {
        return null;
    }

    @Override
    protected List<PageTableEntryAttribute> getAttributesToRead() {
        ArrayList<PageTableEntryAttribute> attributes = new ArrayList<PageTableEntryAttribute>();
        if (!this.isInvalid) {
            attributes.addAll(LongFormatFactory.getLowerBlockPageAttributes());
            attributes.addAll(LongFormatFactory.getUpperBlockPageAttributes());
        }
        return attributes;
    }

    @Override
    protected BitOperator.IBitOperation getPhysicalRegionIndexOp() throws IPageTableEntry.NonTerminatingEntryException, IPageTableEntry.InvalidEntryException {
        this.assertValid();
        if (this.phyRegionIndexOp == null) {
            this.phyRegionIndexOp = new BitOperator.IndexOperation(0, 12);
        }
        return this.phyRegionIndexOp;
    }

    @Override
    protected BitOperator.IBitOperation getBaseAddressOp() throws IPageTableEntry.InvalidEntryException {
        this.assertValid();
        if (this.baOp == null) {
            this.baOp = new BitOperator.AddressOperation(12, 28);
        }
        return this.baOp;
    }

    @Override
    protected String getEntryTypeString() {
        return "L3 Page";
    }

    @Override
    public long getRegionSize() {
        return 4096L;
    }

    @Override
    protected long getPhysicalRegionSize() {
        if (this.isInvalid) {
            return 0L;
        }
        return 4096L;
    }

    @Override
    public boolean isValid() {
        return !this.isInvalid;
    }
}

