/*
 * Decompiled with CFR 0.152.
 */
package com.ti.pagetableviewer.impl.longformat;

import com.ti.debug.engine.IDspValue;
import com.ti.pagetableviewer.IPageTableViewer;
import com.ti.pagetableviewer.impl.common.BitOperator;
import com.ti.pagetableviewer.impl.common.IPageTable;
import com.ti.pagetableviewer.impl.common.IPageTableEntry;
import com.ti.pagetableviewer.impl.common.LevelPageTable;
import com.ti.pagetableviewer.impl.common.NumericDisplayAttribute;
import com.ti.pagetableviewer.impl.longformat.L1PageTable;
import com.ti.pagetableviewer.impl.longformat.L2PageTable;
import com.ti.pagetableviewer.impl.longformat.TTBRPageTable;
import com.ti.pagetableviewer.impl.target.Target;
import java.util.List;

public class TTBREntry
implements IPageTableEntry {
    TTBRPageTable.BaseRegisterRange range;
    int n;
    boolean isSecondLevelLookup;
    long baseAddress = -1L;
    long entry;
    Target target;
    IPageTable parent;
    int index;
    IDspValue virtualBaseAddress = null;

    protected TTBREntry(long entry, Target target, int index, IPageTable parent, TTBRPageTable.BaseRegisterRange range) {
        this.target = target;
        this.entry = entry;
        this.range = range;
        this.isSecondLevelLookup = this.isSecondLevelLookup(range.ttbrMin, range.ttbrMax);
        this.n = this.isSecondLevelLookup ? this.getSmallNValueStage1Level2(range.txSZ) : this.getSmallNValueStage1Level1(range.txSZ);
        this.parent = parent;
        this.index = index;
    }

    @Override
    public boolean isTerminating() throws IPageTableViewer.PageTableViewerException {
        return false;
    }

    @Override
    public LevelPageTable nextLevelPageTable() throws IPageTableViewer.PageTableViewerException {
        if (this.isSecondLevelLookup) {
            return new L2PageTable(this.target, this.target.createAddress(this.getBaseAddress()), this.getBaseVirtualAddress(), this, this.n, true);
        }
        return new L1PageTable(this.target, this.target.createAddress(this.getBaseAddress()), this.getBaseVirtualAddress(), this, this.n);
    }

    public IDspValue getVirtualAddressBits() {
        int startingBit = 26 + this.n;
        long addressBits = BitOperator.apply(this.range.ttbrMin, new BitOperator.AddressOperation(startingBit, 32 - startingBit));
        return this.target.createAddress(addressBits);
    }

    @Override
    public IPageTable getParentEntry() {
        return this.parent;
    }

    @Override
    public void getAttributes(List<IPageTableViewer.IDisplayAttribute> attributes) {
        String ttbrAddressFormatString = "TTBR%d Base Address";
        attributes.add(new NumericDisplayAttribute(String.format(ttbrAddressFormatString, this.index), this.getBaseAddress(), false));
        attributes.add(new NumericDisplayAttribute("Min VA", this.range.ttbrMin, false));
        attributes.add(new NumericDisplayAttribute("Max VA", this.range.ttbrMax, false));
    }

    @Override
    public IDspValue getPhysicalAddress(IDspValue virtualAddress) throws IPageTableEntry.NonTerminatingEntryException {
        throw new IPageTableEntry.NonTerminatingEntryException();
    }

    @Override
    public long getPhysicalSegmentIndex(IDspValue address) throws IPageTableEntry.NonTerminatingEntryException {
        throw new IPageTableEntry.NonTerminatingEntryException();
    }

    @Override
    public boolean isPhysicalAddressInRange(IDspValue physicalAddress) throws IPageTableEntry.NonTerminatingEntryException {
        throw new IPageTableEntry.NonTerminatingEntryException();
    }

    private long getBaseAddress() {
        if (this.baseAddress == -1L) {
            this.baseAddress = BitOperator.apply(this.entry, new BitOperator.AddressOperation(this.n, 40 - this.n));
        }
        return this.baseAddress;
    }

    private long caclulateNumEntries(long minAddress, long maxAddress) {
        long regionSize = maxAddress - minAddress + 1L;
        long numL1Entries = regionSize >> 30;
        return numL1Entries;
    }

    private boolean isSecondLevelLookup(long minAddress, long maxAddress) {
        return this.caclulateNumEntries(minAddress, maxAddress) == 1L;
    }

    private int getSmallNValueStage1Level1(int TxSz) {
        return 5 - TxSz;
    }

    private int getSmallNValueStage1Level2(int TxSz) {
        if (TxSz >= 2) {
            return 14 - TxSz;
        }
        return 12;
    }

    @Override
    public long getRegionSize() {
        return 0x100000000L;
    }

    @Override
    public IDspValue getBaseVirtualAddress() {
        if (this.virtualBaseAddress == null) {
            this.virtualBaseAddress = this.target.createAddress(this.range.ttbrMin);
        }
        return this.virtualBaseAddress;
    }

    @Override
    public boolean isValid() {
        return true;
    }
}

