/*
 * Decompiled with CFR 0.152.
 */
package com.ti.pagetableviewer.impl.longformat;

import com.ti.debug.engine.IDspValue;
import com.ti.pagetableviewer.IPageTableViewer;
import com.ti.pagetableviewer.impl.common.BitOperator;
import com.ti.pagetableviewer.impl.common.IPageTable;
import com.ti.pagetableviewer.impl.common.IPageTableEntry;
import com.ti.pagetableviewer.impl.longformat.TTBREntry;
import com.ti.pagetableviewer.impl.target.Target;
import java.util.ArrayList;
import java.util.List;

public class TTBRPageTable
implements IPageTable {
    List<BaseRegisterRange> ranges;
    int numBaseRegistersUsed;
    Target target;
    IDspValue baseAddress = null;

    private List<BaseRegisterRange> getBaseRegisterRanges() throws IPageTableViewer.PageTableViewerException {
        ArrayList<BaseRegisterRange> ranges = new ArrayList<BaseRegisterRange>();
        BaseRegisterRange rangeTTBR0 = new BaseRegisterRange();
        BaseRegisterRange rangeTTBR1 = new BaseRegisterRange();
        rangeTTBR0.txSZ = this.getT0SZValue();
        rangeTTBR1.txSZ = this.getT1SZValue();
        long ttbr0Min = 0L;
        long ttbr0Max = 0L;
        long ttbr1Min = 0L;
        long ttbr1Max = 0L;
        if (rangeTTBR1.txSZ == 0 && rangeTTBR0.txSZ == 0) {
            ttbr0Max = 0xFFFFFFFFL;
        } else if (rangeTTBR1.txSZ == 0 && rangeTTBR0.txSZ != 0) {
            ttbr0Max = (1L << 32 - rangeTTBR0.txSZ) - 1L;
            ttbr1Min = ttbr0Max + 1L;
            ttbr1Max = 0xFFFFFFFFL;
        } else if (rangeTTBR0.txSZ == 0 & rangeTTBR1.txSZ != 0) {
            ttbr0Max = 0x100000000L - (1L << 32 - rangeTTBR1.txSZ) - 1L;
            ttbr1Min = ttbr0Max + 1L;
            ttbr1Max = 0xFFFFFFFFL;
        } else if (rangeTTBR0.txSZ != 0 && rangeTTBR1.txSZ != 0) {
            ttbr0Min = 0L;
            ttbr0Max = (1L << 32 - rangeTTBR0.txSZ) - 1L;
            ttbr1Min = 0x100000000L - (1L << 32 - rangeTTBR1.txSZ);
            ttbr1Max = 0xFFFFFFFFL;
        }
        rangeTTBR0.ttbrMin = ttbr0Min;
        rangeTTBR0.ttbrMax = ttbr0Max;
        rangeTTBR0.ttbrValue = this.target.getMMUConfig().getTTBR0Reg();
        ranges.add(rangeTTBR0);
        if (rangeTTBR1.txSZ != 0 && rangeTTBR0.txSZ != 0) {
            rangeTTBR1.ttbrMin = ttbr1Min;
            rangeTTBR1.ttbrMax = ttbr1Max;
            rangeTTBR1.ttbrValue = this.target.getMMUConfig().getTTBR1Reg();
            ranges.add(rangeTTBR1);
        }
        return ranges;
    }

    protected TTBRPageTable(Target target) throws IPageTableViewer.PageTableViewerException {
        this.target = target;
        this.ranges = this.getBaseRegisterRanges();
        this.numBaseRegistersUsed = this.ranges.size();
    }

    @Override
    public IPageTableEntry getEntry(IDspValue virtualAddress) throws IPageTableViewer.PageTableViewerException {
        long add = virtualAddress.toLongLong();
        for (int i = 0; i < this.ranges.size(); ++i) {
            BaseRegisterRange range = this.ranges.get(i);
            if (add < range.ttbrMin || add > range.ttbrMax) continue;
            return this.createEntry(i);
        }
        throw new IPageTableViewer.PageTableViewerException("Could not determine base address register ( TTBR0 / TTBR1 ). Pleae make sure TTBCR is set up correctly");
    }

    @Override
    public List<IPageTableEntry> getEntries(int beginIndex, int endIndex) throws IPageTableViewer.PageTableViewerException {
        ArrayList<IPageTableEntry> entries = new ArrayList<IPageTableEntry>();
        for (int i = beginIndex; i <= endIndex; ++i) {
            entries.add(this.createEntry(i));
        }
        return entries;
    }

    @Override
    public IPageTableEntry getEntry(int index) throws IPageTableViewer.PageTableViewerException {
        return this.createEntry(index);
    }

    @Override
    public int getTableSize() {
        return this.numBaseRegistersUsed;
    }

    @Override
    public int getIndexIntoTable(IDspValue virtualAddress) {
        long add = virtualAddress.toLongLong();
        for (int i = 0; i < this.ranges.size(); ++i) {
            BaseRegisterRange range = this.ranges.get(i);
            if (add < range.ttbrMin || add > range.ttbrMax) continue;
            return i;
        }
        return -1;
    }

    @Override
    public IPageTableEntry getParentEntry() {
        return null;
    }

    @Override
    public int getTableBeginIndex() {
        return 0;
    }

    @Override
    public int getTableEndIndex() {
        return this.numBaseRegistersUsed - 1;
    }

    protected IPageTableEntry createEntry(int index) {
        BaseRegisterRange range = this.ranges.get(index);
        return new TTBREntry(range.ttbrValue, this.target, index, this, range);
    }

    private int getT1SZValue() throws IPageTableViewer.PageTableViewerException {
        BitOperator.IndexOperation op = new BitOperator.IndexOperation(16, 3);
        return (int)BitOperator.apply(this.target.getMMUConfig().getTTBCRReg(), op);
    }

    private int getT0SZValue() throws IPageTableViewer.PageTableViewerException {
        BitOperator.IndexOperation op = new BitOperator.IndexOperation(0, 3);
        return (int)BitOperator.apply(this.target.getMMUConfig().getTTBCRReg(), op);
    }

    @Override
    public IDspValue getBaseVirtualAddress() {
        if (this.baseAddress == null) {
            this.baseAddress = this.target.createAddress(0);
        }
        return this.baseAddress;
    }

    @Override
    public long getMinimumEntryRegionSize() {
        return 0x40000000L;
    }

    public static class BaseRegisterRange {
        public long ttbrMin;
        public long ttbrMax;
        public int txSZ;
        public long ttbrValue;
    }
}

