/*
 * Decompiled with CFR 0.152.
 */
package com.ti.pagetableviewer.impl.shortformat;

import com.ti.debug.engine.IDspValue;
import com.ti.pagetableviewer.IPageTableViewer;
import com.ti.pagetableviewer.impl.common.BitOperator;
import com.ti.pagetableviewer.impl.common.IPageTableEntry;
import com.ti.pagetableviewer.impl.common.LevelPageTable;
import com.ti.pagetableviewer.impl.common.LevelPageTableEntry;
import com.ti.pagetableviewer.impl.common.PageTableEntryAttribute;
import com.ti.pagetableviewer.impl.shortformat.L2PageTable;
import com.ti.pagetableviewer.impl.target.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class L1PageTableEntry
extends LevelPageTableEntry {
    L1EntryDescriptor descriptor;
    int N = 0;
    private BitOperator.IBitOperation phyRegionIndexOp = null;
    private BitOperator.IBitOperation baOp = null;

    protected L1PageTableEntry(long entry, Target target, int index, int N, LevelPageTable parent) {
        super(entry, target, index, parent);
        this.N = N;
        this.descriptor = L1EntryDescriptor.getDescriptor(entry);
    }

    @Override
    public boolean isTerminating() {
        return this.descriptor.isTerminating();
    }

    @Override
    public LevelPageTable nextLevelPageTable() throws IPageTableViewer.PageTableViewerException {
        if (this.isTerminating()) {
            return null;
        }
        IDspValue pageTableAddress = this.target.createAddress(this.getBaseAddress());
        return new L2PageTable(this.target, pageTableAddress, this.getBaseVirtualAddress(), this);
    }

    @Override
    protected List<PageTableEntryAttribute> getAttributesToRead() {
        return this.descriptor.createAttributes();
    }

    @Override
    protected BitOperator.IBitOperation getPhysicalRegionIndexOp() throws IPageTableEntry.NonTerminatingEntryException, IPageTableEntry.InvalidEntryException {
        if (this.phyRegionIndexOp == null) {
            this.phyRegionIndexOp = this.descriptor.createIndexOp();
        }
        return this.phyRegionIndexOp;
    }

    @Override
    protected BitOperator.IBitOperation getBaseAddressOp() throws IPageTableEntry.NonTerminatingEntryException, IPageTableEntry.InvalidEntryException {
        if (this.baOp == null) {
            this.baOp = this.descriptor.createBaseAddressOp();
        }
        return this.baOp;
    }

    @Override
    protected String getEntryTypeString() {
        return this.descriptor.toString();
    }

    @Override
    protected long getPhysicalRegionSize() {
        return this.descriptor.getPhysicalRegionSize();
    }

    @Override
    public long getRegionSize() {
        return this.getPhysicalRegionSize();
    }

    @Override
    public boolean isValid() {
        return this.descriptor != L1EntryDescriptor.INVALID;
    }

    private static enum L1EntryDescriptor {
        INVALID,
        PAGETABLE,
        SECTION,
        SUPERSECTION,
        RESERVED;


        static L1EntryDescriptor getDescriptor(long entry) {
            BitOperator.IndexOperation typeOp = new BitOperator.IndexOperation(0, 2);
            int typeBits = (int)BitOperator.apply(entry, typeOp);
            BitOperator.IndexOperation sectionOp = new BitOperator.IndexOperation(18, 1);
            int sectionBit = (int)BitOperator.apply(entry, sectionOp);
            switch (typeBits) {
                case 0: {
                    return INVALID;
                }
                case 1: {
                    return PAGETABLE;
                }
                case 2: {
                    if (sectionBit == 1) {
                        return SUPERSECTION;
                    }
                    return SECTION;
                }
                case 3: {
                    return RESERVED;
                }
            }
            return INVALID;
        }

        BitOperator.IBitOperation createBaseAddressOp() throws IPageTableEntry.InvalidEntryException {
            switch (this) {
                case PAGETABLE: {
                    return new BitOperator.AddressOperation(10, 22);
                }
                case SUPERSECTION: {
                    return new BitOperator.AddressOperation(24, 8);
                }
                case SECTION: {
                    return new BitOperator.AddressOperation(20, 12);
                }
            }
            throw new IPageTableEntry.InvalidEntryException();
        }

        BitOperator.IBitOperation createIndexOp() throws IPageTableEntry.InvalidEntryException {
            switch (this) {
                case SUPERSECTION: {
                    return new BitOperator.IndexOperation(0, 24);
                }
                case SECTION: {
                    return new BitOperator.IndexOperation(0, 20);
                }
            }
            throw new IPageTableEntry.InvalidEntryException();
        }

        public List<PageTableEntryAttribute> createAttributes() {
            ArrayList<PageTableEntryAttribute> attributes = new ArrayList<PageTableEntryAttribute>();
            if (this == INVALID || this == RESERVED) {
                return attributes;
            }
            if (this == PAGETABLE) {
                attributes.add(new PageTableEntryAttribute("Domain", 5, 4));
            } else {
                attributes.addAll(Arrays.asList(new PageTableEntryAttribute("S", 16, 1), new PageTableEntryAttribute("AP", 10, 2), new PageTableEntryAttribute("nG", 17, 1), new PageTableEntryAttribute("AP[2]", 15, 1), new PageTableEntryAttribute("NS", 19, 1), new PageTableEntryAttribute("TEX", 12, 3), new PageTableEntryAttribute("XN", 4, 1)));
                if (this == SECTION) {
                    attributes.add(new PageTableEntryAttribute("Domain", 5, 4));
                } else if (this == SUPERSECTION) {
                    attributes.addAll(Arrays.asList(new PageTableEntryAttribute("S", 16, 1), new PageTableEntryAttribute("PA[39:36]", 5, 4), new PageTableEntryAttribute("PA[35:32]", 20, 4)));
                }
            }
            return attributes;
        }

        public String toString() {
            switch (this) {
                case PAGETABLE: {
                    return "L1 Page Table";
                }
                case SUPERSECTION: {
                    return "L1 Super Section";
                }
                case SECTION: {
                    return "L1 Section";
                }
            }
            return "Invalid";
        }

        public boolean isTerminating() {
            switch (this) {
                case PAGETABLE: {
                    return false;
                }
            }
            return true;
        }

        public long getPhysicalRegionSize() {
            switch (this) {
                case PAGETABLE: 
                case SECTION: {
                    return 0x100000L;
                }
                case SUPERSECTION: {
                    return 0x1000000L;
                }
            }
            return 0L;
        }
    }
}

