/*
 * Decompiled with CFR 0.152.
 */
package com.ti.pagetableviewer.impl.shortformat;

import com.ti.pagetableviewer.impl.common.BitOperator;
import com.ti.pagetableviewer.impl.common.IPageTableEntry;
import com.ti.pagetableviewer.impl.common.LevelPageTable;
import com.ti.pagetableviewer.impl.common.LevelPageTableEntry;
import com.ti.pagetableviewer.impl.common.PageTableEntryAttribute;
import com.ti.pagetableviewer.impl.target.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class L2PageTableEntry
extends LevelPageTableEntry {
    L2EntryDescriptor descriptor;

    protected L2PageTableEntry(long entry, Target target, int index, LevelPageTable parent) {
        super(entry, target, index, parent);
        this.descriptor = L2EntryDescriptor.getDescriptor(entry);
    }

    @Override
    public boolean isTerminating() {
        return true;
    }

    @Override
    public LevelPageTable nextLevelPageTable() {
        return null;
    }

    @Override
    protected List<PageTableEntryAttribute> getAttributesToRead() {
        return this.descriptor.createAttributes();
    }

    @Override
    protected BitOperator.IBitOperation getPhysicalRegionIndexOp() throws IPageTableEntry.NonTerminatingEntryException, IPageTableEntry.InvalidEntryException {
        return this.descriptor.createIndexOp();
    }

    @Override
    protected BitOperator.IBitOperation getBaseAddressOp() throws IPageTableEntry.NonTerminatingEntryException, IPageTableEntry.InvalidEntryException {
        return this.descriptor.createBaseAddressOp();
    }

    @Override
    protected String getEntryTypeString() {
        return this.descriptor.toString();
    }

    @Override
    protected long getPhysicalRegionSize() {
        return this.descriptor.getPhysicalRegionSize();
    }

    @Override
    public long getRegionSize() {
        return this.getPhysicalRegionSize();
    }

    @Override
    public boolean isValid() {
        return this.descriptor != L2EntryDescriptor.INVALID;
    }

    private static enum L2EntryDescriptor {
        INVALID,
        LARGEPAGE,
        SMALLPAGE;


        static L2EntryDescriptor getDescriptor(long entry) {
            BitOperator.IndexOperation op = new BitOperator.IndexOperation(0, 2);
            int typeBits = (int)BitOperator.apply(entry, op);
            switch (typeBits) {
                case 0: {
                    return INVALID;
                }
                case 1: {
                    return LARGEPAGE;
                }
                case 2: 
                case 3: {
                    return SMALLPAGE;
                }
            }
            return INVALID;
        }

        BitOperator.IBitOperation createBaseAddressOp() throws IPageTableEntry.InvalidEntryException {
            switch (this) {
                case LARGEPAGE: {
                    return new BitOperator.AddressOperation(16, 16);
                }
                case SMALLPAGE: {
                    return new BitOperator.AddressOperation(12, 20);
                }
            }
            throw new IPageTableEntry.InvalidEntryException();
        }

        BitOperator.IBitOperation createIndexOp() throws IPageTableEntry.InvalidEntryException {
            switch (this) {
                case LARGEPAGE: {
                    return new BitOperator.IndexOperation(0, 16);
                }
                case SMALLPAGE: {
                    return new BitOperator.IndexOperation(0, 12);
                }
            }
            throw new IPageTableEntry.InvalidEntryException();
        }

        public String toString() {
            switch (this) {
                case LARGEPAGE: {
                    return "L2 Large Page";
                }
                case SMALLPAGE: {
                    return "L2 Small Page";
                }
            }
            return "Fault";
        }

        public List<PageTableEntryAttribute> createAttributes() {
            ArrayList<PageTableEntryAttribute> attributes = new ArrayList<PageTableEntryAttribute>();
            attributes.addAll(Arrays.asList(new PageTableEntryAttribute("AP", 4, 2), new PageTableEntryAttribute("AP[2]", 9, 1), new PageTableEntryAttribute("S", 10, 1), new PageTableEntryAttribute("nG", 11, 1), new PageTableEntryAttribute("B", 2, 1), new PageTableEntryAttribute("C", 3, 1)));
            switch (this) {
                case LARGEPAGE: {
                    attributes.addAll(Arrays.asList(new PageTableEntryAttribute("XN", 15, 1), new PageTableEntryAttribute("TEX", 12, 3)));
                    break;
                }
                case SMALLPAGE: {
                    attributes.addAll(Arrays.asList(new PageTableEntryAttribute("TEX", 6, 3), new PageTableEntryAttribute("XN", 0, 1)));
                    break;
                }
                default: {
                    attributes.clear();
                }
            }
            return attributes;
        }

        public long getPhysicalRegionSize() {
            switch (this) {
                case LARGEPAGE: {
                    return 65536L;
                }
                case SMALLPAGE: {
                    return 4096L;
                }
            }
            return 0L;
        }
    }
}

