/*
 * Decompiled with CFR 0.152.
 */
package com.ti.pagetableviewer.impl.shortformat;

import com.ti.debug.engine.IDspValue;
import com.ti.pagetableviewer.IPageTableViewer;
import com.ti.pagetableviewer.impl.common.BitOperator;
import com.ti.pagetableviewer.impl.common.IPageTable;
import com.ti.pagetableviewer.impl.common.IPageTableEntry;
import com.ti.pagetableviewer.impl.common.NumericDisplayAttribute;
import com.ti.pagetableviewer.impl.shortformat.L1PageTable;
import com.ti.pagetableviewer.impl.target.Target;
import java.util.List;

public class TTBREntry
implements IPageTableEntry {
    int N;
    Target target;
    IPageTable parent;
    int index;
    long entry;
    long baseAddress = -1L;
    IDspValue virtualBaseAddress;
    long maxVirtualAddress;

    protected TTBREntry(long entry, Target target, int index, long baseVirutalAddress, long maxVirtualAddress, IPageTable parent, int N) {
        this.entry = entry;
        this.index = index;
        this.parent = parent;
        this.N = N;
        this.target = target;
        this.virtualBaseAddress = target.createAddress(baseVirutalAddress);
        this.maxVirtualAddress = maxVirtualAddress;
    }

    @Override
    public boolean isTerminating() throws IPageTableViewer.PageTableViewerException {
        return false;
    }

    @Override
    public IPageTable nextLevelPageTable() throws IPageTableViewer.PageTableViewerException {
        return new L1PageTable(this.target, this.target.createAddress(this.getBaseAddress()), this.target.createAddress(0), this.N, this.getL1TableBeginIndex());
    }

    @Override
    public IPageTable getParentEntry() {
        return this.parent;
    }

    @Override
    public void getAttributes(List<IPageTableViewer.IDisplayAttribute> attributes) {
        try {
            String ttbrAddressFormatString = "TTBR%d Base Address";
            attributes.add(new NumericDisplayAttribute(String.format(ttbrAddressFormatString, this.index), this.getBaseAddress(), false));
            attributes.add(new NumericDisplayAttribute("Min VA", this.getBaseVirtualAddress().toLongLong(), false));
            attributes.add(new NumericDisplayAttribute("Max VA", this.maxVirtualAddress, false));
        }
        catch (IPageTableEntry.InvalidEntryException invalidEntryException) {
            // empty catch block
        }
    }

    public IDspValue getVirtualAddressBits() {
        return this.target.createAddress(0);
    }

    @Override
    public IDspValue getPhysicalAddress(IDspValue virtualAddress) throws IPageTableEntry.NonTerminatingEntryException, IPageTableEntry.InvalidEntryException {
        throw new IPageTableEntry.NonTerminatingEntryException();
    }

    @Override
    public long getPhysicalSegmentIndex(IDspValue address) throws IPageTableEntry.NonTerminatingEntryException, IPageTableEntry.InvalidEntryException {
        throw new IPageTableEntry.NonTerminatingEntryException();
    }

    @Override
    public boolean isPhysicalAddressInRange(IDspValue physicalAddress) throws IPageTableEntry.NonTerminatingEntryException {
        throw new IPageTableEntry.NonTerminatingEntryException();
    }

    private long getBaseAddress() throws IPageTableEntry.InvalidEntryException {
        BitOperator.AddressOperation baOp = null;
        if (this.baseAddress == -1L) {
            if (this.index == 0) {
                int startingBit = 14 - this.N;
                baOp = new BitOperator.AddressOperation(startingBit, 32 - startingBit);
            } else if (this.index == 1) {
                baOp = new BitOperator.AddressOperation(14, 18);
            } else {
                throw new IPageTableEntry.InvalidEntryException();
            }
            this.baseAddress = BitOperator.apply(this.entry, baOp);
        }
        return this.baseAddress;
    }

    private int getL1TableBeginIndex() {
        return this.index == 0 ? 0 : 2048 >>> this.N;
    }

    @Override
    public long getRegionSize() {
        return 0x100000000L;
    }

    @Override
    public IDspValue getBaseVirtualAddress() {
        return this.virtualBaseAddress;
    }

    @Override
    public boolean isValid() {
        return true;
    }
}

