/*
 * Decompiled with CFR 0.152.
 */
package com.ti.pagetableviewer.impl.shortformat;

import com.ti.debug.engine.IDspValue;
import com.ti.pagetableviewer.IPageTableViewer;
import com.ti.pagetableviewer.impl.PageTableViewer;
import com.ti.pagetableviewer.impl.common.BitOperator;
import com.ti.pagetableviewer.impl.common.IPageTable;
import com.ti.pagetableviewer.impl.common.IPageTableEntry;
import com.ti.pagetableviewer.impl.shortformat.TTBREntry;
import com.ti.pagetableviewer.impl.target.Target;
import java.util.ArrayList;
import java.util.List;

public class TTBRPageTable
implements IPageTable {
    int size;
    int N;
    Target target;
    IDspValue baseAddress = null;

    public TTBRPageTable(Target target) throws IPageTableViewer.PageTableViewerException {
        this.target = target;
        this.N = this.getNValue();
        this.size = this.N == 0 ? 1 : 2;
    }

    @Override
    public int getTableSize() {
        return this.size;
    }

    @Override
    public IPageTableEntry getEntry(IDspValue virtualAddress) throws IPageTableViewer.PageTableViewerException {
        boolean isInTTBR1Range = this.isAddressInTTBR1Range(virtualAddress);
        if (this.N != 0 && isInTTBR1Range) {
            return this.createEntry(1);
        }
        return this.createEntry(0);
    }

    @Override
    public List<IPageTableEntry> getEntries(int beginIndex, int endIndex) throws PageTableViewer.TargetReadException {
        ArrayList<IPageTableEntry> entries = new ArrayList<IPageTableEntry>();
        for (int i = beginIndex; i <= endIndex; ++i) {
            entries.add(this.createEntry(i));
        }
        return entries;
    }

    @Override
    public IPageTableEntry getEntry(int index) throws IPageTableViewer.PageTableViewerException {
        return this.createEntry(index);
    }

    @Override
    public IPageTableEntry getParentEntry() {
        return null;
    }

    @Override
    public int getIndexIntoTable(IDspValue virtualAddress) {
        return this.isAddressInTTBR1Range(virtualAddress) ? 1 : 0;
    }

    @Override
    public int getTableBeginIndex() {
        return 0;
    }

    @Override
    public int getTableEndIndex() {
        return this.size - 1;
    }

    private long ttbrMinAddress() {
        return 1L << 32 - this.N;
    }

    private boolean isAddressInTTBR1Range(IDspValue virtualAddress) {
        return virtualAddress.toLongLong() >= this.ttbrMinAddress();
    }

    private IPageTableEntry createEntry(int i) throws PageTableViewer.TargetReadException {
        long entryValue = 0L;
        int nValueToPassToTheEntry = 0;
        long ttbrEntryMinVA = 0L;
        long ttbrEntryMaxVA = this.getMinimumEntryRegionSize() - 1L;
        if (i == 0) {
            entryValue = this.target.getMMUConfig().getTTBR0Reg();
            nValueToPassToTheEntry = this.N;
            if (this.size > 1) {
                ttbrEntryMaxVA = this.ttbrMinAddress() - 1L;
            }
        } else if (i == 1) {
            entryValue = this.target.getMMUConfig().getTTBR1Reg();
            nValueToPassToTheEntry = 0;
            ttbrEntryMinVA = this.ttbrMinAddress();
        } else {
            throw new PageTableViewer.TargetReadException("Invalid TTBR register " + i);
        }
        return new TTBREntry(entryValue, this.target, i, ttbrEntryMinVA, ttbrEntryMaxVA, this, nValueToPassToTheEntry);
    }

    private int getNValue() throws IPageTableViewer.PageTableViewerException {
        long regTTBCR = this.target.getMMUConfig().getTTBCRReg();
        int nValue = (int)BitOperator.apply(regTTBCR, new BitOperator.IndexOperation(0, 3));
        return nValue;
    }

    @Override
    public IDspValue getBaseVirtualAddress() {
        if (this.baseAddress == null) {
            this.baseAddress = this.target.createAddress(0);
        }
        return this.baseAddress;
    }

    @Override
    public long getMinimumEntryRegionSize() {
        return 0x100000000L;
    }
}

