/*
 * Decompiled with CFR 0.152.
 */
package com.ti.pagetableviewer.impl.target;

import com.ti.debug.engine.IDspTask;
import com.ti.debug.engine.xpcom.Runtime;
import com.ti.pagetableviewer.impl.target.Target;
import com.ti.utility.filesystem.FSUtil;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MemoryServerXMLHack
implements Target.IMMURegNames {
    IDspTask task;
    String memoryServerXmlPath = null;
    private String ttbcrName = "";
    private String ttbr0Name = "";
    private String ttbr1Name = "";
    private static String TTBCRXMLREGNAME = "MmuTranslationTableBaseControlReg";
    private static String TTBR0XMLREGNAME = "MmuTranslationTableReg0BaseAdrs";
    private static String TTBR1XMLREGNAME = "MmuTranslationTableReg1BaseAdrs";

    protected MemoryServerXMLHack(IDspTask task) throws ParserConfigurationException, SAXException, IOException {
        this.task = task;
        this.initMemoryServerXmlPath();
        this.readRegisterInfoFromXmlFile();
    }

    @Override
    public String getTTBCRRegName() {
        return this.ttbcrName;
    }

    @Override
    public String getTTBR0RegName() {
        return this.ttbr0Name;
    }

    @Override
    public String getTTBR1RegName() {
        return this.ttbr1Name;
    }

    private String initMemoryServerXmlPath() {
        if (this.memoryServerXmlPath == null) {
            Runtime.getInstance();
            Runtime.getInstance();
            String XPCOMDirPath = FSUtil.FSUtil_Get_XPCOM_Dir(Runtime.getFSUtil());
            File XPCOMDir = new File(XPCOMDirPath);
            File cacheInfoDirParent = XPCOMDir.getParentFile();
            this.memoryServerXmlPath = cacheInfoDirParent + File.separator + "CacheInfo" + File.separator;
            this.memoryServerXmlPath = this.memoryServerXmlPath + this.decodeTargetProcessorId(this.task.getProcessorInfo().getProcessorID(), true);
            this.memoryServerXmlPath = this.memoryServerXmlPath + ".xml";
        }
        return this.memoryServerXmlPath;
    }

    private String decodeTargetProcessorId(long processorId, boolean XXformat) {
        String result = "";
        long procId = processorId;
        long family = procId >> 22 & 0x3FFL;
        String strFamily = Long.toString(family, 10);
        long targetIsaId = procId >> 10 & 0xFFFL;
        String strSubFamily = Long.toHexString(targetIsaId).toUpperCase();
        long revision = procId >> 3 & 0x7FL;
        String strRevision = "";
        if (revision <= 99L && !XXformat) {
            strRevision = Long.toString(revision, 10);
            if (revision < 10L && (targetIsaId >= 84L || targetIsaId == 12L && family == 470L)) {
                strRevision = "0" + strRevision;
            }
        } else {
            strRevision = XXformat || revision > 119L ? "XX" : (revision <= 109L ? Long.toString(revision -= 100L, 10) + "X" : "X" + Long.toString(revision -= 110L, 10));
        }
        result = strFamily.compareToIgnoreCase("470") == 0 ? "TMS" + strFamily + "R" + strSubFamily + strRevision : "TMS" + strFamily + "C" + strSubFamily + strRevision;
        return result;
    }

    private synchronized void readRegisterInfoFromXmlFile() throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(this.memoryServerXmlPath);
        doc.getDocumentElement().normalize();
        NodeList regNodeList = doc.getElementsByTagName("Register");
        for (int i = 0; i < regNodeList.getLength(); ++i) {
            Node regNode = regNodeList.item(i);
            if (regNode.getNodeType() != 1) continue;
            Element eRegNode = (Element)regNode;
            this.extractRegValue(eRegNode);
        }
    }

    private void extractRegValue(Element eRegNode) {
        String regName = eRegNode.getElementsByTagName("Name").item(0).getTextContent();
        if (regName != null) {
            if (regName.equals(TTBCRXMLREGNAME)) {
                this.ttbcrName = eRegNode.getElementsByTagName("SymbolName").item(0).getTextContent();
            } else if (regName.equals(TTBR0XMLREGNAME)) {
                this.ttbr0Name = eRegNode.getElementsByTagName("SymbolName").item(0).getTextContent();
            } else if (regName.equals(TTBR1XMLREGNAME)) {
                this.ttbr1Name = eRegNode.getElementsByTagName("SymbolName").item(0).getTextContent();
            }
        }
    }
}

