/*
 * Decompiled with CFR 0.152.
 */
package com.ti.pagetableviewer.impl.target;

import com.ti.debug.engine.IDspMemory;
import com.ti.debug.engine.IDspRegister;
import com.ti.debug.engine.IDspTask;
import com.ti.debug.engine.IDspValue;
import com.ti.debug.engine.IMemoryAccess;
import com.ti.debug.engine.IRegister;
import com.ti.debug.engine.events.data.IMemoryAccessEventData;
import com.ti.debug.engine.events.data.IRegisterAccessEventData;
import com.ti.debug.engine.events.types.IObjectEventListener;
import com.ti.pagetableviewer.impl.PageTableViewer;
import com.ti.pagetableviewer.impl.common.LevelPageTable;
import com.ti.pagetableviewer.impl.target.IMMUConfig;
import com.ti.pagetableviewer.impl.target.MemoryServerXMLHack;
import java.util.concurrent.CountDownLatch;

public class Target {
    IDspTask dspTask;
    IMMUConfig mmuConfig = null;
    LevelPageTable.IPageTableData singleEntryPageTableData = null;
    private static IMMUConfig fakeMMUConfig = null;

    public Target(IDspTask dspTask) {
        this.dspTask = dspTask;
    }

    public IDspValue createAddress(long address) {
        return this.dspTask.getMemoryAccess().createDspValue(IDspValue.Type.UDATA64, address);
    }

    public IDspValue createAddress(int address) {
        return this.dspTask.getMemoryAccess().createDspValue(IDspValue.Type.UDATA64, address);
    }

    private long readRegSync(String name) throws PageTableViewer.TargetReadException {
        IRegister register = this.dspTask.getRegisterServer().findRegisterByName(name);
        IDspMemory memory = this.dspTask.getMemoryAccess().createDspMemory(register);
        IDspRegister reg = (IDspRegister)memory;
        final CountDownLatch requestDone = new CountDownLatch(1);
        this.dspTask.getRegisterAccess().requestRegisterRead(reg, new IObjectEventListener<IRegisterAccessEventData>(){

            @Override
            public void onEvent(IRegisterAccessEventData data) {
                requestDone.countDown();
            }
        });
        try {
            requestDone.await();
        }
        catch (InterruptedException e) {
            throw new PageTableViewer.TargetReadException("Failed to read reg : " + name);
        }
        IDspValue dspValue = this.dspTask.getMemoryAccess().createDspValue(IDspValue.Type.UDATA64, 0L);
        memory.getDspValue(dspValue, 0);
        return dspValue.toLongLong();
    }

    private void readMemSync(IDspMemory mem) throws InterruptedException {
        mem.getIDspMemory2().setMemoryAccessLevel(1);
        final CountDownLatch requestDone = new CountDownLatch(1);
        this.dspTask.getMemoryAccess().requestMemoryRead(mem, new IObjectEventListener<IMemoryAccessEventData>(){

            @Override
            public void onEvent(IMemoryAccessEventData data) {
                requestDone.countDown();
            }
        });
        requestDone.await();
    }

    public IMMUConfig getMMUConfig() throws PageTableViewer.TargetReadException {
        if (fakeMMUConfig != null) {
            return fakeMMUConfig;
        }
        if (this.mmuConfig == null) {
            this.mmuConfig = new MMUConfig();
        }
        return this.mmuConfig;
    }

    public long getEntry(IDspValue entryAddress) throws PageTableViewer.TargetReadException {
        return 0L;
    }

    public LevelPageTable.IPageTableData getSingleEntryPageTableDataAccess(int entrySize) {
        if (this.singleEntryPageTableData == null) {
            this.singleEntryPageTableData = new SingleEntryPageTableData(entrySize);
        }
        return this.singleEntryPageTableData;
    }

    public LevelPageTable.IPageTableData getMultiEntryPageTableDataAccess(long baseAddress, int numEntries, int entrySize) {
        return new MultiEntryPageTableData(baseAddress, numEntries, entrySize);
    }

    public static void setFakeMMUConfig(IMMUConfig config) {
        fakeMMUConfig = config;
    }

    private class MultiEntryPageTableData
    implements LevelPageTable.IPageTableData {
        int entrySize = 0;
        int numEntries = 0;
        IDspMemory mem = null;
        long baseAddress = 0L;
        IDspValue entryDataDspVal = null;

        public MultiEntryPageTableData(long baseAddress, int numEntries, int entrySize) {
            this.entrySize = entrySize;
            this.numEntries = numEntries;
            this.baseAddress = baseAddress;
            IDspValue.Type type = entrySize == 32 ? IDspValue.Type.UDATA32 : IDspValue.Type.UDATA64;
            this.entryDataDspVal = Target.this.dspTask.getMemoryAccess().createDspValue(type, 0L);
        }

        @Override
        public long getEntry(long entryAddress) throws PageTableViewer.TargetReadException {
            if (this.mem == null) {
                this.readEntries(Target.this.createAddress(this.baseAddress));
            }
            int offset = (int)(entryAddress - this.baseAddress);
            this.mem.getDspValue(this.entryDataDspVal, offset);
            return this.entryDataDspVal.toLongLong();
        }

        private int getMuaSize() {
            return 8;
        }

        private void readEntries(IDspValue entryAddress) throws PageTableViewer.TargetReadException {
            if (this.entrySize != 32 && this.entrySize != 64) {
                throw new IllegalArgumentException("Entry size could only be 32 or 64 ");
            }
            IMemoryAccess memAccess = Target.this.dspTask.getMemoryAccess();
            int length = this.entrySize / this.getMuaSize();
            this.mem = memAccess.createDspMemory(entryAddress, length *= this.numEntries, (short)0);
            try {
                Target.this.readMemSync(this.mem);
            }
            catch (InterruptedException e) {
                throw new PageTableViewer.TargetReadException("Failed to read entry at 0x" + Long.toHexString(entryAddress.toLongLong()));
            }
        }
    }

    private class SingleEntryPageTableData
    implements LevelPageTable.IPageTableData {
        int entrySize = 0;
        IDspValue entryDataDspVal = null;
        IDspValue entryAddressDspVal = null;

        public SingleEntryPageTableData(int entrySize) {
            this.entrySize = entrySize;
            IDspValue.Type type = entrySize == 32 ? IDspValue.Type.UDATA32 : IDspValue.Type.UDATA64;
            this.entryDataDspVal = Target.this.dspTask.getMemoryAccess().createDspValue(type, 0L);
            this.entryAddressDspVal = Target.this.createAddress(0);
        }

        @Override
        public long getEntry(long entryAddress) throws PageTableViewer.TargetReadException {
            this.entryAddressDspVal.assignLongLong(entryAddress);
            this.readEntry(this.entryAddressDspVal);
            return this.entryDataDspVal.toLongLong();
        }

        private void readEntry(IDspValue entryAddress) throws PageTableViewer.TargetReadException {
            if (this.entrySize != 32 && this.entrySize != 64) {
                throw new IllegalArgumentException("Entry size could only be 32 or 64 ");
            }
            IMemoryAccess memAccess = Target.this.dspTask.getMemoryAccess();
            int length = this.entrySize / 8;
            IDspMemory mem = memAccess.createDspMemory(entryAddress, length, (short)0);
            try {
                Target.this.readMemSync(mem);
            }
            catch (InterruptedException e) {
                throw new PageTableViewer.TargetReadException("Failed to read entry at 0x" + Long.toHexString(entryAddress.toLongLong()));
            }
            mem.getDspValue(this.entryDataDspVal, 0);
        }
    }

    public static interface IMMURegNames {
        public String getTTBCRRegName();

        public String getTTBR0RegName();

        public String getTTBR1RegName();
    }

    private class MMUConfig
    implements IMMUConfig {
        private IMMURegNames regNames = null;

        public MMUConfig() throws PageTableViewer.TargetReadException {
            try {
                this.regNames = new MemoryServerXMLHack(Target.this.dspTask);
            }
            catch (Exception e) {
                throw new PageTableViewer.TargetReadException("Failed to read register information : " + e.getMessage());
            }
        }

        @Override
        public long getTTBCRReg() throws PageTableViewer.TargetReadException {
            return Target.this.readRegSync(this.regNames.getTTBCRRegName());
        }

        @Override
        public long getTTBR0Reg() throws PageTableViewer.TargetReadException {
            return Target.this.readRegSync(this.regNames.getTTBR0RegName());
        }

        @Override
        public long getTTBR1Reg() throws PageTableViewer.TargetReadException {
            return Target.this.readRegSync(this.regNames.getTTBR1RegName());
        }
    }
}

