/*
 * Decompiled with CFR 0.152.
 */
package com.ti.utility.filesystem;

import com.ti.debug.engine.xpcom.Runtime;
import com.ti.utility.filesystem.FSUtil;
import com.ti.utility.filesystem.SWIGTYPE_p_FSUtil;
import java.io.File;

public class DirectoryService {
    private final SWIGTYPE_p_FSUtil fsUtil = Runtime.getFSUtil();
    private static DirectoryService instance = null;

    private DirectoryService() {
    }

    public static DirectoryService instance() {
        if (null == instance) {
            instance = new DirectoryService();
        }
        return instance;
    }

    public String getAppDataDir() {
        return this.getTemporaryFileDir();
    }

    public String getTemporaryFileDir() {
        return FSUtil.FSUtil_Get_AppData_Dir(this.fsUtil);
    }

    public String getSharedTemporaryFileDir() {
        String temporaryFileDir = this.getTemporaryFileDir();
        if (temporaryFileDir.equals(this.getInstallDir())) {
            return temporaryFileDir;
        }
        return new File(temporaryFileDir).getParent();
    }

    public String getConfigurationFileDir() {
        return System.getProperty("user.home") + File.separator + "ti";
    }

    public String getInstallDir() {
        return FSUtil.FSUtil_Get_Install_Dir(this.fsUtil);
    }

    public String getBaseDir() {
        return FSUtil.FSUtil_Get_Base_Dir(this.fsUtil);
    }

    public String getCommonBinDir() {
        return FSUtil.FSUtil_Get_CommonBin_Dir(this.fsUtil);
    }

    public String getDSBinDir() {
        return FSUtil.FSUtil_Get_DebugServerBin_Dir(this.fsUtil);
    }

    public String getProfileActivitiesDir() {
        return this.getDSBinDir() + File.separator + "SerializedProfileActivities";
    }

    public String getLicenseDir() {
        return this.getDSBinDir() + ".." + File.separator + "license";
    }

    public String getScriptingDir() {
        return this.getBaseDir() + File.separator + "scripting";
    }

    public String getScriptingExamplesDir() {
        return this.getScriptingDir() + File.separator + "examples";
    }

    public String getTargetDBDir() {
        return this.getBaseDir() + File.separator + "common" + File.separator + "targetdb";
    }

    public String getJavaDir() {
        return this.getDSBinDir() + File.separator + ".." + File.separator + "packages" + File.separator + "ti" + File.separator + "dss" + File.separator + "java";
    }
}

