/*
 * Decompiled with CFR 0.152.
 */
package com.ti.xpcom.internal;

import com.ti.xpcom.XPCOMException;
import com.ti.xpcom.interfaces.nsIComponentManager;
import com.ti.xpcom.interfaces.nsISupports;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

class JavaComponentManager
implements nsIComponentManager {
    private Map<String, String> components = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JavaComponentManager(File aXpcomBinDirectory) throws FileNotFoundException, UnsupportedEncodingException {
        File componentsDirectory = new File(aXpcomBinDirectory.getParent() + File.separator + "components" + File.separator + "javacomponents.txt");
        FileInputStream inputStream = new FileInputStream(componentsDirectory);
        Scanner scanner = new Scanner((InputStream)inputStream, "UTF-8");
        try {
            while (scanner.hasNextLine()) {
                this.processLine(scanner.nextLine());
            }
        }
        finally {
            scanner.close();
        }
    }

    private void processLine(String line) {
        Scanner scanner = new Scanner(line);
        scanner.useDelimiter(" ");
        String contractID = scanner.next();
        String javaClass = scanner.next();
        this.components.put(contractID, javaClass);
        scanner.close();
    }

    @Override
    public nsISupports queryInterface(String uuid) {
        if (uuid.equals("{a88e5a60-205a-4bb1-94e1-2628daf51eae}") || uuid.equals("{00000000-0000-0000-c000-000000000046}")) {
            return this;
        }
        return null;
    }

    @Override
    public nsISupports createInstanceByContractID(String aContractID, nsISupports aDelegate, String aIID) {
        try {
            String className = this.components.get(aContractID);
            Class<?> componentDefinition = Class.forName(className);
            Class[] methodSignature = new Class[]{nsISupports.class, String.class};
            Method creator = componentDefinition.getDeclaredMethod("NSCreateInstanceByContractID", methodSignature);
            Object[] constructorArgs = new Object[]{aDelegate, aIID};
            return (nsISupports)creator.invoke(null, constructorArgs);
        }
        catch (NullPointerException e) {
            throw new XPCOMException(2147500035L, e.getMessage());
        }
        catch (OutOfMemoryError e) {
            throw new XPCOMException(2147942414L, e.getMessage());
        }
        catch (Throwable e) {
            throw new XPCOMException(2147500034L, e.getMessage());
        }
    }
}

