/*
 * Decompiled with CFR 0.152.
 */
package com.ti.xpcom.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class XPCOMJavaProxy
implements InvocationHandler {
    private long nativeXPCOMPtr;

    public XPCOMJavaProxy(long aXPCOMInstance) {
        this.nativeXPCOMPtr = aXPCOMInstance;
    }

    private static long getNativeXPCOMInstance(Object aProxy) {
        XPCOMJavaProxy proxy = (XPCOMJavaProxy)Proxy.getInvocationHandler(aProxy);
        return proxy.nativeXPCOMPtr;
    }

    protected static Object createProxy(Class aInterface, long aXPCOMInstance) {
        return Proxy.newProxyInstance(aInterface.getClassLoader(), new Class[]{aInterface}, (InvocationHandler)new XPCOMJavaProxy(aXPCOMInstance));
    }

    @Override
    public Object invoke(Object aProxy, Method aMethod, Object[] aParams) throws Throwable {
        String methodName = aMethod.getName();
        if (aMethod.getDeclaringClass() == Object.class) {
            if (methodName.equals("hashCode")) {
                return XPCOMJavaProxy.proxyHashCode(aProxy);
            }
            if (methodName.equals("equals")) {
                return XPCOMJavaProxy.proxyEquals(aProxy, aParams[0]);
            }
            if (methodName.equals("toString")) {
                return XPCOMJavaProxy.proxyToString(aProxy);
            }
            System.err.println("WARNING: Unhandled Object method [" + methodName + "]");
            return null;
        }
        return XPCOMJavaProxy.callXPCOMMethod(this, this.nativeXPCOMPtr, methodName, aParams);
    }

    private static Integer proxyHashCode(Object aProxy) {
        return new Integer(System.identityHashCode(aProxy));
    }

    private static Boolean proxyEquals(Object aProxy, Object aOther) {
        if (aProxy == aOther) {
            return Boolean.TRUE;
        }
        if (XPCOMJavaProxy.isXPCOMJavaProxy(aOther) && XPCOMJavaProxy.getNativeXPCOMInstance(aProxy) == XPCOMJavaProxy.getNativeXPCOMInstance(aOther)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected static boolean isXPCOMJavaProxy(Object aObject) {
        InvocationHandler h;
        return aObject != null && Proxy.isProxyClass(aObject.getClass()) && (h = Proxy.getInvocationHandler(aObject)) instanceof XPCOMJavaProxy;
    }

    private static String proxyToString(Object aProxy) {
        return aProxy.getClass().getInterfaces()[0].getName() + '@' + Integer.toHexString(aProxy.hashCode());
    }

    protected void finalize() throws Throwable {
        XPCOMJavaProxy.finalizeProxyNative(this.nativeXPCOMPtr);
        super.finalize();
    }

    private static native void finalizeProxyNative(long var0);

    private static native Object callXPCOMMethod(Object var0, long var1, String var3, Object[] var4);
}

