/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.logging.Logger;

public class CIOServer
implements Runnable {
    private InputStream in;
    private OutputStream out;
    private short msTime = (short)1000;
    private Thread cioThread;
    private Logger traceLog;
    private String defaultFilePath;
    private byte[] param = new byte[12];
    private ByteBuffer byteBuf = ByteBuffer.allocateDirect(8);
    private HashMap<Integer, Integer> fileOpenMode;
    private HashMap<Integer, RandomAccessFile> file;
    private static final int STDIN = 0;
    private static final int STDOUT = 1;
    private static final int STDERR = 2;
    private static final int DTOPEN = 240;
    private static final int DTCLOSE = 241;
    private static final int DTREAD = 242;
    private static final int DTWRITE = 243;
    private static final int DTLSEEK = 244;
    private static final int DTUNLINK = 245;
    private static final int DTGETENV = 246;
    private static final int DTRENAME = 247;
    private static final int DTGETTIME = 248;
    private static final int DTGETCLK = 249;
    private static final int O_RDONLY = 0;
    private static final int O_WRONLY = 1;
    private static final int O_RDWR = 2;
    private static final int O_APPEND = 8;
    private static final int O_CREAT = 512;
    private static final int O_TRUNC = 1024;
    private static final int O_BINARY = 32768;
    private static final int SEEK_SET = 0;
    private static final int SEEK_CUR = 1;
    private static final int SEEK_END = 2;
    private static final long TIME_DIFF = 2208988800L;
    private static int count = 0;

    public CIOServer(InputStream iStrm, OutputStream oStrm, String symbolFilePath) {
        this.in = iStrm;
        this.out = oStrm;
        this.defaultFilePath = symbolFilePath;
        this.file = new HashMap();
        this.fileOpenMode = new HashMap();
        this.traceLog = Logger.getLogger(this.getClass().getName());
        this.byteBuf.order(ByteOrder.LITTLE_ENDIAN);
        this.cioThread = new Thread((Runnable)this, CIOServer.getThreadName());
        this.cioThread.start();
    }

    private static String getThreadName() {
        return "cio server thread - " + count;
    }

    protected void stop() {
        try {
            if (this.cioThread != null) {
                this.cioThread.interrupt();
                this.cioThread.join();
                this.cioThread = null;
            }
            Iterator<RandomAccessFile> i = this.file.values().iterator();
            while (i.hasNext()) {
                i.next().close();
            }
            this.file.clear();
        }
        catch (Exception e) {
            System.out.println("CIOServer::stop interrupt: " + e);
        }
    }

    public void flush() {
        try {
            Iterator<RandomAccessFile> i = this.file.values().iterator();
            while (i.hasNext()) {
                i.next().getFD().sync();
            }
        }
        catch (Exception e) {
            System.out.println("CIOServer flush failed: " + e);
        }
    }

    @Override
    public void run() {
        try {
            byte[] buffer = new byte[4];
            int bytesRead = buffer.length;
            block14: while (bytesRead == buffer.length && (bytesRead = this.in.read(buffer, 0, buffer.length)) == buffer.length) {
                this.byteBuf.position(0);
                this.byteBuf.put(buffer, 0, 4);
                this.byteBuf.put((byte)0);
                this.byteBuf.position(0);
                char command = this.byteBuf.getChar(3);
                this.byteBuf.put(3, (byte)0);
                int length = this.byteBuf.getInt();
                Arrays.fill(this.param, (byte)0);
                int paramsRead = this.in.read(this.param, 4, 8);
                if (paramsRead != 8) {
                    System.out.println("CIOServer read param failed, count = " + paramsRead);
                    return;
                }
                this.byteBuf.position(0);
                this.byteBuf.put(this.param, 4, 8);
                this.byteBuf.position(0);
                switch (command) {
                    case '\u00f0': {
                        this.doOpen(length);
                        continue block14;
                    }
                    case '\u00f1': {
                        this.doClose(length);
                        continue block14;
                    }
                    case '\u00f2': {
                        this.doRead(length);
                        continue block14;
                    }
                    case '\u00f3': {
                        this.doWrite(length);
                        continue block14;
                    }
                    case '\u00f4': {
                        this.doSeek(length);
                        continue block14;
                    }
                    case '\u00f5': {
                        this.doUnlink(length);
                        continue block14;
                    }
                    case '\u00f7': {
                        this.doRename(length);
                        continue block14;
                    }
                    case '\u00f6': {
                        this.doEnv(length);
                        continue block14;
                    }
                    case '\u00f8': {
                        this.doTime();
                        continue block14;
                    }
                    case '\u00f9': {
                        this.doClock();
                        continue block14;
                    }
                }
                bytesRead = 0;
                System.out.println("CIOServer invalid command: " + Integer.toHexString(command));
            }
        }
        catch (Exception e) {
            System.out.println("CIOServer failed: " + e);
        }
    }

    private void doRead(int count) {
        try {
            short dev_fd = this.byteBuf.getShort();
            int length = this.byteBuf.getShort() & 0xFFFF;
            if (0 != count) {
                System.out.println("CIOServer length not zero: length = " + count);
                return;
            }
            this.param[0] = this.param[6];
            this.param[1] = this.param[7];
            this.param[4] = this.param[6];
            this.param[5] = this.param[7];
            this.param[6] = 0;
            this.param[7] = 0;
            byte[] buf = new byte[length + 1];
            if (dev_fd == 0) {
                System.in.read(buf, 0, length);
            } else if (dev_fd > 2 && this.fileOpenMode.containsKey(dev_fd) && (this.fileOpenMode.get(dev_fd) & 1) != 1) {
                int len = this.file.get(dev_fd).read(buf, 0, length);
                if (len < 0) {
                    length = 0;
                    this.param[0] = 0;
                    this.param[1] = 0;
                    if (len == -1) {
                        this.param[4] = 0;
                        this.param[5] = 0;
                    } else {
                        this.param[4] = -1;
                        this.param[5] = -1;
                        this.param[6] = -1;
                        this.param[7] = -1;
                    }
                } else if (len < length) {
                    length = len;
                    this.byteBuf.putInt(0, len);
                    this.byteBuf.position(0);
                    this.byteBuf.get(this.param, 0, 2);
                    this.byteBuf.position(0);
                    this.byteBuf.get(this.param, 4, 2);
                }
            } else {
                length = 0;
                this.param[0] = 0;
                this.param[1] = 0;
                this.param[4] = -1;
                this.param[5] = -1;
                this.param[6] = -1;
                this.param[7] = -1;
            }
            this.out.write(this.param);
            this.out.flush();
            this.out.write(buf, 0, length + length % 2);
        }
        catch (Exception e) {
            System.out.println("CIOServer doRead failed: " + e);
        }
    }

    private void doWrite(int count) {
        try {
            short dev_fd = this.byteBuf.getShort();
            int length = this.byteBuf.getShort() & 0xFFFF;
            if (length != count) {
                System.out.println("CIOServer length mismatch: length = " + count + "params = " + length);
                return;
            }
            byte[] buf = new byte[length + 1];
            int bytesRead = this.in.read(buf, 0, length + length % 2);
            if (bytesRead != (length % 2 == 1 ? length + 1 : length)) {
                return;
            }
            this.param[4] = this.param[6];
            this.param[5] = this.param[7];
            this.param[6] = 0;
            this.param[7] = 0;
            if (dev_fd == 1 || dev_fd == 2 || this.fileOpenMode.containsKey(dev_fd) && this.fileOpenMode.get(dev_fd) == -1 || this.fileOpenMode.containsKey(dev_fd) && this.fileOpenMode.get(dev_fd) == -2) {
                String bufStr = new String(buf, 0, length);
                if (length > 0) {
                    if (dev_fd == 2 || this.fileOpenMode.containsKey(dev_fd) && this.fileOpenMode.get(dev_fd) == -2) {
                        System.out.print(bufStr);
                    } else {
                        System.out.print(bufStr);
                    }
                }
            } else if (dev_fd > 2 && this.fileOpenMode.containsKey(dev_fd) && (this.fileOpenMode.get(dev_fd) & 3) != 0) {
                if ((this.fileOpenMode.get(dev_fd) & 8) == 8) {
                    this.file.get(dev_fd).seek(this.file.get(dev_fd).length());
                }
                if ((this.fileOpenMode.get(dev_fd) & 0x8000) != 32768 && length > 0 && buf[length - 1] == 0) {
                    this.file.get(dev_fd).write(buf, 0, length - 1);
                } else {
                    this.file.get(dev_fd).write(buf, 0, length);
                }
            } else {
                this.param[4] = -1;
                this.param[5] = -1;
                this.param[6] = -1;
                this.param[7] = -1;
            }
            this.out.write(this.param);
        }
        catch (Exception e) {
            System.out.println("CIOServer doWrite failed: " + e);
        }
    }

    private void doSeek(int count) {
        try {
            if (0 != count) {
                System.out.println("CIOServer length not zero: length = " + count);
                return;
            }
            short dev_fd = this.byteBuf.getShort();
            int offset = this.byteBuf.getInt();
            short origin = this.byteBuf.getShort();
            int position = -1;
            if (dev_fd > 2 && this.file.get(dev_fd) != null) {
                if (origin == 0) {
                    this.file.get(dev_fd).seek(offset);
                    position = (int)this.file.get(dev_fd).getFilePointer();
                } else if (origin == 1) {
                    this.file.get(dev_fd).seek(this.file.get(dev_fd).getFilePointer() + (long)offset);
                    position = (int)this.file.get(dev_fd).getFilePointer();
                } else if (origin == 2) {
                    this.file.get(dev_fd).seek(this.file.get(dev_fd).length() + (long)offset);
                    position = (int)this.file.get(dev_fd).getFilePointer();
                }
            }
            this.byteBuf.putInt(0, position);
            this.byteBuf.position(0);
            this.byteBuf.get(this.param, 4, 4);
            this.out.write(this.param);
        }
        catch (Exception e) {
            System.out.println("CIOServer doSeek failed: " + e);
        }
    }

    private void doOpen(int length) {
        try {
            short dev_fd = this.byteBuf.getShort();
            short flags = this.byteBuf.getShort();
            byte[] buf = new byte[length + 1];
            int bytesRead = this.in.read(buf, 0, length + length % 2);
            if (bytesRead != length + length % 2) {
                System.out.println("CIOServer doOpen read data failed.");
                return;
            }
            String fileNameStr = new String(buf, 0, length - 1);
            this.traceLog.fine("CIO doOpen file: " + new String(buf, 0, length - 1) + ", dev_fd = " + dev_fd);
            this.param[6] = 0;
            this.param[7] = 0;
            if (fileNameStr.compareTo("stdout") == 0) {
                this.fileOpenMode.put(Integer.valueOf(dev_fd), -1);
            } else if (fileNameStr.compareTo("stderr") == 0) {
                this.fileOpenMode.put(Integer.valueOf(dev_fd), -2);
            } else if (dev_fd <= 2) {
                this.param[4] = -1;
                this.param[5] = -1;
                this.param[6] = -1;
                this.param[7] = -1;
            } else {
                try {
                    File fileName = new File(this.defaultFilePath, new String(buf, 0, length - 1));
                    if ((flags & 0xFFF) == 0) {
                        if (fileName.exists()) {
                            this.file.put(Integer.valueOf(dev_fd), new RandomAccessFile(fileName, "r"));
                        } else {
                            this.param[4] = -1;
                            this.param[5] = -1;
                            this.param[6] = -1;
                            this.param[7] = -1;
                        }
                    } else if ((flags & 0xFFF) == 2) {
                        if (fileName.exists()) {
                            this.file.put(Integer.valueOf(dev_fd), new RandomAccessFile(fileName, "rw"));
                        } else {
                            this.param[4] = -1;
                            this.param[5] = -1;
                            this.param[6] = -1;
                            this.param[7] = -1;
                        }
                    } else if ((flags & 0xFFF) == 1537) {
                        this.file.put(Integer.valueOf(dev_fd), new RandomAccessFile(fileName, "rw"));
                        this.file.get(dev_fd).setLength(0L);
                    } else if ((flags & 0xFFF) == 1538) {
                        this.file.put(Integer.valueOf(dev_fd), new RandomAccessFile(fileName, "rw"));
                        this.file.get(dev_fd).setLength(0L);
                    } else if ((flags & 0xFFF) == 521) {
                        this.file.put(Integer.valueOf(dev_fd), new RandomAccessFile(fileName, "rw"));
                        this.file.get(dev_fd).seek(this.file.get(dev_fd).length());
                    } else if ((flags & 0xFFF) == 522) {
                        this.file.put(Integer.valueOf(dev_fd), new RandomAccessFile(fileName, "rw"));
                        this.file.get(dev_fd).seek(this.file.get(dev_fd).length());
                    }
                    this.fileOpenMode.put(Integer.valueOf(dev_fd), Integer.valueOf(flags));
                }
                catch (Exception e) {
                    System.out.println("CIOServer doOpen failed on file: " + new String(buf, 0, length - 1) + " error = " + e);
                    this.param[4] = -1;
                    this.param[5] = -1;
                    this.param[6] = -1;
                    this.param[7] = -1;
                }
            }
            this.out.write(this.param);
        }
        catch (Exception e) {
            System.out.println("CIOServer doOpen failed: " + e);
        }
    }

    private void doEnv(int length) {
        try {
            byte[] buf = new byte[length + 1];
            int bytesRead = this.in.read(buf, 0, length + length % 2);
            if (bytesRead != length + length % 2) {
                System.out.println("CIOServer doEnv read data failed.");
                return;
            }
            int envLen = 0;
            int retVal = 1;
            byte[] result = null;
            try {
                String env = System.getenv(new String(buf, 0, length - 1));
                if (env == null) {
                    env = "";
                    retVal = 0;
                }
                env = env + "  ";
                result = env.getBytes();
                result[env.length() - 2] = 0;
                envLen = env.length() - 1;
            }
            catch (Exception e) {
                System.out.println("CIOServer getenv failed: " + e);
                result = "  ".getBytes();
                result[0] = 0;
                envLen = 1;
                retVal = 0;
            }
            this.byteBuf.position(0);
            this.byteBuf.putInt(envLen);
            this.byteBuf.putInt(retVal);
            this.byteBuf.position(0);
            this.byteBuf.get(this.param, 0, 8);
            this.out.write(this.param);
            if (envLen > 0) {
                this.out.write(result, 0, envLen + envLen % 2);
            }
        }
        catch (Exception e) {
            System.out.println("CIOServer doEnv failed: " + e);
        }
    }

    private void doUnlink(int length) {
        try {
            byte[] buf = new byte[length + 1];
            int bytesRead = this.in.read(buf, 0, length + length % 2);
            if (bytesRead != length + length % 2) {
                System.out.println("CIOServer doUnlink read data failed.");
                return;
            }
            this.param[4] = -1;
            this.param[5] = -1;
            this.param[6] = -1;
            this.param[7] = -1;
            try {
                File fileName = new File(this.defaultFilePath, new String(buf, 0, length - 1));
                if (fileName.exists() && fileName.isFile() && fileName.canWrite() && fileName.delete()) {
                    this.param[4] = 0;
                    this.param[5] = 0;
                    this.param[6] = 0;
                    this.param[7] = 0;
                }
            }
            catch (Exception e) {
                System.out.println("CIOServer doUnlink failed: " + e);
            }
            this.out.write(this.param);
        }
        catch (Exception e) {
            System.out.println("CIOServer doEnv failed: " + e);
        }
    }

    private void doRename(int length) {
        try {
            byte[] buf = new byte[length + 1];
            int bytesRead = this.in.read(buf, 0, length + length % 2);
            if (bytesRead != length + length % 2) {
                System.out.println("CIOServer doRename read data failed.");
                return;
            }
            this.param[4] = -1;
            this.param[5] = -1;
            this.param[6] = -1;
            this.param[7] = -1;
            try {
                String bothNames = new String(buf, 0, length - 1);
                int index = bothNames.indexOf(0);
                String oldName = new String(buf, 0, index);
                String newName = new String(buf, index + 1, length - index - 2);
                File oldFileName = new File(this.defaultFilePath, oldName);
                File newFileName = new File(this.defaultFilePath, newName);
                if (oldFileName.renameTo(newFileName)) {
                    this.param[4] = 0;
                    this.param[5] = 0;
                    this.param[6] = 0;
                    this.param[7] = 0;
                }
            }
            catch (Exception e) {
                System.out.println("CIOServer doRename failed: " + e);
            }
            this.out.write(this.param);
        }
        catch (Exception e) {
            System.out.println("CIOServer doRename failed: " + e);
        }
    }

    private void doClose(int length) {
        try {
            if (0 != length) {
                System.out.println("CIOServer length not zero: length = " + length);
                return;
            }
            short dev_fd = this.byteBuf.getShort();
            this.traceLog.fine("CIO doClose dev_fd = " + dev_fd);
            this.param[4] = 0;
            this.param[5] = 0;
            this.param[6] = 0;
            this.param[7] = 0;
            if (dev_fd <= 2) {
                this.param[4] = -1;
                this.param[5] = -1;
                this.param[6] = -1;
                this.param[7] = -1;
            } else {
                try {
                    if (this.fileOpenMode.get(dev_fd) > -1) {
                        this.file.get(dev_fd).close();
                    }
                    this.file.remove(dev_fd);
                    this.fileOpenMode.remove(dev_fd);
                }
                catch (Exception e) {
                    this.param[4] = -1;
                    this.param[5] = -1;
                    this.param[6] = -1;
                    this.param[7] = -1;
                }
            }
            this.out.write(this.param);
        }
        catch (Exception e) {
            System.out.println("CIOServer doOpen failed: " + e);
        }
    }

    private void doTime() {
        try {
            long timeInMs = System.currentTimeMillis();
            long timeInSec = timeInMs / 1000L;
            this.msTime = (short)(timeInMs - timeInSec * 1000L);
            long timezoneDiff = TimeZone.getDefault().getRawOffset() / 1000;
            timeInSec = timeInSec + 2208988800L + (timezoneDiff += (long)(TimeZone.getDefault().getDSTSavings() / 1000));
            this.byteBuf.position(0);
            this.byteBuf.putInt((int)timeInSec);
            this.byteBuf.position(0);
            this.byteBuf.get(this.param, 4, 4);
            this.out.write(this.param);
        }
        catch (Exception e) {
            System.out.println("CIOServer doTime failed: " + e);
        }
    }

    private void doClock() {
        try {
            this.param[4] = (byte)(this.msTime & 0xFF);
            this.param[5] = (byte)(this.msTime >> 8 & 0xFF);
            this.param[6] = 0;
            this.param[7] = 0;
            this.out.write(this.param);
        }
        catch (Exception e) {
            System.out.println("CIOServer doClock failed: " + e);
        }
    }
}

