/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting;

import com.ti.ccstudio.scripting.environment.ScriptingException;
import com.ti.debug.engine.scripting.RTDXInputStream;
import com.ti.debug.engine.scripting.RTDXOutputStream;
import com.ti.debug.engine.scripting.RTDXSession;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Logger;

public class RTAServer
implements Runnable {
    private RTDXInputStream in;
    private RTDXOutputStream out;
    private Thread rtaThread;
    private RTDXSession rtdxSession = null;
    private Logger traceLog;
    protected static final String rtaOutputChannelName = "RTA_fromHost$rtdx";
    protected static final String rtaInputChannelName = "RTA_toHost$rtdx";
    private static final int MAXFILES = 20;
    private RandomAccessFile[] file;
    private int[] fileOpenMode;
    private static int count = 0;

    public RTAServer(InputStream iStrm, OutputStream oStrm) {
        this.file = new RandomAccessFile[20];
        this.fileOpenMode = new int[20];
        this.rtaThread = new Thread((Runnable)this, RTAServer.getThreadName());
        this.rtaThread.start();
    }

    public RTAServer(RTDXSession session) throws ScriptingException {
        this.in = new RTDXInputStream(session, rtaInputChannelName);
        this.rtdxSession = session;
        this.out = new RTDXOutputStream(session, rtaOutputChannelName);
        this.traceLog = Logger.getLogger(this.getClass().getName());
        this.file = new RandomAccessFile[20];
        this.fileOpenMode = new int[20];
        System.out.format("RTAServer starting thread(%d)\n", 567);
        this.rtaThread = new Thread((Runnable)this, RTAServer.getThreadName());
        this.rtaThread.start();
    }

    private static String getThreadName() {
        return "rta server thread - " + count;
    }

    protected void start() {
        try {
            if (this.rtdxSession != null) {
                this.rtdxSession.enableChannel(rtaOutputChannelName);
                this.rtdxSession.enableChannel(rtaInputChannelName);
            }
        }
        catch (Exception e) {
            System.out.println("RTAServer::start error: " + e);
        }
    }

    protected void stop() {
        try {
            if (this.rtaThread != null) {
                this.rtaThread.interrupt();
                this.rtaThread = null;
            }
            for (int i = 3; i < 20; ++i) {
                if (this.file[i] == null) continue;
                this.file[i].close();
                this.file[i] = null;
            }
        }
        catch (Exception e) {
            System.out.println("RTAServer::stop interrupt: " + e);
        }
    }

    public void flush() {
        try {
            for (int i = 3; i < 20; ++i) {
                if (this.file[i] == null) continue;
                this.file[i].getFD().sync();
            }
        }
        catch (Exception e) {
            System.out.println("RTAServer flush failed: " + e);
        }
    }

    private String getCoffString(int addr) {
        try {
            int len;
            long[] formatData = this.rtdxSession.debugSession.memory.readData(0, (long)addr, 8, 100, false);
            byte[] fmtStr = new byte[101];
            for (len = 0; len < 100 && formatData[len] != 0L; ++len) {
                fmtStr[len] = (byte)formatData[len];
            }
            fmtStr[len] = 0;
            return new String(fmtStr, 0, len);
        }
        catch (Exception e) {
            System.out.println("RTAServer getCoffString failed: " + e);
            return "ERROR";
        }
    }

    @Override
    public void run() {
        try {
            String logName = "prdLog0";
            int recordSize = this.rtdxSession.debugSession.symbol.exists("LOG_ts") ? 8 : 4;
            long getlogAddr = this.rtdxSession.debugSession.symbol.getAddress("RTA_F_getlog");
            long logTableAddr = this.rtdxSession.debugSession.symbol.getAddress("LOG_A_TABBEG");
            long logTableLen = this.rtdxSession.debugSession.symbol.getAddress("LOG_A_TABLEN");
            long traceLogAddr = this.rtdxSession.debugSession.symbol.getAddress(logName + "$buf");
            long traceLogSize = this.rtdxSession.debugSession.symbol.getAddress(logName + "$size");
            long h2tFramesize = this.rtdxSession.debugSession.symbol.getAddress("RTA_fromHost$framesize");
            long t2hFramesize = this.rtdxSession.debugSession.symbol.getAddress("RTA_toHost$framesize");
            String symbolName = this.rtdxSession.debugSession.symbol.lookupSymbol(0, logTableAddr);
            int[] rpcRequest = new int[(int)h2tFramesize];
            int[][] logBuf = new int[(int)Math.max(traceLogSize, t2hFramesize) / recordSize][recordSize];
            rpcRequest[0] = 1;
            rpcRequest[1] = (int)getlogAddr;
            rpcRequest[2] = (int)t2hFramesize / 4;
            block2: while (true) {
                Thread.sleep(500L);
                this.start();
                int offset = 0;
                while ((long)offset < traceLogSize) {
                    rpcRequest[3] = (int)traceLogAddr + offset * 4;
                    this.out.buffered(-16, 0);
                    this.out.write(rpcRequest, 0, rpcRequest.length);
                    for (int i = 0; i < (int)t2hFramesize; i += recordSize) {
                        this.in.read(logBuf[(offset + i) / recordSize], 0, recordSize, 0);
                    }
                    offset = (int)((long)offset + t2hFramesize);
                }
                Arrays.sort(logBuf, new SeqNumComparator());
                int i = 0;
                while (true) {
                    int len;
                    if (i >= (int)traceLogSize / recordSize || logBuf[i][0] == -1) continue block2;
                    long[] formatData = this.rtdxSession.debugSession.memory.readData(0, (long)logBuf[i][3], 8, 100, false);
                    byte[] fmtStr = new byte[101];
                    int argCnt = 0;
                    String argOneStr = null;
                    String argTwoStr = null;
                    for (len = 0; len < 100 && formatData[len] != 0L; ++len) {
                        fmtStr[len] = (byte)formatData[len];
                        if (fmtStr[len] == 37 && formatData[len + 1] != 37L) {
                            ++argCnt;
                        }
                        if (fmtStr[len] != 37 || formatData[len + 1] != 115L) continue;
                        if (argCnt == 2) {
                            argTwoStr = this.getCoffString(logBuf[i][2]);
                            continue;
                        }
                        argOneStr = this.getCoffString(logBuf[i][1]);
                    }
                    fmtStr[len] = 0;
                    if (recordSize == 8) {
                        ByteBuffer bbsize = ByteBuffer.allocateDirect(8);
                        bbsize.order(ByteOrder.LITTLE_ENDIAN);
                        bbsize.putInt(logBuf[i][6]);
                        bbsize.putInt(logBuf[i][7]);
                        bbsize.position(0);
                        long timeStamp = bbsize.getLong();
                        System.out.print(timeStamp + " : ");
                    }
                    System.out.print(logName + " : " + logBuf[i][0] / 2 + " : ");
                    System.out.printf(new String(fmtStr, 0, len) + "\n", argOneStr == null ? Integer.valueOf(logBuf[i][1]) : argOneStr, argTwoStr == null ? Integer.valueOf(logBuf[i][2]) : argTwoStr);
                    ++i;
                }
                break;
            }
        }
        catch (Exception e) {
            System.out.println("RTAServer failed: " + e);
            return;
        }
    }

    class SeqNumComparator
    implements Comparator<Object> {
        SeqNumComparator() {
        }

        @Override
        public int compare(Object obj1, Object obj2) {
            int result = 0;
            int[] rec1 = (int[])obj1;
            int[] rec2 = (int[])obj2;
            Integer seqNum1 = rec1[0];
            result = seqNum1.compareTo(rec2[0]);
            return result;
        }
    }
}

