/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting;

import com.ti.ccstudio.scripting.environment.ScriptingEnvironment;
import com.ti.ccstudio.scripting.environment.ScriptingException;
import com.ti.debug.engine.IRtdxChannel;
import com.ti.debug.engine.framework.IDisposable;
import com.ti.debug.engine.scripting.RTDXError;
import com.ti.debug.engine.scripting.RTDXSession;
import com.ti.debug.engine.scripting.SWIGTYPE_p_double;
import com.ti.debug.engine.scripting.SWIGTYPE_p_float;
import com.ti.debug.engine.scripting.SWIGTYPE_p_long;
import com.ti.debug.engine.scripting.SWIGTYPE_p_short;
import com.ti.debug.engine.scripting.SWIGTYPE_p_unsigned_char;
import com.ti.debug.engine.scripting.rtdxlibc;
import com.ti.debug.engine.scripting.rtdxlibcConstants;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RTDXChannel
implements IDisposable {
    private static final int RTDX_I1_TYPE = 0;
    private static final int RTDX_I2_TYPE = 1;
    private static final int RTDX_I4_TYPE = 2;
    private static final int RTDX_F4_TYPE = 3;
    private static final int RTDX_F8_TYPE = 4;
    private static final int SLEEP_TIME = 15;
    private boolean closed;
    private boolean disposed = false;
    private IRtdxChannel channel;
    protected ScriptingEnvironment environment;
    protected RTDXSession session;
    protected Logger traceLog = Logger.getLogger(this.getClass().getName());
    protected ArrayList<IDisposable> childObjects = new ArrayList();

    RTDXChannel(ScriptingEnvironment environment, RTDXSession session) throws ScriptingException {
        if (session == null || environment == null) {
            throw new ScriptingException(5001, "ScriptingEnvironment or RTDXSession not initialized");
        }
        this.session = session;
        this.environment = environment;
        this.channel = this.session.getRtdx().createRtdxChannel();
        this.childObjects.add((IDisposable)this.channel);
        this.closed = true;
    }

    public void open(String sChannelName, String sReadWrite) throws ScriptingException {
        String myName = "open";
        this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session.getDebugSession(), "sChannelName: " + sChannelName, "sReadWrite: " + sReadWrite});
        long status = this.channel.open(sChannelName, sReadWrite);
        this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session.getDebugSession(), RTDXError.getStr(status)});
        if (status != 0L) {
            throw new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + "(" + sChannelName + "," + sReadWrite + "), error: " + RTDXError.getStr(status));
        }
        this.closed = false;
    }

    public void open(int nChannelId, String sReadWrite) throws ScriptingException {
        String myName = "open";
        this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session.getDebugSession(), "channelId: " + nChannelId, "sReadWrite: " + sReadWrite});
        String sChannelName = sReadWrite == "r" ? "ti_drivers_rtdx_t2h_output_chan_" + nChannelId : "ti_drivers_rtdx_h2t_input_chan_" + nChannelId;
        long status = this.channel.open(sChannelName, sReadWrite);
        this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session.getDebugSession(), RTDXError.getStr(status)});
        if (status != 0L) {
            throw new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + "(" + nChannelId + "," + sReadWrite + "), error: " + RTDXError.getStr(status));
        }
        this.closed = false;
    }

    public void close() throws ScriptingException {
        String myName = "close";
        if (this.closed) {
            return;
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session.getDebugSession());
        }
        long status = this.channel.close();
        this.closed = true;
        this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session.getDebugSession(), RTDXError.getStr(status)});
        if (status != 0L) {
            throw new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + ", error: " + RTDXError.getStr(status));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long writeState(int nNumBytes, int msTimeout) throws ScriptingException {
        int i;
        String myName = "writeState";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session.getDebugSession());
        }
        long nResult = 0L;
        long status = 0L;
        int loopCount = (msTimeout + 15 - 1) / 15;
        for (i = 0; msTimeout <= 0 || i < loopCount; ++i) {
            nResult = this.channel.statusOfWrite();
            status = this.channel.getLastStatus();
            if (status != 0L || nResult <= (long)nNumBytes || msTimeout < 0) break;
            try {
                Thread thread = Thread.currentThread();
                synchronized (thread) {
                    Thread.currentThread().wait(15L);
                    continue;
                }
            }
            catch (Exception e) {
                throw new ScriptingException(5005, "Thread.wait() error: " + e);
            }
        }
        if (status == (long)rtdxlibcConstants.RTDX_SUCCESS && i == loopCount && msTimeout > 0) {
            throw new ScriptingException(5004, "Timeout doing writeState");
        }
        this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session.getDebugSession(), RTDXError.getStr(status, nResult)});
        if (status != 0L) {
            throw new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + ", error: " + RTDXError.getStr(status));
        }
        return nResult;
    }

    public void rewind() throws ScriptingException {
        String myName = "rewind";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session.getDebugSession());
        }
        long status = this.channel.rewind();
        this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session.getDebugSession(), RTDXError.getStr(status)});
        if (status != 0L) {
            throw new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + ", error: " + RTDXError.getStr(status));
        }
    }

    public void flush() throws ScriptingException {
        String myName = "flush";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session.getDebugSession());
        }
        long status = this.channel.flush();
        this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session.getDebugSession(), RTDXError.getStr(status)});
        if (status != 0L) {
            throw new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + ", error: " + RTDXError.getStr(status));
        }
    }

    public void gotoNextMsg() throws ScriptingException {
        String myName = "gotoNextMsg";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session.getDebugSession());
        }
        long status = this.channel.gotoNextMsg();
        this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session.getDebugSession(), RTDXError.getStr(status)});
        if (status != 0L) {
            throw new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + ", error: " + RTDXError.getStr(status));
        }
    }

    public long getMsgID() throws ScriptingException {
        String myName = "getMsgID";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session.getDebugSession());
        }
        long nResult = this.channel.getMsgID();
        long status = this.channel.getLastStatus();
        this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session.getDebugSession(), RTDXError.getStr(status, nResult, 16)});
        if (status != 0L) {
            throw new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + ", error: " + RTDXError.getStr(status));
        }
        return nResult;
    }

    public long getMsgNumber() throws ScriptingException {
        String myName = "getMsgNumber";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session.getDebugSession());
        }
        long nResult = this.channel.getMsgNumber();
        long status = this.channel.getLastStatus();
        this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session.getDebugSession(), RTDXError.getStr(status, nResult)});
        if (status != 0L) {
            throw new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + ", error: " + RTDXError.getStr(status));
        }
        return nResult;
    }

    public long getNumMsgs() throws ScriptingException {
        String myName = "getNumMsgs";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session.getDebugSession());
        }
        long nResult = this.channel.getNumMsgs();
        long status = this.channel.getLastStatus();
        this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session.getDebugSession(), RTDXError.getStr(status, nResult)});
        if (status != 0L) {
            throw new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + ", error: " + RTDXError.getStr(status));
        }
        return nResult;
    }

    protected long getLastStatus() throws ScriptingException {
        String myName = "getLastStatus";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session.getDebugSession());
        }
        long nResult = this.channel.getLastStatus();
        this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session.getDebugSession(), nResult});
        return nResult;
    }

    public long getMsgLength() throws ScriptingException {
        String myName = "getMsgLength";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session.getDebugSession());
        }
        long nResult = this.channel.getMsgLength();
        long status = this.channel.getLastStatus();
        this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session.getDebugSession(), RTDXError.getStr(status, nResult)});
        if (status != 0L) {
            throw new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + ", error: " + RTDXError.getStr(status));
        }
        return nResult;
    }

    public void reset() throws ScriptingException {
        String myName = "reset";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session.getDebugSession());
        }
        long status = this.channel.reset();
        this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session.getDebugSession(), RTDXError.getStr(status)});
        if (status != 0L) {
            throw new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + ", error: " + RTDXError.getStr(status));
        }
    }

    public void seek(int nMsgNum) throws ScriptingException {
        String myName = "seek";
        this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session.getDebugSession(), "nMsgNum: " + nMsgNum});
        long status = this.channel.seek(nMsgNum);
        this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session.getDebugSession(), RTDXError.getStr(status)});
        if (status != 0L) {
            throw new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + "(" + nMsgNum + "), error: " + RTDXError.getStr(status));
        }
    }

    public void seekData(int nNumBytes) throws ScriptingException {
        String myName = "seekData";
        this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session.getDebugSession(), "nNumBytes: " + nNumBytes});
        long status = this.channel.seekData(nNumBytes);
        this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session.getDebugSession(), RTDXError.getStr(status)});
        if (status != 0L) {
            throw new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + "(" + nNumBytes + "), error: " + RTDXError.getStr(status));
        }
    }

    public long getChannelAddr(String sChannelName) throws ScriptingException {
        String myName = "getChannelID";
        this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session.getDebugSession(), "sChannelName: " + sChannelName});
        long nResult = this.channel.getChannelID(sChannelName);
        long status = this.channel.getLastStatus();
        this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session.getDebugSession(), RTDXError.getStr(status, nResult, 16)});
        if (status != 0L) {
            throw new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + "(" + sChannelName + "), error: " + RTDXError.getStr(status));
        }
        return nResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] buf, int offset, int count, int msTimeout) throws ScriptingException {
        String myName = "read(byte)";
        this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session.getDebugSession(), "offset: " + offset, "count: " + count, "msTimeout: " + msTimeout});
        if (buf == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || offset > buf.length || count < 0 || offset + count > buf.length || offset + count < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (count == 0) {
            return 0;
        }
        SWIGTYPE_p_unsigned_char buffer = rtdxlibc.new_aRTDX_BYTE_TYPE(count);
        SWIGTYPE_p_long nBytesRead = rtdxlibc.copy_pRTDX_INT32_TYPE(0);
        try {
            int i;
            long status = -1754988514L;
            for (i = 0; msTimeout <= 0 || i < (msTimeout + 15 - 1) / 15; ++i) {
                status = this.channel.read((int)SWIGTYPE_p_unsigned_char.getCPtr(buffer), count, 0, (int)SWIGTYPE_p_long.getCPtr(nBytesRead));
                if (status == -1754988514L) {
                    if (msTimeout >= 0) {
                        try {
                            Thread thread = Thread.currentThread();
                            synchronized (thread) {
                                Thread.currentThread().wait(15L);
                                continue;
                            }
                        }
                        catch (Exception e) {
                            throw new ScriptingException(5005, "Thread.wait() error: " + e);
                        }
                    }
                    if (rtdxlibc.pRTDX_INT32_TYPE_value(nBytesRead) >= 1) {
                        count = rtdxlibc.pRTDX_INT32_TYPE_value(nBytesRead);
                        continue;
                    }
                    throw new ScriptingException(5007, "No data available doing read(byte), error: " + status);
                }
                if (status == 0L) break;
                if (status == -1754988542L) {
                    if (rtdxlibc.pRTDX_INT32_TYPE_value(nBytesRead) >= 1) {
                        count = rtdxlibc.pRTDX_INT32_TYPE_value(nBytesRead);
                        continue;
                    }
                    throw new ScriptingException(5006, "End of file doing read(byte), error: " + status);
                }
                if (msTimeout != 0) {
                    throw new ScriptingException(5005, "Failure doing read(byte), error: " + status);
                }
                status = 0L;
                count = -1;
                break;
            }
            if (status != 0L) {
                throw new ScriptingException(5004, "Timeout doing read(byte)");
            }
            for (i = 0; i < count; ++i) {
                buf[offset + i] = (byte)rtdxlibc.aRTDX_BYTE_TYPE_getitem(buffer, i);
            }
        }
        finally {
            rtdxlibc.delete_aRTDX_BYTE_TYPE(buffer);
            rtdxlibc.delete_pRTDX_INT32_TYPE(nBytesRead);
        }
        this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session.getDebugSession(), count});
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(short[] buf, int offset, int count, int msTimeout) throws ScriptingException {
        String myName = "read(short)";
        this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session.getDebugSession(), "offset: " + offset, "count: " + count, "msTimeout: " + msTimeout});
        if (buf == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || offset > buf.length || count < 0 || offset + count > buf.length || offset + count < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (count == 0) {
            return 0;
        }
        SWIGTYPE_p_short buffer = rtdxlibc.new_aRTDX_INT16_TYPE(count);
        SWIGTYPE_p_long nBytesRead = rtdxlibc.copy_pRTDX_INT32_TYPE(0);
        try {
            int i;
            long status = -1754988514L;
            for (i = 0; msTimeout <= 0 || i < (msTimeout + 15 - 1) / 15; ++i) {
                status = this.channel.read((int)SWIGTYPE_p_short.getCPtr(buffer), count * 2, 1, (int)SWIGTYPE_p_long.getCPtr(nBytesRead));
                if (status == -1754988514L) {
                    if (msTimeout >= 0) {
                        try {
                            Thread thread = Thread.currentThread();
                            synchronized (thread) {
                                Thread.currentThread().wait(15L);
                                continue;
                            }
                        }
                        catch (Exception e) {
                            throw new ScriptingException(5005, "Thread.wait() error: " + e);
                        }
                    }
                    if (rtdxlibc.pRTDX_INT32_TYPE_value(nBytesRead) >= 2) {
                        count = rtdxlibc.pRTDX_INT32_TYPE_value(nBytesRead) / 2;
                        continue;
                    }
                    throw new ScriptingException(5007, "No data available doing read(short), error: " + status);
                }
                if (status == 0L) break;
                if (status == -1754988542L) {
                    if (rtdxlibc.pRTDX_INT32_TYPE_value(nBytesRead) >= 2) {
                        count = rtdxlibc.pRTDX_INT32_TYPE_value(nBytesRead) / 2;
                        continue;
                    }
                    throw new ScriptingException(5006, "End of file doing read(short), error: " + status);
                }
                throw new ScriptingException(5005, "Failure doing read(short), error: " + status);
            }
            if (status != 0L) {
                throw new ScriptingException(5004, "Timeout doing read(short)");
            }
            for (i = 0; i < count; ++i) {
                buf[offset + i] = rtdxlibc.aRTDX_INT16_TYPE_getitem(buffer, i);
            }
        }
        finally {
            rtdxlibc.delete_aRTDX_INT16_TYPE(buffer);
            rtdxlibc.delete_pRTDX_INT32_TYPE(nBytesRead);
        }
        this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session.getDebugSession(), count});
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(int[] buf, int offset, int count, int msTimeout) throws ScriptingException {
        String myName = "read(int)";
        this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session.getDebugSession(), "offset: " + offset, "count: " + count, "msTimeout: " + msTimeout});
        if (buf == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || offset > buf.length || count < 0 || offset + count > buf.length || offset + count < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (count == 0) {
            return 0;
        }
        SWIGTYPE_p_long buffer = rtdxlibc.new_aRTDX_INT32_TYPE(count);
        SWIGTYPE_p_long nBytesRead = rtdxlibc.copy_pRTDX_INT32_TYPE(0);
        try {
            int i;
            long status = -1754988514L;
            for (i = 0; msTimeout <= 0 || i < (msTimeout + 15 - 1) / 15; ++i) {
                status = this.channel.read((int)SWIGTYPE_p_long.getCPtr(buffer), count * 4, 2, (int)SWIGTYPE_p_long.getCPtr(nBytesRead));
                if (status == -1754988514L) {
                    if (msTimeout >= 0) {
                        try {
                            Thread thread = Thread.currentThread();
                            synchronized (thread) {
                                Thread.currentThread().wait(15L);
                                continue;
                            }
                        }
                        catch (Exception e) {
                            throw new ScriptingException(5005, "Thread.wait() error: " + e);
                        }
                    }
                    if (rtdxlibc.pRTDX_INT32_TYPE_value(nBytesRead) >= 4) {
                        count = rtdxlibc.pRTDX_INT32_TYPE_value(nBytesRead) / 4;
                        continue;
                    }
                    throw new ScriptingException(5007, "No data available doing read(int), error: " + status);
                }
                if (status == 0L) break;
                if (status == -1754988542L) {
                    if (rtdxlibc.pRTDX_INT32_TYPE_value(nBytesRead) >= 4) {
                        count = rtdxlibc.pRTDX_INT32_TYPE_value(nBytesRead) / 4;
                        continue;
                    }
                    throw new ScriptingException(5006, "End of file doing read(int), error: " + status);
                }
                throw new ScriptingException(5005, "Failure doing read(int), error: " + status);
            }
            if (status != 0L) {
                throw new ScriptingException(5004, "Timeout doing read(int)");
            }
            for (i = 0; i < count; ++i) {
                buf[offset + i] = rtdxlibc.aRTDX_INT32_TYPE_getitem(buffer, i);
            }
        }
        finally {
            rtdxlibc.delete_aRTDX_INT32_TYPE(buffer);
            rtdxlibc.delete_pRTDX_INT32_TYPE(nBytesRead);
        }
        this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session.getDebugSession(), count});
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(float[] buf, int offset, int count, int msTimeout) throws ScriptingException {
        String myName = "read(float)";
        this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session.getDebugSession(), "offset: " + offset, "count: " + count, "msTimeout: " + msTimeout});
        if (buf == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || offset > buf.length || count < 0 || offset + count > buf.length || offset + count < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (count == 0) {
            return 0;
        }
        SWIGTYPE_p_float buffer = rtdxlibc.new_aRTDX_FLOAT_TYPE(count);
        SWIGTYPE_p_long nBytesRead = rtdxlibc.copy_pRTDX_INT32_TYPE(0);
        try {
            int i;
            long status = -1754988514L;
            for (i = 0; msTimeout <= 0 || i < (msTimeout + 15 - 1) / 15; ++i) {
                status = this.channel.read((int)SWIGTYPE_p_float.getCPtr(buffer), count * 4, 3, (int)SWIGTYPE_p_long.getCPtr(nBytesRead));
                if (status == -1754988514L) {
                    if (msTimeout >= 0) {
                        try {
                            Thread thread = Thread.currentThread();
                            synchronized (thread) {
                                Thread.currentThread().wait(15L);
                                continue;
                            }
                        }
                        catch (Exception e) {
                            throw new ScriptingException(5005, "Thread.wait() error: " + e);
                        }
                    }
                    if (rtdxlibc.pRTDX_INT32_TYPE_value(nBytesRead) >= 4) {
                        count = rtdxlibc.pRTDX_INT32_TYPE_value(nBytesRead) / 4;
                        continue;
                    }
                    throw new ScriptingException(5007, "No data available doing read(float), error: " + status);
                }
                if (status == 0L) break;
                if (status == -1754988542L) {
                    if (rtdxlibc.pRTDX_INT32_TYPE_value(nBytesRead) >= 4) {
                        count = rtdxlibc.pRTDX_INT32_TYPE_value(nBytesRead) / 4;
                        continue;
                    }
                    throw new ScriptingException(5006, "End of file doing read(float), error: " + status);
                }
                throw new ScriptingException(5005, "Failure doing read(float), error: " + status);
            }
            if (status != 0L) {
                throw new ScriptingException(5004, "Timeout doing read(float)");
            }
            for (i = 0; i < count; ++i) {
                buf[offset + i] = rtdxlibc.aRTDX_FLOAT_TYPE_getitem(buffer, i);
            }
        }
        finally {
            rtdxlibc.delete_aRTDX_FLOAT_TYPE(buffer);
            rtdxlibc.delete_pRTDX_INT32_TYPE(nBytesRead);
        }
        this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session.getDebugSession(), count});
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(double[] buf, int offset, int count, int msTimeout) throws ScriptingException {
        String myName = "read(double)";
        this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session.getDebugSession(), "offset: " + offset, "count: " + count, "msTimeout: " + msTimeout});
        if (buf == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || offset > buf.length || count < 0 || offset + count > buf.length || offset + count < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (count == 0) {
            return 0;
        }
        SWIGTYPE_p_double buffer = rtdxlibc.new_aRTDX_DOUBLE_TYPE(count);
        SWIGTYPE_p_long nBytesRead = rtdxlibc.copy_pRTDX_INT32_TYPE(0);
        try {
            int i;
            long status = -1754988514L;
            for (i = 0; msTimeout <= 0 || i < (msTimeout + 15 - 1) / 15; ++i) {
                status = this.channel.read((int)SWIGTYPE_p_double.getCPtr(buffer), count * 8, 4, (int)SWIGTYPE_p_long.getCPtr(nBytesRead));
                if (status == -1754988514L) {
                    if (msTimeout >= 0) {
                        try {
                            Thread thread = Thread.currentThread();
                            synchronized (thread) {
                                Thread.currentThread().wait(15L);
                                continue;
                            }
                        }
                        catch (Exception e) {
                            throw new ScriptingException(5005, "Thread.wait() error: " + e);
                        }
                    }
                    if (rtdxlibc.pRTDX_INT32_TYPE_value(nBytesRead) >= 8) {
                        count = rtdxlibc.pRTDX_INT32_TYPE_value(nBytesRead) / 8;
                        continue;
                    }
                    throw new ScriptingException(5007, "No data available doing read(double), error: " + status);
                }
                if (status == 0L) break;
                if (status == -1754988542L) {
                    if (rtdxlibc.pRTDX_INT32_TYPE_value(nBytesRead) >= 8) {
                        count = rtdxlibc.pRTDX_INT32_TYPE_value(nBytesRead) / 8;
                        continue;
                    }
                    throw new ScriptingException(5006, "End of file doing read(double), error: " + status);
                }
                throw new ScriptingException(5005, "Failure doing read(double), error: " + status);
            }
            if (status != 0L) {
                throw new ScriptingException(5004, "Timeout doing read(double)");
            }
            for (i = 0; i < count; ++i) {
                buf[offset + i] = rtdxlibc.aRTDX_DOUBLE_TYPE_getitem(buffer, i);
            }
        }
        finally {
            rtdxlibc.delete_aRTDX_DOUBLE_TYPE(buffer);
            rtdxlibc.delete_pRTDX_INT32_TYPE(nBytesRead);
        }
        this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session.getDebugSession(), count});
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(long[] buf, int offset, int count, int msTimeout) throws ScriptingException {
        String myName = "read(long)";
        this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session.getDebugSession(), "offset: " + offset, "count: " + count, "msTimeout: " + msTimeout});
        if (buf == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || offset > buf.length || count < 0 || offset + count > buf.length || offset + count < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (count == 0) {
            return 0;
        }
        SWIGTYPE_p_double buffer = rtdxlibc.new_aRTDX_DOUBLE_TYPE(count);
        SWIGTYPE_p_long nBytesRead = rtdxlibc.copy_pRTDX_INT32_TYPE(0);
        try {
            int i;
            long status = -1754988514L;
            for (i = 0; msTimeout <= 0 || i < (msTimeout + 15 - 1) / 15; ++i) {
                status = this.channel.read((int)SWIGTYPE_p_double.getCPtr(buffer), count * 8, 4, (int)SWIGTYPE_p_long.getCPtr(nBytesRead));
                if (status == -1754988514L) {
                    if (msTimeout >= 0) {
                        try {
                            Thread thread = Thread.currentThread();
                            synchronized (thread) {
                                Thread.currentThread().wait(15L);
                                continue;
                            }
                        }
                        catch (Exception e) {
                            throw new ScriptingException(5005, "Thread.wait() error: " + e);
                        }
                    }
                    if (rtdxlibc.pRTDX_INT32_TYPE_value(nBytesRead) >= 8) {
                        count = rtdxlibc.pRTDX_INT32_TYPE_value(nBytesRead) / 8;
                        continue;
                    }
                    throw new ScriptingException(5007, "No data available doing read(long), error: " + status);
                }
                if (status == 0L) break;
                if (status == -1754988542L) {
                    if (rtdxlibc.pRTDX_INT32_TYPE_value(nBytesRead) >= 8) {
                        count = rtdxlibc.pRTDX_INT32_TYPE_value(nBytesRead) / 8;
                        continue;
                    }
                    throw new ScriptingException(5006, "End of file doing read(long), error: " + status);
                }
                throw new ScriptingException(5005, "Failure doing read(long), error: " + status);
            }
            if (status != 0L) {
                throw new ScriptingException(5004, "Timeout doing read(long)");
            }
            for (i = 0; i < count; ++i) {
                buf[offset + i] = Double.doubleToRawLongBits(rtdxlibc.aRTDX_DOUBLE_TYPE_getitem(buffer, i));
            }
        }
        finally {
            rtdxlibc.delete_aRTDX_DOUBLE_TYPE(buffer);
            rtdxlibc.delete_pRTDX_INT32_TYPE(nBytesRead);
        }
        this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session.getDebugSession(), count});
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readState(int nNumBytes, int msTimeout) throws ScriptingException {
        String myName = "readState";
        this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session.getDebugSession(), "msTimeout: " + msTimeout, "nNumBytes: " + nNumBytes});
        int nResult = 0;
        SWIGTYPE_p_long nBytesRead = rtdxlibc.copy_pRTDX_INT32_TYPE(0);
        try {
            long status = -1754988514L;
            for (int i = 0; msTimeout <= 0 || i < (msTimeout + 15 - 1) / 15; ++i) {
                status = this.channel.read(0, Integer.MAX_VALUE, 0, (int)SWIGTYPE_p_long.getCPtr(nBytesRead));
                nResult = rtdxlibc.pRTDX_INT32_TYPE_value(nBytesRead);
                if (nResult >= nNumBytes || status == -1754988542L) break;
                if (msTimeout < 0) {
                    break;
                }
                if (status == -1754988514L) {
                    try {
                        Thread thread = Thread.currentThread();
                        synchronized (thread) {
                            Thread.currentThread().wait(15L);
                            continue;
                        }
                    }
                    catch (Exception e) {
                        throw new ScriptingException(5005, "Thread.wait() error: " + e);
                    }
                }
                throw new ScriptingException(5005, "Failure doing readState, error: " + status);
            }
        }
        finally {
            rtdxlibc.delete_pRTDX_INT32_TYPE(nBytesRead);
        }
        this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session.getDebugSession(), nResult});
        return nResult;
    }

    public long write(byte[] nData) throws ScriptingException {
        return this.write(nData, 0, nData.length);
    }

    public long write(byte[] nData, int offset, int count) throws ScriptingException {
        String myName = "write(byte)";
        this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session.getDebugSession(), "offset: " + offset, "length: " + count});
        if (nData == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || offset > nData.length || count < 0 || offset + count > nData.length || offset + count < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (count == 0) {
            return this.writeState(0, -1);
        }
        SWIGTYPE_p_unsigned_char buffer = rtdxlibc.new_aRTDX_BYTE_TYPE(count);
        SWIGTYPE_p_long pNumBytes = rtdxlibc.copy_pRTDX_INT32_TYPE(0);
        for (int i = 0; i < count; ++i) {
            rtdxlibc.aRTDX_BYTE_TYPE_setitem(buffer, i, nData[i + offset]);
        }
        long status = this.writeUntilSuccess(SWIGTYPE_p_unsigned_char.getCPtr(buffer), count, 0, SWIGTYPE_p_long.getCPtr(pNumBytes));
        long nResult = rtdxlibc.pRTDX_INT32_TYPE_value(pNumBytes);
        rtdxlibc.delete_aRTDX_BYTE_TYPE(buffer);
        rtdxlibc.delete_pRTDX_INT32_TYPE(pNumBytes);
        this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session.getDebugSession(), RTDXError.getStr(status)});
        if (status != 0L) {
            throw new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + "), error: " + RTDXError.getStr(status));
        }
        return nResult;
    }

    public long write(short[] nData, int offset, int count) throws ScriptingException {
        String myName = "writeShort";
        this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session.getDebugSession(), "offset: " + offset, "length: " + count});
        if (nData == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || offset > nData.length || count < 0 || offset + count > nData.length || offset + count < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (count == 0) {
            return this.writeState(0, -1);
        }
        SWIGTYPE_p_short buffer = rtdxlibc.new_aRTDX_INT16_TYPE(count);
        SWIGTYPE_p_long pNumBytes = rtdxlibc.copy_pRTDX_INT32_TYPE(0);
        for (int i = 0; i < count; ++i) {
            rtdxlibc.aRTDX_INT16_TYPE_setitem(buffer, i, nData[i + offset]);
        }
        long status = this.writeUntilSuccess(SWIGTYPE_p_short.getCPtr(buffer), count * 2, 1, SWIGTYPE_p_long.getCPtr(pNumBytes));
        long nResult = rtdxlibc.pRTDX_INT32_TYPE_value(pNumBytes);
        rtdxlibc.delete_aRTDX_INT16_TYPE(buffer);
        rtdxlibc.delete_pRTDX_INT32_TYPE(pNumBytes);
        this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session.getDebugSession(), RTDXError.getStr(status)});
        if (status != 0L) {
            throw new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + "), error: " + RTDXError.getStr(status));
        }
        return nResult;
    }

    public long write(int[] nData, int offset, int count) throws ScriptingException {
        String myName = "writeInt";
        this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session.getDebugSession(), "offset: " + offset, "length: " + count});
        if (nData == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || offset > nData.length || count < 0 || offset + count > nData.length || offset + count < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (count == 0) {
            return this.writeState(0, -1);
        }
        SWIGTYPE_p_long buffer = rtdxlibc.new_aRTDX_INT32_TYPE(count);
        SWIGTYPE_p_long pNumBytes = rtdxlibc.copy_pRTDX_INT32_TYPE(0);
        for (int i = 0; i < count; ++i) {
            rtdxlibc.aRTDX_INT32_TYPE_setitem(buffer, i, nData[i + offset]);
        }
        long status = this.writeUntilSuccess(SWIGTYPE_p_long.getCPtr(buffer), count * 4, 2, SWIGTYPE_p_long.getCPtr(pNumBytes));
        long nResult = rtdxlibc.pRTDX_INT32_TYPE_value(pNumBytes);
        rtdxlibc.delete_aRTDX_INT32_TYPE(buffer);
        rtdxlibc.delete_pRTDX_INT32_TYPE(pNumBytes);
        this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session.getDebugSession(), RTDXError.getStr(status)});
        if (status != 0L) {
            throw new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + ", error: " + RTDXError.getStr(status));
        }
        return nResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long writeUntilSuccess(long pData, int nNumBytesToWrite, int nDataType, long pNumBytes) {
        long status = 5005L;
        while (status != 0L) {
            status = this.channel.write((int)pData, nNumBytesToWrite, nDataType, (int)pNumBytes);
            if (status == 0L) continue;
            try {
                Thread thread = Thread.currentThread();
                synchronized (thread) {
                    Thread.currentThread().wait(15L);
                }
            }
            catch (Exception e) {
                break;
            }
        }
        return status;
    }

    public long write(float[] nData, int offset, int count) throws ScriptingException {
        String myName = "writeFloat";
        this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session.getDebugSession(), "offset: " + offset, "length: " + count});
        if (nData == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || offset > nData.length || count < 0 || offset + count > nData.length || offset + count < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (count == 0) {
            return this.writeState(0, -1);
        }
        SWIGTYPE_p_float buffer = rtdxlibc.new_aRTDX_FLOAT_TYPE(count);
        SWIGTYPE_p_long pNumBytes = rtdxlibc.copy_pRTDX_INT32_TYPE(0);
        for (int i = 0; i < count; ++i) {
            rtdxlibc.aRTDX_FLOAT_TYPE_setitem(buffer, i, nData[i + offset]);
        }
        long status = this.writeUntilSuccess(SWIGTYPE_p_float.getCPtr(buffer), count * 4, 3, SWIGTYPE_p_long.getCPtr(pNumBytes));
        long nResult = rtdxlibc.pRTDX_INT32_TYPE_value(pNumBytes);
        rtdxlibc.delete_aRTDX_FLOAT_TYPE(buffer);
        rtdxlibc.delete_pRTDX_INT32_TYPE(pNumBytes);
        this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session.getDebugSession(), RTDXError.getStr(status)});
        if (status != 0L) {
            throw new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + "), error: " + RTDXError.getStr(status));
        }
        return nResult;
    }

    public long write(double[] nData, int offset, int count) throws ScriptingException {
        String myName = "writeDouble";
        this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session.getDebugSession(), "offset: " + offset, "length: " + count});
        if (nData == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || offset > nData.length || count < 0 || offset + count > nData.length || offset + count < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (count == 0) {
            return this.writeState(0, -1);
        }
        SWIGTYPE_p_double buffer = rtdxlibc.new_aRTDX_DOUBLE_TYPE(count);
        SWIGTYPE_p_long pNumBytes = rtdxlibc.copy_pRTDX_INT32_TYPE(0);
        for (int i = 0; i < count; ++i) {
            rtdxlibc.aRTDX_DOUBLE_TYPE_setitem(buffer, i, nData[i + offset]);
        }
        long status = this.writeUntilSuccess(SWIGTYPE_p_double.getCPtr(buffer), count * 8, 4, SWIGTYPE_p_long.getCPtr(pNumBytes));
        long nResult = rtdxlibc.pRTDX_INT32_TYPE_value(pNumBytes);
        rtdxlibc.delete_aRTDX_DOUBLE_TYPE(buffer);
        rtdxlibc.delete_pRTDX_INT32_TYPE(pNumBytes);
        this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session.getDebugSession(), RTDXError.getStr(status)});
        if (status != 0L) {
            throw new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + ", error: " + RTDXError.getStr(status));
        }
        return nResult;
    }

    public long write(long[] nData, int offset, int count) throws ScriptingException {
        String myName = "write(long)";
        this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session.getDebugSession(), "offset: " + offset, "length: " + count});
        if (nData == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || offset > nData.length || count < 0 || offset + count > nData.length || offset + count < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (count == 0) {
            return this.writeState(0, -1);
        }
        SWIGTYPE_p_double buffer = rtdxlibc.new_aRTDX_DOUBLE_TYPE(count);
        SWIGTYPE_p_long pNumBytes = rtdxlibc.copy_pRTDX_INT32_TYPE(0);
        for (int i = 0; i < count; ++i) {
            rtdxlibc.aRTDX_DOUBLE_TYPE_setitem(buffer, i, Double.longBitsToDouble(nData[i + offset]));
        }
        long status = this.writeUntilSuccess(SWIGTYPE_p_double.getCPtr(buffer), count * 8, 4, SWIGTYPE_p_long.getCPtr(pNumBytes));
        long nResult = rtdxlibc.pRTDX_INT32_TYPE_value(pNumBytes);
        rtdxlibc.delete_aRTDX_DOUBLE_TYPE(buffer);
        rtdxlibc.delete_pRTDX_INT32_TYPE(pNumBytes);
        this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session.getDebugSession(), RTDXError.getStr(status)});
        if (status != 0L) {
            throw new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + "), error: " + RTDXError.getStr(status));
        }
        return nResult;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void dispose() {
        if (!this.childObjects.isEmpty()) {
            Iterator<IDisposable> i = this.childObjects.iterator();
            while (i.hasNext()) {
                IDisposable childObject = i.next();
                i.remove();
                childObject.dispose();
                Object var2_2 = null;
            }
        }
        this.disposed = true;
    }

    public void acquire() {
    }
}

