/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting;

import com.ti.ccstudio.scripting.environment.ScriptingException;
import com.ti.debug.engine.scripting.RTDXChannel;
import com.ti.debug.engine.scripting.RTDXSession;
import java.io.IOException;
import java.io.InputStream;

public class RTDXInputStream
extends InputStream {
    private RTDXChannel iChan;
    private String channelName;
    private int channelID;
    private RTDXSession rtdxSession;

    public RTDXInputStream(RTDXSession session, String inputChanName) throws ScriptingException {
        this.iChan = session.createChannel();
        this.iChan.open(inputChanName, "r");
        this.channelName = inputChanName;
        this.channelID = -1;
        this.rtdxSession = session;
        this.rtdxSession.enableChannel(this.channelName);
    }

    public RTDXInputStream(RTDXSession session, int inputChanID) throws ScriptingException {
        this.iChan = session.createChannel();
        this.iChan.open(inputChanID, "r");
        this.channelID = inputChanID;
        this.channelName = null;
        this.rtdxSession = session;
        this.rtdxSession.enableInputChannel(this.channelID);
    }

    @Override
    public int read() throws IOException {
        try {
            byte[] data = new byte[1];
            this.iChan.read(data, 0, 1, 0);
            return data[0];
        }
        catch (ScriptingException scriptingException) {
            return -1;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            return this.iChan.read(b, off, len, 0);
        }
        catch (ScriptingException ee) {
            return -1;
        }
    }

    public int read(byte[] buffer, int offset, int count, int timeout) throws IOException {
        try {
            return this.iChan.read(buffer, offset, count, timeout);
        }
        catch (ScriptingException ee) {
            throw new IOException("RTDXInputStream read error: " + ee.getMessage());
        }
    }

    public int read(short[] buffer, int offset, int count, int timeout) throws IOException {
        try {
            return this.iChan.read(buffer, offset, count, timeout);
        }
        catch (ScriptingException ee) {
            throw new IOException("RTDXInputStream read error: " + ee.getMessage());
        }
    }

    public int read(int[] buffer, int offset, int count, int timeout) throws IOException {
        try {
            return this.iChan.read(buffer, offset, count, timeout);
        }
        catch (ScriptingException ee) {
            throw new IOException("RTDXInputStream read error: " + ee.getMessage());
        }
    }

    public int read(int[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length, 0);
    }

    public int read(long[] buffer, int offset, int count, int timeout) throws IOException {
        try {
            return this.iChan.read(buffer, offset, count, timeout);
        }
        catch (ScriptingException ee) {
            throw new IOException("RTDXInputStream read error: " + ee.getMessage());
        }
    }

    public int read(float[] buffer, int offset, int count, int timeout) throws IOException {
        try {
            return this.iChan.read(buffer, offset, count, timeout);
        }
        catch (ScriptingException ee) {
            throw new IOException("RTDXInputStream read error: " + ee.getMessage());
        }
    }

    public int read(double[] buffer, int offset, int count, int timeout) throws IOException {
        try {
            return this.iChan.read(buffer, offset, count, timeout);
        }
        catch (ScriptingException ee) {
            throw new IOException("RTDXInputStream read error: " + ee.getMessage());
        }
    }

    @Override
    public int available() throws IOException {
        try {
            return this.iChan.readState(0, -1);
        }
        catch (ScriptingException ee) {
            throw new IOException("RTDXInputStream available error: " + ee.getMessage());
        }
    }

    public void enable() throws IOException {
        try {
            if (this.channelName != null) {
                this.rtdxSession.enableChannel(this.channelName);
            } else {
                this.rtdxSession.enableInputChannel(this.channelID);
            }
        }
        catch (ScriptingException ee) {
            throw new IOException("RTDXInputStream enable error: " + ee.getMessage());
        }
    }

    public void disable() throws IOException {
        try {
            if (this.channelName != null) {
                this.rtdxSession.disableChannel(this.channelName);
            } else {
                this.rtdxSession.disableInputChannel(this.channelID);
            }
        }
        catch (ScriptingException ee) {
            throw new IOException("RTDXInputStream disable error: " + ee.getMessage());
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.iChan.close();
        }
        catch (ScriptingException ee) {
            throw new IOException("RTDXInputStream close error: " + ee.getMessage());
        }
    }

    protected void finalize() throws IOException {
        try {
            this.iChan.close();
        }
        catch (ScriptingException ee) {
            throw new IOException("RTDXInputStream finalize error: " + ee.getMessage());
        }
    }
}

