/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting;

import com.ti.ccstudio.scripting.environment.ScriptingException;
import com.ti.debug.engine.scripting.RTDXChannel;
import com.ti.debug.engine.scripting.RTDXSession;
import java.io.IOException;
import java.io.OutputStream;

public class RTDXOutputStream
extends OutputStream {
    private RTDXChannel oChan;
    private String channelName;
    private int channelID;
    private RTDXSession rtdxSession;

    public RTDXOutputStream(RTDXSession session, String outputChanName) throws ScriptingException {
        this.oChan = session.createChannel();
        this.oChan.open(outputChanName, "w");
        this.channelName = outputChanName;
        this.channelID = -1;
        this.rtdxSession = session;
        this.rtdxSession.enableChannel(outputChanName);
    }

    public RTDXOutputStream(RTDXSession session, int outputChanID) throws ScriptingException {
        this.oChan = session.createChannel();
        this.oChan.open(outputChanID, "w");
        this.channelID = outputChanID;
        this.channelName = null;
        this.rtdxSession = session;
        this.rtdxSession.enableOutputChannel(outputChanID);
    }

    @Override
    public void write(int b) throws IOException {
        try {
            byte[] data = new byte[]{(byte)b};
            this.oChan.write(data);
        }
        catch (ScriptingException scriptingException) {
            // empty catch block
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.oChan.write(b, off, len);
        }
        catch (ScriptingException ee) {
            throw new IOException("RTDXOutputStream write error: " + ee.getMessage());
        }
    }

    public void write(short[] buffer, int offset, int count) throws IOException {
        try {
            this.oChan.write(buffer, offset, count);
        }
        catch (ScriptingException ee) {
            throw new IOException("RTDXOutputStream write error: " + ee.getMessage());
        }
    }

    public void write(int[] buffer, int offset, int count) throws IOException {
        try {
            this.oChan.write(buffer, offset, count);
        }
        catch (ScriptingException ee) {
            throw new IOException("RTDXOutputStream write error: " + ee.getMessage());
        }
    }

    public void write(long[] buffer, int offset, int count) throws IOException {
        try {
            this.oChan.write(buffer, offset, count);
        }
        catch (ScriptingException ee) {
            throw new IOException("RTDXOutputStream write error: " + ee.getMessage());
        }
    }

    public void write(float[] buffer, int offset, int count) throws IOException {
        try {
            this.oChan.write(buffer, offset, count);
        }
        catch (ScriptingException ee) {
            throw new IOException("RTDXOutputStream write error: " + ee.getMessage());
        }
    }

    public void write(double[] buffer, int offset, int count) throws IOException {
        try {
            this.oChan.write(buffer, offset, count);
        }
        catch (ScriptingException ee) {
            throw new IOException("RTDXOutputStream write error: " + ee.getMessage());
        }
    }

    public long buffered(int numBytes, int timeout) throws IOException {
        try {
            return this.oChan.writeState(numBytes, timeout);
        }
        catch (ScriptingException ee) {
            throw new IOException("RTDXOutputStream buffered error: " + ee.getMessage());
        }
    }

    public void enable() throws IOException {
        try {
            if (this.channelName != null) {
                this.rtdxSession.enableChannel(this.channelName);
            } else {
                this.rtdxSession.enableOutputChannel(this.channelID);
            }
        }
        catch (ScriptingException ee) {
            throw new IOException("RTDXOutputStream enable error: " + ee.getMessage());
        }
    }

    public void disable() throws IOException {
        try {
            if (this.channelName != null) {
                this.rtdxSession.disableChannel(this.channelName);
            } else {
                this.rtdxSession.disableOutputChannel(this.channelID);
            }
        }
        catch (ScriptingException ee) {
            throw new IOException("RTDXOutputStream disable error: " + ee.getMessage());
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.oChan.flush();
        }
        catch (ScriptingException ee) {
            throw new IOException("RTDXOutputStream flush error: " + ee.getMessage());
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.oChan.close();
        }
        catch (ScriptingException ee) {
            throw new IOException("RTDXOutputStream close error: " + ee.getMessage());
        }
    }

    protected void finalize() throws IOException {
        try {
            this.oChan.close();
        }
        catch (ScriptingException ee) {
            throw new IOException("RTDXOutputStream close error: " + ee.getMessage());
        }
    }
}

