/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting;

import com.ti.ccstudio.scripting.IScriptServer;
import com.ti.ccstudio.scripting.IScriptSession;
import com.ti.ccstudio.scripting.ScriptServer;
import com.ti.ccstudio.scripting.environment.ScriptingEnvironment;
import com.ti.ccstudio.scripting.environment.ScriptingException;
import com.ti.debug.engine.scripting.DebugServer;
import com.ti.debug.engine.scripting.DebugSession;
import com.ti.debug.engine.scripting.RTDXSession;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RTDXServer
extends ScriptServer {
    public RTDXServer(String sServerName, ScriptingEnvironment environment) throws ScriptingException {
        super(sServerName, environment);
        this.traceLog = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    public RTDXSession openSession(String sDebugSession) throws ScriptingException {
        String myName = "openSession";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName, new Object[]{"sDebugSession: " + sDebugSession});
        }
        String serverName = "DebugServer.1";
        RTDXSession rs = null;
        if (this.environment.isRegistered(serverName)) {
            IScriptServer server = this.environment.getServer(serverName);
            IScriptSession session = server.getSession(sDebugSession);
            if (session != null) {
                rs = this.openSession((DebugSession)session);
            } else {
                this.environment.errorHandler.raise(new ScriptingException(4002, "Cannot open RTDXSession.  Debug Session: " + sDebugSession + " has not been opened"));
            }
        } else {
            this.environment.errorHandler.raise(new ScriptingException(4002, "Cannot open RTDXSession.  Debug Server has not been started."));
        }
        this.environment.errorHandler.success();
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(((Object)((Object)this)).getClass().getName(), myName, (Object)rs);
        }
        return rs;
    }

    public RTDXSession openSession(DebugSession session) throws ScriptingException {
        String myName = "openSession";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName, new Object[]{session, "session: " + session});
        }
        RTDXSession rs = null;
        rs = (RTDXSession)this.getSession(session.getName());
        if (rs == null) {
            DebugServer server = (DebugServer)session.getServer();
            rs = (RTDXSession)server.getApplication().getComponent(session.getName(), RTDXSession.class.toString());
            rs.setServer(this);
            this.registerSession(rs);
        }
        this.environment.errorHandler.success();
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.logp(Level.FINER, ((Object)((Object)this)).getClass().getName(), myName, "RETURN {0} {1}", new Object[]{session, rs});
        }
        return rs;
    }

    public void start() throws ScriptingException {
        String myName = "start";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName);
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(((Object)((Object)this)).getClass().getName(), myName);
        }
    }

    public void stop() throws ScriptingException {
        int sessionCount;
        String myName = "stop";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName);
        }
        if ((sessionCount = this.getSessionCount()) > 0) {
            this.environment.errorHandler.raise(new ScriptingException(4002, "Cannot shut down RTDXServer: " + String.valueOf(sessionCount) + " session(s) are still active"));
        } else {
            this.environment.unregisterServer((IScriptServer)this);
        }
        this.environment.errorHandler.success();
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(((Object)((Object)this)).getClass().getName(), myName);
        }
    }
}

