/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting;

import com.ti.ccstudio.scripting.IScriptSession;
import com.ti.ccstudio.scripting.ScriptSession;
import com.ti.ccstudio.scripting.environment.ScriptingEnvironment;
import com.ti.ccstudio.scripting.environment.ScriptingException;
import com.ti.debug.engine.IDspTask;
import com.ti.debug.engine.IDspUser;
import com.ti.debug.engine.IGenericComponent;
import com.ti.debug.engine.IRtdx;
import com.ti.debug.engine.events.data.IRtdxChannelData;
import com.ti.debug.engine.events.data.IRtdxStateData;
import com.ti.debug.engine.events.types.IObjectEventListener;
import com.ti.debug.engine.framework.IDisposable;
import com.ti.debug.engine.scripting.CIOServer;
import com.ti.debug.engine.scripting.DebugSession;
import com.ti.debug.engine.scripting.RTDXChannel;
import com.ti.debug.engine.scripting.RTDXError;
import com.ti.debug.engine.scripting.RTDXInputStream;
import com.ti.debug.engine.scripting.RTDXOutputStream;
import com.ti.debug.engine.scripting.RTDXServer;
import com.ti.debug.engine.scripting.RTDX_EMUinfo;
import com.ti.debug.engine.scripting.RTDX_HWmode;
import com.ti.debug.engine.scripting.RTDX_modequery;
import com.ti.debug.engine.scripting.SWIGTYPE_p_int;
import com.ti.debug.engine.scripting.SWIGTYPE_p_long;
import com.ti.debug.engine.scripting.events.internal.BooleanEventCallback;
import com.ti.debug.engine.scripting.events.internal.FileLoadedEventCallback;
import com.ti.debug.engine.scripting.events.internal.NumberEventCallback;
import com.ti.debug.engine.scripting.events.internal.SimpleEventCallback;
import com.ti.debug.engine.scripting.rtdxlibc;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RTDXSession
extends ScriptSession
implements IGenericComponent {
    protected static final String INPUT_CHANNEL_NAME = "ti_drivers_rtdx_t2h_output_chan_";
    protected static final String OUTPUT_CHANNLE_NAME = "ti_drivers_rtdx_h2t_input_chan_";
    private static final String CIO_OUTPUT_CHANNLE_NAME = "rtdxCioOutputChannel";
    private static final String CIO_INPUT_CHANNLE_NAME = "rtdxCioInputChannel";
    private static final String ENABLE_CIO_CHANNELS_AT_BOOT = "RTDX_shouldCioChannelsBeEnabledAtBootTime";
    private IRtdx rtdx;
    private int emuPin = 0;
    private CIOServer cio;
    private InputStream inCioStrm;
    private OutputStream outCioStrm;
    private String symbolFilePath;
    private String sessionName;
    private boolean isRunning = false;
    private boolean hsSupported = false;
    protected DebugSession debugSession;
    private RTDXListener rtdxListener;
    private RTDXOnRunningCallback onRunningListener;
    private RTDXOnResetCallback onResetListener;
    private RTDXOnRestartCallback onRestartListener;
    private RTDXOnConnectCallback onConnectListener;
    private RTDXOnDisconnectCallback onDisconnectListener;
    private RTDXOnHaltedCallback onHaltedListener;
    private RTDXOnEnabledCallback onEnabledListener;
    private RTDXOnConfiguredCallback onConfiguredListener;
    private RTDXOnChannelOpenCallback onChannelOpenListener;
    private RTDXOnChannelEnabledCallback onChannelEnabledListener;
    private ArrayList<IDisposable> childObjects = new ArrayList();

    public RTDXSession(IGenericComponent session) throws ScriptingException {
        super(ScriptingEnvironment.instance());
        this.traceLog = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.debugSession = (DebugSession)session;
        this.sessionName = this.debugSession.getName();
        this.rtdxListener = new RTDXListener(this);
        this.onRunningListener = new RTDXOnRunningCallback(this);
        this.onResetListener = new RTDXOnResetCallback(this);
        this.onRestartListener = new RTDXOnRestartCallback(this);
        this.onHaltedListener = new RTDXOnHaltedCallback(this);
        this.onConnectListener = new RTDXOnConnectCallback(this);
        this.onDisconnectListener = new RTDXOnDisconnectCallback(this);
        this.onEnabledListener = new RTDXOnEnabledCallback(this);
        this.onConfiguredListener = new RTDXOnConfiguredCallback(this);
        this.onChannelOpenListener = new RTDXOnChannelOpenCallback(this);
        this.onChannelEnabledListener = new RTDXOnChannelEnabledCallback(this);
        this.debugSession.eventHandler.onHalt().addListener((Object)this.onHaltedListener);
        this.debugSession.eventHandler.onRunning().addListener((Object)this.onRunningListener);
        this.debugSession.eventHandler.onReset().addListener((Object)this.onResetListener);
        this.debugSession.eventHandler.onRestart().addListener((Object)this.onRestartListener);
        this.debugSession.eventHandler.onConnected().addListener((Object)this.onConnectListener);
        this.debugSession.eventHandler.onDisconnecting().addListener((Object)this.onDisconnectListener);
        this.debugSession.eventHandler.onPriorityProgramLoaded().addListener((Object)this.rtdxListener);
        IDspTask dspTask = this.debugSession.getDspTask();
        try {
            IRtdx rtdx = dspTask.getRtdx();
            this.setRtdx(rtdx);
        }
        catch (Exception e) {
            System.out.println("Error:  Unable to initialize RTDX. " + e);
        }
    }

    IRtdx getRtdx() {
        return this.rtdx;
    }

    void setRtdx(IRtdx rtdx) {
        this.rtdx = rtdx;
        this.childObjects.add((IDisposable)rtdx);
        IDspTask dspTask = this.debugSession.getDspTask();
        boolean capable = dspTask.getIsRtdxCapable();
        try {
            if (capable && this.debugSession.target.isConnected()) {
                LogFileAttr logFile = this.getLogFileConfig();
                this.configureLogFile(logFile.name, 0L, 1L, logFile.openMode);
                this.configureRTDX(1, 64600L, 4L, 0);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        rtdx.onEnabled().addIObjectEventListener((IObjectEventListener)this.onEnabledListener);
        rtdx.onConfigured().addIObjectEventListener((IObjectEventListener)this.onConfiguredListener);
        rtdx.onChannelOpen().addIObjectEventListener((IObjectEventListener)this.onChannelOpenListener);
        rtdx.onChannelEnabled().addIObjectEventListener((IObjectEventListener)this.onChannelEnabledListener);
    }

    protected void setupBeforeRun(int nEmuPin, boolean enableRtdx) throws ScriptingException, RTDXException {
        long retVal;
        int inBufSize;
        String myName = "setupBeforeRun";
        this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName, new Object[]{this.getDebugSession(), "emuPin: " + nEmuPin});
        IDspTask dspTask = this.debugSession.getDspTask();
        boolean capable = dspTask.getIsRtdxCapable();
        if (!capable) {
            return;
        }
        SWIGTYPE_p_long pOutBufferSize = rtdxlibc.new_pRTDX_INT32_TYPE();
        rtdxlibc.pRTDX_INT32_TYPE_assign(pOutBufferSize, 0);
        int platform = this.debugSession.getPlatform();
        int mode = rtdxlibc.Mode_NONE;
        if (this.debugSession.symbol.exists("_RTDX_JTAGONLY")) {
            if (platform == 0) {
                mode = rtdxlibc.Mode_JTAG;
            } else {
                this.debugSession.getDspUser().reportError(IDspUser.ErrorSeverity.ERROR_SEVERE, "RTDX", "Not a valid RTDX program:  RTDX protocol (JTAG) does not match CCS setup (SIMULATOR)");
                this.environment.raise(new ScriptingException(5005, "Not a valid RTDX program:  RTDX protocol (JTAG) does not match CCS setup (SIMULATOR)"));
            }
        } else if (this.debugSession.symbol.exists("_RTDX_HPONLY")) {
            if (platform == 0) {
                mode = rtdxlibc.Mode_HPRTDX0;
            } else {
                this.debugSession.getDspUser().reportError(IDspUser.ErrorSeverity.ERROR_SEVERE, "RTDX", "Not a valid RTDX program:  RTDX protocol (HSRTDX) does not match CCS setup (SIMULATOR)");
                this.environment.raise(new ScriptingException(5005, "Not a valid RTDX program:  RTDX protocol (HSRTDX) does not match CCS setup (SIMULATOR)"));
            }
        } else if (this.debugSession.symbol.exists("_RTDX_ICEONLY")) {
            mode = rtdxlibc.Mode_IceRTDX;
            this.traceLog.log(Level.INFO, "RTDX program mode is IceRTDX.", this.getDebugSession());
            this.debugSession.expression.evaluate("GEL_TextOut(\"RTDX program mode is IceRTDX.\\n\")");
        } else if (this.debugSession.symbol.exists("RTDX$$MSG")) {
            try {
                if (platform == 0) {
                    this.debugSession.getDspUser().reportError(IDspUser.ErrorSeverity.ERROR_SEVERE, "RTDX", "Not a valid RTDX program:  RTDX protocol (SIMULATOR) does not match CCS setup (EMULATOR)");
                    this.environment.raise(new ScriptingException(5005, "Not a valid RTDX program:  RTDX protocol (SIMULATOR) does not match CCS setup (EMULATOR)"));
                }
                long rtdxMsg = this.debugSession.symbol.getAddress("RTDX$$MSG");
                long rtdxBuf = this.debugSession.symbol.getAddress("__rtdx_buf");
                SWIGTYPE_p_long inBuf = rtdxlibc.new_aRTDX_INT32_TYPE(3);
                rtdxlibc.aRTDX_INT32_TYPE_setitem(inBuf, 0, (int)rtdxMsg);
                rtdxlibc.aRTDX_INT32_TYPE_setitem(inBuf, 1, (int)rtdxBuf);
                rtdxlibc.aRTDX_INT32_TYPE_setitem(inBuf, 2, 1);
                inBufSize = rtdxlibc.sizeof_RTDX_INT32_TYPE * 3;
                retVal = this.rtdx.command(rtdxlibc.Sim_Rtdx_Symbols, (int)SWIGTYPE_p_long.getCPtr(inBuf), inBufSize, 0, (int)SWIGTYPE_p_long.getCPtr(pOutBufferSize));
                if (retVal != 0L) {
                    System.out.println("Unable to set RTDX Sim_Rtdx_Symbols with rtdxMsg = " + rtdxMsg + " and rtdxBuf = " + rtdxBuf + ", error = " + retVal);
                    return;
                }
                mode = rtdxlibc.Mode_simulator;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        long configMode = this.getConfigMode();
        if (configMode == 2L) {
            int n = mode = nEmuPin > 1 ? rtdxlibc.Mode_JTAG : rtdxlibc.Mode_HPRTDX0;
        }
        if (mode == rtdxlibc.Mode_NONE) {
            return;
        }
        inBufSize = rtdxlibc.sizeof_RTDX_linkmodes;
        SWIGTYPE_p_int linkModeBuf = rtdxlibc.new_pRTDX_linkmodes();
        rtdxlibc.pRTDX_linkmodes_assign(linkModeBuf, rtdxlibc.Mode_NONE);
        retVal = this.rtdx.command(rtdxlibc.Default_Config, (int)SWIGTYPE_p_int.getCPtr(linkModeBuf), inBufSize, 0, (int)SWIGTYPE_p_long.getCPtr(pOutBufferSize));
        if (retVal != 0L) {
            this.environment.raise(new ScriptingException(5005, "Unable to do setupBeforeRun, Default_Config with mode = " + rtdxlibc.Mode_NONE + " error: " + Integer.toHexString((int)retVal)));
        }
        RTDX_modequery modeQuery = rtdxlibc.new_pRTDX_modequery();
        inBufSize = rtdxlibc.sizeof_RTDX_INT32_TYPE;
        SWIGTYPE_p_long index = rtdxlibc.new_pRTDX_INT32_TYPE();
        rtdxlibc.pRTDX_INT32_TYPE_assign(pOutBufferSize, rtdxlibc.sizeof_RTDX_modequery);
        for (int i = 0; i < 4; ++i) {
            rtdxlibc.pRTDX_INT32_TYPE_assign(index, i);
            try {
                retVal = this.rtdx.command(rtdxlibc.Query_Modes, (int)SWIGTYPE_p_long.getCPtr(index), inBufSize, (int)RTDX_modequery.getCPtr(modeQuery), (int)SWIGTYPE_p_long.getCPtr(pOutBufferSize));
                if (retVal != 0L || 3 != modeQuery.getMode().getHwunit()) continue;
                this.hsSupported = true;
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        RTDX_EMUinfo emuInfo = rtdxlibc.new_pRTDX_EMUinfo();
        rtdxlibc.pRTDX_INT32_TYPE_assign(pOutBufferSize, rtdxlibc.sizeof_RTDX_EMUinfo);
        retVal = this.rtdx.command(rtdxlibc.Query_EMUinfo, 0, 0, (int)RTDX_EMUinfo.getCPtr(emuInfo), (int)SWIGTYPE_p_long.getCPtr(pOutBufferSize));
        if (retVal != 0L) {
            this.environment.raise(new ScriptingException(5005, "Unable to do setupBeforeRun, Query_EMUinfo error: " + Integer.toHexString((int)retVal)));
        }
        if (mode == rtdxlibc.Mode_HPRTDX0 && !this.hsSupported) {
            if (configMode == 2L) {
                mode = rtdxlibc.Mode_JTAG;
                this.emuPin = 2;
                this.traceLog.log(Level.INFO, "High Speed RTDX is not supported on this EMULATOR, changing to JTAG.", this.getDebugSession());
                this.debugSession.getDspUser().reportError(IDspUser.ErrorSeverity.ERROR_WARNING, "RTDX", "High Speed RTDX is not supported on this EMULATOR, changing to JTAG.");
            } else {
                this.debugSession.getDspUser().reportError(IDspUser.ErrorSeverity.ERROR_SEVERE, "RTDX", "Not a valid RTDX program:  High Speed RTDX is not supported on this EMULATOR.");
                this.environment.raise(new ScriptingException(5005, "Not a valid RTDX program:  High Speed RTDX is not supported on this EMULATOR."));
            }
        }
        inBufSize = rtdxlibc.sizeof_RTDX_linkmodes;
        rtdxlibc.pRTDX_linkmodes_assign(linkModeBuf, mode);
        retVal = this.rtdx.command(rtdxlibc.Default_Config, (int)SWIGTYPE_p_int.getCPtr(linkModeBuf), inBufSize, 0, (int)SWIGTYPE_p_long.getCPtr(pOutBufferSize));
        if (retVal != 0L) {
            this.environment.raise(new ScriptingException(5005, "Unable to do setupBeforeRun, Default_Config with mode = " + mode + " error: " + Integer.toHexString((int)retVal)));
        }
        RTDX_HWmode hwModeBuf = rtdxlibc.new_pRTDX_HWmode();
        rtdxlibc.pRTDX_INT32_TYPE_assign(pOutBufferSize, rtdxlibc.sizeof_RTDX_HWmode);
        retVal = this.rtdx.command(rtdxlibc.Get_Config, 0, 0, (int)RTDX_HWmode.getCPtr(hwModeBuf), (int)SWIGTYPE_p_long.getCPtr(pOutBufferSize));
        if (retVal != 0L) {
            this.environment.raise(new ScriptingException(5005, "Unable to do setupBeforeRun, Get_Config error: " + Integer.toHexString((int)retVal)));
        }
        if (mode == rtdxlibc.Mode_HPRTDX0 || this.getConfigMode() == 2L) {
            inBufSize = rtdxlibc.sizeof_RTDX_HWmode;
            rtdxlibc.pRTDX_INT32_TYPE_assign(pOutBufferSize, 0);
            if (mode == rtdxlibc.Mode_HPRTDX0) {
                if (nEmuPin == 0) {
                    hwModeBuf.setPins_used(rtdxlibc.EMU0_PIN);
                    hwModeBuf.setModeID(3L);
                    hwModeBuf.setPort_config(0L);
                } else {
                    hwModeBuf.setPins_used(rtdxlibc.EMU1_PIN);
                    hwModeBuf.setModeID(4L);
                    hwModeBuf.setPort_config(1L);
                }
            }
            if (this.getConfigMode() == 2L) {
                long port_options = hwModeBuf.getPort_options() | 2L;
                hwModeBuf.setPort_options(port_options);
            }
            if ((retVal = this.rtdx.command(rtdxlibc.Set_Config, (int)RTDX_HWmode.getCPtr(hwModeBuf), inBufSize, 0, (int)SWIGTYPE_p_long.getCPtr(pOutBufferSize))) != 0L) {
                this.environment.raise(new ScriptingException(5005, "Unable to do setupBeforeRun, Set_Config error: " + Integer.toHexString((int)retVal)));
            }
        }
        if (enableRtdx) {
            this.enableRTDX();
        }
        this.traceLog.exiting(((Object)((Object)this)).getClass().getName(), myName, this.getDebugSession());
    }

    public void enableRTDX() throws ScriptingException {
        String myName = "enableRTDX";
        this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName, this.getDebugSession());
        long status = 0L;
        if (!this.rtdx.isEnabled()) {
            this.rtdx.enableRtdx();
        }
        this.traceLog.logp(Level.FINER, ((Object)((Object)this)).getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.getDebugSession(), RTDXError.getStr(status)});
        if (status != 0L) {
            this.environment.raise(new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + ", error: " + RTDXError.getStr(status)));
        }
    }

    public void disableRTDX() throws ScriptingException {
        String myName = "disableRTDX";
        this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName, this.getDebugSession());
        long status = this.rtdx.disableRtdx();
        this.traceLog.logp(Level.FINER, ((Object)((Object)this)).getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.getDebugSession(), RTDXError.getStr(status)});
        if (status != 0L) {
            this.environment.raise(new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + ", error: " + RTDXError.getStr(status)));
        }
    }

    public void configureRTDX(int nMode, long nBufferSize, long nBufferCount, int hsEmuPin) throws ScriptingException {
        boolean wasEnabled;
        String myName = "configureRTDX";
        this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName, new Object[]{this.getDebugSession(), "nMode: " + nMode, "nBufferSize: " + nBufferSize, "hsEmuPin: " + hsEmuPin, "nBufferCount: " + nBufferCount});
        if (this.isRunning || !this.debugSession.target.isConnected()) {
            throw new ScriptingException(5010, "Unable to do " + myName + "(" + nMode + "," + nBufferSize + "," + nBufferCount + "), error: Cannot configure while target is running");
        }
        if (nMode < 0 || nMode > 2) {
            throw new ScriptingException(5010, "Unable to do " + myName + "(" + nMode + "," + nBufferSize + "," + nBufferCount + "), error: invalid mode");
        }
        if (nMode == 2) {
            int family = this.debugSession.getFamily();
            int major = this.debugSession.getMajorISA();
            int minor = this.debugSession.getMinorISA();
            if (this.debugSession.getPlatform() != 0) {
                this.debugSession.getDspUser().reportError(IDspUser.ErrorSeverity.ERROR_FATAL, "RTDX", "Unable to do STATISCTIAL PROFILING on simulator.");
                throw new ScriptingException(5010, "Unable to do STATISCTIAL PROFILING on simulator");
            }
            if (family != 320 || major != 100 || minor < 20) {
                this.traceLog.log(Level.INFO, "STATISCTIAL PROFILING may not be supported on this device.", this.getDebugSession());
                this.debugSession.getDspUser().reportError(IDspUser.ErrorSeverity.ERROR_WARNING, "RTDX", "STATISCTIAL PROFILING may not be supported on this device.");
            }
        }
        if (wasEnabled = this.isEnabled()) {
            this.disableRTDX();
        }
        this.emuPin = hsEmuPin;
        IRtdx.Configuration config = new IRtdx.Configuration(nBufferSize, nMode, nBufferCount);
        this.rtdx.configure(config);
        long status = this.rtdx.getLastStatus();
        if (wasEnabled) {
            this.enableRTDX();
        }
        if (status == 0L && nMode == 2) {
            int dataPage;
            long dataAddr;
            try {
                this.setupBeforeRun(hsEmuPin, false);
            }
            catch (RTDXException e) {
                throw new ScriptingException(e.errorID, e.getMessage());
            }
            if (this.debugSession.symbol.exists("rtdx_mon_state")) {
                dataAddr = this.debugSession.symbol.getAddress("rtdx_mon_state");
                dataPage = this.debugSession.memory.getPage(1);
                this.debugSession.memory.writeWord(dataPage, dataAddr, 0L);
                long regBefore = this.debugSession.memory.readRegister("IER");
                this.debugSession.memory.writeRegister("IER", regBefore & 0xFFFFFFFFFFFFFFF7L);
                this.debugSession.memory.writeRegister("ICR", 8L);
            }
            if (this.debugSession.symbol.exists(CIO_OUTPUT_CHANNLE_NAME)) {
                dataAddr = this.debugSession.symbol.getAddress(CIO_OUTPUT_CHANNLE_NAME);
                dataPage = this.debugSession.memory.getPage(1);
                long[] dataBefore = this.debugSession.memory.readWord(dataPage, dataAddr, 1);
                this.traceLog.log(Level.INFO, "STATISCTIAL PROFILING CIO_OUTPUT_CHANNLE_NAME before: " + dataBefore[0], this.getDebugSession());
                this.debugSession.memory.writeWord(dataPage, dataAddr, 0L);
                dataAddr = this.debugSession.symbol.getAddress(CIO_INPUT_CHANNLE_NAME);
                this.debugSession.memory.writeWord(dataPage, dataAddr, 0L);
            }
        }
        this.traceLog.logp(Level.FINER, ((Object)((Object)this)).getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.getDebugSession(), RTDXError.getStr(status)});
        if (status != 0L) {
            this.environment.raise(new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + "(" + nMode + "," + nBufferSize + "," + nBufferCount + "), error: " + RTDXError.getStr(status)));
        }
    }

    public void configureLogFile(String sFileName, long nFileSize, long nFileFullMode, int nFileOpenMode) throws ScriptingException {
        String myName = "configureLogFile";
        this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName, new Object[]{this.getDebugSession(), "sFileName: " + sFileName, "nFileSize: " + nFileSize, "nFileFullMode: " + nFileFullMode, "nFileOpenMode: " + nFileOpenMode});
        if (this.isRunning || !this.debugSession.target.isConnected()) {
            throw new ScriptingException(5010, "Unable to do " + myName + "(" + sFileName + "," + nFileSize + "," + nFileFullMode + "," + nFileOpenMode + "), error: Cannot configure while target is running");
        }
        boolean wasEnabled = this.isEnabled();
        IRtdx.LogConfiguration log = new IRtdx.LogConfiguration(nFileFullMode, sFileName, (long)nFileOpenMode, nFileSize);
        if (wasEnabled && nFileOpenMode != 3) {
            this.disableRTDX();
        }
        this.rtdx.configureLogFile(log);
        long status = this.rtdx.getLastStatus();
        if (wasEnabled && nFileOpenMode != 3) {
            this.enableRTDX();
        }
        this.traceLog.logp(Level.FINER, ((Object)((Object)this)).getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.getDebugSession(), RTDXError.getStr(status)});
        if (status != 0L) {
            this.environment.raise(new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + "(" + sFileName + "," + nFileSize + "," + nFileFullMode + "," + nFileOpenMode + "), error: " + RTDXError.getStr(status)));
        }
    }

    public LogFileAttr getLogFileConfig() throws ScriptingException {
        String myName = "getLogFileConfig";
        this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName, this.getDebugSession());
        IRtdx.LogConfiguration config = new IRtdx.LogConfiguration();
        this.rtdx.getLogFileConfiguration(config);
        long status = this.rtdx.getLastStatus();
        this.traceLog.logp(Level.FINER, ((Object)((Object)this)).getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.getDebugSession(), RTDXError.getStr(status)});
        if (status != 0L) {
            throw new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + ", error: " + RTDXError.getStr(status));
        }
        LogFileAttr logFile = new LogFileAttr();
        logFile.name = config.getFileName();
        logFile.size = config.getFileSize();
        logFile.logMode = config.getFileFullMode();
        logFile.openMode = config.getFileOpenMode();
        return logFile;
    }

    protected RTDXChannel createChannel() throws ScriptingException {
        String myName = "createChannel";
        this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName, this.getDebugSession());
        RTDXChannel myChannel = new RTDXChannel(this.environment, this);
        this.childObjects.add(myChannel);
        this.traceLog.logp(Level.FINER, ((Object)((Object)this)).getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.getDebugSession(), myChannel});
        return myChannel;
    }

    protected void enableChannel(String sChannelName) throws ScriptingException {
        String myName = "enableChannel";
        this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName, new Object[]{this.getDebugSession(), "sChannelName: " + sChannelName});
        long status = 0L;
        if (sChannelName != "ALL") {
            status = this.rtdx.enableChannel(sChannelName);
        }
        this.traceLog.logp(Level.FINER, ((Object)((Object)this)).getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.getDebugSession(), RTDXError.getStr(status)});
        if (status != 0L) {
            throw new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + "(" + sChannelName + "), error: " + RTDXError.getStr(status));
        }
    }

    protected void enableInputChannel(int nChannelId) throws ScriptingException {
        String myName = "enableInputChannel";
        this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName, new Object[]{this.getDebugSession(), "channelId: " + nChannelId});
        String sChannelName = INPUT_CHANNEL_NAME + nChannelId;
        long status = this.rtdx.enableChannel(sChannelName);
        this.traceLog.logp(Level.FINER, ((Object)((Object)this)).getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.getDebugSession(), RTDXError.getStr(status)});
        if (status != 0L) {
            throw new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + "(" + nChannelId + "), error: " + RTDXError.getStr(status));
        }
    }

    protected void enableOutputChannel(int nChannelId) throws ScriptingException {
        String myName = "enableOutputChannel";
        this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName, new Object[]{this.getDebugSession(), "channelId: " + nChannelId});
        String sChannelName = OUTPUT_CHANNLE_NAME + nChannelId;
        long status = this.rtdx.enableChannel(sChannelName);
        this.traceLog.logp(Level.FINER, ((Object)((Object)this)).getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.getDebugSession(), RTDXError.getStr(status)});
        if (status != 0L) {
            throw new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + "(" + nChannelId + "), error: " + RTDXError.getStr(status));
        }
    }

    protected void disableChannel(String sChannelName) throws ScriptingException {
        String myName = "disableChannel";
        this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName, new Object[]{this.getDebugSession(), "sChannelName: " + sChannelName});
        long status = this.rtdx.disableChannel(sChannelName);
        this.traceLog.logp(Level.FINER, ((Object)((Object)this)).getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.getDebugSession(), RTDXError.getStr(status)});
        if (status != 0L) {
            throw new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + "(" + sChannelName + "), error: " + RTDXError.getStr(status));
        }
    }

    protected void disableInputChannel(int nChannelId) throws ScriptingException {
        String myName = "disableInputChannel";
        this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName, new Object[]{this.getDebugSession(), "channelId: " + nChannelId});
        String sChannelName = INPUT_CHANNEL_NAME + nChannelId;
        long status = this.rtdx.disableChannel(sChannelName);
        this.traceLog.logp(Level.FINER, ((Object)((Object)this)).getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.getDebugSession(), RTDXError.getStr(status)});
        if (status != 0L) {
            throw new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + "(" + nChannelId + "), error: " + RTDXError.getStr(status));
        }
    }

    protected void disableOutputChannel(int nChannelId) throws ScriptingException {
        String myName = "disableOutputChannel";
        this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName, new Object[]{this.getDebugSession(), "channelId: " + nChannelId});
        String sChannelName = OUTPUT_CHANNLE_NAME + nChannelId;
        long status = this.rtdx.disableChannel(sChannelName);
        this.traceLog.logp(Level.FINER, ((Object)((Object)this)).getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.getDebugSession(), RTDXError.getStr(status)});
        if (status != 0L) {
            throw new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + "(" + nChannelId + "), error: " + RTDXError.getStr(status));
        }
    }

    protected long getChannelStatus(String sChannelName) throws ScriptingException {
        String myName = "getChannelStatus";
        this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName, new Object[]{this.getDebugSession(), "sChannelName: " + sChannelName});
        long nResult = this.rtdx.getChannelStatus(sChannelName);
        long status = this.rtdx.getLastStatus();
        this.traceLog.logp(Level.FINER, ((Object)((Object)this)).getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.getDebugSession(), RTDXError.getStr(status, nResult)});
        if (status != 0L) {
            throw new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + "(" + sChannelName + "), error: " + RTDXError.getStr(status));
        }
        return nResult;
    }

    protected long getInputChannelStatus(int nChannelId) throws ScriptingException {
        String myName = "getInputChannelStatus";
        this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName, new Object[]{this.getDebugSession(), "channelId: " + nChannelId});
        String sChannelName = INPUT_CHANNEL_NAME + nChannelId;
        long nResult = this.rtdx.getChannelStatus(sChannelName);
        long status = this.rtdx.getLastStatus();
        this.traceLog.logp(Level.FINER, ((Object)((Object)this)).getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.getDebugSession(), RTDXError.getStr(status, nResult)});
        if (status != 0L) {
            throw new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + "(" + nChannelId + "), error: " + RTDXError.getStr(status));
        }
        return nResult;
    }

    protected long getOutputChannelStatus(int nChannelId) throws ScriptingException {
        String myName = "getOutputChannelStatus";
        this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName, new Object[]{this.getDebugSession(), "nChannelId: " + nChannelId});
        String sChannelName = OUTPUT_CHANNLE_NAME + nChannelId;
        long nResult = this.rtdx.getChannelStatus(sChannelName);
        long status = this.rtdx.getLastStatus();
        this.traceLog.logp(Level.FINER, ((Object)((Object)this)).getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.getDebugSession(), RTDXError.getStr(status, nResult)});
        if (status != 0L) {
            throw new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + "(" + nChannelId + "), error: " + RTDXError.getStr(status));
        }
        return nResult;
    }

    protected long runDiagnostics(int nTestType, int nTestMode, int nTestInfo) throws ScriptingException {
        String myName = "runDiagnostics";
        this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName, new Object[]{this.getDebugSession(), "nTestType: " + nTestType, "nTestMode: " + nTestMode, "nTestInfo: " + nTestInfo});
        long nResult = this.rtdx.runDiagnostics(nTestType, nTestMode, nTestInfo);
        this.traceLog.logp(Level.FINER, ((Object)((Object)this)).getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.getDebugSession(), nResult});
        return nResult;
    }

    protected long getChannelAddr(String sChannelName) throws ScriptingException {
        String myName = "getChannelAddr";
        this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName, new Object[]{this.getDebugSession(), "sChannelName: " + sChannelName});
        long addr = this.rtdx.getChannelID(sChannelName);
        long status = this.rtdx.getLastStatus();
        this.traceLog.logp(Level.FINER, ((Object)((Object)this)).getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.getDebugSession(), RTDXError.getStr(status, addr, 16)});
        if (status != 0L) {
            throw new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + "(" + sChannelName + "), error: " + RTDXError.getStr(status));
        }
        return addr;
    }

    protected long getInputChannelAddr(int channelId) throws ScriptingException {
        String myName = "getInputChannelAddr";
        this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName, new Object[]{this.getDebugSession(), "channelId: " + channelId});
        String sChannelName = INPUT_CHANNEL_NAME + channelId;
        long addr = this.rtdx.getChannelID(sChannelName);
        long status = this.rtdx.getLastStatus();
        this.traceLog.logp(Level.FINER, ((Object)((Object)this)).getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.getDebugSession(), RTDXError.getStr(status, addr, 16)});
        if (status != 0L) {
            throw new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + "(" + channelId + "), error: " + RTDXError.getStr(status));
        }
        return addr;
    }

    protected long getOutputChannelAddr(int channelId) throws ScriptingException {
        String myName = "getOutputChannelAddr";
        this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName, new Object[]{this.getDebugSession(), "channelId: " + channelId});
        String sChannelName = OUTPUT_CHANNLE_NAME + channelId;
        long addr = this.rtdx.getChannelID(sChannelName);
        long status = this.rtdx.getLastStatus();
        this.traceLog.logp(Level.FINER, ((Object)((Object)this)).getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.getDebugSession(), RTDXError.getStr(status, addr, 16)});
        if (status != 0L) {
            throw new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + "(" + channelId + "), error: " + RTDXError.getStr(status));
        }
        return addr;
    }

    public String getStatusString() throws ScriptingException {
        String myName = "getStatusString";
        this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName, this.getDebugSession());
        String sResult = this.rtdx.getStatusString();
        long status = this.rtdx.getLastStatus();
        this.traceLog.logp(Level.FINER, ((Object)((Object)this)).getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.getDebugSession(), status == 0L ? sResult : RTDXError.getStr(status)});
        return sResult;
    }

    protected long getCapability() throws ScriptingException {
        String myName = "getCapability";
        this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName, this.getDebugSession());
        long nResult = this.rtdx.getCapability();
        long status = this.rtdx.getLastStatus();
        this.traceLog.logp(Level.FINER, ((Object)((Object)this)).getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.getDebugSession(), RTDXError.getStr(status, nResult)});
        if (status != 0L) {
            this.environment.raise(new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + ", error: " + RTDXError.getStr(status)));
        }
        return nResult;
    }

    public long getRTDXRev() throws ScriptingException {
        String myName = "getRTDXRev";
        this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName, this.getDebugSession());
        long nResult = this.rtdx.getRTDXRev();
        long status = this.rtdx.getLastStatus();
        this.traceLog.logp(Level.FINER, ((Object)((Object)this)).getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.getDebugSession(), RTDXError.getStr(status, nResult, 16)});
        if (status != 0L) {
            this.environment.raise(new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + ", error: " + RTDXError.getStr(status)));
        }
        return nResult;
    }

    protected boolean isEnabled() throws ScriptingException {
        String myName = "isEnabled";
        this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName, this.getDebugSession());
        boolean bResult = this.rtdx.isEnabled();
        long status = this.rtdx.getLastStatus();
        this.traceLog.logp(Level.FINER, ((Object)((Object)this)).getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.getDebugSession(), RTDXError.getStr(status, bResult ? 1 : 0)});
        if (status != 0L) {
            this.environment.raise(new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + ", error: " + RTDXError.getStr(status)));
        }
        return bResult;
    }

    protected boolean isConfigurable() throws ScriptingException {
        String myName = "isConfigurable";
        this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName, this.getDebugSession());
        boolean bResult = this.rtdx.isRTDXConfigurable();
        long status = this.rtdx.getLastStatus();
        this.traceLog.logp(Level.FINER, ((Object)((Object)this)).getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.getDebugSession(), RTDXError.getStr(status, bResult ? 1 : 0)});
        if (status != 0L) {
            this.environment.raise(new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + ", error: " + RTDXError.getStr(status)));
        }
        return bResult;
    }

    protected long getConfigMode() throws RTDXException {
        String myName = "getConfigMode";
        this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName, this.getDebugSession());
        IRtdx.Configuration config = new IRtdx.Configuration();
        this.rtdx.getConfiguration(config);
        long nResult = config.getMode();
        long status = this.rtdx.getLastStatus();
        this.traceLog.logp(Level.FINER, ((Object)((Object)this)).getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.getDebugSession(), RTDXError.getStr(status, nResult)});
        if (status != 0L) {
            throw new RTDXException(RTDXError.getID(status), "Unable to do " + myName + ", error: " + RTDXError.getStr(status));
        }
        return nResult;
    }

    protected long getConfigBufferSize() throws ScriptingException {
        String myName = "getConfigBufferSize";
        this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName, this.getDebugSession());
        IRtdx.Configuration config = new IRtdx.Configuration();
        this.rtdx.getConfiguration(config);
        long nResult = config.getMainBufferSize();
        long status = this.rtdx.getLastStatus();
        this.traceLog.logp(Level.FINER, ((Object)((Object)this)).getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.getDebugSession(), RTDXError.getStr(status, nResult)});
        if (status != 0L) {
            this.environment.raise(new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + ", error: " + RTDXError.getStr(status)));
        }
        return nResult;
    }

    protected long getConfigBufferCount() throws ScriptingException {
        String myName = "getConfigBufferCount";
        this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName, this.getDebugSession());
        IRtdx.Configuration config = new IRtdx.Configuration();
        this.rtdx.getConfiguration(config);
        long nResult = config.getNumOfMainBuffers();
        long status = this.rtdx.getLastStatus();
        this.traceLog.logp(Level.FINER, ((Object)((Object)this)).getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.getDebugSession(), RTDXError.getStr(status, nResult)});
        if (status != 0L) {
            this.environment.raise(new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + ", error: " + RTDXError.getStr(status)));
        }
        return nResult;
    }

    public HostBufferAttr getRTDXConfig() throws ScriptingException {
        String myName = "getRTDXConfig";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName, this.getDebugSession());
        }
        IRtdx.Configuration config = new IRtdx.Configuration();
        this.rtdx.getConfiguration(config);
        long status = this.rtdx.getLastStatus();
        this.traceLog.logp(Level.FINER, ((Object)((Object)this)).getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.getDebugSession(), RTDXError.getStr(status)});
        if (status != 0L) {
            this.environment.raise(new ScriptingException(RTDXError.getID(status), "Unable to do " + myName + ", error: " + RTDXError.getStr(status)));
        }
        HostBufferAttr hostBuf = new HostBufferAttr();
        hostBuf.mode = config.getMode();
        hostBuf.size = config.getMainBufferSize();
        hostBuf.count = config.getNumOfMainBuffers();
        return hostBuf;
    }

    public void terminate() throws ScriptingException {
        String myName = "terminate";
        this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName, this.getDebugSession());
        if (null != this.server) {
            this.traceLog.log(Level.FINER, "Unregistering this session from the parent Server", this.getDebugSession());
            this.server.unregisterSession((IScriptSession)this);
            if (0 == this.server.getSessionCount()) {
                this.environment.unregisterServer(this.server);
            }
            this.server = null;
        }
        this.traceLog.exiting(((Object)((Object)this)).getClass().getName(), myName, this.getDebugSession());
    }

    public String getName() throws ScriptingException {
        return this.sessionName;
    }

    public DebugSession getDebugSession() {
        return this.debugSession;
    }

    void setServer(RTDXServer server) {
        this.server = server;
    }

    private class RTDXException
    extends Exception {
        private static final long serialVersionUID = -6478920776059472285L;
        private final int errorID;

        private RTDXException(int nID, String sMessage) {
            super(sMessage);
            this.errorID = nID;
        }
    }

    class RTDXListener
    implements FileLoadedEventCallback {
        RTDXSession rtdxSession;

        RTDXListener(RTDXSession session) {
            this.rtdxSession = session;
        }

        public void onEvent(int errorCode, boolean isSymbolsOnly) {
            if (0L == (long)errorCode) {
                try {
                    if (RTDXSession.this.cio != null) {
                        RTDXSession.this.cio.stop();
                        RTDXSession.this.cio = null;
                    }
                }
                catch (Exception e) {
                    System.out.println("RTDXSession::cio.stop failed: " + e);
                    RTDXSession.this.cio = null;
                }
                try {
                    if (RTDXSession.this.inCioStrm != null) {
                        RTDXSession.this.inCioStrm.close();
                        RTDXSession.this.inCioStrm = null;
                    }
                }
                catch (Exception e) {
                    System.out.println("RTDXSession::inCioStrm.close failed: " + e);
                    RTDXSession.this.inCioStrm = null;
                }
                try {
                    if (RTDXSession.this.outCioStrm != null) {
                        RTDXSession.this.outCioStrm.close();
                        RTDXSession.this.outCioStrm = null;
                    }
                }
                catch (Exception e) {
                    System.out.println("RTDXSession::outCioStrm.close failed: " + e);
                    RTDXSession.this.outCioStrm = null;
                }
                try {
                    RTDXSession.this.setupBeforeRun(RTDXSession.this.emuPin, true);
                }
                catch (Exception e) {
                    return;
                }
                try {
                    if (RTDXSession.this.getConfigMode() != 2L && RTDXSession.this.debugSession.symbol.exists(RTDXSession.CIO_OUTPUT_CHANNLE_NAME)) {
                        RTDXSession.this.inCioStrm = new RTDXInputStream(this.rtdxSession, RTDXSession.CIO_OUTPUT_CHANNLE_NAME);
                        RTDXSession.this.outCioStrm = new RTDXOutputStream(this.rtdxSession, RTDXSession.CIO_INPUT_CHANNLE_NAME);
                        File fileName = new File(RTDXSession.this.debugSession.symbol.getSymbolFileName());
                        RTDXSession.this.symbolFilePath = fileName.getParent();
                        RTDXSession.this.cio = new CIOServer(RTDXSession.this.inCioStrm, RTDXSession.this.outCioStrm, RTDXSession.this.symbolFilePath);
                        if (RTDXSession.this.debugSession.symbol.exists(RTDXSession.ENABLE_CIO_CHANNELS_AT_BOOT)) {
                            int majorISA = RTDXSession.this.debugSession.getMajorISA();
                            if (majorISA == 85) {
                                long funcAddr = (RTDXSession.this.debugSession.symbol.getAddress(RTDXSession.ENABLE_CIO_CHANNELS_AT_BOOT) + 1L) / 2L;
                                int dataPage = this.rtdxSession.debugSession.memory.getPage(1);
                                this.rtdxSession.debugSession.memory.writeWord(dataPage, funcAddr, 0L);
                            } else {
                                long funcAddr = RTDXSession.this.debugSession.symbol.getAddress(RTDXSession.ENABLE_CIO_CHANNELS_AT_BOOT);
                                int progPage = this.rtdxSession.debugSession.memory.getPage(0);
                                this.rtdxSession.debugSession.memory.writeWord(progPage, funcAddr, 0L);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    RTDXSession.this.cio = null;
                }
            }
        }
    }

    class RTDXOnRestartCallback
    implements NumberEventCallback {
        RTDXSession rtdxSession;

        RTDXOnRestartCallback(RTDXSession session) {
            this.rtdxSession = session;
        }

        public void onEvent(long errorCode) {
            try {
                if (RTDXSession.this.cio != null) {
                    RTDXSession.this.cio.stop();
                    RTDXSession.this.cio = null;
                }
                if (RTDXSession.this.outCioStrm != null) {
                    RTDXSession.this.cio = new CIOServer(RTDXSession.this.inCioStrm, RTDXSession.this.outCioStrm, RTDXSession.this.symbolFilePath);
                }
            }
            catch (Exception e) {
                System.out.println("RTDXSession: CIOServer failed: " + e);
                RTDXSession.this.cio = null;
            }
        }
    }

    class RTDXOnResetCallback
    implements NumberEventCallback {
        RTDXSession rtdxSession;

        RTDXOnResetCallback(RTDXSession session) {
            this.rtdxSession = session;
        }

        public void onEvent(long errorCode) {
            try {
                if (RTDXSession.this.cio != null) {
                    RTDXSession.this.cio.stop();
                    RTDXSession.this.cio = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class RTDXOnDisconnectCallback
    implements BooleanEventCallback {
        RTDXSession rtdxSession;

        RTDXOnDisconnectCallback(RTDXSession session) {
            this.rtdxSession = session;
        }

        public void onEvent(boolean dueToError) {
            try {
                if (RTDXSession.this.cio != null) {
                    RTDXSession.this.cio.flush();
                }
            }
            catch (Exception e) {
                System.out.println("RTDXSession::CIOServer failed: " + e);
            }
        }
    }

    class RTDXOnConnectCallback
    implements SimpleEventCallback {
        RTDXSession rtdxSession;

        RTDXOnConnectCallback(RTDXSession session) {
            this.rtdxSession = session;
        }

        public void onEvent() {
            try {
                IDspTask dspTask = RTDXSession.this.debugSession.getDspTask();
                boolean capable = dspTask.getIsRtdxCapable();
                if (capable) {
                    LogFileAttr logFile = RTDXSession.this.getLogFileConfig();
                    RTDXSession.this.configureLogFile(logFile.name, 0L, 1L, logFile.openMode);
                    RTDXSession.this.configureRTDX(1, 64600L, 4L, 0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class RTDXOnRunningCallback
    implements SimpleEventCallback {
        RTDXSession rtdxSession;

        RTDXOnRunningCallback(RTDXSession session) {
            this.rtdxSession = session;
        }

        public void onEvent() {
            RTDXSession.this.isRunning = true;
            try {
                if (RTDXSession.this.cio != null) {
                    this.rtdxSession.enableChannel(RTDXSession.CIO_OUTPUT_CHANNLE_NAME);
                    this.rtdxSession.enableChannel(RTDXSession.CIO_INPUT_CHANNLE_NAME);
                }
            }
            catch (Exception e) {
                System.out.println("RTDXSession::CIOServer start failed: " + e);
            }
        }
    }

    class RTDXOnChannelEnabledCallback
    implements IObjectEventListener<IRtdxChannelData> {
        private RTDXSession rtdxSession;
        private boolean enabled;
        private long resultCode;
        private String channelName;

        RTDXOnChannelEnabledCallback(RTDXSession session) {
            this.rtdxSession = session;
        }

        public boolean getEnabled() {
            return this.enabled;
        }

        public long getResultCode() {
            return this.resultCode;
        }

        public void onEvent(IRtdxChannelData result) {
            RTDXSession.this.traceLog.log(Level.FINE, "RTDX session = " + this.rtdxSession.sessionName, this.rtdxSession.getDebugSession());
            this.enabled = result.getEnabled();
            RTDXSession.this.traceLog.log(Level.FINE, "RTDX Channel Enabled: " + this.enabled, this.rtdxSession.getDebugSession());
            this.resultCode = result.getResultCode();
            RTDXSession.this.traceLog.log(Level.FINE, "RTDX Channel Enabled result code = " + this.resultCode, this.rtdxSession.getDebugSession());
            this.channelName = result.getChannelName();
            RTDXSession.this.traceLog.log(Level.FINE, "RTDX Channel Name: " + this.channelName, this.rtdxSession.getDebugSession());
        }
    }

    class RTDXOnChannelOpenCallback
    implements IObjectEventListener<IRtdxChannelData> {
        private RTDXSession rtdxSession;
        private boolean enabled;
        private long resultCode;
        private String channelName;

        RTDXOnChannelOpenCallback(RTDXSession session) {
            this.rtdxSession = session;
        }

        public boolean getEnabled() {
            return this.enabled;
        }

        public long getResultCode() {
            return this.resultCode;
        }

        public void onEvent(IRtdxChannelData result) {
            RTDXSession.this.traceLog.log(Level.FINE, "RTDX session = " + this.rtdxSession.sessionName, this.rtdxSession.getDebugSession());
            this.enabled = result.getEnabled();
            RTDXSession.this.traceLog.log(Level.FINE, "RTDX Channel Enabled: " + this.enabled, this.rtdxSession.getDebugSession());
            this.resultCode = result.getResultCode();
            RTDXSession.this.traceLog.log(Level.FINE, "RTDX Channel Open result code = " + this.resultCode, this.rtdxSession.getDebugSession());
            this.channelName = result.getChannelName();
            RTDXSession.this.traceLog.log(Level.FINE, "RTDX Channel Name: " + this.channelName, this.rtdxSession.getDebugSession());
        }
    }

    class RTDXOnConfiguredCallback
    implements IObjectEventListener<IRtdxStateData> {
        private RTDXSession rtdxSession;
        private long resultCode;

        RTDXOnConfiguredCallback(RTDXSession session) {
            this.rtdxSession = session;
        }

        public long getResultCode() {
            return this.resultCode;
        }

        public void onEvent(IRtdxStateData result) {
            this.resultCode = result.getResultCode();
            RTDXSession.this.traceLog.log(Level.FINE, "RTDX session = " + this.rtdxSession.sessionName, this.rtdxSession.getDebugSession());
            RTDXSession.this.traceLog.log(Level.FINE, "RTDX Configured result code = " + this.resultCode, this.rtdxSession.getDebugSession());
        }
    }

    class RTDXOnEnabledCallback
    implements IObjectEventListener<IRtdxStateData> {
        private RTDXSession rtdxSession;
        private boolean enabled;

        RTDXOnEnabledCallback(RTDXSession session) {
            this.rtdxSession = session;
        }

        public boolean getEnabled() {
            return this.enabled;
        }

        public void onEvent(IRtdxStateData result) {
            RTDXSession.this.traceLog.log(Level.FINE, "RTDX session = " + this.rtdxSession.sessionName, this.rtdxSession.getDebugSession());
            this.enabled = result.getEnabled();
            RTDXSession.this.traceLog.log(Level.FINE, "RTDX Enabled: " + this.enabled, this.rtdxSession.getDebugSession());
        }
    }

    class RTDXOnHaltedCallback
    implements NumberEventCallback {
        private RTDXSession rtdxSession;

        RTDXOnHaltedCallback(RTDXSession session) {
            this.rtdxSession = session;
        }

        public void onEvent(long pc) {
            RTDXSession.this.isRunning = false;
            try {
                if (RTDXSession.this.cio != null) {
                    RTDXSession.this.cio.flush();
                }
            }
            catch (Exception e) {
                RTDXSession.this.traceLog.log(Level.FINE, "RTDX session = " + this.rtdxSession.sessionName, this.rtdxSession.getDebugSession());
                System.out.println("RTDXSession::CIOServer flush failed: " + e);
            }
        }
    }

    public static class LogMode {
        public static final int LINEAR = 0;
        public static final int CIRCULAR = 1;
        public static final int STATISCTIAL_PROFILING = 2;

        private LogMode() {
        }
    }

    public static class FileOpenMode {
        public static final int READ_ONLY = 0;
        public static final int APPEND = 1;
        public static final int OVER_WRITE = 2;
        public static final int TRACE_LOG = 3;

        private FileOpenMode() {
        }
    }

    public static class ChannelStatus {
        public static final long CHANNEL_ENABLED = 0L;
        public static final long CHANNEL_DISABLED = 1L;

        private ChannelStatus() {
        }
    }

    private static class RtdxHardware {
        public static final int HW_NONE = 0;
        public static final int HW_JTAG = 1;
        public static final int HW_IceRTDX = 2;
        public static final int HW_HPRTDX0 = 3;
        public static final int HW_Simulator = 4;
        public static final int HW_END = 5;

        private RtdxHardware() {
        }
    }

    public class HostBufferAttr {
        public int mode;
        public long size;
        public long count;

        private HostBufferAttr() {
        }
    }

    public class LogFileAttr {
        public String name;
        public long size;
        public long logMode;
        public int openMode;

        private LogFileAttr() {
        }
    }
}

