/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver;

import com.ti.ccstudio.debug.memoryserver.MemoryServer;
import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.configoptions.ClientConfigOptions;
import com.ti.ccstudio.debug.memoryserver.enums.EnumDspValueType;
import com.ti.ccstudio.debug.memoryserver.enums.EnumGtiMemResult;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryRegionStatus;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryRequestStates;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryRequestTypes;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryServerErrorCodes;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryViews;
import com.ti.ccstudio.debug.memoryserver.enums.EnumSpecialDisplayStrings;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTargetType;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.EventArgs;
import com.ti.ccstudio.debug.memoryserver.events.internal.IMemoryRegionReadCompleteEventHandler;
import com.ti.ccstudio.debug.memoryserver.interfaces.IDisposable;
import com.ti.ccstudio.debug.memoryserver.interfaces.IFactoryObjectCreator;
import com.ti.ccstudio.debug.memoryserver.interfaces.IMemoryRegion;
import com.ti.ccstudio.debug.memoryserver.interfaces.IMemoryRequestClient;
import com.ti.ccstudio.debug.memoryserver.interfaces.ITargetHandler;
import com.ti.ccstudio.debug.memoryserver.maps.AdrsMap;
import com.ti.ccstudio.debug.memoryserver.maps.AdrsRegion;
import com.ti.ccstudio.debug.memoryserver.maps.AdrsRegionCreator;
import com.ti.ccstudio.debug.memoryserver.maps.CacheList;
import com.ti.ccstudio.debug.memoryserver.maps.MemoryMapHandler;
import com.ti.ccstudio.debug.memoryserver.maps.MemoryMapRegionCreator;
import com.ti.ccstudio.debug.memoryserver.maps.MemoryMapRegionList;
import com.ti.ccstudio.debug.memoryserver.memoryhierarchy.MemoryHierarchyHandler;
import com.ti.ccstudio.debug.memoryserver.memoryhierarchy.MemoryTypeDescriptor;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.CExprRequestDescriptor;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.MemoryRequestDescriptor;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.RegisterRequestDescriptor;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.RequestDescriptorBaseClass;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.RequestDescriptorQueue;
import com.ti.ccstudio.debug.memoryserver.target.MemoryRWHandler;
import com.ti.ccstudio.debug.memoryserver.target.MemoryRWHandlerCreator;
import com.ti.ccstudio.debug.memoryserver.target.TargetHandler;
import com.ti.ccstudio.debug.memoryserver.util.BaseConverter;
import com.ti.ccstudio.debug.memoryserver.util.RecyclingFactory;
import com.ti.debug.engine.IDspMemory;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.EventObject;
import java.util.List;

public class MemoryPageHandler
implements IMemoryRequestClient,
IMemoryRegionReadCompleteEventHandler,
IDisposable {
    private boolean isInitialized = false;
    private MemoryServer owner = null;
    protected MemoryMapRegionCreator memoryMapRegionCreator = null;
    protected RecyclingFactory memoryMapRegionFactory = null;
    protected IFactoryObjectCreator targetMemoryRegionCreator = null;
    protected RecyclingFactory targetMemoryRegionFactory = null;
    protected IFactoryObjectCreator memoryRWHandlerCreator = null;
    protected RecyclingFactory memoryRWHandlerFactory = null;
    private MemoryHierarchyHandler memoryHierarchy = null;
    private CacheList memoryViewList_CPUview = null;
    private CacheList memoryViewList_PhysicalView = null;
    private CacheList memoryViewList_Stage2PhysicalView = null;
    private AdrsMap registerContextSaveMap = null;
    private TargetHandler target;
    private String strMemoryPageName = "defaultPage";
    private short memoryPageNumber;
    private String strName;
    private MemoryMapHandler memoryMapHandler = null;
    private MemoryMapRegionList memoryMapRegionList = null;
    private volatile boolean disposed = false;

    public MemoryPageHandler(MemoryServer ownerObj, TargetHandler targetDevice, String memPageName, short memPageNumber) {
        this.owner = ownerObj;
        this.target = targetDevice;
        this.targetMemoryRegionCreator = new AdrsRegionCreator(this.target, this.getTargetAccessRequestQueue(), this.owner.getMmuHandler());
        this.targetMemoryRegionFactory = new RecyclingFactory(this.target.info.getStrTargetDescription() + " Target Memory Region Class Factory", this.targetMemoryRegionCreator);
        this.strName = this.target.getInfo().getStrTargetProcessorId() + ": " + memPageName;
        this.strMemoryPageName = memPageName;
        this.memoryPageNumber = memPageNumber;
    }

    public void init() {
        if (!this.isInitialized || this.memoryHierarchy == null || this.memoryHierarchy.getXmlFileName().compareTo(this.target.info.getXmlDeviceDescriptionFileName()) != 0) {
            this.memoryHierarchy = new MemoryHierarchyHandler(this.target, this.memoryPageNumber, this.owner.getListOfRegisterHandlers());
            this.registerContextSaveMap = new AdrsMap(this.target.getInfo(), this.memoryPageNumber, this.strName, null, this.targetMemoryRegionFactory);
            this.memoryViewList_CPUview = new CacheList();
            this.memoryViewList_PhysicalView = new CacheList();
            this.memoryViewList_Stage2PhysicalView = new CacheList();
            for (MemoryTypeDescriptor memTypeObj : this.memoryHierarchy.getListOfMemoryViews()) {
                AdrsMap msCache = new AdrsMap(this.target.info, this.memoryPageNumber, this.strName, memTypeObj, this.targetMemoryRegionFactory);
                this.memoryViewList_CPUview.add(msCache);
                msCache = new AdrsMap(this.target.info, this.memoryPageNumber, this.strName + "_physical", memTypeObj, this.targetMemoryRegionFactory);
                this.memoryViewList_PhysicalView.add(msCache);
                msCache = new AdrsMap(this.target.info, this.memoryPageNumber, this.strName + "_stage2physical", memTypeObj, this.targetMemoryRegionFactory);
                this.memoryViewList_Stage2PhysicalView.add(msCache);
            }
            if (!(this.isInitialized || this.isDisposed() || this.owner.isDisposed())) {
                this.memoryRWHandlerCreator = new MemoryRWHandlerCreator(this, this.target, this.getTargetAccessRequestQueue(), this.getCExprEvalRequestQueue(), this.owner.getMmuHandler());
                this.memoryRWHandlerFactory = new RecyclingFactory(this.target.info.getStrTargetDescription() + " MemoryRWHandlerFactory", this.memoryRWHandlerCreator);
                this.memoryMapHandler = new MemoryMapHandler(this, this.target.info);
                this.memoryMapRegionCreator = new MemoryMapRegionCreator(this.target, this.memoryMapHandler);
                this.memoryMapRegionFactory = new RecyclingFactory(this.target.info.getStrTargetDescription() + " MemoryMapRegion Factory", this.memoryMapRegionCreator);
                if (this.memoryHierarchy.getListOfMemoryViews().size() > 0) {
                    this.memoryMapRegionList = new MemoryMapRegionList(this.target.getInfo(), this.getMemoryPageNumber(), "SDK MemoryMap List", this.memoryHierarchy.getListOfMemoryViews().get(0), this.memoryMapRegionFactory, this.memoryMapHandler);
                } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                    MemoryServerTrace.logError("Could not create memoryMapRegionList - this.memoryHierarchy.getListOfMemoryViews().size() == 0", "MemoryPageHandler.init", this.target.info);
                }
            }
            this.isInitialized = true;
        } else if (this.target.info.getTargetTypeId() == EnumTargetType.EMULATOR && !this.target.isDisconnected()) {
            this.memoryHierarchy.initOnConnect();
        }
    }

    public void setAdrsRegionCreator(IFactoryObjectCreator value) {
        this.targetMemoryRegionCreator = value;
        this.targetMemoryRegionFactory.setFactoryObjectCreator(value);
    }

    public void setMemoryRWHandlerCreator(IFactoryObjectCreator value) {
        this.memoryRWHandlerCreator = value;
        this.memoryRWHandlerFactory.setFactoryObjectCreator(value);
    }

    public MemoryRWHandler getMemoryRWHandler() {
        return (MemoryRWHandler)this.memoryRWHandlerFactory.createInstance();
    }

    public RequestDescriptorQueue getTargetAccessRequestQueue() {
        return this.owner.getTargetAccessRequestQueue();
    }

    public RequestDescriptorQueue getCExprEvalRequestQueue() {
        return this.owner.getCExprEvalRequestQueue();
    }

    public MemoryHierarchyHandler getMemoryHierarchy() {
        return this.memoryHierarchy;
    }

    public CacheList getMemoryViewList(EnumMemoryViews viewType) {
        CacheList result = this.memoryViewList_CPUview;
        if (viewType == EnumMemoryViews.PHYSICAL_MEMORY_VIEW) {
            result = this.memoryViewList_PhysicalView;
        } else if (viewType == EnumMemoryViews.STAGE2_PHYSICAL_MEMORY_VIEW) {
            result = this.memoryViewList_Stage2PhysicalView;
        }
        return result;
    }

    public AdrsMap getRegisterContextSaveMap() {
        return this.registerContextSaveMap;
    }

    public ITargetHandler getTarget() {
        return this.target;
    }

    public String getStrMemoryPageName() {
        return this.strMemoryPageName;
    }

    public short getMemoryPageNumber() {
        return this.memoryPageNumber;
    }

    public String getStrName() {
        return this.strName;
    }

    public MemoryMapHandler getMemoryMapHandler() {
        return this.memoryMapHandler;
    }

    public void setMemoryMapHandler(MemoryMapHandler value) {
        this.memoryMapHandler = value;
    }

    public MemoryMapRegionList getMemoryMapRegionList() {
        return this.memoryMapRegionList;
    }

    public void flushServerCache() {
        this.flushServerCacheForView(EnumMemoryViews.CPU_MEMORY_VIEW);
        this.flushServerCacheForView(EnumMemoryViews.PHYSICAL_MEMORY_VIEW);
        this.flushServerCacheForView(EnumMemoryViews.STAGE2_PHYSICAL_MEMORY_VIEW);
    }

    public void flushServerCacheForView(EnumMemoryViews view) {
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
            int numAdrsRegions = 0;
            int numTransactionsPending = 0;
            for (AdrsMap msCache : this.getMemoryViewList(view)) {
                numAdrsRegions += msCache.getAdrsRegionCount();
                for (IMemoryRegion region : msCache) {
                    if (!region.getStatus().contains((Object)EnumMemoryRegionStatus.MEMORY_REQUEST_PENDING)) continue;
                    ++numTransactionsPending;
                }
            }
            MemoryServerTrace.logInfo("Num Adrs Regions in cache = " + numAdrsRegions + ", Num Pending transactions (won't be flushed) = " + numTransactionsPending + ", " + this.getTargetAccessRequestQueue().name + " requestQueue status: size=" + this.getTargetAccessRequestQueue().size(), "MemoryPageHandler.flushServerCacheForView(" + (Object)((Object)view) + ")", this.target.info);
        }
        for (AdrsMap msCache : this.getMemoryViewList(view)) {
            msCache.clearMap();
        }
    }

    public int getNumMAUsPerMemoryItem(MemoryRequestDescriptor req) {
        int result = 1;
        MemoryRWHandler memoryRWHandler = this.getMemoryRWHandler();
        memoryRWHandler.config(req);
        result = memoryRWHandler.getNumMAUsPerMemoryItem();
        memoryRWHandler.release();
        return result;
    }

    public String getSpecialDataString(MemoryRequestDescriptor req, EnumSpecialDisplayStrings StringType) {
        String result = "?";
        MemoryRWHandler memoryRWHandler = this.getMemoryRWHandler();
        memoryRWHandler.config(req);
        result = memoryRWHandler.getSpecialDataString(StringType);
        memoryRWHandler.release();
        return result;
    }

    private MemoryRequestDescriptor createTargetWriteRequest(MemoryRequestDescriptor clientRequest) {
        MemoryRequestDescriptor targetRequest = (MemoryRequestDescriptor)this.getTargetAccessRequestQueue().getRequestDescriptorFactory().createInstance();
        this.getTargetAccessRequestQueue().addRequest(targetRequest);
        targetRequest.config(this, this, clientRequest);
        return targetRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeMemory_String(long adrs, MemoryRequestDescriptor clientRequest, long[] nextAdrs, String strWriteData, String[] strErrorInfo) {
        boolean result = false;
        boolean isValidWriteData = false;
        nextAdrs[0] = this.target.info.getNextAdrs(adrs, this.getNumMAUsPerMemoryItem(clientRequest), this.memoryPageNumber);
        strErrorInfo[0] = "";
        String cleanWriteData = strWriteData.trim().toLowerCase();
        MemoryRWHandler memoryRWHandler = null;
        if (!this.target.isDisconnected()) {
            try {
                try {
                    isValidWriteData = true;
                    switch (clientRequest.getFormatStyle()) {
                        case REAL: 
                        case SCIENTIFIC: {
                            if (clientRequest.getFormatDataType() == EnumDspValueType.DSP_IEEE_DOUBLE || clientRequest.getFormatDataType() == EnumDspValueType.DSP_DOUBLE || clientRequest.getFormatDataType() == EnumDspValueType.DSP_LDOUBLE) {
                                cleanWriteData = cleanWriteData + "d";
                            }
                            break;
                        }
                        case CHARACTER: 
                        case PACKED_CHAR: {
                            cleanWriteData = "0x" + Long.toHexString(BaseConverter.fromCharStringToULong(strWriteData));
                            break;
                        }
                        case BINARY: {
                            if (cleanWriteData.endsWith("b")) {
                                cleanWriteData = cleanWriteData.substring(0, cleanWriteData.length() - 1);
                            }
                            if (isValidWriteData = BaseConverter.isBin(cleanWriteData)) {
                                cleanWriteData = "0x" + Long.toHexString(BaseConverter.fromBinStringToULong(cleanWriteData));
                            }
                            break;
                        }
                        case OCTAL: {
                            isValidWriteData = BaseConverter.isOct(cleanWriteData);
                            if (isValidWriteData) {
                                cleanWriteData = "0x" + Long.toHexString(BaseConverter.fromOctStringToULong(cleanWriteData));
                            }
                            break;
                        }
                        case TI_STYLE_HEX: {
                            cleanWriteData = cleanWriteData.replace("0x", "");
                            cleanWriteData = "0x" + cleanWriteData;
                            break;
                        }
                        default: {
                            cleanWriteData = strWriteData;
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    isValidWriteData = false;
                }
                if (!isValidWriteData && this.target.isCExprEvalAllowed()) {
                    isValidWriteData = true;
                    cleanWriteData = strWriteData;
                }
                if (!isValidWriteData) {
                    strErrorInfo[0] = "Invalid write data string [" + strWriteData + "]. Display format: " + (Object)((Object)clientRequest.getFormatStyle());
                    if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                        MemoryServerTrace.logInfo(strErrorInfo[0], "MemoryPageHandler.writeMemory_String", null);
                    }
                } else {
                    int viewIndex = this.getMemoryHierarchy().getMemoryViewIndex(clientRequest.getTargetMemoryLevelEnableFlags());
                    if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                        String strTrace = "adrs: 0x" + Long.toHexString(adrs) + " data: [" + strWriteData + "]: ViewIndex = " + Integer.toString(viewIndex) + " = " + this.getMemoryHierarchy().getListOfMemoryViews().get(viewIndex).getName();
                        MemoryServerTrace.logInfo(strTrace, "MemoryPageHandler.WriteMemory_String", this.target.info);
                    }
                    for (AdrsMap msCache : this.getMemoryViewList(clientRequest.getMemoryView())) {
                        AdrsRegion targetMemory;
                        if (msCache == null || (targetMemory = (AdrsRegion)msCache.findAdrsRegionContainingAdrs(adrs)) == null) continue;
                        if (!targetMemory.getStatus().equals(EnumSet.of(EnumMemoryRegionStatus.READY_FOR_USE))) {
                            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                                String strTrace = "WRITE CONFLICT at adrs 0x" + Long.toHexString(adrs) + " [" + strWriteData + "]: Aborting " + targetMemory.getStatus().toString() + " request for adrs 0x" + Long.toHexString(targetMemory.getStartAdrs()) + "-0x" + Long.toHexString(targetMemory.getEndAdrs());
                                MemoryServerTrace.logInfo(strTrace, "MemoryPageHandler.WriteMemory_String", this.target.info);
                            }
                            targetMemory.setStatus(EnumSet.of(EnumMemoryRegionStatus.ABORT_PENDING));
                            msCache.removeRegion(targetMemory);
                            continue;
                        }
                        msCache.removeRegion(targetMemory);
                        targetMemory.release();
                    }
                    memoryRWHandler = this.getMemoryRWHandler();
                    memoryRWHandler.config(clientRequest);
                    result = memoryRWHandler.setString(adrs, clientRequest, nextAdrs, cleanWriteData, strErrorInfo);
                    memoryRWHandler.release();
                    memoryRWHandler = null;
                    if (!result && MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                        MemoryServerTrace.logError(strErrorInfo[0] + ".", "MemoryPageHandler.writeMemory_String", this.target.info);
                    }
                }
            }
            catch (Exception e) {
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                    MemoryServerTrace.logException("Exception: " + e.getMessage() + ". [" + strErrorInfo[0] + "].", "MemoryPageHandler.writeMemory_String", e, this.target.info);
                }
            }
            finally {
                if (memoryRWHandler != null) {
                    memoryRWHandler.release();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeMemory_Data(long adrs, MemoryRequestDescriptor clientRequest, long[] nextAdrs, long writeData, String[] strErrorInfo) {
        boolean result = false;
        EnumGtiMemResult[] memWriteErrorCode = new EnumGtiMemResult[]{EnumGtiMemResult.MEM_ACCESS_OK};
        MemoryRWHandler memoryRWHandler = null;
        nextAdrs[0] = this.target.info.getNextAdrs(adrs, this.getNumMAUsPerMemoryItem(clientRequest), this.memoryPageNumber);
        strErrorInfo[0] = "";
        if (!this.target.isDisconnected()) {
            try {
                int viewIndex = this.getMemoryHierarchy().getMemoryViewIndex(clientRequest.getTargetMemoryLevelEnableFlags());
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                    String strTrace = "MemoryPageHandler.WriteMemory_Data: adrs 0x" + Long.toHexString(adrs) + " [0x" + Long.toHexString(writeData) + "]: ViewIndex = " + Integer.toString(viewIndex) + " = " + this.getMemoryHierarchy().getListOfMemoryViews().get(viewIndex).getName();
                    MemoryServerTrace.logInfo(strTrace, "MemoryPageHandler.writeMemory_Data", this.target.info);
                }
                for (AdrsMap msCache : this.getMemoryViewList(clientRequest.getMemoryView())) {
                    AdrsRegion targetMemory;
                    if (msCache == null || (targetMemory = (AdrsRegion)msCache.findAdrsRegionContainingAdrs(adrs)) == null) continue;
                    msCache.removeRegion(targetMemory);
                }
                MemoryRequestDescriptor targetRequest = this.createTargetWriteRequest(clientRequest);
                memoryRWHandler = this.getMemoryRWHandler();
                memoryRWHandler.config(targetRequest);
                result = memoryRWHandler.setData(adrs, targetRequest, nextAdrs, writeData, strErrorInfo, memWriteErrorCode);
                memoryRWHandler.release();
                if (!result && MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                    MemoryServerTrace.logError(strErrorInfo[0] + ".", "MemoryPageHandler.writeMemory_Data (!result)", this.target.info);
                }
            }
            catch (Exception e) {
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                    MemoryServerTrace.logException("Exception: " + e.getMessage() + " [" + strErrorInfo[0] + "].", "MemoryPageHandler.writeMemory_Data", e, this.target.info);
                }
            }
            finally {
                if (memoryRWHandler != null) {
                    memoryRWHandler.release();
                }
            }
        }
        return result;
    }

    public synchronized boolean requestMemoryRead(MemoryRequestDescriptor clientRequest, String[] strErrorInfo) {
        if (MemoryServer.TRACE__MEMORY_SERVER) {
            System.out.println("Memory Server: MemoryPageHandler.requestMemoryRead() start @ " + System.currentTimeMillis() + " ms");
        }
        boolean result = false;
        int viewIndex = 0;
        AdrsMap msCache = this.getMemoryViewList(clientRequest.getMemoryView()).getCache(viewIndex);
        boolean okIfmsCacheIsNull = true;
        if (msCache != null || okIfmsCacheIsNull) {
            try {
                String msg;
                ArrayList targetMemoryAccessList = new ArrayList();
                if (this.target.isRunning()) {
                    this.flushServerCache();
                }
                if (msCache != null && clientRequest.getTargetMemoryLevelEnableFlags() != msCache.getMemoryTypeDescriptor().getMemoryLevelEnableFlags() || clientRequest.getClientConfigOptions() != null && ((ClientConfigOptions)clientRequest.getClientConfigOptions()).isMemoryAnalysisEnabled()) {
                    CacheList cacheList = this.getMemoryViewList(clientRequest.getMemoryView());
                    for (int n = 0; n < cacheList.size(); ++n) {
                        AdrsMap view = cacheList.get(n);
                        viewIndex = this.getMemoryHierarchy().getMemoryViewIndex(view.getMemoryTypeDescriptor().getMemoryLevelEnableFlags());
                        this.updateView(viewIndex, clientRequest, targetMemoryAccessList);
                    }
                } else {
                    this.updateView(0, clientRequest, targetMemoryAccessList);
                }
                if (targetMemoryAccessList.size() == 0) {
                    clientRequest.setRequestStatus(EnumMemoryRequestStates.REQUEST_ALREADY_IN_CACHE);
                    msg = "All memory addresses for the request have already been read and are available in the Memory Server Cache. ";
                    strErrorInfo[0] = strErrorInfo[0] + msg;
                    if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                        MemoryServerTrace.logInfo(msg + "  About to call NotifyClient()", "MemoryPageHandler.requestMemoryRead", this.target.info);
                    }
                    if (clientRequest.getRequestQueue() != null) {
                        clientRequest.getRequestQueue().deleteRequest(clientRequest, false);
                    }
                    clientRequest.notifyClient();
                    clientRequest.release();
                } else if (this.target.isDisconnected()) {
                    clientRequest.setRequestStatus(EnumMemoryRequestStates.REQUEST_ALREADY_IN_CACHE);
                    msg = "Target Disconnected.  Use data available in the Memory Server Cache. ";
                    strErrorInfo[0] = strErrorInfo[0] + msg;
                    if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                        MemoryServerTrace.logInfo(msg + " About to call NotifyClient()", "MemoryPageHandler.requestMemoryRead", this.target.info);
                    }
                    clientRequest.getRequestQueue().deleteRequest(clientRequest, false);
                    clientRequest.notifyClient();
                    clientRequest.release();
                } else {
                    IMemoryRegion lastRegionToBeRead = (IMemoryRegion)targetMemoryAccessList.get(targetMemoryAccessList.size() - 1);
                    lastRegionToBeRead.getOnMemoryRegionReadCompleteEvent().addListener(this);
                    lastRegionToBeRead.getOriginalClientRequestList().add(clientRequest);
                    if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                        if (clientRequest.getLengthInMAUs() > 1L || lastRegionToBeRead.getOriginalClientRequestList().size() == 1) {
                            for (int i = 0; i < targetMemoryAccessList.size(); ++i) {
                                AdrsRegion adrsRegion = (AdrsRegion)targetMemoryAccessList.get(i);
                                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.VERBOSE)) {
                                    MemoryServerTrace.logVerbose("OriginalClientRequestList.size() = " + Integer.toString(adrsRegion.getOriginalClientRequestList().size()) + " for " + adrsRegion.toString(), "MemoryPageHandler.requestMemoryRead", this.target.info);
                                }
                                for (int j = 0; j < adrsRegion.getOriginalClientRequestList().size(); ++j) {
                                    RequestDescriptorBaseClass rq = adrsRegion.getOriginalClientRequestList().get(j);
                                    MemoryRequestDescriptor reqDesc = (MemoryRequestDescriptor)rq;
                                    if (reqDesc.getClientToNotifyOnRequestComplete() == null) continue;
                                    if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.VERBOSE)) {
                                        MemoryServerTrace.logVerbose("NotifyClient calls " + reqDesc.getClientToNotifyOnRequestComplete().toString(), "MemoryPageHandler.requestMemoryRead", this.target.info);
                                    }
                                    if (!(clientRequest.getClientToNotifyOnRequestComplete() instanceof AdrsRegion)) continue;
                                    MemoryServerTrace.logError("ReqID: " + clientRequest.getRequestIdStr() + ": ClientToNotifyOnRequestComplete is AdrsRegion Object [" + clientRequest.getClientToNotifyOnRequestComplete().toString(), "MemoryPageHandler.requestMemoryRead", this.target.info);
                                }
                            }
                        }
                        MemoryServerTrace.logInfo("ReqID: " + clientRequest.getRequestIdStr() + ": " + Integer.toString(targetMemoryAccessList.size()) + " address regions will be read from target. " + Integer.toString(lastRegionToBeRead.getOriginalClientRequestList().size()) + " clients will be notified", "MemoryPageHandler.requestMemoryRead", this.target.info);
                        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.VERBOSE)) {
                            int regionNum = 0;
                            for (int k = 0; k < targetMemoryAccessList.size(); ++k) {
                                AdrsRegion region = (AdrsRegion)targetMemoryAccessList.get(k);
                                MemoryServerTrace.logVerbose("Region " + Integer.toString(regionNum) + ": " + region.toString(), "MemoryPageHandler.requestMemoryRead", this.target.info);
                            }
                        }
                    }
                    for (int m = 0; m < targetMemoryAccessList.size(); ++m) {
                        String msg2;
                        AdrsRegion adrsRegion = (AdrsRegion)targetMemoryAccessList.get(m);
                        if (adrsRegion.getStartAdrs() != adrsRegion.getStartAddressOfLineContainingAdrs(adrsRegion.getStartAdrs())) {
                            msg2 = " Start of Address region not aligned with start of cache line(adrs = 0x" + Long.toHexString(adrsRegion.getStartAdrs()) + "). ";
                            strErrorInfo[0] = strErrorInfo[0] + msg2;
                            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                                MemoryServerTrace.logError(msg2, "MemoryPageHandler.requestMemoryRead", this.target.info);
                            }
                        }
                        if (adrsRegion.getEndAdrs() != adrsRegion.getEndAddressOfLineContainingAdrs(adrsRegion.getEndAdrs())) {
                            msg2 = "End of Address region not aligned with end of cache line (adrs = 0x" + Long.toHexString(adrsRegion.getEndAdrs()) + "). ";
                            strErrorInfo[0] = strErrorInfo[0] + msg2;
                            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                                MemoryServerTrace.logError(msg2, "MemoryPageHandler.requestMemoryRead", this.target.info);
                            }
                        }
                        if (!adrsRegion.getStatus().equals(EnumSet.of(EnumMemoryRegionStatus.MEMORY_REQUEST_PENDING))) {
                            viewIndex = this.getMemoryHierarchy().getMemoryViewIndex(adrsRegion.getMemoryLevelEnableFlags());
                            msCache = this.getMemoryViewList(clientRequest.getMemoryView()).getCache(viewIndex);
                            if (msCache != null) {
                                if (MemoryServer.TRACE__MEMORY_SERVER) {
                                    System.out.println("Memory Server: adrsRegion.requestInfoFromTarget() start @ " + System.currentTimeMillis() + " ms");
                                }
                                adrsRegion.requestInfoFromTarget();
                                continue;
                            }
                            adrsRegion.release();
                            msg2 = " AdrsRegion does not belong to a valid memory view. ";
                            strErrorInfo[0] = strErrorInfo[0] + msg2;
                            if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) continue;
                            MemoryServerTrace.logError(msg2, "MemoryPageHandler.requestMemoryRead", this.target.info);
                            continue;
                        }
                        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                            MemoryServerTrace.logInfo("AdrsRegion.RequestInfoFromTarget not called - request already pending (" + adrsRegion.toString() + ")", "MemoryPageHandler.requestMemoryRead", this.target.info);
                        }
                        if (adrsRegion.getOriginalClientRequestList().contains(clientRequest)) continue;
                        adrsRegion.getOriginalClientRequestList().add(clientRequest);
                        if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) continue;
                        MemoryServerTrace.logInfo("...Added clientRequest to AdrsRegion.originalClientRequestList (size = " + adrsRegion.getOriginalClientRequestList().size(), "MemoryPageHandler.requestMemoryRead", this.target.info);
                    }
                }
                result = true;
            }
            catch (Exception ex) {
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                    String msg = "MemoryPageHander.requestMemoryRead Exception while handling request: " + clientRequest.toString() + ". ";
                    strErrorInfo[0] = strErrorInfo[0] + msg;
                    MemoryServerTrace.logException(msg, "MemoryPageHandler.RequestMemoryRead", ex, this.target.info);
                }
            }
        } else {
            result = false;
            String msg = "Error: invalid viewIndex (" + Integer.toString(viewIndex) + "). ";
            strErrorInfo[0] = strErrorInfo[0] + msg;
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                MemoryServerTrace.logError(msg, "MemoryPageHandler.RequestMemoryRead", this.target.info);
            }
        }
        return result;
    }

    public synchronized boolean requestCExprEval(CExprRequestDescriptor clientRequest) {
        boolean result = false;
        int viewIndex = this.getMemoryHierarchy().getMemoryViewIndex(clientRequest.getTargetMemoryLevelEnableFlags());
        AdrsMap msCache = this.getMemoryViewList(clientRequest.getMemoryView()).getCache(viewIndex);
        if (msCache != null) {
            try {
                CExprRequestDescriptor targetRequest = (CExprRequestDescriptor)this.getCExprEvalRequestQueue().getRequestDescriptorFactory().createInstance();
                this.getCExprEvalRequestQueue().addRequest(targetRequest);
                targetRequest.config(this, this, clientRequest);
                targetRequest.requestInfoFromTarget();
                result = true;
            }
            catch (Exception ex) {
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                    MemoryServerTrace.logException("Exception while handling request: " + clientRequest.toString() + "\n", "MemoryPageHandler.RequestCExprEval", ex, this.target.info);
                }
            }
        } else {
            result = false;
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                MemoryServerTrace.logError("doRequest error: invalid viewIndex (" + Integer.toString(viewIndex) + ")", "MemoryPageHandler.RequestCExprEval", this.target.info);
            }
        }
        return result;
    }

    public String readMemory_String(long adrs, MemoryRequestDescriptor req, long[] nextAdrs, EnumGtiMemResult[] memAccessErrorCode) {
        String[] rmResult = new String[]{""};
        int viewIndex = 0;
        memAccessErrorCode[0] = EnumGtiMemResult.MEM_ACCESS_OK;
        nextAdrs[0] = this.target.info.getNextAdrs(adrs, this.getNumMAUsPerMemoryItem(req), this.memoryPageNumber);
        if (req.getTargetMemoryLevelEnableFlags() != this.getMemoryHierarchy().getMemoryLevelEnableFlags_DefaultLevels() && req.getTargetMemoryLevelEnableFlags() != 0) {
            for (viewIndex = 1; viewIndex < this.memoryHierarchy.getListOfMemoryViews().size() && !this.readMemory(adrs, req, viewIndex, nextAdrs, rmResult, memAccessErrorCode); ++viewIndex) {
            }
        } else {
            this.readMemory(adrs, req, viewIndex, nextAdrs, rmResult, memAccessErrorCode);
        }
        return rmResult[0];
    }

    public int readMemory_Strings(List<IDspMemory.IMemoryValue> memValues, long adrs, MemoryRequestDescriptor req) {
        int viewIndex = 0;
        int[] result = new int[1];
        if (req.getTargetMemoryLevelEnableFlags() != this.getMemoryHierarchy().getMemoryLevelEnableFlags_DefaultLevels() && req.getTargetMemoryLevelEnableFlags() != 0) {
            for (viewIndex = 1; viewIndex < this.memoryHierarchy.getListOfMemoryViews().size() && !this.readMemory(memValues, adrs, req, viewIndex, result); ++viewIndex) {
            }
        } else {
            this.readMemory(memValues, adrs, req, viewIndex, result);
        }
        return result[0];
    }

    public boolean readMemoryView_String(long adrs, MemoryRequestDescriptor req, int viewIndex, String[] strValue, long[] nextAdrs, EnumGtiMemResult[] memAccessErrorCode) {
        return this.readMemory(adrs, req, viewIndex, nextAdrs, strValue, memAccessErrorCode);
    }

    private boolean readMemory(long adrs, MemoryRequestDescriptor req, int viewIndex, long[] nextAdrs, String[] StringValue, EnumGtiMemResult[] memAccessErrorCode) {
        AdrsMap viewCache;
        AdrsRegion viewTargetMemory;
        int memLevelHitCode = 0;
        memAccessErrorCode[0] = EnumGtiMemResult.MEM_ACCESS_NOT_ATTEMPTED;
        MemoryRWHandler memRWHandler = null;
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.VERBOSE)) {
            MemoryServerTrace.logVerbose("[... adrs=0x" + Long.toHexString(adrs), "MemoryPageHandler.readMemory_DataAndString", this.target.info);
        }
        boolean found = false;
        int originalRequestMemoryEnableFlags = req.getTargetMemoryLevelEnableFlags();
        MemoryTypeDescriptor viewMemType = this.getMemoryHierarchy().getListOfMemoryViews().get(viewIndex);
        boolean isMemoryLevelCacheEnabled = this.getMemoryHierarchy().isMemoryLevelCacheEnabled(req.getTargetMemoryLevelEnableFlags(), viewIndex);
        memRWHandler = this.getMemoryRWHandler();
        StringValue[0] = !this.target.isDisconnected() ? this.getSpecialDataString(req, EnumSpecialDisplayStrings.MEMORY_DOES_NOT_EXIST) : this.getSpecialDataString(req, EnumSpecialDisplayStrings.NO_DATA_AVAILABLE);
        req.setTargetMemoryLevelEnableFlags(viewMemType.getMemoryLevelEnableFlags());
        nextAdrs[0] = this.target.info.getNextAdrs(adrs, this.getNumMAUsPerMemoryItem(req), this.memoryPageNumber);
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO) && adrs == req.getStartAdrs()) {
            MemoryServerTrace.logInfo("readMemory_String: " + req.toString(), "MemoryPageHandler.readMemory_DataAndString", this.target.info);
        }
        if ((viewTargetMemory = (AdrsRegion)(viewCache = this.getMemoryViewList(req.getMemoryView()).getCache(viewIndex)).findAdrsRegionContainingAdrs(adrs)) != null) {
            memRWHandler.config(req);
            memLevelHitCode = memRWHandler.getGtiMemoryHierarchyHitCode(adrs, viewTargetMemory);
            if (viewIndex == 0 || !viewMemType.isExternalMemory() && (memLevelHitCode & viewMemType.getGtiMemHierarchyReadEnableFlags()) != 0 || viewMemType.isExternalMemory() && memLevelHitCode == this.getMemoryHierarchy().getGtiHitCodeForExternalMemory()) {
                boolean okToReadData = true;
                if (!isMemoryLevelCacheEnabled && !viewMemType.isExternalMemory() && viewMemType.getGtiMemHierarchyReadEnableFlags() != 0) {
                    okToReadData = false;
                    for (MemoryTypeDescriptor memType : viewMemType.getListOfAssociatedMemTypes()) {
                        if (memType.isCache() || (memType.getGtiMemHierarchyReadEnableFlags() & memLevelHitCode) == 0) continue;
                        okToReadData = true;
                        break;
                    }
                }
                if (okToReadData) {
                    StringValue[0] = memRWHandler.getString(adrs, viewTargetMemory, nextAdrs, memAccessErrorCode);
                    found = true;
                }
            }
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.VERBOSE) && adrs >= MemoryServerTrace.verboseTraceMinAdrs && adrs <= MemoryServerTrace.verboseTraceMaxAdrs) {
                MemoryServerTrace.logVerbose(Long.toHexString(adrs) + ": ViewIndex =" + Integer.toString(viewIndex) + " StringValue = " + StringValue + " memAccessErrorCode = " + (Object)((Object)memAccessErrorCode[0]) + " viewMemType.IsExternalMemory=" + Boolean.toString(viewMemType.isExternalMemory()) + " memLevelHitCode=0x" + Long.toHexString(memLevelHitCode) + " viewMemType.GtiMemHierarchyReadEnableFlags=0x" + Long.toHexString(viewMemType.getGtiMemHierarchyReadEnableFlags()), "MemoryPageHandler.readMemory_DataAndString", this.target.info);
            }
            req.setTargetMemoryLevelEnableFlags(originalRequestMemoryEnableFlags);
            if (memRWHandler != null) {
                memRWHandler.release();
            }
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.VERBOSE)) {
                MemoryServerTrace.logVerbose("...]", "MemoryPageHandler.readMemory_DataAndString", this.target.info);
            }
        }
        return found;
    }

    boolean readMemory(List<IDspMemory.IMemoryValue> memValues, long adrs, MemoryRequestDescriptor req, int viewIndex, int[] memAccessErrorCode) {
        AdrsMap viewCache;
        AdrsRegion viewTargetMemory;
        MemoryRWHandler memRWHandler = null;
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.VERBOSE)) {
            MemoryServerTrace.logVerbose("[... adrs=0x" + Long.toHexString(adrs), "MemoryPageHandler.readMemory_DataAndString", this.target.info);
        }
        int result = 0;
        int originalRequestMemoryEnableFlags = req.getTargetMemoryLevelEnableFlags();
        MemoryTypeDescriptor viewMemType = this.getMemoryHierarchy().getListOfMemoryViews().get(viewIndex);
        memRWHandler = this.getMemoryRWHandler();
        req.setTargetMemoryLevelEnableFlags(viewMemType.getMemoryLevelEnableFlags());
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO) && adrs == req.getStartAdrs()) {
            MemoryServerTrace.logInfo("readMemory_String: " + req.toString(), "MemoryPageHandler.readMemory_DataAndString", this.target.info);
        }
        if ((viewTargetMemory = (AdrsRegion)(viewCache = this.getMemoryViewList(req.getMemoryView()).getCache(viewIndex)).findAdrsRegionContainingAdrs(adrs)) != null) {
            memRWHandler.config(req);
            int memLevelHitCode = memRWHandler.getGtiMemoryHierarchyHitCode(adrs, viewTargetMemory);
            boolean isMemoryLevelCacheEnabled = this.getMemoryHierarchy().isMemoryLevelCacheEnabled(req.getTargetMemoryLevelEnableFlags(), viewIndex);
            boolean okToReadData = true;
            if ((viewIndex == 0 || !viewMemType.isExternalMemory() && (memLevelHitCode & viewMemType.getGtiMemHierarchyReadEnableFlags()) != 0 || viewMemType.isExternalMemory() && memLevelHitCode == this.getMemoryHierarchy().getGtiHitCodeForExternalMemory()) && !isMemoryLevelCacheEnabled && !viewMemType.isExternalMemory() && viewMemType.getGtiMemHierarchyReadEnableFlags() != 0) {
                okToReadData = false;
                for (MemoryTypeDescriptor memType : viewMemType.getListOfAssociatedMemTypes()) {
                    if (memType.isCache() || (memType.getGtiMemHierarchyReadEnableFlags() & memLevelHitCode) == 0) continue;
                    okToReadData = true;
                    break;
                }
            }
            if (!okToReadData) {
                return false;
            }
            int currentReadBeginIdnex = 0;
            int currentReadEndIndex = 0;
            do {
                long currentReadEndAdrs = req.getEndAdrs() > viewTargetMemory.getEndAdrs() ? viewTargetMemory.getEndAdrs() : req.getEndAdrs();
                long lengthInMaus = this.target.info.getNumMausInAddressRange(adrs, currentReadEndAdrs, memRWHandler.getMemoryPageNumber());
                currentReadEndIndex = (int)(lengthInMaus / (long)memRWHandler.getActualNumMAUsPerMemoryItem() + (long)currentReadBeginIdnex);
                List<IDspMemory.IMemoryValue> subList = memValues.subList(currentReadBeginIdnex, currentReadEndIndex);
                int intermediateResult = memRWHandler.getStrings(subList, adrs, lengthInMaus, viewTargetMemory);
                currentReadBeginIdnex = currentReadEndIndex;
                if (intermediateResult != 0) {
                    result = intermediateResult;
                }
                adrs = memRWHandler.getNextAdrs(viewTargetMemory.getEndAdrs());
                viewTargetMemory = (AdrsRegion)viewCache.findAdrsRegionContainingAdrs(adrs);
            } while (req.getEndAdrs() > adrs);
        }
        req.setTargetMemoryLevelEnableFlags(originalRequestMemoryEnableFlags);
        if (memRWHandler != null) {
            memRWHandler.release();
        }
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.VERBOSE)) {
            MemoryServerTrace.logVerbose("...]", "MemoryPageHandler.readMemory_DataAndString", this.target.info);
        }
        memAccessErrorCode[0] = result;
        return true;
    }

    public AdrsRegion getAdrsRegion(long adrs, MemoryRequestDescriptor req, int viewIndex) {
        AdrsRegion result = null;
        AdrsMap viewCache = this.getMemoryViewList(req.getMemoryView()).getCache(viewIndex);
        result = (AdrsRegion)viewCache.findAdrsRegionContainingAdrs(adrs);
        return result;
    }

    public int readMemory_HierarchyInfo(long adrs, MemoryRequestDescriptor req, long[] nextAdrs) {
        int result = 0;
        int adrsIncr = 0;
        int gtiHitCode = 0;
        int viewIndex = 0;
        MemoryRWHandler memRWHandler = this.getMemoryRWHandler();
        nextAdrs[0] = this.target.info.getNextAdrs(adrs, this.getNumMAUsPerMemoryItem(req), this.memoryPageNumber);
        AdrsMap view0Cache = this.getMemoryViewList(req.getMemoryView()).getCache(0);
        if (view0Cache != null) {
            AdrsRegion targetMemory = (AdrsRegion)view0Cache.findAdrsRegionContainingAdrs(adrs);
            if (targetMemory != null) {
                try {
                    memRWHandler.config(req);
                    adrsIncr = memRWHandler.getNumMAUsPerMemoryItem();
                    nextAdrs[0] = this.target.info.getNextAdrs(adrs, adrsIncr, this.memoryPageNumber);
                    result = gtiHitCode = memRWHandler.getGtiMemoryHierarchyHitCode(adrs, targetMemory);
                }
                catch (Exception e) {
                    if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                        MemoryServerTrace.logException("Exception :" + e.getMessage(), "MemoryPageHandler.readMemory_HierarchyInfo", e, this.target.info);
                    }
                }
            } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.VERBOSE) && adrs >= MemoryServerTrace.verboseTraceMinAdrs && adrs <= MemoryServerTrace.verboseTraceMaxAdrs) {
                MemoryServerTrace.logVerbose(Long.toHexString(adrs) + " - not in cache", "MemoryPageHandler.readMemory_HierarchyInfo", this.target.info);
            }
            CacheList cacheList = this.getMemoryViewList(req.getMemoryView());
            for (int i = 1; i < cacheList.size(); ++i) {
                AdrsMap cache = cacheList.get(i);
                targetMemory = (AdrsRegion)cache.findAdrsRegionContainingAdrs(adrs);
                if (targetMemory == null) continue;
                try {
                    memRWHandler.config(req);
                    gtiHitCode = memRWHandler.getGtiMemoryHierarchyHitCode(adrs, targetMemory);
                    if (gtiHitCode == 0) continue;
                    result |= gtiHitCode;
                    continue;
                }
                catch (Exception e) {
                    if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) continue;
                    MemoryServerTrace.logException("Exception :" + e.getMessage(), "MemoryPageHandler.readMemory_HierarchyInfo", e, this.target.info);
                }
            }
        } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
            MemoryServerTrace.logError("ReadMemory_Data error: invalid viewIndex (" + Integer.toString(viewIndex) + ")", "MemoryPageHandler.readMemory_HierarchyInfo", this.target.info);
        }
        if (memRWHandler != null) {
            memRWHandler.release();
        }
        return result;
    }

    private boolean updateView(int viewIndex, MemoryRequestDescriptor memRdRequest, ArrayList targetMemoryAccessList) {
        AdrsMap msCache = this.getMemoryViewList(memRdRequest.getMemoryView()).getCache(viewIndex);
        boolean result = this.updateMemoryServerCache(msCache, memRdRequest, targetMemoryAccessList);
        return result;
    }

    private boolean updateMemoryServerCache(AdrsMap msCache, MemoryRequestDescriptor memRdRequest, ArrayList<IMemoryRegion> targetMemoryAccessList) {
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
            MemoryServerTrace.logInfo("(msCache = " + msCache.getMemoryTypeDescriptor().getName() + ", targetMemoryAccessList.size() = " + Integer.toString(targetMemoryAccessList.size()) + ")", "MemoryPageHandler.updateMemoryServerCache", this.target.info);
        }
        boolean result = false;
        ArrayList<IMemoryRegion> regionList = new ArrayList<IMemoryRegion>();
        try {
            long readableStartAdrs = memRdRequest.getStartAdrs();
            long readableEndAdrs = memRdRequest.getEndAdrs();
            long readableNumMaus = this.target.info.getNumMausInAddressRange(readableStartAdrs, readableEndAdrs, this.getMemoryPageNumber());
            msCache.getListOfRegionsInAddressRange(readableStartAdrs, readableNumMaus, regionList, EnumSet.of(EnumMemoryRegionStatus.CONFIGURED, EnumMemoryRegionStatus.MEMORY_REQUEST_PENDING, EnumMemoryRegionStatus.MEMORY_REQUEST_FAILED));
            for (IMemoryRegion region : regionList) {
                for (EnumMemoryRegionStatus regionStatus : region.getStatus()) {
                    switch (regionStatus) {
                        case ABORT_PENDING: 
                        case MEMORY_REQUEST_FAILED: {
                            msCache.removeRegion(region);
                            region.release();
                            break;
                        }
                        case MEMORY_REQUEST_PENDING: {
                            if (targetMemoryAccessList.contains(region)) break;
                            targetMemoryAccessList.add(region);
                        }
                    }
                }
            }
            regionList.clear();
            msCache.getListOfHolesInMap(readableStartAdrs, readableEndAdrs, memRdRequest.getMemoryView(), regionList);
            if (regionList.size() != 0) {
                for (IMemoryRegion region : regionList) {
                    if (targetMemoryAccessList.contains(region)) continue;
                    targetMemoryAccessList.add(region);
                    msCache.addRegion(region);
                }
                regionList.clear();
            }
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.VERBOSE) && memRdRequest.getStartAdrs() <= MemoryServerTrace.verboseTraceMaxAdrs && memRdRequest.getEndAdrs() >= MemoryServerTrace.verboseTraceMinAdrs) {
                MemoryServerTrace.logVerbose("Cache to be updated: TargetMemoryAccessList.size() = " + Integer.toString(targetMemoryAccessList.size()) + "for requested adrs range 0x" + Long.toHexString(memRdRequest.getStartAdrs()) + " - 0x" + Long.toHexString(memRdRequest.getEndAdrs()), "MemoryPageHandler.UpdateMemoryServerCache", this.target.info);
            }
            result = true;
        }
        catch (Exception ex) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                MemoryServerTrace.logException("UpdateView Exception while handling request: " + memRdRequest.toString(), "MemoryPageHandler.updateView", ex, this.target.info);
            }
            result = false;
        }
        return result;
    }

    public void discardMemoryRequest(MemoryRequestDescriptor request) {
        int viewIndex = this.getMemoryHierarchy().getMemoryViewIndex(request.getTargetMemoryLevelEnableFlags());
        AdrsMap msCache = this.getMemoryViewList(request.getMemoryView()).getCache(viewIndex);
        if (msCache != null) {
            msCache.discardRequest(request);
        }
    }

    @Override
    public void onMemoryRequestCompleteHandler(MemoryRequestDescriptor req, long requestStartAdrs, long requestLengthInMAUs) {
        long startAddress = 0L;
        if (req.getRequestType() == EnumMemoryRequestTypes.WRITE) {
            if (req.getClientTagObject() instanceof MemoryRequestDescriptor) {
                MemoryRequestDescriptor clientReq = (MemoryRequestDescriptor)req.getClientTagObject();
                req.MoveEvaluationResult(clientReq);
                startAddress = clientReq.getStartAdrs();
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                    MemoryServerTrace.logInfo("Memory Write Request " + req.getRequestIdStr() + " Complete. About to call " + clientReq.getRequestIdStr() + " NotifyClient()", "MemoryPageHandler.OnCcsMemoryRequestCompleteHandler", this.target.info);
                }
                clientReq.getRequestQueue().deleteRequest(clientReq, false);
                clientReq.notifyClient();
                clientReq.release();
            }
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                MemoryServerTrace.logInfo("startAdrs=" + Long.toHexString(startAddress), "MemoryPageHandler.OnCcsMemoryRequestCompleteHandler", this.target.info);
            }
        }
    }

    @Override
    public void onCExpressionEvaluationCompleteHandler(CExprRequestDescriptor cExprEvalRequestDescriptor) {
        boolean valid = false;
        CExprRequestDescriptor req = cExprEvalRequestDescriptor;
        if (cExprEvalRequestDescriptor instanceof CExprRequestDescriptor && req.getClientTagObject() != null && req.getClientTagObject() instanceof CExprRequestDescriptor) {
            CExprRequestDescriptor clientRequest = (CExprRequestDescriptor)req.getClientTagObject();
            req.moveEvaluationResult(clientRequest);
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                MemoryServerTrace.logInfo("CExprEval RequestID " + req.getRequestIdStr() + "  Complete. About to call " + clientRequest.getRequestIdStr() + " NotifyClient()", "MemoryPageHandler.OnCcsCExpressionEvaluationCompleteHandler", this.target.info);
            }
            clientRequest.getRequestQueue().deleteRequest(clientRequest, false);
            if (clientRequest.getErrorCode() == 0) {
                clientRequest.setRequestStatus(EnumMemoryRequestStates.REQUEST_COMPLETE);
            } else {
                clientRequest.setRequestStatus(EnumMemoryRequestStates.REQUEST_FAILED);
            }
            clientRequest.notifyClient();
            clientRequest.release();
            valid = true;
        }
        if (!valid && MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
            MemoryServerTrace.logError("invalid request parameter", "MemoryPageHandler.onCExpressionEvaluationCompleteHandler", this.target.info);
        }
    }

    @Override
    public void handleMemoryRegionReadCompleteEvent(EventObject sender, EventArgs e) {
        block33: {
            AdrsRegion adrsRegion = (AdrsRegion)sender.getSource();
            adrsRegion.getOnMemoryRegionReadCompleteEvent().removeListener(this);
            MemoryRequestDescriptor targetAccessReq = adrsRegion.getTargetAccessRequestDescriptor();
            ArrayList<RequestDescriptorBaseClass> listOfRequests = new ArrayList<RequestDescriptorBaseClass>();
            EnumSet<EnumMemoryRegionStatus> memoryRegionStatus = adrsRegion.getStatus();
            long startAdrs = adrsRegion.getStartAdrs();
            boolean found = true;
            boolean cacheFlushRequired = false;
            try {
                if (adrsRegion != null) {
                    if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                        String strTrace = "memObj.StartAdrs = 0x" + Long.toHexString(adrsRegion.getStartAdrs()) + ", OriginalClientRequestList.size() = " + Integer.toString(adrsRegion.getOriginalClientRequestList().size());
                        MemoryServerTrace.logInfo(strTrace, "MemoryPageHandler.handleMemoryReadCompleteEvent", this.target.info);
                    }
                    if (adrsRegion.getOriginalClientRequestList().size() > 0) {
                        EnumMemoryViews requestedMemoryView = adrsRegion.getOriginalClientRequestList().get(0).getMemoryView();
                        for (RequestDescriptorBaseClass req : adrsRegion.getOriginalClientRequestList()) {
                            listOfRequests.add(req);
                        }
                        adrsRegion.getOriginalClientRequestList().clear();
                        CacheList cacheList = this.getMemoryViewList(requestedMemoryView);
                        for (int viewIndex = 0; viewIndex < cacheList.size(); ++viewIndex) {
                            AdrsMap cacheMap = cacheList.get(viewIndex);
                            found = cacheMap.contains(adrsRegion);
                            cacheMap.defragmentMap();
                            if (!found) continue;
                            adrsRegion = (AdrsRegion)cacheMap.findAdrsRegionContainingAdrs(startAdrs);
                        }
                        for (RequestDescriptorBaseClass req : listOfRequests) {
                            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                                MemoryServerTrace.logInfo("memObj.getStatus() = " + memoryRegionStatus.toString() + ",OriginalClientRequestList req : " + req.toString(), "MemoryPageHandler.handleMemoryReadCompleteEvent", this.target.info);
                            }
                            req.getErrorInfoString();
                            String reqInfo = "";
                            for (EnumMemoryRegionStatus status : memoryRegionStatus) {
                                if (req instanceof MemoryRequestDescriptor) {
                                    long addOffset = ((MemoryRequestDescriptor)req).getStartAdrs() - adrsRegion.getStartAdrs();
                                    reqInfo = adrsRegion.getErrorString(addOffset);
                                } else if (req instanceof CExprRequestDescriptor) {
                                    CExprRequestDescriptor cExprReq = (CExprRequestDescriptor)req;
                                    reqInfo = "[C Expression " + cExprReq.getStrCExpression() + "]";
                                } else if (req instanceof RegisterRequestDescriptor) {
                                    RegisterRequestDescriptor regReq = (RegisterRequestDescriptor)req;
                                    reqInfo = "[Register name=" + regReq.getNameOfRegister() + ", Id=0x" + Long.toHexString(regReq.getIdOfRegister()) + ", Adrs=0x" + Long.toHexString(regReq.getStartAdrs()) + "]";
                                }
                                switch (status) {
                                    case READY_FOR_USE: {
                                        req.setErrorCode(EnumMemoryServerErrorCodes.OK);
                                        req.setRequestStatus(EnumMemoryRequestStates.REQUEST_COMPLETE);
                                        req.setErrorInfoString("OK - Request Complete " + reqInfo);
                                        break;
                                    }
                                    case ABORT_PENDING: {
                                        req.setRequestStatus(EnumMemoryRequestStates.REQUEST_ABORTED);
                                        req.setErrorCode(EnumMemoryServerErrorCodes.MEMORY_WRITE_COLLISION_WITH_PENDING_MEMORY_READ_ABORTED);
                                        req.setErrorInfoString(reqInfo);
                                        break;
                                    }
                                    case MEMORY_REQUEST_FAILED: {
                                        req.setErrorCode(EnumMemoryServerErrorCodes.REQUESTED_ACTION_FAILED);
                                        req.setRequestStatus(EnumMemoryRequestStates.REQUEST_FAILED);
                                        req.setErrorInfoString(reqInfo);
                                        break;
                                    }
                                    default: {
                                        req.setRequestStatus(EnumMemoryRequestStates.REQUEST_FAILED);
                                        req.setErrorCode(EnumMemoryServerErrorCodes.TARGET_MEMORY_REGION_OBJECT_IN_UNEXPECTED_STATE);
                                        req.setErrorInfoString(reqInfo);
                                    }
                                }
                                if (memoryRegionStatus.equals(EnumSet.of(EnumMemoryRegionStatus.READY_FOR_USE)) || !MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.WARNINGS)) continue;
                                MemoryServerTrace.logWarning(req.getErrorInfoString(), "MemoryPageHandler.handleMemoryReadCompleteEvent", this.target.info);
                            }
                            if (targetAccessReq != null) {
                                ((MemoryRequestDescriptor)req).setMemoryUpdateInfo(targetAccessReq.getMemoryUpdateInfo());
                                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                                    MemoryServerTrace.logInfo("Memory Read Complete. About to call NotifyClient()", "MemoryPageHandler.handleMemoryReadCompleteEvent", this.target.info);
                                }
                            } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                                MemoryServerTrace.logError("targetAccessReq == null. Could not set Memory Update Info", "MemoryPageHandler.handleMemoryReadCompleteEvent", this.target.info);
                            }
                            if (req.getRequestQueue() != null) {
                                req.getRequestQueue().deleteRequest(req, false);
                            } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                                MemoryServerTrace.logError("RequestDescriptor.getRequesQueue() = null. req.getErrorCode()=" + req.getErrorCode() + ", errorInfo=" + req.getErrorInfoString() + ", req: " + req.toString(), "MemoryPageHandler.handleMemoryReadCompleteEvent", this.target.info);
                            }
                            req.notifyClient();
                            if (req instanceof MemoryRequestDescriptor && this.target.isRunning()) {
                                cacheFlushRequired = true;
                            }
                            req.release();
                        }
                        listOfRequests.clear();
                        if (cacheFlushRequired && this.getTargetAccessRequestQueue().size() == 0) {
                            this.flushServerCache();
                        }
                    } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                        String infoMsg = "adrsRegion.getOriginalClientRequestList().size() == 0";
                        if (adrsRegion != null) {
                            infoMsg = infoMsg + "(AddressRegion.StartAdrs = 0x" + Long.toHexString(adrsRegion.getStartAdrs()) + ", EndAdrs = 0x" + Long.toHexString(adrsRegion.getEndAdrs()) + ")";
                        }
                        MemoryServerTrace.logInfo(infoMsg, "MemoryPageHandler.handleMemoryReadCompleteEvent", this.target.info);
                    }
                }
            }
            catch (Exception ex) {
                if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block33;
                String errorMsg = "Error handling OnMemoryReadComplete event ";
                if (adrsRegion != null) {
                    errorMsg = errorMsg + "(AddressRegion.StartAdrs = 0x" + Long.toHexString(adrsRegion.getStartAdrs()) + ", EndAdrs = 0x" + Long.toHexString(adrsRegion.getEndAdrs()) + ")";
                }
                MemoryServerTrace.logException(errorMsg, "MemoryPageHandler.handleMemoryReadCompleteEvent", ex, this.target.info);
            }
        }
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public synchronized void dispose() {
        if (!this.disposed) {
            try {
                if (this.memoryMapRegionFactory != null && !this.memoryMapRegionFactory.isDisposed()) {
                    this.memoryMapRegionFactory.dispose();
                }
                this.memoryMapRegionFactory = null;
                if (this.targetMemoryRegionFactory != null && !this.targetMemoryRegionFactory.isDisposed()) {
                    this.targetMemoryRegionFactory.dispose();
                }
                this.targetMemoryRegionFactory = null;
                if (this.memoryRWHandlerFactory != null && !this.memoryRWHandlerFactory.isDisposed()) {
                    this.memoryRWHandlerFactory.dispose();
                }
                this.memoryRWHandlerFactory = null;
                if (this.memoryMapHandler != null && !this.memoryMapHandler.isDisposed()) {
                    this.memoryMapHandler.dispose();
                }
                this.memoryMapHandler = null;
                if (this.memoryHierarchy != null && !this.memoryHierarchy.isDisposed()) {
                    this.memoryHierarchy.dispose();
                }
                this.memoryHierarchy = null;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        this.disposed = true;
    }

    public boolean isDeviceDescriptionChanged() {
        return this.memoryHierarchy == null ? true : this.memoryHierarchy.getXmlFileName().compareTo(this.target.info.getXmlDeviceDescriptionFileName()) != 0;
    }
}

