/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver;

import com.ti.ccstudio.debug.memoryserver.RequestDspValue;
import com.ti.ccstudio.debug.memoryserver.enums.EnumGtiMemResult;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryLevelIndex;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryServerErrorCodes;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryViews;
import com.ti.ccstudio.debug.memoryserver.enums.EnumSpecialDisplayStrings;
import com.ti.ccstudio.debug.memoryserver.interfaces.IMemoryRequestParameters;
import com.ti.ccstudio.debug.memoryserver.memoryhierarchy.MemLevelInfoHdlr;
import com.ti.ccstudio.debug.memoryserver.memoryhierarchy.MemoryTypeDescriptor;
import com.ti.ccstudio.debug.memoryserver.memoryinfoitems.IMemoryItem;
import com.ti.ccstudio.debug.memoryserver.memoryinfoitems.MemoryItem;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.MemoryRequestDescriptor;
import com.ti.ccstudio.debug.memoryserver.target.MemoryRWHandler;
import com.ti.debug.engine.IDspMemory;
import com.ti.debug.engine.IDspMemory2;
import com.ti.debug.engine.IDspTask;
import com.ti.debug.engine.IDspValue;
import com.ti.debug.engine.IMemoryAccess;
import com.ti.debug.engine.events.data.IMemoryAccessEventData;
import com.ti.debug.engine.events.types.IObjectEventListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class MemoryRead
implements IObjectEventListener<IMemoryAccessEventData> {
    private static final ExecutorService pool = Executors.newFixedThreadPool(5);
    private int memoryReadRequestsCompleted;
    private ArrayList<MemoryTypeDescriptor> listOfMemViews;
    MemoryRequestDescriptor requestDesc;
    private HashMap<MemoryTypeDescriptor, DataPair> memViewToDataMap = new HashMap();
    private boolean formattedDataRead = false;
    IMemoryRequestParameters params;
    private IDspTask dspTask;
    RequestDspValue requestDspValue;
    private int addressableUnitSizeInBytes;

    MemoryRead(long startAddress, long lengthInMaus, IMemoryRequestParameters params, MemoryRequestDescriptor requestDesc, ArrayList<MemoryTypeDescriptor> cpuListOfViews, IDspTask dspTask, MemLevelInfoHdlr memLevelInfo) {
        this.requestDesc = requestDesc;
        this.dspTask = dspTask;
        this.params = params;
        this.requestDspValue = new RequestDspValue(dspTask, params);
        this.addressableUnitSizeInBytes = this.dspTask.createDspUser().addressableDataSizeInBits(params.getPageNumber()) >> 3;
        this.initMemoryViews(params, cpuListOfViews);
        requestDesc.setReadRequest(this);
        this.createMemoryReadRequests(startAddress, lengthInMaus, params, this.dspTask, memLevelInfo);
    }

    private void initMemoryViews(IMemoryRequestParameters params, ArrayList<MemoryTypeDescriptor> cpuListOfViews) {
        if (params.getMemoryView() == EnumMemoryViews.CPU_MEMORY_VIEW) {
            this.listOfMemViews = cpuListOfViews;
        } else {
            this.listOfMemViews = new ArrayList();
            this.listOfMemViews.add(cpuListOfViews.get(0));
        }
    }

    private void createMemoryReadRequests(long startAddress, long lengthInMaus, IMemoryRequestParameters params, IDspTask dspTask, MemLevelInfoHdlr memLevelInfo) {
        IDspMemory memoryObj = null;
        IMemoryAccess access = dspTask.getMemoryAccess();
        for (MemoryTypeDescriptor memView : this.listOfMemViews) {
            memoryObj = access.createDspMemory(access.createDspValue(IDspValue.Type.UDATA64, startAddress), (int)lengthInMaus, params.getPageNumber());
            int memAccess = memLevelInfo.calculateMemAccessIdFlags(params.getMemoryView(), memView.getGtiMemHierarchyReadEnableFlags());
            memoryObj.getIDspMemory2().setMemoryAccessLevel(memAccess);
            DataPair data = new DataPair();
            data.dspMemory = memoryObj;
            this.memViewToDataMap.put(memView, data);
            access.requestMemoryRead(memoryObj, (IObjectEventListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(IMemoryAccessEventData data) {
        MemoryRead memoryRead = this;
        synchronized (memoryRead) {
            ++this.memoryReadRequestsCompleted;
            if (this.memoryReadRequestsCompleted == this.listOfMemViews.size()) {
                pool.execute(new Runnable(){

                    @Override
                    public void run() {
                        MemoryRead.this.requestDesc.notifyClient();
                    }
                });
            }
        }
    }

    public boolean isCompleted() {
        return this.memoryReadRequestsCompleted == this.listOfMemViews.size();
    }

    private void readFormatedData() {
        if (!this.formattedDataRead) {
            assert (this.isCompleted());
            for (MemoryTypeDescriptor memView : this.listOfMemViews) {
                DataPair dataPair = this.memViewToDataMap.get(memView);
                IDspMemory2 dspMemory = dataPair.dspMemory.getIDspMemory2();
                ArrayList<IDspMemory.IMemoryValue> memValuesToRead = new ArrayList<IDspMemory.IMemoryValue>();
                int length = (int)(this.requestDesc.getLengthInMAUs() / (long)this.requestDspValue.getDataSizeInMaus());
                for (int i = 0; i < length; ++i) {
                    MemoryItem memVal = new MemoryItem();
                    memValuesToRead.add(i, memVal);
                }
                dataPair.formattedData = memValuesToRead;
                dspMemory.getValues(memValuesToRead, this.requestDspValue.getDspValue(), MemoryRWHandler.convertToIDspValueFormat(this.requestDesc.getFormatStyle()), 0);
            }
            this.formattedDataRead = true;
        }
    }

    public int getViewIndex(EnumMemoryLevelIndex level) {
        int viewIndex = 0;
        boolean found = false;
        for (int i = 1; i < this.listOfMemViews.size(); ++i) {
            if (this.listOfMemViews.get(i).getMemoryLevelIndex() != level) continue;
            found = true;
            viewIndex = i;
            break;
        }
        return found ? viewIndex : 0;
    }

    public boolean populateMemoryItem(int formattedDataIndex, IMemoryItem itemToPopulate, int viewIndex, boolean readAllLevelsBelow) {
        this.readFormatedData();
        if (viewIndex == 0 || !readAllLevelsBelow) {
            return this.populateMemoryItem(itemToPopulate, this.getMemItemFromIndex(formattedDataIndex, viewIndex));
        }
        return this.populateMemoryItemFromAllLevels(itemToPopulate, formattedDataIndex, viewIndex);
    }

    private boolean populateMemoryItemFromAllLevels(IMemoryItem itemToPopulate, int formattedDataIndex, int index) {
        MemoryItem memItem;
        int levelIndex;
        boolean validDataFound = false;
        boolean noHits = true;
        for (levelIndex = index; !validDataFound && levelIndex < this.listOfMemViews.size(); ++levelIndex) {
            memItem = this.getMemItemFromIndex(formattedDataIndex, levelIndex);
            if (memItem.getGtiHitCode() == 0) continue;
            noHits = false;
            validDataFound = this.populateMemoryItem(itemToPopulate, memItem);
        }
        if (noHits) {
            for (levelIndex = this.listOfMemViews.size() - 1; levelIndex >= index; --levelIndex) {
                memItem = this.getMemItemFromIndex(formattedDataIndex, levelIndex);
                if (memItem.getGtiErrorCode() == EnumGtiMemResult.MEM_ACCESS_OK) continue;
                this.populateMemoryItem(itemToPopulate, memItem);
            }
        }
        return validDataFound;
    }

    private MemoryItem getMemItemFromIndex(int offset, int index) {
        MemoryTypeDescriptor memLevel = this.listOfMemViews.get(index);
        List<IDspMemory.IMemoryValue> formattedData = this.memViewToDataMap.get((Object)memLevel).formattedData;
        MemoryItem memItem = (MemoryItem)formattedData.get(offset);
        return memItem;
    }

    private boolean populateMemoryItem(IMemoryItem itemToPopulate, MemoryItem memItem) {
        EnumGtiMemResult gtiError = memItem.getGtiErrorCode();
        String dataValue = gtiError == EnumGtiMemResult.MEM_ACCESS_OK ? memItem.getDataValue() : this.getSpecialDataString(gtiError);
        itemToPopulate.setDataValue(dataValue);
        itemToPopulate.setErrorCode(memItem.getGtiErrorCode().ordinal());
        itemToPopulate.setErrorString(memItem.getErrorString());
        itemToPopulate.setErrorCode(EnumMemoryServerErrorCodes.fromEnumGtiMemResult(memItem.getGtiErrorCode()));
        itemToPopulate.setMemoryLevelIndex(this.actualLevelHit(memItem.getGtiHitCode()));
        return gtiError == EnumGtiMemResult.MEM_ACCESS_OK;
    }

    public List<MemoryTypeDescriptor> getListOfMemoryViews() {
        return this.listOfMemViews;
    }

    private EnumMemoryLevelIndex actualLevelHit(int gtiHitCode) {
        for (MemoryTypeDescriptor memLevelObj : this.listOfMemViews) {
            if ((memLevelObj.getGtiMemHierarchyReadEnableFlags() & gtiHitCode) == 0) continue;
            for (MemoryTypeDescriptor associatedLevel : memLevelObj.getListOfAssociatedMemTypes()) {
                if ((associatedLevel.getGtiMemHierarchyReadEnableFlags() & gtiHitCode) == 0) continue;
                return associatedLevel.getMemoryLevelIndex();
            }
        }
        return EnumMemoryLevelIndex.NONE;
    }

    public int getFormattedDataIndex(long adrs) {
        long index = (adrs - this.requestDesc.getStartAdrs()) / (long)this.requestDspValue.getDataSizeInMaus();
        return (int)index;
    }

    public long getNextAdrs(long adrs) {
        return adrs + (long)this.requestDspValue.getDataSizeInMaus();
    }

    private String getSpecialDataString(EnumSpecialDisplayStrings StringType) {
        String result = " ";
        switch (StringType) {
            case DATA_NOT_REQUESTED: {
                result = this.getUnknownDataStringForMemoryItem(".");
                break;
            }
            case NO_DATA_AVAILABLE: {
                result = this.getUnknownDataStringForMemoryItem("-");
                break;
            }
            case ERROR_READING_MEMORY: {
                result = this.getUnknownDataStringForMemoryItem("?");
                break;
            }
            case NON_EMULATABLE_SECURE_MEMORY: {
                result = this.getUnknownDataStringForMemoryItem("*");
                break;
            }
            case MEMORY_DOES_NOT_EXIST: {
                result = this.getUnknownDataStringForMemoryItem("X");
            }
        }
        return result;
    }

    private String getUnknownDataStringForMemoryItem(String nibbleString) {
        String result = "";
        String mauString = "";
        int bytesPerMau = this.addressableUnitSizeInBytes;
        while (bytesPerMau-- > 0) {
            mauString = mauString + nibbleString + nibbleString;
        }
        long numMAUs = this.requestDspValue.getDataSizeInMaus();
        while (numMAUs-- > 0L) {
            result = result + mauString;
        }
        return result;
    }

    private String getSpecialDataString(EnumGtiMemResult error) {
        EnumSpecialDisplayStrings displayStringEnum = EnumSpecialDisplayStrings.NONE;
        switch (error) {
            case MEM_ACCESS_OK: {
                displayStringEnum = EnumSpecialDisplayStrings.NONE;
                break;
            }
            case DEBUG_SERVER_ERROR_TARGET_ACCESS_FAILED: 
            case MEM_ACCESS_FAILED: {
                displayStringEnum = EnumSpecialDisplayStrings.ERROR_READING_MEMORY;
                break;
            }
            case MEM_ACCESS_SECURITY_VIOLATION: {
                displayStringEnum = EnumSpecialDisplayStrings.NON_EMULATABLE_SECURE_MEMORY;
                break;
            }
            case DEBUG_SERVER_ERROR_ACCESS_NOT_ATTEMPTED: 
            case DEBUG_SERVER_ERROR_NOT_IN_MEMORY_MAP: 
            case MEM_ACCESS_NOT_ATTEMPTED: {
                displayStringEnum = EnumSpecialDisplayStrings.NO_DATA_AVAILABLE;
                break;
            }
            case MEM_NOT_PRESENT: {
                displayStringEnum = EnumSpecialDisplayStrings.MEMORY_DOES_NOT_EXIST;
                break;
            }
            case MEM_ACCESS_INVALID: {
                displayStringEnum = EnumSpecialDisplayStrings.ERROR_READING_MEMORY;
                break;
            }
            case MEM_REGION_DSP_MEMORY_OBJECT_NULL: {
                displayStringEnum = EnumSpecialDisplayStrings.NO_DATA_AVAILABLE;
                break;
            }
            case DEBUG_SERVER_ERROR_INVALID_INDEX_INTO_MEMORY_OBJECT: 
            case UNDEFINED_MEM_ACCESS_ERROR_CODE: {
                displayStringEnum = EnumSpecialDisplayStrings.ERROR_READING_MEMORY;
                break;
            }
            default: {
                displayStringEnum = EnumSpecialDisplayStrings.NONE;
            }
        }
        return this.getSpecialDataString(displayStringEnum);
    }

    private class DataPair {
        public IDspMemory dspMemory;
        public List<IDspMemory.IMemoryValue> formattedData;

        private DataPair() {
        }
    }
}

