/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver;

import com.ti.ccstudio.debug.memoryserver.MemoryPageHandler;
import com.ti.ccstudio.debug.memoryserver.MemoryRead;
import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.MemoryWrite;
import com.ti.ccstudio.debug.memoryserver.TileConversionParameters;
import com.ti.ccstudio.debug.memoryserver.analyzers.IMemoryAnalyzer;
import com.ti.ccstudio.debug.memoryserver.analyzers.MemoryAnalyzerList;
import com.ti.ccstudio.debug.memoryserver.configoptions.ClientConfigOptions;
import com.ti.ccstudio.debug.memoryserver.configoptions.ClientConfigOptionsFactory;
import com.ti.ccstudio.debug.memoryserver.configoptions.ConfigOptionList;
import com.ti.ccstudio.debug.memoryserver.configoptions.ConfigOption_Boolean;
import com.ti.ccstudio.debug.memoryserver.configoptions.ConfigOption_CacheBoundaryMarkerOptionList;
import com.ti.ccstudio.debug.memoryserver.configoptions.ConfigOption_MemoryLevelEnable;
import com.ti.ccstudio.debug.memoryserver.configoptions.ConfigOption_MemoryLevelVisibilityOptionList;
import com.ti.ccstudio.debug.memoryserver.configoptions.EnumConfigOptionType;
import com.ti.ccstudio.debug.memoryserver.configoptions.EnumMemoryLevelVisibilityMode;
import com.ti.ccstudio.debug.memoryserver.configoptions.IConfigOption;
import com.ti.ccstudio.debug.memoryserver.configoptions.IConfigOptionList;
import com.ti.ccstudio.debug.memoryserver.configoptions.MemoryView;
import com.ti.ccstudio.debug.memoryserver.enums.EnumC64plusTargetDiscoveryState;
import com.ti.ccstudio.debug.memoryserver.enums.EnumCacheLevel;
import com.ti.ccstudio.debug.memoryserver.enums.EnumDspValueType;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryLevelIndex;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryProtectionFlags;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryRequestErrorCodes;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryRequestStates;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryRequestTypes;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryServerErrorCodes;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryViews;
import com.ti.ccstudio.debug.memoryserver.enums.EnumReasonForRefresh;
import com.ti.ccstudio.debug.memoryserver.enums.EnumSpecialDisplayStrings;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTargetType;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTileConversionType;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.ContinuousRefreshUpdateEventListener;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.FileLoadedEventArgs;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.HaltEventArgs;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.ICExpressionEvalEventHandler;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.IContinuousRefreshUpdateEventHandler;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.IExternalMemoryChangedEventHandler;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.IFileLoadedEventHandler;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.IGetRegisterContextValuesCompleteEventHandler;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.IHaltEventHandler;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.IMemoryMapChangedEventHandler;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.IMemoryRequestCompleteEventHandler;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.IMemoryUpdateEventHandler;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.INewSymbolsEventHandler;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.IRegisterRequestCompleteEventHandler;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.ITargetConnectedEventHandler;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.ITargetDisconnectedEventHandler;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.ITargetResetEventHandler;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.ITargetRestartedEventHandler;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.ITargetRunningEventHandler;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.IXmlFileDiscoveryCompleteEventHandler;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.RegisterUpdateArgs;
import com.ti.ccstudio.debug.memoryserver.events.internal.MemoryRefreshRequiredEvent;
import com.ti.ccstudio.debug.memoryserver.interfaces.IDisposable;
import com.ti.ccstudio.debug.memoryserver.interfaces.IMemoryRequestClient;
import com.ti.ccstudio.debug.memoryserver.interfaces.IMemoryRequestParameters;
import com.ti.ccstudio.debug.memoryserver.interfaces.IMemoryServer;
import com.ti.ccstudio.debug.memoryserver.interfaces.IMmuHandler;
import com.ti.ccstudio.debug.memoryserver.interfaces.ITargetHandler;
import com.ti.ccstudio.debug.memoryserver.interfaces.ITiledMemoryRequestClient;
import com.ti.ccstudio.debug.memoryserver.maps.CacheList;
import com.ti.ccstudio.debug.memoryserver.maps.MemoryMapRegion;
import com.ti.ccstudio.debug.memoryserver.maps.MemoryMapRegionList;
import com.ti.ccstudio.debug.memoryserver.memoryhierarchy.MemLevelInfoHdlr;
import com.ti.ccstudio.debug.memoryserver.memoryhierarchy.MemoryHierarchyHandler;
import com.ti.ccstudio.debug.memoryserver.memoryhierarchy.MemoryTypeDescriptor;
import com.ti.ccstudio.debug.memoryserver.memoryinfoitems.IMemoryItem;
import com.ti.ccstudio.debug.memoryserver.memoryinfoitems.ListOfMemoryInfoItems;
import com.ti.ccstudio.debug.memoryserver.memoryinfoitems.MemoryItem;
import com.ti.ccstudio.debug.memoryserver.public_events.ClientRefreshRequiredEvent;
import com.ti.ccstudio.debug.memoryserver.public_events.IClientRefreshRequiredEventHandler;
import com.ti.ccstudio.debug.memoryserver.public_events.IMemoryHierarchyUpdatedEventHandler;
import com.ti.ccstudio.debug.memoryserver.public_events.MemoryHierarchyUpdatedEvent;
import com.ti.ccstudio.debug.memoryserver.public_events.ProbePointHitEvent;
import com.ti.ccstudio.debug.memoryserver.public_events.RefreshRequiredEventArgs;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.CExprRequestDescriptor;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.CExprRequestDescriptorCreator;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.CExpressionEvalResultArgs;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.MemoryRequestDescriptor;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.MemoryRequestDescriptorCreator;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.MemoryUpdateArgs;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.RegisterRequestDescriptor;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.RegisterRequestDescriptorCreator;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.RequestDescriptorBaseClass;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.RequestDescriptorFactory;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.RequestDescriptorQueue;
import com.ti.ccstudio.debug.memoryserver.symbols.SymbolMgr;
import com.ti.ccstudio.debug.memoryserver.target.CoreNumberHdlr;
import com.ti.ccstudio.debug.memoryserver.target.MemoryRWHandler;
import com.ti.ccstudio.debug.memoryserver.target.MmuHandler;
import com.ti.ccstudio.debug.memoryserver.target.RefreshToken;
import com.ti.ccstudio.debug.memoryserver.target.RefreshTokenCreator;
import com.ti.ccstudio.debug.memoryserver.target.RegisterHandler;
import com.ti.ccstudio.debug.memoryserver.target.RegisterList;
import com.ti.ccstudio.debug.memoryserver.target.TargetHandler;
import com.ti.ccstudio.debug.memoryserver.util.DataTypeFormat;
import com.ti.ccstudio.debug.memoryserver.util.RecyclingFactory;
import com.ti.ccstudio.debug.memoryserver.util.UInt63;
import com.ti.ccstudio.debug.memoryserver.xml.DeviceXMLReader;
import com.ti.ccstudio.debug.memoryserver.xml.XmlDeviceInfoHandler;
import com.ti.ccstudio.debug.memoryserver.xml.XmlFileDiscoveryHandler;
import com.ti.debug.engine.IDspMemory;
import com.ti.debug.engine.IDspValue;
import com.ti.debug.engine.impl.DspValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;

public class MemoryServer
implements IXmlFileDiscoveryCompleteEventHandler,
ICExpressionEvalEventHandler,
IContinuousRefreshUpdateEventHandler,
IExternalMemoryChangedEventHandler,
IFileLoadedEventHandler,
IGetRegisterContextValuesCompleteEventHandler,
IHaltEventHandler,
IMemoryServer,
IMemoryMapChangedEventHandler,
IMemoryRequestCompleteEventHandler,
IMemoryUpdateEventHandler,
IRegisterRequestCompleteEventHandler,
ITargetConnectedEventHandler,
ITargetDisconnectedEventHandler,
ITargetResetEventHandler,
ITargetRestartedEventHandler,
ITargetRunningEventHandler,
INewSymbolsEventHandler,
IDisposable {
    public static final boolean TRACE__MEMORY_SERVER = Boolean.parseBoolean("false");
    private MemoryRequestDescriptorCreator memoryRequestDescriptorCreator;
    private CExprRequestDescriptorCreator cExprEvalRequestDescriptorCreator;
    private RegisterRequestDescriptorCreator registerRequestDescriptorCreator;
    private RefreshTokenCreator refreshTokenCreator;
    private XMLFileDiscoveryWaiter xmlFileDiscoveryWaiter = new XMLFileDiscoveryWaiter();
    protected RequestDescriptorFactory memoryRequestDescriptorFactory = null;
    protected RequestDescriptorFactory cExprEvalRequestDescriptorFactory = null;
    protected RequestDescriptorFactory registerRequestDescriptorFactory = null;
    protected ArrayList<MemoryPageHandler> memoryPageHandlerList = null;
    protected ArrayList<MemoryHierarchyHandler> memoryHierarchyHandlerList = null;
    protected ArrayList<MemoryTypeDescriptor> listOfMemoryLevelsForAllMemoryPages = null;
    protected ArrayList<MemoryTypeDescriptor> listOfTargetCachesForAllMemoryPages = null;
    protected ArrayList<RefreshToken> listOfRefreshTokens = null;
    private ClientRefreshRequiredEvent onClientRefreshRequiredEvent = null;
    private ClientRefreshRequiredEvent onClientContinuousRefreshEvent = null;
    private ProbePointHitEvent onProbePointHitEvent = null;
    public MemoryRefreshRequiredEvent onMemoryRefreshRequiredEvent = null;
    public MemoryHierarchyUpdatedEvent onMemoryHierarchyUpdatedEvent;
    protected RecyclingFactory refreshTokenFactory = null;
    public TargetHandler targetHdlr = null;
    private SymbolMgr symbolMgr = null;
    protected MemoryAnalyzerList memoryAnalyzerList = null;
    protected RegisterList listOfRegisterHandlers = null;
    protected RequestDescriptorQueue clientRequestQueue = null;
    protected RequestDescriptorQueue targetAccessRequestQueue = null;
    protected RequestDescriptorQueue registerAccessRequestQueue = null;
    protected RequestDescriptorQueue cExprEvalRequestQueue = null;
    protected ClientConfigOptionsFactory clientConfigOptionsFactory;
    protected CoreNumberHdlr coreNumberHdlr = null;
    protected XmlFileDiscoveryHandler xmlFileDiscoveryHandler = null;
    protected MmuHandler mmuHandler = null;
    private int continuousRefreshInterval = 5000;
    private short cachedSupportedTypesPageNum = (short)-1;
    private List<DataTypeFormat> supportedTypes = null;
    private boolean isMemoryLevelVisibilitySupported = false;
    private boolean areMemoryAnalysisRegistersAvailable = false;
    private static final HashMap<MemoryRequestDescriptor, ArrayList<IMemoryItem>> requestToItemsMapping = new HashMap();
    private boolean isContinuousRefreshEnabled = false;
    public int numTimesHandleRegisterRequestCompleteEventCalledSimultaneously = 0;
    public int numTimesHandleMemoryRequestCompleteEventCalledSimultaneously = 0;
    private boolean isContinuousRefreshEventPending = false;
    private volatile boolean disposed = false;

    protected MemoryServer(TargetHandler target) {
        this.targetHdlr = target;
        this.targetHdlr.getEventHandler().addEventListener(this);
        this.memoryHierarchyHandlerList = new ArrayList();
        this.listOfMemoryLevelsForAllMemoryPages = new ArrayList();
        this.listOfTargetCachesForAllMemoryPages = new ArrayList();
        this.onMemoryRefreshRequiredEvent = new MemoryRefreshRequiredEvent(this);
        this.onMemoryHierarchyUpdatedEvent = new MemoryHierarchyUpdatedEvent(this);
        this.onClientRefreshRequiredEvent = new ClientRefreshRequiredEvent(this);
        this.onClientContinuousRefreshEvent = new ClientRefreshRequiredEvent(this);
        this.onProbePointHitEvent = new ProbePointHitEvent(this, this.targetHdlr);
    }

    @Override
    public ArrayList<MemoryPageHandler> getMemoryPageHandlerList() {
        return this.memoryPageHandlerList;
    }

    public RecyclingFactory getRefreshTokenFactory() {
        return this.refreshTokenFactory;
    }

    public ITargetHandler getTargetHdlr() {
        return this.targetHdlr;
    }

    public SymbolMgr getSymbolMgr() {
        return this.symbolMgr;
    }

    public MemoryAnalyzerList getMemoryAnalyzerList() {
        return this.memoryAnalyzerList;
    }

    public RegisterList getListOfRegisterHandlers() {
        return this.listOfRegisterHandlers;
    }

    public RequestDescriptorQueue getClientRequestQueue() {
        return this.clientRequestQueue;
    }

    public RequestDescriptorQueue getTargetAccessRequestQueue() {
        return this.targetAccessRequestQueue;
    }

    public RequestDescriptorQueue getRegisterAccessRequestQueue() {
        return this.registerAccessRequestQueue;
    }

    public RequestDescriptorQueue getCExprEvalRequestQueue() {
        return this.cExprEvalRequestQueue;
    }

    @Override
    public ClientConfigOptions getClientConfigOptions() {
        ClientConfigOptions result = null;
        if (this.clientConfigOptionsFactory != null) {
            result = (ClientConfigOptions)this.clientConfigOptionsFactory.createInstance();
        }
        return result;
    }

    public int getCoreNumber() {
        int result = 0;
        if (this.coreNumberHdlr != null) {
            if (this.coreNumberHdlr.isCoreNumberFromTaskNameAvailable()) {
                result = this.coreNumberHdlr.getCoreNumberFromTaskName();
            } else if (this.coreNumberHdlr.isCoreNumberFromTargetAvailable()) {
                result = this.coreNumberHdlr.getCoreNumberForThisTarget();
            }
        }
        return result;
    }

    public String getCoreNumberFromTaskName() {
        String result = "0";
        result = Integer.toString(this.getCoreNumber());
        return result;
    }

    @Override
    public Collection<MemoryView> getSupportedViews() {
        ArrayList<MemoryView> views = new ArrayList<MemoryView>();
        views.add(new MemoryView(EnumMemoryViews.CPU_MEMORY_VIEW, "CPU Memory View"));
        if (this.targetHdlr.getMemLevelInfoHdlr().isStage2MmuBypassSupported()) {
            views.add(new MemoryView(EnumMemoryViews.PHYSICAL_MEMORY_VIEW, "Intermediate Physical Memory View"));
            views.add(new MemoryView(EnumMemoryViews.STAGE2_PHYSICAL_MEMORY_VIEW, "Physical Memory View"));
        } else if (this.isMmuBypassSupported()) {
            views.add(new MemoryView(EnumMemoryViews.PHYSICAL_MEMORY_VIEW, "Physical Memory View"));
        }
        return views;
    }

    @Override
    public boolean isPhysicalMemorySupported() {
        boolean result = this.isMmuBypassSupported();
        if (!result && this.targetHdlr != null && (result = this.targetHdlr.info.getXmlDeviceInfoHandler().isVirtualMemorySupported()) && this.mmuHandler != null) {
            result = this.mmuHandler.isMmuSupported();
        }
        return result;
    }

    @Override
    public boolean isMmuBypassSupported() {
        boolean result = false;
        if (this.targetHdlr != null && this.targetHdlr.getMemLevelInfoHdlr() != null && (result = this.targetHdlr.getMemLevelInfoHdlr().isMmuBypassSupported()) && this.mmuHandler != null) {
            result = this.mmuHandler.useDriverMmuBypassAPIs();
        }
        return result;
    }

    @Override
    public int getMaxAddressBusWidth(short pageNumber, EnumMemoryViews view) {
        return this.targetHdlr.getInfo().getMaxAddressBusWidth(pageNumber, view);
    }

    public boolean isNoMemoryDevice() {
        boolean result = false;
        if (this.targetHdlr != null) {
            result = this.targetHdlr.info.isNoMemoryDevice();
        }
        return result;
    }

    public XmlFileDiscoveryHandler getXmlFileDiscoveryHandler() {
        return this.xmlFileDiscoveryHandler;
    }

    @Override
    public IMmuHandler getMmuHandler() {
        return this.mmuHandler;
    }

    public String getStrTaskName() {
        String result = "";
        if (this.targetHdlr != null) {
            return this.targetHdlr.getTaskName();
        }
        return result;
    }

    @Override
    public void setContinuousRefreshInterval(int value) {
        this.continuousRefreshInterval = value;
    }

    public int getContinuousRefreshInterval() {
        return this.continuousRefreshInterval;
    }

    private void discardAllTargetRequests() {
        while (this.getCExprEvalRequestQueue().size() > 0) {
            this.getCExprEvalRequestQueue().deleteFirstRequest(true);
        }
        while (this.getTargetAccessRequestQueue().size() > 0) {
            this.getTargetAccessRequestQueue().deleteFirstRequest(true);
        }
        while (this.getRegisterAccessRequestQueue().size() > 0) {
            this.getRegisterAccessRequestQueue().deleteFirstRequest(true);
        }
    }

    @Override
    public List<DataTypeFormat> getSupportedTypes(short pageNum) {
        if (this.supportedTypes == null || this.cachedSupportedTypesPageNum != pageNum) {
            this.supportedTypes = new ArrayList<DataTypeFormat>();
            this.cachedSupportedTypesPageNum = pageNum;
            for (IDspValue.SupportedType supType : this.targetHdlr.getDspTask().getMemoryAccess().getSupportedTypes((int)pageNum)) {
                this.supportedTypes.add(new DataTypeFormat(supType));
            }
        }
        return this.supportedTypes;
    }

    private void getCacheTagRamInfo(RegisterList registerList) {
        MemoryTypeDescriptor memType = null;
        MemoryHierarchyHandler mhHdlr = null;
        if (this.clientConfigOptionsFactory.isMemoryAnalysisRequired()) {
            for (int memPageNum = 0; memPageNum < this.targetHdlr.info.getNumMemoryPages(); ++memPageNum) {
                mhHdlr = this.memoryHierarchyHandlerList.get(memPageNum);
                if (mhHdlr == null || mhHdlr.getListOfMemoryViews() == null) continue;
                for (int viewNum = 1; viewNum < mhHdlr.getListOfMemoryViews().size(); ++viewNum) {
                    memType = mhHdlr.getListOfMemoryViews().get(viewNum);
                    if (!memType.isCache() || this.targetHdlr.isRealTimeModeEnabled() || !memType.isCacheTagRamDecodingSupported()) continue;
                    try {
                        if (memType.getCacheTagRamHandler() == null) continue;
                        memType.getCacheTagRamHandler().getCacheTagInfo();
                        continue;
                    }
                    catch (Exception e1) {
                        e1.getMessage();
                    }
                }
            }
        }
    }

    public void init() {
        this.symbolMgr = new SymbolMgr(this.targetHdlr);
        this.cExprEvalRequestDescriptorCreator = new CExprRequestDescriptorCreator(this.targetHdlr);
        this.cExprEvalRequestDescriptorFactory = new RequestDescriptorFactory(this.targetHdlr.info.getStrTargetDescription() + " C Expression Evaluation Request Descriptor Factory", this.cExprEvalRequestDescriptorCreator);
        this.memoryRequestDescriptorCreator = new MemoryRequestDescriptorCreator(this.targetHdlr);
        this.memoryRequestDescriptorFactory = new RequestDescriptorFactory(this.targetHdlr.info.getStrTargetDescription() + " Memory Request Descriptor Factory", this.memoryRequestDescriptorCreator);
        this.registerRequestDescriptorCreator = new RegisterRequestDescriptorCreator(this.targetHdlr);
        this.registerRequestDescriptorFactory = new RequestDescriptorFactory(this.targetHdlr.info.getStrTargetDescription() + " Register Request Descriptor Factory", this.registerRequestDescriptorCreator);
        this.memoryPageHandlerList = new ArrayList();
        this.clientRequestQueue = new RequestDescriptorQueue("ClientReqQueue", null);
        this.targetAccessRequestQueue = new RequestDescriptorQueue("TargetAccessRequestQueue (" + this.targetHdlr.info.getStrTargetDescription() + ")", this.memoryRequestDescriptorFactory);
        this.registerAccessRequestQueue = new RequestDescriptorQueue("TargetRegisterRequestQueue (" + this.targetHdlr.info.getStrTargetDescription() + ")", this.registerRequestDescriptorFactory);
        this.cExprEvalRequestQueue = new RequestDescriptorQueue("CExprEvalRequestQue (" + this.targetHdlr.info.getStrTargetDescription() + ")", this.cExprEvalRequestDescriptorFactory);
        this.listOfRegisterHandlers = new RegisterList(this.targetHdlr, this.targetAccessRequestQueue, this.cExprEvalRequestQueue, this.registerAccessRequestQueue);
        this.listOfRegisterHandlers.setName("MemoryServer.listOfRegisterHandlers");
        this.listOfRegisterHandlers.onGetRegisterContextValuesComplete.addListener(this);
        this.refreshTokenFactory = new RecyclingFactory(this.targetHdlr.info.getStrTargetDescription() + " RefreshToken Factory", this.refreshTokenCreator);
        this.mmuHandler = new MmuHandler(this, this.getListOfRegisterHandlers(), this.getCExprEvalRequestQueue());
        this.coreNumberHdlr = new CoreNumberHdlr();
        this.coreNumberHdlr.init(this.targetHdlr, this.listOfRegisterHandlers);
        this.createMemoryPageHandlers();
        this.initMemoryHierarchyHandlerList();
        this.memoryAnalyzerList = new MemoryAnalyzerList(this, this.targetHdlr);
        this.memoryAnalyzerList.init();
        this.clientConfigOptionsFactory = new ClientConfigOptionsFactory(this.targetHdlr.info.getStrTargetDescription() + " Client config options factory", this, this.targetHdlr);
        this.updateMemoryLevelVisibilitySupportedFlag();
        this.clientConfigOptionsFactory.config(this.isMemoryAnalysisSupported(), this.listOfMemoryLevelsForAllMemoryPages, this.listOfTargetCachesForAllMemoryPages, this.getMemoryAnalyzerList());
        this.xmlFileDiscoveryHandler = new XmlFileDiscoveryHandler(this.targetHdlr.getMemoryServerXmlPath(), this.targetHdlr, this.targetAccessRequestQueue, this.cExprEvalRequestQueue, this.registerAccessRequestQueue);
        this.xmlFileDiscoveryHandler.onXmlFileDiscoveryComplete.addListener(this);
        if (this.xmlFileDiscoveryHandler.getListOfXmlFiles() > 0) {
            this.xmlFileDiscoveryHandler.getDeviceIdRegisterHdlrs();
            if (this.targetHdlr.getInfo().getTargetTypeId() == EnumTargetType.SIMULATOR || !this.targetHdlr.isDisconnected()) {
                this.xmlFileDiscoveryHandler.readDeviceIds();
                this.xmlFileDiscoveryWaiter.waitUntilFinished();
            }
        }
        this.updateMemoryLevelVisibilitySupportedFlag();
        this.clientConfigOptionsFactory.config(this.isMemoryAnalysisSupported(), this.listOfMemoryLevelsForAllMemoryPages, this.listOfTargetCachesForAllMemoryPages, this.getMemoryAnalyzerList());
        this.targetHdlr.getEventHandler().getContinuousRefreshEventListener().init(this);
    }

    private void updateMemoryLevelVisibilitySupportedFlag() {
        XmlDeviceInfoHandler devInfoHdlr = this.targetHdlr.getInfo().getXmlDeviceInfoHandler();
        this.isMemoryLevelVisibilitySupported = devInfoHdlr.isMemoryLevelVisibilitySupported();
        if (this.isMemoryLevelVisibilitySupported && this.targetHdlr.getInfo().getTargetTypeId() == EnumTargetType.SIMULATOR) {
            this.isMemoryLevelVisibilitySupported = true;
            MemLevelInfoHdlr memLvlInfoHdlr = this.targetHdlr.getMemLevelInfoHdlr();
            if (memLvlInfoHdlr != null) {
                this.isMemoryLevelVisibilitySupported = memLvlInfoHdlr.isCacheVisibilitySupported();
            }
        }
    }

    @Override
    public boolean isMemoryLevelVisibilitySupported() {
        return this.isMemoryLevelVisibilitySupported;
    }

    protected short createMemoryPageHandlers() {
        short numMemoryPages = this.targetHdlr.getInfo().getNumMemoryPages();
        String memPageName = "";
        for (short i = 0; i < numMemoryPages; i = (short)(i + 1)) {
            memPageName = this.targetHdlr.getInfo().getMemoryPageNames().get(i);
            try {
                MemoryPageHandler handler = new MemoryPageHandler(this, this.targetHdlr, memPageName, i);
                this.memoryPageHandlerList.add(handler);
                handler.init();
                continue;
            }
            catch (Exception e) {
                MemoryServerTrace.logException("Exception creating memory page handlers", "MemoryServer.CreateMemoryPageHandlers", e, this.targetHdlr.info);
            }
        }
        return (short)this.memoryPageHandlerList.size();
    }

    protected MemoryPageHandler getMemoryPageHandlerForPage(short memPageNum) {
        MemoryPageHandler result = null;
        if (memPageNum >= 0 && memPageNum < this.memoryPageHandlerList.size()) {
            result = this.memoryPageHandlerList.get(memPageNum);
        } else if (this.memoryPageHandlerList.size() > 0) {
            result = this.memoryPageHandlerList.get(0);
        }
        return result;
    }

    public synchronized MemoryHierarchyHandler getMemoryHierarchyHandler(short memoryPageNum) {
        short pgNum = memoryPageNum;
        if (pgNum < 0) {
            pgNum = 0;
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                MemoryServerTrace.logError("Requested memory page was negative: [" + Integer.toString(memoryPageNum) + "].  Using 0 instead.", this.getClass().getName(), this.targetHdlr.info);
            }
        }
        MemoryHierarchyHandler result = null;
        if (pgNum < this.memoryHierarchyHandlerList.size()) {
            result = this.memoryHierarchyHandlerList.get(pgNum);
        } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
            MemoryServerTrace.logError("Requested memory page was out of range: [" + Integer.toString(memoryPageNum) + "]", this.getClass().getName(), this.targetHdlr.info);
        }
        return result;
    }

    protected int initMemoryHierarchyHandlerList() {
        this.memoryHierarchyHandlerList.clear();
        this.listOfMemoryLevelsForAllMemoryPages.clear();
        this.listOfTargetCachesForAllMemoryPages.clear();
        short numMemoryPages = this.targetHdlr.getInfo().getNumMemoryPages();
        MemoryPageHandler memPgHdlr = null;
        try {
            for (short i = 0; i < numMemoryPages; i = (short)(i + 1)) {
                memPgHdlr = this.getMemoryPageHandlerForPage(i);
                if (memPgHdlr == null) continue;
                MemoryHierarchyHandler memHierarchyHdlr = memPgHdlr.getMemoryHierarchy();
                if (memHierarchyHdlr != null) {
                    this.memoryHierarchyHandlerList.add(memHierarchyHdlr);
                    for (MemoryTypeDescriptor memLevel : memHierarchyHdlr.getListOfMemoryLevels()) {
                        this.listOfMemoryLevelsForAllMemoryPages.add(memLevel);
                    }
                    for (MemoryTypeDescriptor cache : memHierarchyHdlr.getListOfTargetCaches()) {
                        this.listOfTargetCachesForAllMemoryPages.add(cache);
                    }
                    continue;
                }
                throw new NullPointerException();
            }
            this.getMemoryTypeDescriptorForDefaultPage();
        }
        catch (Exception ex) {
            MemoryServerTrace.logException("numMemoryPages = " + Integer.toString(numMemoryPages), "MemoryServer.initMemoryHierarchyHandlerList", ex, this.targetHdlr.info);
        }
        return this.memoryHierarchyHandlerList.size();
    }

    public synchronized int getNumOutstandingRefreshTokens() {
        int result = 0;
        if (!this.isDisposed() && this.getRefreshTokenFactory() != null && !this.getRefreshTokenFactory().isDisposed()) {
            result = this.getRefreshTokenFactory().getNumInUse();
        }
        return result;
    }

    public synchronized MemoryTypeDescriptor getMemoryTypeDescriptorForDefaultPage() {
        MemoryTypeDescriptor memType = null;
        MemoryTypeDescriptor dataPageMemType = null;
        boolean found = false;
        for (MemoryPageHandler memPage : this.memoryPageHandlerList) {
            memType = memPage.getMemoryHierarchy().getListOfMemoryViews().get(0);
            if (memType.isDefaultPage()) {
                found = true;
                break;
            }
            if (!memType.isDataMemory() || dataPageMemType != null) continue;
            dataPageMemType = memType;
        }
        if (!found) {
            memType = dataPageMemType != null ? dataPageMemType : this.memoryPageHandlerList.get(0).getMemoryHierarchy().getListOfMemoryViews().get(0);
            memType.setIsDefaultPage(true);
        }
        return memType;
    }

    public MemoryTypeDescriptor getMemoryTypeDescriptorForCache(short memPage, EnumCacheLevel cacheLevel) {
        MemoryTypeDescriptor result = null;
        EnumMemoryLevelIndex memLevelIndex = EnumMemoryLevelIndex.fromEnumCacheLevel(cacheLevel);
        ArrayList<MemoryTypeDescriptor> listOfTargetCaches = this.getMemoryHierarchyHandler(memPage).getListOfTargetCaches();
        for (int index = 0; index < listOfTargetCaches.size(); ++index) {
            MemoryTypeDescriptor memType = listOfTargetCaches.get(index);
            if (memType.getMemoryLevelIndex() != memLevelIndex) continue;
            result = memType;
            break;
        }
        return result;
    }

    public synchronized EnumC64plusTargetDiscoveryState isC64XplusTarget() {
        EnumC64plusTargetDiscoveryState result = EnumC64plusTargetDiscoveryState.WAITING_FOR_DISCOVERY_PROCESS_TO_COMPLETE;
        if (this.targetHdlr.isDisconnected()) {
            result = EnumC64plusTargetDiscoveryState.DISCONNECTED;
        }
        if (this.getXmlFileDiscoveryHandler().isTargetDiscoveryProcessComplete()) {
            MemoryHierarchyHandler mhHdlr;
            MemoryPageHandler memPageHdlr;
            result = EnumC64plusTargetDiscoveryState.NOT_C64PLUS_DEVICE;
            if (this.targetHdlr.info.getTargetIsaId() == 100L && (memPageHdlr = this.getMemoryPageHandlerForPage((short)0)) != null && (mhHdlr = memPageHdlr.getMemoryHierarchy()) != null && mhHdlr.getListOfMemoryLevels().size() == 4 && mhHdlr.getListOfMemoryTypes().size() == 7) {
                result = EnumC64plusTargetDiscoveryState.IS_C64PLUS_DEVICE;
            }
        }
        return result;
    }

    public synchronized boolean isMemoryAnalysisSupported(short memPage) {
        MemoryHierarchyHandler mhHdlr;
        MemoryPageHandler memPageHdlr;
        boolean result = false;
        if (!this.isDisposed() && (memPageHdlr = this.getMemoryPageHandlerForPage(memPage)) != null && (mhHdlr = memPageHdlr.getMemoryHierarchy()) != null && mhHdlr.getListOfMemoryLevels().size() > 1) {
            result = true;
        }
        return result;
    }

    @Override
    public synchronized boolean isMemoryAnalysisSupported() {
        boolean result = false;
        if (!this.isDisposed()) {
            for (short memPageNum = 0; memPageNum < this.targetHdlr.info.getNumMemoryPages(); memPageNum = (short)(memPageNum + 1)) {
                short s = memPageNum;
                result = this.isMemoryAnalysisSupported(s);
                if (!result) continue;
                break;
            }
        }
        return result;
    }

    public synchronized boolean isCacheTagRamDecodingSupported(short memPage) {
        MemoryPageHandler memPgHdlr;
        boolean result = false;
        if (!this.isDisposed() && (memPgHdlr = this.getMemoryPageHandlerForPage(memPage)) != null) {
            MemoryHierarchyHandler memHierarchyHdlr = memPgHdlr.getMemoryHierarchy();
            for (MemoryTypeDescriptor memType : memHierarchyHdlr.getListOfTargetCaches()) {
                if (!memType.isCacheTagRamDecodingSupported()) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public MemoryRWHandler getMemoryRWHandlerForPage(short memPage) {
        MemoryPageHandler memPgHdlr = this.getMemoryPageHandlerForPage(memPage);
        return memPgHdlr.getMemoryRWHandler();
    }

    public CacheList getMemoryViewListForPage(EnumMemoryViews memoryView, short memoryPage) {
        MemoryPageHandler memPageHdlr = this.getMemoryPageHandlerForPage(memoryPage);
        return memPageHdlr.getMemoryViewList(memoryView);
    }

    @Override
    public synchronized void flushAllHostCachesOfTargetMemory(EnumReasonForRefresh reasonForRefresh) {
        if (!this.isDisposed()) {
            boolean isMemoryAnalysisRequired = this.clientConfigOptionsFactory.isMemoryAnalysisRequired();
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                MemoryServerTrace.logInfo("Flush called with ReasonForRefresh = " + reasonForRefresh.toString(), "MemoryServer.FlushAllHostCachesOfTargetMemory", this.targetHdlr.info);
            }
            if (this.mmuHandler != null && !this.mmuHandler.isDisposed()) {
                this.mmuHandler.updateMmuStatus();
            }
            if (!this.targetHdlr.isRunning() || reasonForRefresh != EnumReasonForRefresh.TARGET_RUNNING) {
                for (MemoryPageHandler memPage : this.memoryPageHandlerList) {
                    memPage.flushServerCache();
                }
            }
            if (!(this.isDisposed() || this.targetHdlr.isRunning() || this.targetHdlr.isDisconnected() || reasonForRefresh == EnumReasonForRefresh.TARGET_RUNNING || reasonForRefresh == EnumReasonForRefresh.TARGET_REAL_TIME_UPDATE || this.getListOfRegisterHandlers() == null || this.getListOfRegisterHandlers().getNumRegistersToReadOnFlush(isMemoryAnalysisRequired) <= 0)) {
                if (!this.getListOfRegisterHandlers().isReadingRegisterContextValues()) {
                    this.getListOfRegisterHandlers().flush();
                    this.getListOfRegisterHandlers().setReasonForRefresh(reasonForRefresh);
                    if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                        MemoryServerTrace.logInfo("About to call getListOfRegisterHandlers().getRegisterContextValues [Count = " + Integer.toString(this.getListOfRegisterHandlers().size()) + "]", "MemoryServer.flushAllHostCachesOfTargetMemory", this.targetHdlr.info);
                    }
                }
                this.getListOfRegisterHandlers().getRegisterContextValues(isMemoryAnalysisRequired);
                this.areMemoryAnalysisRegistersAvailable = isMemoryAnalysisRequired;
            } else if (reasonForRefresh != EnumReasonForRefresh.TARGET_REAL_TIME_UPDATE) {
                this.raiseOnMemoryRefreshRequiredEvent(false, (short)0, 0L, 0L, reasonForRefresh, reasonForRefresh.toString());
            }
        }
    }

    @Override
    public synchronized void flushHostCachesOfTargetMemory(short pageNum, boolean raiseRefreshRequiredEvent) {
        block4: {
            if (!this.isDisposed()) {
                try {
                    MemoryPageHandler memPage = this.getMemoryPageHandlerForPage(pageNum);
                    memPage.flushServerCache();
                    if (raiseRefreshRequiredEvent) {
                        this.raiseOnMemoryRefreshRequiredEvent(true, pageNum, this.targetHdlr.getInfo().getMinAdrsInMemoryPage(pageNum), this.targetHdlr.getInfo().getMaxAdrsInMemoryPage(pageNum, EnumMemoryViews.CPU_MEMORY_VIEW), EnumReasonForRefresh.REQUESTED_BY_MEMORY_SERVER_CLIENT, "flushHostCachesOfTargetMemory(" + Integer.toString(pageNum) + ")");
                    }
                }
                catch (Exception err) {
                    if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block4;
                    MemoryServerTrace.logException("Exception: " + err.getMessage() + " - pageNum = " + Short.toString(pageNum) + ", raiseRefreshRequiredEvent = " + Boolean.toString(raiseRefreshRequiredEvent), "MemoryServer.flushHostCachesOfTargetMemory", err, this.targetHdlr.info);
                }
            }
        }
    }

    public synchronized void discardMemRequest(int requestId) {
        if (!this.isDisposed()) {
            RequestDescriptorBaseClass request = this.clientRequestQueue.findRequestWithId(requestId);
            if (request instanceof MemoryRequestDescriptor) {
                MemoryPageHandler memHandler = this.getMemoryPageHandlerForPage(request.getTargetMemoryPageNumber());
                memHandler.discardMemoryRequest((MemoryRequestDescriptor)request);
                this.clientRequestQueue.deleteRequest(requestId, true);
            } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                MemoryServerTrace.logError("MemoryServer logic error: Called DiscardMemRequest on a C Expression Evaluation request", "MemoryServer.discardMemRequest", this.targetHdlr.info);
            }
        }
    }

    public synchronized boolean isAdrsRangeReadable(short memoryPageNumber, long startAdrs, long endAdrs) {
        MemoryPageHandler memPage;
        boolean result = false;
        if (!this.isDisposed() && (memPage = this.getMemoryPageHandlerForPage(memoryPageNumber)) != null) {
            result = !memPage.getMemoryMapHandler().isMemoryMapEnabled() ? true : memPage.getMemoryMapHandler().isAdrsReadable(startAdrs, endAdrs);
        }
        return result;
    }

    public int getNumMAUsPerMemoryItem(EnumDspValueType formatDataType, short memoryPageNum) {
        int result = 0;
        if (!this.isDisposed()) {
            MemoryRequestDescriptor tempReq = (MemoryRequestDescriptor)this.memoryRequestDescriptorFactory.createInstance();
            tempReq.setFormatDataType(formatDataType);
            tempReq.setTargetMemoryPageNumber(memoryPageNum);
            result = this.getNumMAUsPerMemoryItem(tempReq);
            tempReq.release();
        }
        return result;
    }

    @Override
    public int getNumMAUsPerMemoryItem(MemoryRequestDescriptor req) {
        MemoryPageHandler memPage;
        int result = 4;
        if (!this.isDisposed() && (memPage = this.getMemoryPageHandlerForPage(req.getTargetMemoryPageNumber())) != null) {
            result = memPage.getNumMAUsPerMemoryItem(req);
        }
        return result;
    }

    @Override
    public int getAddressIncrementInMAUs(MemoryRequestDescriptor req) {
        int result = 4;
        if (!this.isDisposed()) {
            int numMAUsPerMemoryItem = this.getNumMAUsPerMemoryItem(req);
            result = this.targetHdlr.info.getAdrsIncrementInMAUs(numMAUsPerMemoryItem, req.getTargetMemoryPageNumber());
        }
        return result;
    }

    @Override
    public String getSpecialDataStringForMemoryItem(MemoryRequestDescriptor req, EnumSpecialDisplayStrings StringType) {
        MemoryPageHandler memPage;
        String result = "?";
        if (!this.isDisposed() && (memPage = this.getMemoryPageHandlerForPage(req.getTargetMemoryPageNumber())) != null) {
            result = memPage.getSpecialDataString(req, StringType);
        }
        return result;
    }

    @Override
    public synchronized EnumMemoryRequestErrorCodes requestCExpressionEvaluation(Object sender, String strCExpression, IMemoryRequestParameters memRequestParams, IMemoryRequestClient clientToNotifyOnRequestComplete, Object clientTagObject, long[] requestId, String[] strErrorInfo) {
        strErrorInfo[0] = "OK";
        EnumMemoryRequestErrorCodes retval = EnumMemoryRequestErrorCodes.OK;
        if (!this.isDisposed()) {
            if (this.targetHdlr.isCExprEvalAllowed()) {
                if (!this.targetHdlr.info.isMemoryPageNumberValid(memRequestParams.getPageNumber())) {
                    requestId[0] = -1L;
                    if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                        MemoryServerTrace.logError("Invalid Memory Page Number (" + memRequestParams.getPageNumber() + ") for expression " + strCExpression, "MemoryServer.requestCExpressionEvaluation", this.targetHdlr.info);
                    }
                } else {
                    MemoryPageHandler memPage;
                    CExprRequestDescriptor request;
                    if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                        MemoryServerTrace.logInfo("RequestCExpressionEvaluation: ", "MemoryServer.requestCExpressionEvaluation", this.targetHdlr.info);
                    }
                    if ((request = (CExprRequestDescriptor)this.cExprEvalRequestDescriptorFactory.createInstance()) != null) {
                        this.getClientRequestQueue().addRequest(request);
                        request.config(sender, 0L, strCExpression, memRequestParams.getMemoryView(), memRequestParams.getDSPStringFormat(), memRequestParams.getDSPValueType(), memRequestParams.getPageNumber(), memRequestParams.getQValue(), memRequestParams.getMemoryLevelEnableFlags(), clientToNotifyOnRequestComplete, clientTagObject);
                    }
                    if ((memPage = this.getMemoryPageHandlerForPage(memRequestParams.getPageNumber())).requestCExprEval(request)) {
                        requestId[0] = request.getRequestId();
                    } else {
                        request.release();
                        requestId[0] = -1L;
                    }
                }
            }
            if (retval != EnumMemoryRequestErrorCodes.OK && MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                String errorMsg = retval.toString();
                MemoryServerTrace.logError(errorMsg, "MemoryServerClass.requestCExpressionEvaluation", this.targetHdlr.info);
            }
        }
        return retval;
    }

    private int dataSizeInMaus(EnumDspValueType type) {
        IDspValue value = this.targetHdlr.getDspTask().getMemoryAccess().createDspValue(DspValue.translateToDspValueTypeEnum((int)type.getInt()), 0L);
        return value.sizeOf();
    }

    @Override
    public EnumMemoryRequestErrorCodes requestTiledTargetMemoryRead(Object sender, IMemoryRequestParameters memRequestParams, TileConversionParameters tileConversionParms, ITiledMemoryRequestClient clientToNotifyOnRequestComplete, Object clientTagObject, final long[] requestId, final String[] strErrorInfo) {
        final TileConversionParameters fTileConversionParms = tileConversionParms;
        final ITiledMemoryRequestClient fClientToNotifyOnRequestComplete = clientToNotifyOnRequestComplete;
        final Object fSender = sender;
        final Object fClientTagObject = clientTagObject;
        final IMemoryRequestParameters fMemRequestParams = memRequestParams;
        final int dataSizeInMaus = this.dataSizeInMaus(fMemRequestParams.getDSPValueType());
        final List<TiledRequestSegment> requestsToMake = this.getRequestSegments(fTileConversionParms, dataSizeInMaus);
        long maxAdrs = this.targetHdlr.info.getMaxAdrsInMemoryPage(memRequestParams.getPageNumber(), memRequestParams.getMemoryView());
        for (TiledRequestSegment requestSeg : requestsToMake) {
            long requestEndAddress = requestSeg.getTiledAddress() + (long)requestSeg.getBlockSizeInMaus();
            if (requestEndAddress <= maxAdrs) continue;
            strErrorInfo[0] = "MemoryServer.RequestTiledTargetMemoryRead Error: end adrs of requested memory read (0x" + Long.toHexString(requestEndAddress) + " > device adrs space max adrs " + "(0x" + Long.toHexString(maxAdrs) + ")";
            return EnumMemoryRequestErrorCodes.END_ADDRESS_EXCEEDS_DEVICE_MAX_ADDRESS;
        }
        Runnable memoryRequest = new Runnable(){

            @Override
            public void run() {
                int numRequests = requestsToMake.size();
                MultipleRequestsClient memoryRequestClient = new MultipleRequestsClient(numRequests, dataSizeInMaus);
                for (TiledRequestSegment requestSeg : requestsToMake) {
                    CountDownLatch latch = new CountDownLatch(1);
                    memoryRequestClient.setCountDownLatch(latch);
                    MemoryServer.this.requestTargetMemoryRead(fSender, requestSeg.getTiledAddress(), requestSeg.getBlockSizeInMaus(), fMemRequestParams, memoryRequestClient, fClientTagObject, requestId, strErrorInfo);
                    try {
                        latch.await();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                fClientToNotifyOnRequestComplete.onTiledMemoryRequestCompleteHandler(memoryRequestClient.getKeyIntoItems(), fTileConversionParms.Row, fTileConversionParms.Column, fTileConversionParms.BlockSizeInTileCells);
            }
        };
        Thread multipleMemThread = new Thread(memoryRequest);
        multipleMemThread.start();
        return EnumMemoryRequestErrorCodes.OK;
    }

    private List<TiledRequestSegment> getRequestSegments(TileConversionParameters params, int dataSizeInMaus) {
        ArrayList<TiledRequestSegment> result = new ArrayList<TiledRequestSegment>();
        int columnInTile = (int)(params.Column % (long)params.TileConversionType.TileWidth);
        int cellsLeftToProcess = params.BlockSizeInTileCells;
        int columnsProcessed = 0;
        while (cellsLeftToProcess > 0) {
            int maxCellsToProccess = cellsLeftToProcess > params.TileConversionType.TileWidth ? params.TileConversionType.TileWidth : cellsLeftToProcess;
            int cellsProcessedInSegment = maxCellsToProccess - columnInTile;
            long currentColumn = params.Column + (long)columnsProcessed;
            long tiledAddress = this.getTiledAddress(params.Row, currentColumn, params.ImageWidthInNumColumns, params.TileConversionType, dataSizeInMaus);
            cellsLeftToProcess -= cellsProcessedInSegment;
            columnsProcessed += cellsProcessedInSegment;
            columnInTile = 0;
            result.add(new TiledRequestSegment(tiledAddress += params.ImageStartAddress, cellsProcessedInSegment * dataSizeInMaus));
        }
        return result;
    }

    private long getTiledAddress(long row, long column, long tileStride, EnumTileConversionType type, int dataSizeInMaus) {
        long tileSize = type.TileHeight * type.TileWidth;
        long rowInTile = row % (long)type.TileHeight;
        long columnInTile = column % (long)type.TileWidth;
        long tileNumInImage = row / (long)type.TileHeight * (tileStride / (long)type.TileWidth) + column / (long)type.TileWidth;
        long tiledAddress = rowInTile * (long)type.TileWidth + columnInTile + tileNumInImage * tileSize;
        long tiledAddressInMaus = tiledAddress * (long)dataSizeInMaus;
        return tiledAddressInMaus;
    }

    @Override
    public synchronized List<IMemoryItem> readTiledMemoryItems(MemoryRequestDescriptor request) {
        return requestToItemsMapping.remove(request);
    }

    @Override
    public long getTiledAddress(TileConversionParameters params, EnumDspValueType DSPValuetype) {
        int dataSizeInMaus = this.dataSizeInMaus(DSPValuetype);
        long tiledAddressOffset = this.getTiledAddress(params.Row, params.Column, params.ImageWidthInNumColumns, params.TileConversionType, dataSizeInMaus);
        return tiledAddressOffset + params.ImageStartAddress;
    }

    @Override
    public void getTiledRowColumnFromAddress(long address, TileConversionParameters params, EnumDspValueType DSPValuetype) {
        EnumTileConversionType type = params.TileConversionType;
        int dataSizeInMaus = this.dataSizeInMaus(DSPValuetype);
        long offset = (address - params.ImageStartAddress) / (long)dataSizeInMaus;
        long tileSize = type.TileHeight * type.TileWidth;
        long tileNum = offset / tileSize;
        long tilesPerRow = params.ImageWidthInNumColumns / (long)type.TileWidth;
        params.Row = tileNum / tilesPerRow * (long)type.TileHeight;
        params.Column = tileNum % tilesPerRow * (long)type.TileWidth;
        long positionInTile = offset % tileSize;
        long rowInTile = positionInTile / (long)type.TileWidth;
        long columnInTile = positionInTile % (long)type.TileWidth;
        params.Row += rowInTile;
        params.Column += columnInTile;
    }

    private EnumMemoryRequestErrorCodes isReadRequestValid(Object sender, long beginAdrs, int blockSizeInMAUs, IMemoryRequestParameters memRequestParams, IMemoryRequestClient clientToNotifyOnRequestComplete, Object clientTagObject, long[] requestId, String[] strErrorInfo) {
        strErrorInfo[0] = "OK";
        requestId[0] = 0L;
        EnumMemoryRequestErrorCodes retval = EnumMemoryRequestErrorCodes.OK;
        if (!this.targetHdlr.isMemoryReadAllowed()) {
            if (this.targetHdlr.isRunning()) {
                retval = EnumMemoryRequestErrorCodes.TARGET_MEMORY_READ_NOT_ALLOWED_WHILE_RUNNING;
                strErrorInfo[0] = "Target device does not support reading memory while the target is running.";
            } else if (this.targetHdlr.isDisconnected()) {
                retval = EnumMemoryRequestErrorCodes.TARGET_DISCONNECTED;
                strErrorInfo[0] = "Target disconnected";
            } else {
                retval = EnumMemoryRequestErrorCodes.TARGET_MEMORY_READ_NOT_ALLOWED;
                strErrorInfo[0] = "Target device does not support reading memory.";
            }
            return retval;
        }
        long uStartAdrs = beginAdrs;
        if (beginAdrs < 0L) {
            uStartAdrs = UInt63.getFromSignedLong(beginAdrs);
        }
        long endAdrs = this.targetHdlr.info.getEndAdrsInRange(uStartAdrs, blockSizeInMAUs, memRequestParams.getPageNumber());
        long minAdrs = this.targetHdlr.info.getMinAdrsInMemoryPage(memRequestParams.getPageNumber());
        long maxAdrs = this.targetHdlr.info.getMaxAdrsInMemoryPage(memRequestParams.getPageNumber(), memRequestParams.getMemoryView());
        if (!this.targetHdlr.info.isMemoryPageNumberValid(memRequestParams.getPageNumber())) {
            retval = EnumMemoryRequestErrorCodes.INVALID_MEMORY_PAGE_NUMBER;
            strErrorInfo[0] = "MemoryServer.RequestTargetMemoryRead: Invalid Memory Page Number (" + memRequestParams.getPageNumber() + ") for adrs " + Long.toHexString(uStartAdrs);
            return retval;
        }
        if (blockSizeInMAUs <= 0) {
            retval = EnumMemoryRequestErrorCodes.INVALID_BLOCKSIZE;
            strErrorInfo[0] = "MemoryServer.RequestTargetMemoryRead Error: memory read length must be >= 0(was = " + Long.toString(blockSizeInMAUs) + ".  Start adrs = 0x" + Long.toHexString(uStartAdrs);
        } else if (endAdrs > maxAdrs) {
            retval = EnumMemoryRequestErrorCodes.END_ADDRESS_EXCEEDS_DEVICE_MAX_ADDRESS;
            strErrorInfo[0] = "MemoryServer.RequestTargetMemoryRead Error: end adrs of requested memory read (0x" + Long.toHexString(endAdrs) + " > device adrs space max adrs " + "(0x" + Long.toHexString(maxAdrs) + ")";
        } else if (uStartAdrs < minAdrs) {
            retval = EnumMemoryRequestErrorCodes.START_ADDRESS_LESS_THAN_DEVICE_MIN_ADDRESS;
            strErrorInfo[0] = "MemoryServer.RequestTargetMemoryRead Error: start adrs of requested memory read (0x" + Long.toHexString(uStartAdrs) + " < device adrs space min adrs " + "(0x" + Long.toHexString(minAdrs) + ")";
        }
        return retval;
    }

    @Override
    public synchronized EnumMemoryRequestErrorCodes requestTargetMemoryRead(Object sender, long beginAdrs, int blockSizeInMAUs, IMemoryRequestParameters memRequestParams, IMemoryRequestClient clientToNotifyOnRequestComplete, Object clientTagObject, long[] requestId, String[] strErrorInfo) {
        strErrorInfo[0] = "OK";
        requestId[0] = 0L;
        EnumMemoryRequestErrorCodes retval = EnumMemoryRequestErrorCodes.MEMORY_ACCESS_REQUEST_CREATION_FAILED;
        if (!this.isDisposed() && (retval = this.isReadRequestValid(sender, beginAdrs, blockSizeInMAUs, memRequestParams, clientToNotifyOnRequestComplete, clientTagObject, requestId, strErrorInfo)) == EnumMemoryRequestErrorCodes.OK) {
            MemoryRequestDescriptor requestDesc = new MemoryRequestDescriptor(this.targetHdlr.info);
            requestDesc.config(sender, EnumMemoryRequestTypes.READ, memRequestParams.getDSPStringFormat(), memRequestParams.getDSPValueType(), memRequestParams.getPageNumber(), memRequestParams.getMemoryLevelEnableFlags(), memRequestParams.getQValue(), memRequestParams.getClientConfigOptions(), beginAdrs, blockSizeInMAUs, memRequestParams.getMemoryView(), clientToNotifyOnRequestComplete, clientTagObject);
            MemoryHierarchyHandler memH = this.getMemoryHierarchyHandler(memRequestParams.getPageNumber());
            ArrayList<MemoryTypeDescriptor> listOfMemViews = memH.getListOfMemoryViews();
            new MemoryRead(beginAdrs, blockSizeInMAUs, memRequestParams, requestDesc, listOfMemViews, this.targetHdlr.getDspTask(), this.targetHdlr.getMemLevelInfoHdlr());
        }
        return retval;
    }

    @Override
    public synchronized EnumMemoryRequestErrorCodes requestTargetMemoryWrite_String(Object sender, long writeAddress, String writeData, IMemoryRequestParameters memRequestParams, IMemoryRequestClient clientToNotifyOnRequestComplete, Object clientTagObject, long[] nextAdrs, String[] strErrorInfo) {
        EnumMemoryRequestErrorCodes retval = this.isWriteRequestValid(writeAddress, writeData, memRequestParams, nextAdrs, strErrorInfo);
        if (retval == EnumMemoryRequestErrorCodes.OK) {
            MemoryRequestDescriptor clientRequest = new MemoryRequestDescriptor(this.targetHdlr.info);
            clientRequest.config(sender, EnumMemoryRequestTypes.READ, memRequestParams.getDSPStringFormat(), memRequestParams.getDSPValueType(), memRequestParams.getPageNumber(), memRequestParams.getMemoryLevelEnableFlags(), memRequestParams.getQValue(), memRequestParams.getClientConfigOptions(), writeAddress, 0L, memRequestParams.getMemoryView(), clientToNotifyOnRequestComplete, clientTagObject);
            MemoryWrite memWrite = new MemoryWrite(writeAddress, writeData, memRequestParams, clientRequest, this.targetHdlr.getDspTask(), this.targetHdlr.getMemLevelInfoHdlr());
            nextAdrs[0] = memWrite.getNextAdrs(writeAddress);
        }
        return retval;
    }

    private EnumMemoryRequestErrorCodes isWriteRequestValid(long writeAddress, String writeData, IMemoryRequestParameters memRequestParams, long[] nextAdrs, String[] strErrorInfo) {
        EnumMemoryRequestErrorCodes retval = EnumMemoryRequestErrorCodes.OK;
        long writeAdrs = writeAddress;
        if (writeAdrs < 0L) {
            writeAdrs = UInt63.getFromSignedLong(writeAddress);
        }
        nextAdrs[0] = writeAdrs;
        if (this.targetHdlr.isMemoryWriteAllowed()) {
            if (this.targetHdlr.isDisconnected()) {
                retval = EnumMemoryRequestErrorCodes.TARGET_DISCONNECTED;
                strErrorInfo[0] = "Target disconnected";
            } else {
                strErrorInfo[0] = "";
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                    MemoryServerTrace.logInfo("RequestTargetMemoryWrite_String: [" + writeData + "] to address 0x" + Long.toHexString(writeAddress), "MemoryServer.requestTargetMemoryWrite_String", this.targetHdlr.info);
                }
            }
        }
        return retval;
    }

    @Override
    public synchronized EnumMemoryRequestErrorCodes requestTargetMemoryWrite_Data(Object sender, long writeAddress, long writeData, IMemoryRequestParameters memRequestParams, IMemoryRequestClient clientToNotifyOnRequestComplete, Object clientTagObject, long[] nextAdrs, String[] strErrorInfo) {
        EnumMemoryRequestErrorCodes retval = EnumMemoryRequestErrorCodes.MEMORY_ACCESS_REQUEST_CREATION_FAILED;
        if (!this.isDisposed()) {
            long writeAdrs = writeAddress;
            if (writeAdrs < 0L) {
                writeAdrs = UInt63.getFromSignedLong(writeAddress);
            }
            nextAdrs[0] = writeAdrs;
            if (this.targetHdlr.isMemoryWriteAllowed()) {
                if (memRequestParams.getMemoryLevelEnableFlags() == 0) {
                    memRequestParams.setMemoryLevelEnableFlags(this.getMemoryHierarchyHandler(memRequestParams.getPageNumber()).getMemoryLevelEnableFlags_AllLevels());
                }
                if (this.targetHdlr.isDisconnected()) {
                    strErrorInfo[0] = "Target disconnected";
                    retval = EnumMemoryRequestErrorCodes.TARGET_DISCONNECTED;
                } else {
                    MemoryRequestDescriptor clientRequest;
                    strErrorInfo[0] = "";
                    if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                        MemoryServerTrace.logInfo("RequestTargetMemoryWrite_Data: ", "MemoryServer.RequestTargetMemoryWrite_Data", this.targetHdlr.info);
                    }
                    if ((clientRequest = (MemoryRequestDescriptor)this.memoryRequestDescriptorFactory.createInstance()) != null) {
                        MemoryPageHandler memPageHdlr;
                        this.clientRequestQueue.addRequest(clientRequest);
                        clientRequest.config(sender, EnumMemoryRequestTypes.WRITE, memRequestParams.getDSPStringFormat(), memRequestParams.getDSPValueType(), memRequestParams.getPageNumber(), memRequestParams.getMemoryLevelEnableFlags(), memRequestParams.getQValue(), memRequestParams.getClientConfigOptions(), writeAdrs, this.getNumMAUsPerMemoryItem(memRequestParams.getDSPValueType(), memRequestParams.getPageNumber()), memRequestParams.getMemoryView(), clientToNotifyOnRequestComplete, clientTagObject);
                        if (this.targetHdlr.info.getNumMemoryPages() > 3) {
                            short requestedMemPage = memRequestParams.getPageNumber();
                            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                                MemoryServerTrace.logInfo("Target device has " + Integer.toString(this.targetHdlr.info.getNumMemoryPages()) + " - Clearing all caches except for the requested page (page " + Integer.toString(requestedMemPage) + ")", "MemoryServer.RequestTargetMemoryWrite_Data", this.targetHdlr.info);
                            }
                            for (short pgNum = 0; pgNum < this.targetHdlr.info.getNumMemoryPages(); pgNum = (short)(pgNum + 1)) {
                                MemoryPageHandler memPgHdlr;
                                if (pgNum == requestedMemPage || (memPgHdlr = this.getMemoryPageHandlerForPage(pgNum)) == null) continue;
                                memPgHdlr.flushServerCache();
                            }
                        }
                        if ((memPageHdlr = this.getMemoryPageHandlerForPage(clientRequest.getTargetMemoryPageNumber())).writeMemory_Data(writeAdrs, clientRequest, nextAdrs, writeData, strErrorInfo)) {
                            retval = EnumMemoryRequestErrorCodes.OK;
                        }
                    } else {
                        retval = EnumMemoryRequestErrorCodes.MEMORY_ACCESS_REQUEST_CREATION_FAILED;
                        strErrorInfo[0] = "Failed to create memory access request descriptor";
                    }
                }
            }
        }
        return retval;
    }

    @Override
    public String readMemory_String(long address, MemoryRequestDescriptor req, long[] nextAdrs, EnumMemoryServerErrorCodes[] errorCode) {
        errorCode[0] = EnumMemoryServerErrorCodes.OK;
        nextAdrs[0] = req.getReadRequest().getNextAdrs(address);
        return "";
    }

    @Override
    public boolean readMemory_UpdateAdrsSpecificProperties(long address, MemoryRequestDescriptor req, ListOfMemoryInfoItems[] listOfMemoryInfoItems, EnumMemoryServerErrorCodes[] errorCode) {
        MemoryMapRegion memMapRegion;
        IConfigOptionList listOfMemoryAnalyzerOptions;
        boolean isCacheTagRamDecodingEnabled = false;
        boolean isMemoryAnalysisEnabled = false;
        short memPage = req.getTargetMemoryPageNumber();
        listOfMemoryInfoItems[0].setAdrs(address);
        ClientConfigOptions clientCfgOptions = (ClientConfigOptions)req.getClientConfigOptions();
        boolean result = false;
        if (clientCfgOptions != null) {
            isMemoryAnalysisEnabled = clientCfgOptions.isMemoryAnalysisEnabled();
            isCacheTagRamDecodingEnabled = isMemoryAnalysisEnabled && this.isCacheTagRamDecodingSupported(memPage);
        }
        MemoryPageHandler memPageHdlr = this.getMemoryPageHandlerForPage(req.getTargetMemoryPageNumber());
        result = true;
        MemoryRead memoryRead = req.getReadRequest();
        MemoryItem memItem = new MemoryItem();
        List<MemoryTypeDescriptor> listOfMemoryViews = memoryRead.getListOfMemoryViews();
        if (!memoryRead.populateMemoryItem((int)(address - req.getStartAdrs()), memItem, 0, false)) {
            listOfMemoryInfoItems[0].storeMemAccessErrorInformation(listOfMemoryViews.get(0), memItem.getErrorString(), address, req);
        }
        if (!isMemoryAnalysisEnabled) {
            return true;
        }
        for (int index = 1; index < listOfMemoryViews.size(); ++index) {
            MemoryTypeDescriptor memLevel = listOfMemoryViews.get(index);
            int viewIndex = memoryRead.getListOfMemoryViews().indexOf(memLevel);
            if (!memoryRead.populateMemoryItem(0, memItem, viewIndex, false)) continue;
            String value = memItem.getDataValue();
            boolean isAdrsInCache = false;
            boolean isLRU = false;
            boolean isDirty = false;
            boolean isCacheTagRamDecodingAvailable = false;
            if (isCacheTagRamDecodingEnabled && memLevel.getCacheTagRamHandler() != null && memLevel.isCacheEnabled()) {
                isAdrsInCache = memLevel.getCacheTagRamHandler().isAdrsInCache(address);
                isLRU = memLevel.getCacheTagRamHandler().isCachedAdrsLeastRecentlyUsed(address);
                isDirty = memLevel.getCacheTagRamHandler().isCacheLineDirty(address);
                isCacheTagRamDecodingAvailable = true;
            }
            if (memLevel.canBeProtected() && memLevel.getMemoryProtectionHandler() != null) {
                listOfMemoryInfoItems[0].storeAddressMappedAttrInfo(address, memLevel, memLevel.getMemoryProtectionHandler());
            }
            if (memLevel.hasMemoryAccessIDs() && memLevel.getMemoryAccessIDHandler() != null) {
                listOfMemoryInfoItems[0].storeAddressMappedAttrInfo(address, memLevel, memLevel.getMemoryAccessIDHandler());
            }
            if (memLevel.canBeSecured() && memLevel.getMemorySecurityHandler() != null) {
                listOfMemoryInfoItems[0].storeAddressMappedAttrInfo(address, memLevel, memLevel.getMemorySecurityHandler());
            }
            listOfMemoryInfoItems[0].storeMemLevelInfo(memLevel, value, isCacheTagRamDecodingAvailable, isAdrsInCache, isLRU, isDirty, address, req.getMemoryView());
        }
        String[] analysisResult = new String[]{""};
        boolean highlightRequired = false;
        IMemoryAnalyzer memAnalyzer = null;
        if (clientCfgOptions != null && (listOfMemoryAnalyzerOptions = clientCfgOptions.getListOfMemoryAnalyzerOptions()) != null) {
            for (IConfigOption option : listOfMemoryAnalyzerOptions) {
                ConfigOption_Boolean cfgOption;
                Object tagObject;
                if (option.getConfigOptionType() != EnumConfigOptionType.BOOLEAN || (tagObject = (cfgOption = (ConfigOption_Boolean)option).getMemoryServerOwnedTagObject()) == null || !(tagObject instanceof IMemoryAnalyzer)) continue;
                memAnalyzer = (IMemoryAnalyzer)tagObject;
                highlightRequired = false;
                if (cfgOption.isOptionEnabled() && cfgOption.getCurrentValue()) {
                    highlightRequired = memAnalyzer.isAdrsHighlightingRequired(address, req, analysisResult);
                }
                if (!highlightRequired || analysisResult[0].length() <= 0) continue;
                listOfMemoryInfoItems[0].createInfoItem(memAnalyzer.getShortDescription() + " analysis", analysisResult[0], memAnalyzer.getLongDescription());
            }
        }
        EnumSet<EnumMemoryProtectionFlags> memProtectionFlags = EnumSet.noneOf(EnumMemoryProtectionFlags.class);
        long numMausPerMemoryItem = memPageHdlr.getNumMAUsPerMemoryItem(req);
        long maxAdrs = this.targetHdlr.info.getMaxAdrsInMemoryPage(req.getTargetMemoryPageNumber(), req.getMemoryView());
        MemoryMapRegionList memMapRegionList = memPageHdlr.getMemoryMapRegionList();
        if (req.getMemoryView() != EnumMemoryViews.CPU_MEMORY_VIEW_IGNORE_MEMORY_MAP && memMapRegionList.isAdrsInMap(address) && (memProtectionFlags = (memMapRegion = (MemoryMapRegion)memMapRegionList.findAdrsRegionContainingAdrs(address)).getMemoryProtectionFlags()).isEmpty()) {
            while (memMapRegion != null && memMapRegion.getEndAdrs() < address + numMausPerMemoryItem - 1L && memMapRegion.getEndAdrs() + 1L < maxAdrs) {
                if ((memMapRegion = (MemoryMapRegion)memMapRegionList.findAdrsRegionContainingAdrs(memMapRegion.getEndAdrs() + 1L)) == null || memMapRegion.getMemoryProtectionFlags().isEmpty()) continue;
                memProtectionFlags.addAll(memMapRegion.getMemoryProtectionFlags());
                break;
            }
        }
        if (!memProtectionFlags.isEmpty()) {
            listOfMemoryInfoItems[0].createInfoItem("Memory Protection Flags", memProtectionFlags.toString(), "Write Protected == adrs cannot be written into, Read Protected == adrs cannot be read from");
        }
        return result;
    }

    @Override
    public boolean readMemoryItems(long startAddress, ArrayList<IMemoryItem> listOfMemoryItems, MemoryRequestDescriptor req, EnumMemoryServerErrorCodes[] errorCode) {
        boolean proccessingSuccessFul = false;
        long adrs = startAddress;
        boolean isDisconnected = this.targetHdlr.isDisconnected();
        boolean isRunning = this.targetHdlr.isRunning();
        errorCode[0] = EnumMemoryServerErrorCodes.fromInt(req.getErrorCode());
        if (errorCode[0] == EnumMemoryServerErrorCodes.OK) {
            ConfigOptionsReader opts = new ConfigOptionsReader((ClientConfigOptions)req.getClientConfigOptions());
            EnumMemoryLevelIndex levelIndex = opts.getLevelIndex();
            boolean isMemoryAnalysisEnabled = opts.IsMemAnalysisEnabled();
            MemoryRead memoryRead = req.getReadRequest();
            int viewIndex = memoryRead.getViewIndex(levelIndex);
            int index = memoryRead.getFormattedDataIndex(adrs);
            for (IMemoryItem item : listOfMemoryItems) {
                block4: {
                    item.setAddress(adrs);
                    item.setIsDisconnected(isDisconnected);
                    item.setIsRunning(isRunning);
                    try {
                        if (!memoryRead.populateMemoryItem(index, item, viewIndex, true) || !isMemoryAnalysisEnabled) break block4;
                        item.setIsFlaggedByMemoryAnalysis(this.isAdrsFlaggedByMemoryAnalyzers(adrs, req));
                    }
                    catch (IndexOutOfBoundsException e) {
                        MemoryServerTrace.logException(e.getMessage(), "MemoryServer::readMemoryItems", e, this.targetHdlr.getInfo());
                        errorCode[0] = EnumMemoryServerErrorCodes.MEMORY_ACCESS_OUTSIDE_OF_REQUEST_DESCRIPTOR_ADDRESS_RANGE;
                        proccessingSuccessFul = false;
                        break;
                    }
                }
                adrs = memoryRead.getNextAdrs(adrs);
                ++index;
            }
            errorCode[0] = listOfMemoryItems.get(listOfMemoryItems.size() - 1).getErrorCode();
            proccessingSuccessFul = true;
        }
        return proccessingSuccessFul;
    }

    private boolean isAdrsFlaggedByMemoryAnalyzers(long adrs, MemoryRequestDescriptor req) {
        ClientConfigOptions cfgOptions;
        boolean result = false;
        long maxAdrs = this.targetHdlr.info.getMaxAdrsInMemoryPage(req.getTargetMemoryPageNumber(), req.getMemoryView());
        if (!this.isDisposed() && UInt63.getFromSignedLong(adrs) <= maxAdrs && (cfgOptions = (ClientConfigOptions)req.getClientConfigOptions()) != null && cfgOptions.isMemoryAnalysisEnabled()) {
            ConfigOptionList listOfMemoryAnalyzers = (ConfigOptionList)cfgOptions.getListOfMemoryAnalyzerOptions();
            for (IConfigOption option : listOfMemoryAnalyzers) {
                String[] analysisResult;
                IMemoryAnalyzer memoryAnalyzer;
                ConfigOption_Boolean cfgOption = (ConfigOption_Boolean)option;
                if (!cfgOption.isOptionEnabled() || cfgOption.getMemoryServerOwnedTagObject() == null || !(cfgOption.getMemoryServerOwnedTagObject() instanceof IMemoryAnalyzer) || !(memoryAnalyzer = (IMemoryAnalyzer)cfgOption.getMemoryServerOwnedTagObject()).isAdrsHighlightingRequired(adrs, req, analysisResult = new String[]{""})) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private boolean isAdrsAtStartOfCacheLine(long address, MemoryRequestDescriptor req) {
        boolean result = false;
        if (!this.isDisposed()) {
            long adrs = address;
            if (adrs < 0L) {
                adrs = UInt63.getFromSignedLong(address);
            }
            EnumMemoryLevelIndex levelIndex = EnumMemoryLevelIndex.NONE;
            MemoryTypeDescriptor memType = null;
            ClientConfigOptions cfgOptions = (ClientConfigOptions)req.getClientConfigOptions();
            if (cfgOptions != null) {
                MemoryHierarchyHandler mhHdlr;
                MemoryPageHandler memPage;
                ConfigOption_CacheBoundaryMarkerOptionList cfg_CacheBoundaryMarkerOptions = null;
                for (IConfigOption option : cfgOptions) {
                    if (!(option instanceof ConfigOption_CacheBoundaryMarkerOptionList)) continue;
                    cfg_CacheBoundaryMarkerOptions = (ConfigOption_CacheBoundaryMarkerOptionList)option;
                    break;
                }
                if (cfg_CacheBoundaryMarkerOptions != null && (levelIndex = cfg_CacheBoundaryMarkerOptions.getSelectedMemoryLevel()).compareTo(EnumMemoryLevelIndex.NONE) != 0 && (memPage = this.getMemoryPageHandlerForPage(req.getTargetMemoryPageNumber())) != null && (memType = (mhHdlr = memPage.getMemoryHierarchy()).getMemoryTypeDescriptorForMemoryLevel(levelIndex)) != null && adrs == memType.getStartAddressOfLineContainingAdrs(adrs)) {
                    result = true;
                }
            }
        }
        return result;
    }

    public EnumMemoryLevelIndex getMemoryLevelIndexForAdrs(long address, MemoryRequestDescriptor req, int gtiHitCode, EnumMemoryServerErrorCodes[] errorCode) {
        EnumMemoryLevelIndex result = EnumMemoryLevelIndex.NONE;
        if (!this.isDisposed()) {
            MemoryPageHandler memPage;
            long adrs = address;
            if (adrs < 0L) {
                adrs = UInt63.getFromSignedLong(address);
            }
            EnumMemoryLevelVisibilityMode visMode = EnumMemoryLevelVisibilityMode.NONE;
            ClientConfigOptions cfgOptions = (ClientConfigOptions)req.getClientConfigOptions();
            if (cfgOptions != null && (visMode = cfgOptions.getMemoryLevelVisibilityMode()).compareTo(EnumMemoryLevelVisibilityMode.NONE) != 0 && !this.targetHdlr.isDisconnected() && !this.targetHdlr.isRunning() && (memPage = this.getMemoryPageHandlerForPage(req.getTargetMemoryPageNumber())) != null) {
                if (req.getTargetMemoryLevelEnableFlags() == 0) {
                    if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.VERBOSE) && adrs >= MemoryServerTrace.verboseTraceMinAdrs && adrs <= MemoryServerTrace.verboseTraceMaxAdrs) {
                        MemoryServerTrace.logVerbose("req.TargetMemoryLevelEnableFlags == 0!", "MemoryServer.getMemoryLevelIndexForAdrs(" + Long.toHexString(adrs) + ")", this.targetHdlr.info);
                    }
                    req.setTargetMemoryLevelEnableFlags(memPage.getMemoryHierarchy().getMemoryLevelEnableFlags_AllLevels());
                }
                String name = "";
                boolean includeAllNonCacheMemoryLevels = false;
                int gtiEnabledMemLevelBits = memPage.getMemoryHierarchy().getMemoryHierarchyReadEnableFlags(req.getTargetMemoryLevelEnableFlags(), false, true);
                if (visMode.compareTo(EnumMemoryLevelVisibilityMode.MEMORY_LEVEL_VISIBILITY) == 0) {
                    includeAllNonCacheMemoryLevels = true;
                }
                MemoryHierarchyHandler mhHdlr = this.memoryHierarchyHandlerList.get(req.getTargetMemoryPageNumber());
                ArrayList<MemoryTypeDescriptor> sortedListOfMemTypes = new ArrayList<MemoryTypeDescriptor>();
                MemoryTypeDescriptor cpuViewMemType = null;
                cpuViewMemType = mhHdlr.getListOfMemoryTypesForGtiHitCode(adrs, includeAllNonCacheMemoryLevels, gtiHitCode, gtiEnabledMemLevelBits, sortedListOfMemTypes);
                if (cpuViewMemType != null) {
                    switch (visMode) {
                        case CACHE_VISIBILITY: {
                            if (!cpuViewMemType.isCache()) break;
                            result = cpuViewMemType.getMemoryLevelIndex();
                            break;
                        }
                        case MEMORY_LEVEL_VISIBILITY: {
                            result = cpuViewMemType.getMemoryLevelIndex();
                        }
                    }
                    name = cpuViewMemType.getName();
                }
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.VERBOSE) && adrs >= MemoryServerTrace.verboseTraceMinAdrs && adrs <= MemoryServerTrace.verboseTraceMaxAdrs) {
                    MemoryServerTrace.logVerbose("Adrs 0x" + Long.toHexString(adrs) + " MemoryLevelIndex : " + name + " : " + result.toString() + ", gtiEnabledMemLevelBits = " + Long.toHexString(gtiEnabledMemLevelBits), "MemoryServer.getMemoryLevelIndexForAdrs", this.targetHdlr.info);
                    if (name.length() == 0) {
                        MemoryServerTrace.logVerbose("memory type not found for adrs " + Long.toHexString(adrs) + ", gtiHitCode=0x" + Long.toHexString(gtiHitCode), "MemoryServer.getMemoryLevelIndexForAdrs", this.targetHdlr.info);
                    }
                }
            }
            if (errorCode[0] != EnumMemoryServerErrorCodes.OK && MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                String errorText = "Request Handling Error: adrs " + Long.toHexString(adrs) + ", ErrorCode = " + errorCode[0].toString() + ", requested range = 0x" + Long.toHexString(req.getStartAdrs()) + "- 0x" + Long.toHexString(req.getEndAdrs());
                MemoryServerTrace.logError(errorText, "MemoryServer.getMemoryLevelIndexForAdrs", this.targetHdlr.info);
            }
        }
        return result;
    }

    @Override
    public void setContextFromXmlString(String xPathSearchPrefix, String strXmlContext) {
    }

    @Override
    public String getContextAsXmlString() {
        return null;
    }

    @Override
    public void registerForRefreshRequiredCallback(IClientRefreshRequiredEventHandler clientInstance) {
        if (!this.isDisposed()) {
            this.onClientRefreshRequiredEvent.addListener(clientInstance);
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                MemoryServerTrace.logInfo("Registered RefreshRequired callback client " + clientInstance.toString() + " [count = " + Integer.toString(this.onClientRefreshRequiredEvent.getNumListeners()), "MemoryServer.registerForRefreshRequiredCallback", this.targetHdlr.info);
            }
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.VERBOSE)) {
                MemoryServerTrace.logVerbose("List of RefreshRequired callback clients:\n" + this.onClientRefreshRequiredEvent.toString(), "MemoryServer.registerForRefreshRequiredCallback", this.targetHdlr.info);
            }
        }
    }

    @Override
    public void unRegisterForRefreshRequiredCallback(IClientRefreshRequiredEventHandler clientInstance, boolean disposeClientInstance) {
        if (!this.isDisposed()) {
            this.onClientRefreshRequiredEvent.removeListener(clientInstance);
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                MemoryServerTrace.logInfo("Unregistered RefreshRequired callback client " + clientInstance.toString() + " [count = " + Integer.toString(this.onClientRefreshRequiredEvent.getNumListeners()), "MemoryServer.unRegisterForRefreshRequiredCallback", this.targetHdlr.info);
            }
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.VERBOSE)) {
                MemoryServerTrace.logVerbose("List of RefreshRequired callback clients:\n" + this.onClientRefreshRequiredEvent.toString(), "MemoryServer.unRegisterForRefreshRequiredCallback", this.targetHdlr.info);
            }
        }
    }

    @Override
    public void registerForContinuousRefreshCallback(IClientRefreshRequiredEventHandler clientInstance) {
        if (!this.isDisposed()) {
            ContinuousRefreshUpdateEventListener cRefreshListener = this.targetHdlr.getEventHandler().getContinuousRefreshEventListener();
            cRefreshListener.addListener(this);
            cRefreshListener.startThread();
            this.isContinuousRefreshEnabled = true;
            this.onClientContinuousRefreshEvent.addListener(clientInstance);
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                MemoryServerTrace.logInfo("Registered ContinuousRefresh callback client " + clientInstance.toString() + " [count = " + Integer.toString(this.onClientContinuousRefreshEvent.getNumListeners()), "MemoryServer.registerForContinuousRefreshCallback", this.targetHdlr.info);
            }
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.VERBOSE)) {
                MemoryServerTrace.logVerbose("List of ContinuousRefresh callback clients:\n" + this.onClientContinuousRefreshEvent.toString(), "MemoryServer.registerForContinuousRefreshCallback", this.targetHdlr.info);
            }
        }
    }

    @Override
    public void unRegisterForContinuousRefreshCallback(IClientRefreshRequiredEventHandler clientInstance, boolean disposeClientInstance) {
        if (!this.isDisposed()) {
            ContinuousRefreshUpdateEventListener cRefreshListener;
            this.onClientContinuousRefreshEvent.removeListener(clientInstance);
            if (this.onClientContinuousRefreshEvent.getNumListeners() == 0 && (cRefreshListener = this.targetHdlr.getEventHandler().getContinuousRefreshEventListener()).getNumListeners() > 0) {
                cRefreshListener.removeListener(this);
                cRefreshListener.stopThread();
                this.isContinuousRefreshEnabled = false;
            }
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                MemoryServerTrace.logInfo("Unregistered ContinuousRefresh callback client " + clientInstance.toString() + " [count = " + Integer.toString(this.onClientContinuousRefreshEvent.getNumListeners()), "MemoryServer.unRegisterForContinuousRefreshCallback", this.targetHdlr.info);
            }
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.VERBOSE)) {
                MemoryServerTrace.logVerbose("List of ContinuousRefresh callback clients:\n" + this.onClientContinuousRefreshEvent.toString(), "MemoryServer.unRegisterForContinuousRefreshCallback", this.targetHdlr.info);
            }
        }
    }

    @Override
    public void registerForProbePointHitCallback(IClientRefreshRequiredEventHandler clientInstance, String probePointClientName) {
        if (!this.isDisposed()) {
            this.onProbePointHitEvent.addListener(clientInstance, probePointClientName);
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                MemoryServerTrace.logInfo("Registered ProbePoint callback client " + clientInstance.toString() + " [name = " + probePointClientName + ", count = " + Integer.toString(this.onProbePointHitEvent.getNumListeners()), "MemoryServer.registerForProbePointHitCallback", this.targetHdlr.info);
            }
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.VERBOSE)) {
                MemoryServerTrace.logVerbose("List of ProbePoint callback clients:\n" + this.onProbePointHitEvent.toString(), "MemoryServer.registerForProbePointHitCallback", this.targetHdlr.info);
            }
        }
    }

    @Override
    public void unRegisterForProbePointHitCallback(IClientRefreshRequiredEventHandler clientInstance, boolean disposeClientInstance) {
        if (!this.isDisposed()) {
            this.onProbePointHitEvent.removeListener(clientInstance);
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                MemoryServerTrace.logInfo("Unregistered ProbePoint callback client " + clientInstance.toString() + " [count = " + Integer.toString(this.onProbePointHitEvent.getNumListeners()), "MemoryServer.unRegisterForProbePointHitCallback", this.targetHdlr.info);
            }
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.VERBOSE)) {
                MemoryServerTrace.logVerbose("List of ProbePoint callback clients:\n" + this.onProbePointHitEvent.toString(), "MemoryServer.unRegisterForProbePointHitCallback", this.targetHdlr.info);
            }
        }
    }

    @Override
    public void registerForMemoryHierarchyUpdatedEventCallback(IMemoryHierarchyUpdatedEventHandler clientInstance) {
        if (!this.isDisposed()) {
            this.onMemoryHierarchyUpdatedEvent.addListener(clientInstance);
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                MemoryServerTrace.logInfo("Registered MemoryHierarchyUpdated callback client " + clientInstance.toString() + " [count = " + Integer.toString(this.onMemoryHierarchyUpdatedEvent.getNumListeners()), "MemoryServer.registerForMemoryHierarchyUpdatedEventCallback", this.targetHdlr.info);
            }
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.VERBOSE)) {
                MemoryServerTrace.logVerbose("List of onMemoryHierarchyUpdatedEvent callback clients:\n" + this.onMemoryHierarchyUpdatedEvent.toString(), "MemoryServer.registerForMemoryHierarchyUpdatedEventCallback", this.targetHdlr.info);
            }
        }
    }

    @Override
    public void unRegisterForMemoryHierarchyUpdatedEventCallback(IMemoryHierarchyUpdatedEventHandler clientInstance, boolean disposeClientInstance) {
        if (!this.isDisposed()) {
            this.onMemoryHierarchyUpdatedEvent.removeListener(clientInstance);
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                MemoryServerTrace.logInfo("Unregistered MemoryHierarchyUpdated callback client " + clientInstance.toString() + " [count = " + Integer.toString(this.onMemoryHierarchyUpdatedEvent.getNumListeners()), "MemoryServer.unRegisterForMemoryHierarchyUpdatedCallback", this.targetHdlr.info);
            }
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.VERBOSE)) {
                MemoryServerTrace.logVerbose("List of MemoryHierarchyUpdated callback clients:\n" + this.onMemoryHierarchyUpdatedEvent.toString(), "MemoryServer.unRegisterForMemoryHiearchyUpdatedCallback", this.targetHdlr.info);
            }
        }
    }

    public void raiseOnMemoryRefreshRequiredEvent(boolean partialRefresh, short memoryPage, long startAddress, long lengthInMAUs, EnumReasonForRefresh reasonForRefresh, String debugInfoString) {
        block10: {
            if (!this.isDisposed()) {
                RefreshRequiredEventArgs args;
                block9: {
                    long startAdrs = startAddress;
                    if (startAdrs < 0L) {
                        startAdrs = UInt63.getFromSignedLong(startAdrs);
                    }
                    args = new RefreshRequiredEventArgs(partialRefresh, memoryPage, startAdrs, lengthInMAUs, reasonForRefresh, debugInfoString);
                    if (this.onMemoryRefreshRequiredEvent != null) {
                        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                            MemoryServerTrace.logInfo("OnMemoryRefreshRequiredEvent raised: " + (Object)((Object)reasonForRefresh) + ", " + debugInfoString + ", partialRefresh = " + Boolean.toString(partialRefresh) + ", start =" + Long.toHexString(startAdrs) + ", numMAUs=" + Long.toString(lengthInMAUs), "MemoryServer.raiseOnMemoryRefreshRequiredEvent", this.targetHdlr.info);
                        }
                        try {
                            if (this.onMemoryRefreshRequiredEvent != null) {
                                this.onMemoryRefreshRequiredEvent.raise(args);
                            }
                        }
                        catch (Exception ex1) {
                            if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block9;
                            MemoryServerTrace.logException("Exception raised in OnMemoryRefreshRequiredEvent handler: " + (Object)((Object)reasonForRefresh) + ", " + debugInfoString + ", partialRefresh = " + Boolean.toString(partialRefresh) + ", start =" + Long.toHexString(startAdrs) + ", numMAUs=" + Long.toString(lengthInMAUs), "MemoryServer.raiseOnMemoryRefreshRequiredEvent", ex1, this.targetHdlr.info);
                        }
                    }
                }
                try {
                    this.onClientRefreshRequiredEvent.raise(args);
                }
                catch (Exception ex) {
                    if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block10;
                    MemoryServerTrace.logException("Exception when calling back into IClientRefreshRequired client", "MemoryServer.raiseOnMemoryRefreshRequiredEvent", ex, this.targetHdlr.info);
                }
            }
        }
    }

    @Override
    public Object beginRefresh(IClientRefreshRequiredEventHandler clientInstance) {
        RefreshToken result = new RefreshToken(this.targetHdlr);
        result.beginRefresh(clientInstance, clientInstance.toString());
        return result;
    }

    @Override
    public void endRefresh(IClientRefreshRequiredEventHandler clientInstance, Object refreshToken) {
        if (refreshToken instanceof RefreshToken) {
            RefreshToken token = (RefreshToken)refreshToken;
            token.endRefresh();
            token.release();
        }
    }

    @Override
    public void handleCExpressionEvalEvent(EventObject sender, CExpressionEvalResultArgs args) {
        block10: {
            if (!this.isDisposed()) {
                int searchIndex = 0;
                boolean found = false;
                String origCExpr = "";
                try {
                    origCExpr = args.getOriginalCExpression();
                    while (searchIndex < this.getCExprEvalRequestQueue().size() && !found) {
                        CExprRequestDescriptor nextRequestPending = (CExprRequestDescriptor)this.getCExprEvalRequestQueue().peekAtRequestAtIndex(searchIndex);
                        if (nextRequestPending != null && nextRequestPending.getStrCExpression().equals(origCExpr)) {
                            found = true;
                            nextRequestPending.storeEvaluationResult(args.getErrorCode(), args.getDspValueObj());
                            if (args.getErrorCode() == 0) {
                                nextRequestPending.setRequestStatus(EnumMemoryRequestStates.REQUEST_COMPLETE);
                            } else {
                                nextRequestPending.setRequestStatus(EnumMemoryRequestStates.REQUEST_FAILED);
                            }
                            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.EVENTS)) {
                                MemoryServerTrace.logEvent("OnCExprEvalCompleteEvent : status = " + nextRequestPending.getRequestStatus().toString() + ". About to call NotifyClient()", "MemoryServer.handleCExprEvalEvent", this.targetHdlr.info);
                            }
                            this.getCExprEvalRequestQueue().deleteRequestAtIndex(searchIndex, false);
                            nextRequestPending.notifyClient();
                            if (!args.isDisposed()) {
                                args.dispose();
                            }
                            nextRequestPending.release();
                        }
                        if (found) continue;
                        ++searchIndex;
                    }
                    if (!found && MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.WARNINGS)) {
                        MemoryServerTrace.logWarning("Unexpected CExprEvalCompleteEvent:  CExpr = " + origCExpr, "MemoryServer.handleCExpressionEvalEvent", this.targetHdlr.info);
                    }
                }
                catch (Exception exc) {
                    if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block10;
                    MemoryServerTrace.logException("Exception in CExprEvalCompleteEvent: CExpr = " + origCExpr, "MemoryServer.handleCExpressionEvalEvent", exc, this.targetHdlr.info);
                }
            }
        }
    }

    @Override
    public void handleFileLoadedEvent(EventObject sender, FileLoadedEventArgs args) {
        if (!this.isDisposed()) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.EVENTS)) {
                MemoryServerTrace.logEvent("File Loaded", "MemoryServer.handleFileLoadedEvent", this.targetHdlr.info);
            }
            System.gc();
        }
    }

    @Override
    public void handleHaltEvent(EventObject sender, HaltEventArgs args) {
        try {
            if (!this.isDisposed()) {
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.EVENTS)) {
                    String pcAdrs = "null";
                    if (args != null) {
                        pcAdrs = Long.toHexString(args.getCurrentPC());
                    }
                    MemoryServerTrace.logEvent("Halt Event: PC = 0x" + pcAdrs, "MemoryServer.handleHaltEvent", this.targetHdlr.info);
                }
                if (this.getListOfRegisterHandlers() != null && this.getListOfRegisterHandlers().isReadingRegisterContextValues()) {
                    if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.WARNINGS)) {
                        MemoryServerTrace.logWarning("ListOfRegisterHandlers.isReadingRegisterContextValues = true when OnHaltEvent fired.  Setting to False", "MemoryServer.handleHaltEvent", this.targetHdlr.info);
                    }
                    this.getListOfRegisterHandlers().setIsReadingRegisterContextValues(false);
                }
                this.flushAllHostCachesOfTargetMemory(EnumReasonForRefresh.TARGET_HALTED);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void handleMemoryMapChangedEvent(EventObject sender) {
        if (!this.isDisposed()) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.EVENTS)) {
                MemoryServerTrace.logEvent("MemoryMap Changed Event - flushing caches and raising onMemoryRefreshRequredEvent.", "MemoryServer.handleMemoryMapChangedEvent", this.targetHdlr.info);
            }
            for (MemoryPageHandler memPage : this.memoryPageHandlerList) {
                memPage.flushServerCache();
                memPage.getMemoryMapRegionList().init();
                this.raiseOnMemoryRefreshRequiredEvent(false, memPage.getMemoryPageNumber(), this.targetHdlr.info.getMinAdrsInMemoryPage(memPage.getMemoryPageNumber()), this.targetHdlr.info.getMaxAdrsInMemoryPage(memPage.getMemoryPageNumber(), EnumMemoryViews.CPU_MEMORY_VIEW), EnumReasonForRefresh.MEMORY_MAP_UPDATE, "MemoryMapChangedEvent");
            }
        }
    }

    @Override
    public void handleRegisterRequestCompleteEvent(EventObject sender, RegisterUpdateArgs args) {
        if (!this.isDisposed()) {
            block28: {
                ++this.numTimesHandleRegisterRequestCompleteEventCalledSimultaneously;
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.EVENTS)) {
                    MemoryServerTrace.logEvent("args = " + args.toString() + "[ simultaneous calls = " + Integer.toString(this.numTimesHandleRegisterRequestCompleteEventCalledSimultaneously) + " times.]", "MemoryServer.handleRegisterRequestCompleteEvent", this.targetHdlr.info);
                }
                boolean requestAborted = args.isAborted();
                boolean requestFound = false;
                RegisterRequestDescriptor nextRequestPending = null;
                try {
                    String errorMsg;
                    if (this.registerAccessRequestQueue.size() > 0) {
                        nextRequestPending = (RegisterRequestDescriptor)this.registerAccessRequestQueue.peekAtRequestAtIndex(0);
                        if (nextRequestPending != null) {
                            requestFound = nextRequestPending.compare(sender, args);
                        }
                        if (!requestFound) {
                            errorMsg = "MemoryServer: Unexpected onRegisterRequestComplete Event.\nArgs = " + args.toString() + "\nNext pending request in the registerAccessRequestQueue: " + nextRequestPending.toString() + "\nCount in queue = " + Integer.toString(this.registerAccessRequestQueue.size()) + ", Event raised for " + args.toString();
                            for (int queueIndex = 0; queueIndex < this.getTargetAccessRequestQueue().size(); ++queueIndex) {
                                RegisterRequestDescriptor registerReq;
                                RequestDescriptorBaseClass reqInQueue = this.getTargetAccessRequestQueue().peekAtRequestAtIndex(queueIndex);
                                errorMsg = errorMsg + "\n[" + Integer.toString(queueIndex) + "]: " + reqInQueue.getRequestIdStr();
                                if (!(reqInQueue instanceof RegisterRequestDescriptor) || (registerReq = (RegisterRequestDescriptor)reqInQueue) == null) continue;
                                errorMsg = errorMsg + ", startAdrs=0x" + Long.toHexString(registerReq.getStartAdrs()) + ", ID=" + Long.toString(registerReq.getIdOfRegister()) + ", length=0x" + Long.toHexString(registerReq.getLengthInMAUs()) + ", type=" + registerReq.getRequestType().toString();
                                if (registerReq.getClientToNotifyOnRequestComplete() != null) {
                                    errorMsg = errorMsg + ", client=" + registerReq.getClientToNotifyOnRequestComplete().toString();
                                }
                                if (registerReq.getClientToNotifyOnRequestComplete() instanceof RegisterHandler) {
                                    errorMsg = errorMsg + "Register Name = " + ((RegisterHandler)registerReq.getClientToNotifyOnRequestComplete()).getName();
                                }
                                if (!(requestFound = registerReq.compare(sender, args))) continue;
                                nextRequestPending = registerReq;
                                if (nextRequestPending.getNumTimesNotifyCalled() == 0) {
                                    errorMsg = errorMsg + "<= Using this request (out of order!)";
                                    break;
                                }
                                errorMsg = errorMsg + "<= Not using this request (NumTimesNotifyCalled = " + Long.toString(nextRequestPending.getNumTimesNotifyCalled()) + ")";
                            }
                            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.TRANSACTIONS)) {
                                MemoryServerTrace.logTransaction(errorMsg, "MemoryServer.handleRegisterRequestCompleteEvent", this.targetHdlr.info);
                            }
                        } else if (nextRequestPending.getNumTimesNotifyCalled() == 0) {
                            requestFound = true;
                        } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.WARNINGS)) {
                            MemoryServerTrace.logWarning("NextRequestPending is still being processed - removing it from the queue. " + nextRequestPending.toString(), "MemoryServer.handleRegisterRequestCompleteEvent", this.targetHdlr.info);
                        }
                    }
                    if (requestFound) {
                        if (requestAborted) {
                            nextRequestPending.setRequestStatus(EnumMemoryRequestStates.REQUEST_ABORTED);
                        } else {
                            nextRequestPending.setRequestStatus(EnumMemoryRequestStates.REQUEST_COMPLETE);
                        }
                        nextRequestPending.setRegisterUpdateInfo(args);
                        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                            MemoryServerTrace.logInfo("About to call NotifyClient() for " + nextRequestPending.toString(), "MemoryServer.handleRegisterRequestCompleteEvent", this.targetHdlr.info);
                        }
                        this.registerAccessRequestQueue.deleteRequest(nextRequestPending, false);
                        --this.numTimesHandleRegisterRequestCompleteEventCalledSimultaneously;
                        nextRequestPending.notifyClient();
                        nextRequestPending.release();
                    } else {
                        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.WARNINGS)) {
                            errorMsg = "MemoryServer: Unexpected onRegisterUpdateEvent:\nNo matching requests found in the targetRegisterRequestQueue\nDiscarding event raised for " + args.toString();
                            MemoryServerTrace.logWarning(errorMsg, "MemoryServer.handleRegisterRequestCompleteEvent", this.targetHdlr.info);
                        }
                        --this.numTimesHandleRegisterRequestCompleteEventCalledSimultaneously;
                    }
                    if (args != null && !args.isDisposed()) {
                        args.dispose();
                    }
                }
                catch (Exception exc) {
                    if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block28;
                    String argValues = "null";
                    if (args != null) {
                        argValues = args.toString();
                    }
                    if (nextRequestPending != null) {
                        MemoryServerTrace.logException("RegisterRequestCompleteEvent: Exception while processing nextRequestPending, - removing it from the queue. " + nextRequestPending.toString() + "[args: " + argValues + "]", "MemoryServer.handleRegisterRequestCompleteEvent", exc, this.targetHdlr.info);
                    }
                    MemoryServerTrace.logException("RegisterRequestCompleteEvent: Exception while processing args: " + argValues, "MemoryServer.handleRegisterRequestCompleteEvent", exc, this.targetHdlr.info);
                }
            }
            if (this.targetAccessRequestQueue.size() == 0 && this.isContinuousRefreshEventPending) {
                this.isContinuousRefreshEventPending = false;
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.EVENTS)) {
                    MemoryServerTrace.logEvent("isContinuousRefreshEventPending = true and targetAccessRequestQueue empty so flushing all host caches", "MemoryServer.handleRegisterRequestCompleteEvent", this.targetHdlr.info);
                }
            }
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.EVENTS) && this.targetHdlr != null) {
                MemoryServerTrace.logEvent("Exiting MemoryServer.handleRegisterRequestCompleteEvent: called simultaneously " + Integer.toString(this.numTimesHandleRegisterRequestCompleteEventCalledSimultaneously) + " times.", "MemoryServer.handleRegisterRequestCompleteEvent", this.targetHdlr.info);
            }
        }
    }

    @Override
    public void handleMemoryRequestCompleteEvent(EventObject sender, MemoryUpdateArgs args) {
        if (!this.isDisposed()) {
            block29: {
                ++this.numTimesHandleMemoryRequestCompleteEventCalledSimultaneously;
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.EVENTS)) {
                    MemoryServerTrace.logEvent("args = " + args.toString() + "[ simultaneous calls = " + Integer.toString(this.numTimesHandleMemoryRequestCompleteEventCalledSimultaneously) + " times.]", "MemoryServer.handleMemoryRequestCompleteEvent", this.targetHdlr.info);
                }
                boolean requestAborted = args.isAborted();
                boolean requestFound = false;
                MemoryRequestDescriptor nextRequestPending = null;
                try {
                    String errorMsg;
                    if (this.targetAccessRequestQueue.size() > 0) {
                        nextRequestPending = (MemoryRequestDescriptor)this.targetAccessRequestQueue.peekAtRequestAtIndex(0);
                        if (nextRequestPending != null) {
                            requestFound = nextRequestPending.compare(sender, args);
                        }
                        if (!requestFound) {
                            errorMsg = "MemoryServer: Unexpected onMemoryRequestCompleteEvent.\nArgs = " + args.toString() + "\nNext pending request in the targetAccessRequestQueue: " + nextRequestPending.toString() + "\nCount in queue = " + Integer.toString(this.targetAccessRequestQueue.size()) + ", Event raised for " + args.toString();
                            for (int queueIndex = 0; queueIndex < this.getTargetAccessRequestQueue().size(); ++queueIndex) {
                                RequestDescriptorBaseClass reqInQueue = this.getTargetAccessRequestQueue().peekAtRequestAtIndex(queueIndex);
                                errorMsg = errorMsg + "\n[" + Integer.toString(queueIndex) + "]: " + reqInQueue.getRequestIdStr();
                                if (reqInQueue instanceof MemoryRequestDescriptor) {
                                    MemoryRequestDescriptor memReq = (MemoryRequestDescriptor)reqInQueue;
                                    if (memReq == null) continue;
                                    errorMsg = errorMsg + ", startAdrs=0x" + Long.toHexString(memReq.getStartAdrs()) + ", length=0x" + Long.toHexString(memReq.getLengthInMAUs()) + ", type=" + memReq.getRequestType().toString();
                                    if (memReq.getClientToNotifyOnRequestComplete() != null) {
                                        errorMsg = errorMsg + ", client=" + memReq.getClientToNotifyOnRequestComplete().toString();
                                    }
                                    if (memReq.getClientToNotifyOnRequestComplete() instanceof RegisterHandler) {
                                        errorMsg = errorMsg + "Register Name = " + ((RegisterHandler)memReq.getClientToNotifyOnRequestComplete()).getName();
                                    }
                                    if (!(requestFound = memReq.compare(sender, args))) continue;
                                    nextRequestPending = memReq;
                                    if (nextRequestPending.getNumTimesNotifyCalled() == 0) {
                                        errorMsg = errorMsg + "<= Using this request (out of order!)";
                                        break;
                                    }
                                    errorMsg = errorMsg + "<= Not using this request (NumTimesNotifyCalled = " + Long.toString(nextRequestPending.getNumTimesNotifyCalled()) + ")";
                                    continue;
                                }
                                CExprRequestDescriptor evalReq = (CExprRequestDescriptor)reqInQueue;
                                errorMsg = errorMsg + ", Expression = " + evalReq.getStrCExpression() + ", client=" + evalReq.getClientToNotifyOnRequestComplete().toString();
                            }
                            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.TRANSACTIONS)) {
                                MemoryServerTrace.logTransaction(errorMsg, "MemoryServer.handleMemoryRequestCompleteEvent", this.targetHdlr.info);
                            }
                        } else if (nextRequestPending.getNumTimesNotifyCalled() == 0) {
                            requestFound = true;
                        } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.WARNINGS)) {
                            MemoryServerTrace.logWarning("NextRequestPending is still being processed - removing it from the queue. " + nextRequestPending.toString(), "MemoryServer.handleMemoryRequestCompleteEvent", this.targetHdlr.info);
                        }
                    }
                    if (requestFound) {
                        if (requestAborted) {
                            nextRequestPending.setRequestStatus(EnumMemoryRequestStates.REQUEST_ABORTED);
                        } else {
                            nextRequestPending.setRequestStatus(EnumMemoryRequestStates.REQUEST_COMPLETE);
                        }
                        nextRequestPending.setMemoryUpdateInfo(args);
                        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                            MemoryServerTrace.logInfo("About to call NotifyClient() for " + nextRequestPending.toString(), "MemoryServer.handleMemoryRequestCompleteEvent", this.targetHdlr.info);
                        }
                        this.targetAccessRequestQueue.deleteRequest(nextRequestPending, false);
                        --this.numTimesHandleMemoryRequestCompleteEventCalledSimultaneously;
                        nextRequestPending.notifyClient();
                        nextRequestPending.release();
                    } else {
                        IDspMemory dspMemoryObj;
                        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.WARNINGS)) {
                            errorMsg = "MemoryServer: Unexpected onMemoryRequestCompleteEvent:\nNo matching requests found in the targetAccessRequestQueue\nDiscarding event raised for " + args.toString();
                            MemoryServerTrace.logWarning(errorMsg, "MemoryServer.handleMemoryRequestCompleteEvent", this.targetHdlr.info);
                        }
                        if (args != null && args.getDspMemoryObj() != null && !(dspMemoryObj = (IDspMemory)args.getDspMemoryObj()).isDisposed()) {
                            dspMemoryObj.dispose();
                        }
                        --this.numTimesHandleMemoryRequestCompleteEventCalledSimultaneously;
                    }
                }
                catch (Exception exc) {
                    if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block29;
                    String argValues = "null";
                    if (args != null) {
                        argValues = args.toString();
                    }
                    if (nextRequestPending != null) {
                        MemoryServerTrace.logException("MemoryRequestCompleteEvent: Exception while processing nextRequestPending, - removing it from the queue. " + nextRequestPending.toString() + "[args: " + argValues + "]", "MemoryServer.handleMemoryRequestCompleteEvent", exc, this.targetHdlr.info);
                    }
                    MemoryServerTrace.logException("MemoryRequestCompleteEvent: Exception while processing args: " + argValues, "MemoryServer.handleMemoryRequestCompleteEvent", exc, this.targetHdlr.info);
                }
            }
            if (this.targetAccessRequestQueue.size() == 0 && this.isContinuousRefreshEventPending) {
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.EVENTS)) {
                    MemoryServerTrace.logEvent("isContinuousRefreshEventPending = true and targetAccessRequestQueue empty so flushing all host caches", "MemoryServer.handleMemoryRequestCompleteEvent", this.targetHdlr.info);
                }
                this.handleContinuousRefreshUpdateEvent(null);
            }
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.EVENTS)) {
                MemoryServerTrace.logEvent("Exiting MemoryServer.handleMemoryRequestCompleteEvent: called simultaneously " + Integer.toString(this.numTimesHandleMemoryRequestCompleteEventCalledSimultaneously) + " times.", "MemoryServer.handleMemoryRequestCompleteEvent", this.targetHdlr.info);
            }
        }
    }

    @Override
    public void handleMemoryUpdateEvent(EventObject sender, MemoryUpdateArgs args) {
        block4: {
            if (!this.isDisposed()) {
                String traceMsg = "";
                try {
                    this.targetAccessRequestQueue.peekAtFirstRequest();
                    if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.EVENTS)) {
                        MemoryServerTrace.logEvent("MemoryUpdateEvent != targetAccessQueue[0]: " + traceMsg, "MemoryServer.handleMemoryUpdateEvent", this.targetHdlr.info);
                    }
                    this.flushAllHostCachesOfTargetMemory(EnumReasonForRefresh.TARGET_MEMORY_UPDATE);
                }
                catch (Exception ex) {
                    if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block4;
                    MemoryServerTrace.logException("Exception in MemoryUpdateEventHandler: " + ex.getMessage() + ".\n" + traceMsg, "MemoryServer.handleMemoryUpdateEvent", ex, this.targetHdlr.info);
                }
            }
        }
    }

    @Override
    public void handleTargetConnectedEvent(EventObject sender) {
        if (!this.isDisposed()) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.EVENTS)) {
                MemoryServerTrace.logEvent("Target Connected", "MemoryServer.handleTargetConnectedEvent", this.targetHdlr.info);
            }
            this.targetHdlr.setIsDisconnected(false);
            this.targetHdlr.getMemLevelInfoHdlr().init();
            this.mmuHandler.requestMmuPropertiesFromDebugServer();
            this.flushAllHostCachesOfTargetMemory(EnumReasonForRefresh.TARGET_CONNECTED);
            if (this.targetHdlr.info.getXmlDeviceInfoHandler().isSendTraceEventsToOutputWindowEnabledInXmlFile()) {
                MemoryServerTrace.IsTraceSentToOutputWindow = true;
            }
            this.xmlFileDiscoveryHandler.readDeviceIds();
        }
    }

    @Override
    public void handleTargetDisconnectedEvent(EventObject sender) {
        if (!this.isDisposed()) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.EVENTS)) {
                MemoryServerTrace.logEvent("Target Disconnected", "MemoryServer.handleTargetDisconnectedEvent", this.targetHdlr.info);
            }
            this.getXmlFileDiscoveryHandler().setIsTargetDiscoveryComplete(false);
            this.targetHdlr.setIsDisconnected(true);
            this.discardAllTargetRequests();
            this.raiseOnMemoryRefreshRequiredEvent(false, (short)0, 0L, 0L, EnumReasonForRefresh.TARGET_DISCONNECTED, "OnTargetDisconnectedEvent");
        }
    }

    @Override
    public void handleTargetRestartedEvent(EventObject sender) {
        if (!this.isDisposed()) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.EVENTS)) {
                MemoryServerTrace.drawLineOfDashes();
                MemoryServerTrace.logEvent("TargetRestarted", "MemoryServer.handleTargetRestartedEvent", this.targetHdlr.info);
            }
            for (MemoryPageHandler memPage : this.memoryPageHandlerList) {
                memPage.flushServerCache();
                this.raiseOnMemoryRefreshRequiredEvent(false, memPage.getMemoryPageNumber(), this.targetHdlr.info.getMinAdrsInMemoryPage(memPage.getMemoryPageNumber()), this.targetHdlr.info.getMaxAdrsInMemoryPage(memPage.getMemoryPageNumber(), EnumMemoryViews.CPU_MEMORY_VIEW), EnumReasonForRefresh.TARGET_RESTARTED, "TargetRestartedEvent");
            }
        }
    }

    @Override
    public void handleTargetRunningEvent(EventObject sender) {
        if (!this.isDisposed()) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.EVENTS)) {
                MemoryServerTrace.logEvent("Target Running.", "MemoryServer.handleTargetRunningEvent", this.targetHdlr.info);
            }
            if (!this.targetHdlr.isRunning() || this.targetHdlr.isMemoryReadAllowed()) {
                this.flushAllHostCachesOfTargetMemory(EnumReasonForRefresh.TARGET_RUNNING);
            }
        }
    }

    @Override
    public void handleXmlFileDiscoveryCompleteEvent(EventObject sender) {
        if (!this.isDisposed()) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.EVENTS)) {
                MemoryServerTrace.logEvent("XML File Discovery Complete", "MemoryServer.handleXmlFileDiscoveryCompleteEvent", this.targetHdlr.info);
            }
            this.targetHdlr.getInfo().init();
            MemoryPageHandler memPgHdlr = this.getMemoryPageHandlerForPage((short)0);
            boolean deviceDescriptionChanged = true;
            if (memPgHdlr != null) {
                deviceDescriptionChanged = memPgHdlr.isDeviceDescriptionChanged();
            }
            if (deviceDescriptionChanged) {
                for (int index = 0; index < this.listOfRegisterHandlers.size(); ++index) {
                    RegisterHandler regHdlr = this.listOfRegisterHandlers.get(index);
                    if (regHdlr == null || regHdlr.isDisposed()) continue;
                    regHdlr.dispose();
                }
                this.listOfRegisterHandlers.clear();
            }
            this.targetHdlr.getInfo().getXmlDeviceInfoHandler().readRegisterInfoFromXmlFile(this.listOfRegisterHandlers);
            if (this.mmuHandler != null) {
                this.mmuHandler.init(this.listOfRegisterHandlers);
            }
            boolean wasMemPgHdlrInitCalled = false;
            for (short pageNum = 0; pageNum < this.targetHdlr.getInfo().getNumMemoryPages(); pageNum = (short)(pageNum + 1)) {
                memPgHdlr = this.getMemoryPageHandlerForPage(pageNum);
                if (memPgHdlr == null) continue;
                memPgHdlr.init();
                wasMemPgHdlrInitCalled = true;
            }
            if (wasMemPgHdlrInitCalled) {
                this.initMemoryHierarchyHandlerList();
                this.memoryAnalyzerList.init();
                if (this.targetHdlr.getInfo().getXmlDeviceInfoHandler().isSendTraceEventsToOutputWindowEnabledInXmlFile()) {
                    MemoryServerTrace.IsTraceSentToOutputWindow = true;
                }
                if (this.coreNumberHdlr != null) {
                    if (this.listOfRegisterHandlers != null) {
                        this.coreNumberHdlr.init(this.targetHdlr, this.listOfRegisterHandlers);
                    }
                    this.targetHdlr.info.setCoreNumber(this.getCoreNumber());
                }
                this.updateMemoryLevelVisibilitySupportedFlag();
                this.clientConfigOptionsFactory.config(this.isMemoryAnalysisSupported(), this.listOfMemoryLevelsForAllMemoryPages, this.listOfTargetCachesForAllMemoryPages, this.getMemoryAnalyzerList());
                if (this.onMemoryHierarchyUpdatedEvent != null) {
                    this.onMemoryHierarchyUpdatedEvent.raise();
                }
            } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.WARNINGS)) {
                MemoryServerTrace.logWarning("this.getMemoryPageHandlerForPage(0) == null", "MemoryServer.handleXmlFileDiscoveryCompleteEvent", this.targetHdlr.info);
            }
        }
        this.xmlFileDiscoveryWaiter.finished();
    }

    @Override
    public void handleGetRegisterContextValuesCompleteEvent(EventObject sender) {
        if (!this.isDisposed()) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.EVENTS)) {
                MemoryServerTrace.logEvent(".. raising onMemoryRefreshRequiredEvent", "MemoryServer.handleGetRegisterContextValuesCompleteEvent", this.targetHdlr.info);
            }
            RegisterList registerList = (RegisterList)sender.getSource();
            this.getCacheTagRamInfo(registerList);
            EnumReasonForRefresh reasonForRefresh = registerList.getReasonForRefresh();
            if (reasonForRefresh == EnumReasonForRefresh.NO_REASON_SPECIFIED) {
                reasonForRefresh = EnumReasonForRefresh.TARGET_HALTED;
            }
            this.raiseOnMemoryRefreshRequiredEvent(false, (short)0, 0L, 0L, reasonForRefresh, reasonForRefresh.toString());
        }
    }

    @Override
    public void handleExternalMemoryChangedEvent(EventObject sender, boolean isExtendedMemoryEnabled) {
        if (!this.isDisposed()) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.EVENTS)) {
                MemoryServerTrace.logEvent("Extended Memory enabled = " + Boolean.toString(isExtendedMemoryEnabled), "MemoryServer.handleExternalMemoryChangedEvent", this.targetHdlr.info);
            }
            EnumReasonForRefresh reasonForRefresh = EnumReasonForRefresh.MEMORY_MAP_UPDATE;
            this.raiseOnMemoryRefreshRequiredEvent(false, (short)0, 0L, 0L, reasonForRefresh, reasonForRefresh.toString());
        }
    }

    @Override
    public void handleTargetResetEvent(EventObject sender) {
        if (!this.isDisposed()) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.EVENTS)) {
                MemoryServerTrace.logEvent("Target Reset.", "MemoryServer.handleTargetResetEvent", this.targetHdlr.info);
            }
            for (MemoryPageHandler memPage : this.memoryPageHandlerList) {
                memPage.flushServerCache();
                this.raiseOnMemoryRefreshRequiredEvent(false, memPage.getMemoryPageNumber(), this.targetHdlr.info.getMinAdrsInMemoryPage(memPage.getMemoryPageNumber()), this.targetHdlr.info.getMaxAdrsInMemoryPage(memPage.getMemoryPageNumber(), EnumMemoryViews.CPU_MEMORY_VIEW), EnumReasonForRefresh.TARGET_RESET, "TargetResetEvent");
            }
        }
    }

    @Override
    public void handleNewSymbolsEvent(EventObject sender) {
        if (!this.isDisposed()) {
            if (this.getSymbolMgr() != null) {
                this.getSymbolMgr().clearSymbols();
            }
            for (short page = 0; page < this.targetHdlr.info.getNumMemoryPages(); page = (short)(page + 1)) {
                long numMAUsInPage = this.targetHdlr.info.getMaxAdrsInMemoryPage(page, EnumMemoryViews.CPU_MEMORY_VIEW) - this.targetHdlr.info.getMinAdrsInMemoryPage(page) + 1L;
                this.raiseOnMemoryRefreshRequiredEvent(false, page, this.targetHdlr.info.getMinAdrsInMemoryPage(page), numMAUsInPage, EnumReasonForRefresh.SYMBOL_UPDATE, "OnNewSymbolEvent");
            }
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.EVENTS)) {
                MemoryServerTrace.logEvent("New Symbols.", "MemoryServer.handleNewSymbolsEvent", this.targetHdlr.info);
            }
        }
    }

    @Override
    public void handleContinuousRefreshUpdateEvent(EventObject sender) {
        this.isContinuousRefreshEventPending = false;
        if (!this.isDisposed() && !this.targetHdlr.isDisconnected() && this.onClientContinuousRefreshEvent.getNumListeners() > 0) {
            if (this.getTargetAccessRequestQueue().size() == 0) {
                RefreshRequiredEventArgs args = new RefreshRequiredEventArgs(false, 0, 0L, 0L, EnumReasonForRefresh.TARGET_REAL_TIME_UPDATE, EnumReasonForRefresh.TARGET_REAL_TIME_UPDATE.toString());
                this.onClientContinuousRefreshEvent.raise(args);
            } else {
                this.isContinuousRefreshEventPending = true;
            }
        }
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public synchronized void dispose() {
        if (!this.disposed) {
            if (this.xmlFileDiscoveryHandler != null) {
                this.xmlFileDiscoveryHandler.onXmlFileDiscoveryComplete.removeListener(this);
            }
            if (!this.xmlFileDiscoveryHandler.isDisposed()) {
                this.xmlFileDiscoveryHandler.dispose();
            }
            this.xmlFileDiscoveryHandler = null;
            if (this.mmuHandler != null && !this.mmuHandler.isDisposed()) {
                this.mmuHandler.dispose();
            }
            this.mmuHandler = null;
            if (this.refreshTokenFactory != null && !this.refreshTokenFactory.isDisposed()) {
                this.refreshTokenFactory.dispose();
            }
            this.refreshTokenFactory = null;
            if (this.clientConfigOptionsFactory != null && !this.clientConfigOptionsFactory.isDisposed()) {
                this.clientConfigOptionsFactory.dispose();
            }
            this.clientConfigOptionsFactory = null;
            if (this.memoryRequestDescriptorFactory != null && !this.memoryRequestDescriptorFactory.isDisposed()) {
                this.memoryRequestDescriptorFactory.dispose();
            }
            this.memoryRequestDescriptorFactory = null;
            if (this.cExprEvalRequestDescriptorFactory != null && !this.cExprEvalRequestDescriptorFactory.isDisposed()) {
                this.cExprEvalRequestDescriptorFactory.dispose();
            }
            this.cExprEvalRequestDescriptorFactory = null;
            if (this.listOfRegisterHandlers != null) {
                this.listOfRegisterHandlers.onGetRegisterContextValuesComplete.removeListener(this);
            }
            if (!this.listOfRegisterHandlers.isDisposed()) {
                this.listOfRegisterHandlers.dispose();
            }
            this.listOfRegisterHandlers = null;
            if (this.symbolMgr != null && !this.symbolMgr.isDisposed()) {
                this.symbolMgr.dispose();
            }
            this.symbolMgr = null;
            DeviceXMLReader.getInstance(this.targetHdlr.getMemoryServerXmlPath()).storeCachedDevices();
            if (this.targetHdlr != null && !this.targetHdlr.isDisposed()) {
                if (this.targetHdlr.getEventHandler() != null) {
                    this.targetHdlr.getEventHandler().removeEventListener(this);
                }
                this.targetHdlr.dispose();
            }
            this.targetHdlr = null;
            if (this.memoryPageHandlerList != null) {
                for (MemoryPageHandler memPgHdlr : this.memoryPageHandlerList) {
                    if (memPgHdlr.isDisposed()) continue;
                    memPgHdlr.dispose();
                }
                this.memoryPageHandlerList.clear();
            }
            this.memoryPageHandlerList = null;
            MemoryServerTrace.closeLogs();
        }
        this.disposed = true;
    }

    private class XMLFileDiscoveryWaiter {
        boolean alreadyDone = false;

        private XMLFileDiscoveryWaiter() {
        }

        public synchronized void waitUntilFinished() {
            if (!this.alreadyDone) {
                try {
                    this.wait(60000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public synchronized void finished() {
            this.notify();
            this.alreadyDone = true;
        }
    }

    private class ConfigOptionsReader {
        boolean isMemoryAnalysisEnabled = false;
        boolean isMemoryLevelVisibilityEnabled = false;
        EnumMemoryLevelIndex levelIndex = EnumMemoryLevelIndex.NONE;

        ConfigOptionsReader(ClientConfigOptions cfgOptions) {
            if (cfgOptions != null) {
                this.isMemoryAnalysisEnabled = cfgOptions.isMemoryAnalysisEnabled();
                this.isMemoryLevelVisibilityEnabled = cfgOptions.isMemoryLevelVisibilityEnabled();
                ConfigOption_MemoryLevelVisibilityOptionList memLevelVisOptionList = null;
                for (IConfigOption option : cfgOptions) {
                    if (!(option instanceof ConfigOption_MemoryLevelVisibilityOptionList)) continue;
                    memLevelVisOptionList = (ConfigOption_MemoryLevelVisibilityOptionList)option;
                    break;
                }
                if (memLevelVisOptionList != null && !memLevelVisOptionList.isDefaultMemoryLevelBypass()) {
                    for (IConfigOption option : memLevelVisOptionList.getNestedConfigOptionList()) {
                        ConfigOption_MemoryLevelEnable memLevelEnableOption = (ConfigOption_MemoryLevelEnable)option;
                        if (memLevelEnableOption.isBypassed()) continue;
                        this.levelIndex = memLevelEnableOption.getMemoryLevelIndex();
                        break;
                    }
                }
            }
        }

        public EnumMemoryLevelIndex getLevelIndex() {
            return this.levelIndex;
        }

        public boolean IsMemAnalysisEnabled() {
            return this.isMemoryAnalysisEnabled;
        }

        public boolean IsMemVisibilityEnabled() {
            return this.isMemoryAnalysisEnabled;
        }
    }

    private class TiledRequestSegment {
        private long tiledAddress;
        private int blockSizeInMaus;

        public TiledRequestSegment(long tiledAddress, int blockSizeInMaus) {
            this.tiledAddress = tiledAddress;
            this.blockSizeInMaus = blockSizeInMaus;
        }

        public long getTiledAddress() {
            return this.tiledAddress;
        }

        public int getBlockSizeInMaus() {
            return this.blockSizeInMaus;
        }
    }

    private class MultipleRequestsClient
    implements IMemoryRequestClient {
        int numOfRequests;
        int numOfRequestsCompleted = 0;
        SortedMap<Long, ArrayList<IMemoryItem>> requestAddressMemoryInfoMap = new TreeMap<Long, ArrayList<IMemoryItem>>();
        int dataSizeInMaus;
        MemoryRequestDescriptor keyIntoItemsMapping = null;
        CountDownLatch latch;

        public MultipleRequestsClient(int numOfRequests, int dataSizeInMaus) {
            this.numOfRequests = numOfRequests;
            this.dataSizeInMaus = dataSizeInMaus;
            this.latch = new CountDownLatch(numOfRequests);
        }

        public void setCountDownLatch(CountDownLatch latch) {
            this.latch = latch;
        }

        public MemoryRequestDescriptor getKeyIntoItems() {
            return this.keyIntoItemsMapping;
        }

        @Override
        public synchronized void onMemoryRequestCompleteHandler(MemoryRequestDescriptor memoryRequestDescriptor, long requestStartAdrs, long requestLengthInMAUs) {
            ++this.numOfRequestsCompleted;
            int numMemoryItemsNeeded = (int)(requestLengthInMAUs / (long)this.dataSizeInMaus);
            ArrayList<IMemoryItem> listOfIMemoryItems = new ArrayList<IMemoryItem>();
            for (int i = 0; i < numMemoryItemsNeeded; ++i) {
                MemoryItem item = new MemoryItem();
                listOfIMemoryItems.add(item);
            }
            EnumMemoryServerErrorCodes[] errorCode = new EnumMemoryServerErrorCodes[]{EnumMemoryServerErrorCodes.OK};
            MemoryServer.this.readMemoryItems(requestStartAdrs, listOfIMemoryItems, memoryRequestDescriptor, errorCode);
            if (errorCode[0] != EnumMemoryServerErrorCodes.OK) {
                // empty if block
            }
            this.requestAddressMemoryInfoMap.put(new Long(requestStartAdrs), listOfIMemoryItems);
            if (this.numOfRequests == this.numOfRequestsCompleted) {
                ArrayList<IMemoryItem> combinedValues = new ArrayList<IMemoryItem>();
                for (ArrayList<IMemoryItem> items : this.requestAddressMemoryInfoMap.values()) {
                    combinedValues.addAll(items);
                }
                requestToItemsMapping.put(memoryRequestDescriptor, combinedValues);
            }
            this.keyIntoItemsMapping = memoryRequestDescriptor;
            this.latch.countDown();
        }

        @Override
        public void onCExpressionEvaluationCompleteHandler(CExprRequestDescriptor cExprEvalRequestDescriptor) {
        }
    }
}

