/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver;

import com.ti.ccstudio.debug.memoryserver.MemoryServer;
import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.interfaces.IDisposable;
import com.ti.ccstudio.debug.memoryserver.interfaces.IMemoryServer;
import com.ti.ccstudio.debug.memoryserver.target.TargetHandler;
import com.ti.debug.engine.IDspTask;

public class MemoryServerHandler
implements IDisposable {
    private final TargetHandler target;
    private final MemoryServer memoryServerInstance;
    private long numReferences = 0L;
    private boolean isNonDebuggableDevice = false;
    private String boardName = "";
    private volatile boolean disposed = false;

    MemoryServerHandler(String boardName, IDspTask dspTask, String targetDatabaseDirectoryPath) {
        this.boardName = boardName;
        TargetHandler newTarget = new TargetHandler(boardName, dspTask, targetDatabaseDirectoryPath);
        newTarget.init();
        String procDescription = newTarget.info.getStrTargetDescription();
        MemoryServer memServer = new MemoryServer(newTarget);
        memServer.init();
        this.memoryServerInstance = memServer;
        this.target = newTarget;
        this.numReferences = 0L;
    }

    TargetHandler getTarget() {
        return this.target;
    }

    IMemoryServer getMemoryServerInstance() {
        ++this.numReferences;
        MemoryServer result = null;
        if (!this.isDisposed()) {
            result = this.memoryServerInstance;
        }
        return result;
    }

    public boolean isNonDebuggableDevice() {
        return this.isNonDebuggableDevice;
    }

    public void setIsNonDebuggableDevice(boolean value) {
        this.target.info.setIsNonDebuggableDevice(value);
        this.isNonDebuggableDevice = value;
    }

    public boolean isDisconnected() {
        if (this.target != null) {
            return this.target.isDisconnected();
        }
        return true;
    }

    public String getTaskName() {
        if (this.target != null) {
            return this.target.getTaskName();
        }
        return "Not Found";
    }

    public String getBoardName() {
        return this.boardName;
    }

    public String toString() {
        String result = "Not Found";
        if (this.target != null) {
            result = this.target.info.getStrTargetProcessorId() + " " + this.target.info.getStrTargetTypeId() + " (" + this.getTaskName() + ")";
        }
        return result;
    }

    public boolean containsMemoryServer(IMemoryServer instance) {
        boolean result = false;
        if (this.memoryServerInstance.equals(instance)) {
            result = true;
        }
        return result;
    }

    public synchronized void release() {
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
            MemoryServerTrace.logInfo("MemoryServerHandler.release() called with NumReferences = " + String.valueOf(this.numReferences), "MemoryServerHandler.dispose()", this.target.getInfo());
        }
        if (this.numReferences > 0L) {
            --this.numReferences;
            if (this.numReferences == 0L && !this.isDisposed()) {
                this.dispose();
            }
        }
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public synchronized void dispose() {
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
            MemoryServerTrace.logInfo("MemoryServerHandler.dispose() called with NumReferences = " + String.valueOf(this.numReferences), "MemoryServerHandler.dispose()", this.target.getInfo());
        }
        if (!(this.disposed || this.memoryServerInstance.equals(null) || this.memoryServerInstance.isDisposed())) {
            this.memoryServerInstance.dispose();
            if (this.target != null) {
                this.target.dispose();
            }
        }
        this.disposed = true;
    }
}

