/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver;

import com.ti.ccstudio.debug.memoryserver.MemoryServerHandler;
import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.interfaces.IDisposable;
import com.ti.ccstudio.debug.memoryserver.interfaces.IMemoryServer;
import com.ti.debug.engine.IDspTask;
import com.ti.debug.engine.IOSAwareManager;
import com.ti.debug.engine.xpcom.Runtime;
import com.ti.utility.filesystem.FSUtil;
import com.ti.utility.filesystem.SWIGTYPE_p_FSUtil;
import java.io.File;
import java.util.Vector;

public class MemoryServerManager
implements IDisposable {
    static final String PLUGIN_ID = "com.ti.ccstudio.debug.memoryserver";
    private final String sCacheInfoDir = "CacheInfo";
    private static MemoryServerManager instance = null;
    private final Vector<MemoryServerHandler> listOfMemoryServerHandlers = new Vector();
    private final boolean disableOnRunningEventNotification = false;
    private static long numReferences = 0L;
    private String debugServerDirectoryPath = "";
    private String memoryServerXmlPath = "";
    private volatile boolean disposed = false;

    public static synchronized MemoryServerManager getInstance() {
        if (instance == null) {
            instance = new MemoryServerManager();
        }
        ++numReferences;
        return instance;
    }

    private MemoryServerManager() {
        Runtime.getInstance();
        String XPCOMDirPath = FSUtil.FSUtil_Get_XPCOM_Dir((SWIGTYPE_p_FSUtil)Runtime.getFSUtil());
        File XPCOMDir = new File(XPCOMDirPath);
        File cacheInfoDirParent = XPCOMDir.getParentFile();
        this.memoryServerXmlPath = cacheInfoDirParent + File.separator + "CacheInfo" + File.separator;
        this.InitlistOfMemoryServers();
        MemoryServerTrace.readEnvSettings();
    }

    private int InitlistOfMemoryServers() {
        this.listOfMemoryServerHandlers.clear();
        return this.listOfMemoryServerHandlers.size();
    }

    public String getDebugServerDirectoryPath() {
        return this.debugServerDirectoryPath;
    }

    public String getMemoryServerXmlPath() {
        return this.memoryServerXmlPath;
    }

    public synchronized IMemoryServer getMemoryServer(String taskName) {
        IDspTask dspTask = null;
        IOSAwareManager osAwareMgr = null;
        IMemoryServer result = null;
        for (MemoryServerHandler memoryServerItem : this.listOfMemoryServerHandlers) {
            if (memoryServerItem.getTarget().getTaskName() != taskName) continue;
            dspTask = memoryServerItem.getTarget().getDspTask();
            result = memoryServerItem.getMemoryServerInstance();
            break;
        }
        if (dspTask == null) {
            for (MemoryServerHandler memoryServerItem : this.listOfMemoryServerHandlers) {
                if (taskName.indexOf(memoryServerItem.getTarget().getTaskName() + "//") != 0) continue;
                osAwareMgr = memoryServerItem.getTarget().getDspTask().getOSAwareManager();
                boolean isTaskLevelDebuggingEnabled = osAwareMgr.isTaskLevelDebugEnabled();
                osAwareMgr.dispose();
                if (!isTaskLevelDebuggingEnabled) continue;
                Object listOfUOEs = null;
                boolean numUOEs = false;
                break;
            }
        }
        if (dspTask != null && result == null) {
            MemoryServerHandler memoryServerItem = new MemoryServerHandler("", dspTask, this.getMemoryServerXmlPath());
            result = memoryServerItem.getMemoryServerInstance();
        }
        return result;
    }

    public synchronized IMemoryServer getMemoryServer(IDspTask dspTask) {
        IMemoryServer instance = null;
        for (MemoryServerHandler memSrvHdlr : this.listOfMemoryServerHandlers) {
            if (memSrvHdlr == null || memSrvHdlr.getTarget().getDspTask() != dspTask) continue;
            instance = memSrvHdlr.getMemoryServerInstance();
            break;
        }
        if (instance == null) {
            MemoryServerHandler memSrvHdlr = null;
            memSrvHdlr = new MemoryServerHandler(dspTask.getName(), dspTask, this.getMemoryServerXmlPath());
            if (memSrvHdlr != null) {
                boolean isNonDebuggableDevice = false;
                if (dspTask.getTargetType().startsWith("CS_DAP")) {
                    isNonDebuggableDevice = true;
                }
                if (!dspTask.getTargetType().startsWith("ICEPick")) {
                    isNonDebuggableDevice = true;
                }
                memSrvHdlr.setIsNonDebuggableDevice(isNonDebuggableDevice);
                this.listOfMemoryServerHandlers.add(memSrvHdlr);
            }
            instance = memSrvHdlr.getMemoryServerInstance();
        }
        return instance;
    }

    public synchronized void releaseMemoryServer(IMemoryServer instance) {
        MemoryServerHandler memSrvHdlr = null;
        for (int index = 0; index < this.listOfMemoryServerHandlers.size(); ++index) {
            memSrvHdlr = this.listOfMemoryServerHandlers.get(index);
            if (!memSrvHdlr.containsMemoryServer(instance)) continue;
            memSrvHdlr.release();
            this.listOfMemoryServerHandlers.remove(index);
            break;
        }
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public synchronized void dispose() {
        if (--numReferences == 0L) {
            if (!this.disposed) {
                MemoryServerHandler memSrvHdlr = null;
                for (int index = 0; index < this.listOfMemoryServerHandlers.size(); ++index) {
                    memSrvHdlr = this.listOfMemoryServerHandlers.get(index);
                    memSrvHdlr.release();
                }
                this.listOfMemoryServerHandlers.clear();
            }
            this.disposed = true;
        }
    }
}

