/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver;

import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.interfaces.ITargetDeviceInfo;
import com.ti.ccstudio.debug.memoryserver.target.TargetDeviceInfo;
import com.ti.debug.engine.IDspTask;
import com.ti.logger.DSLoggerTypes;
import com.ti.logger.impl.DSLogger;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;

public class MemoryServerTrace {
    public static boolean IsHaltTraceOnError = false;
    public static boolean IsHaltTraceOnWarning = false;
    public static boolean IsTraceSentToOutputWindow = false;
    public static boolean IsTraceSentToErrorLog = false;
    public static boolean IsTimestampEnabled = false;
    public static boolean IsTargetNameEnabled = false;
    public static boolean IsTraceErrorsEnabled = false;
    public static boolean IsTraceWarningsEnabled = false;
    public static boolean IsTraceTransactionsEnabled = false;
    public static boolean IsTraceEventsEnabled = false;
    public static boolean IsTraceInfoEnabled = false;
    public static boolean IsTraceVerboseEnabled = false;
    public static boolean IsTraceObjectLifecycleEnabled = false;
    public static long verboseTraceMaxAdrs = -8L;
    public static long verboseTraceMinAdrs = -1L;
    public static int prevTimeInMs = 0;
    private static boolean ignoreAsserts = false;
    public static int CtrvTraceLevel = 0;
    public static int MptvTraceLevel = 0;
    public static String LogFileName = "";
    public static FileWriter logFileOutputStream = null;
    private static HashMap<EnumTraceLevel, Integer> TraceLevelToDSLoggerLevelMap = new HashMap();
    private static HashMap<EnumTraceLevel, DSLoggerTypes.LogMessageType> TraceLevelToDSLoggerTypeMap;

    public static void readEnvSettings() {
        String value = System.getenv("MS_TRACE_LOG_FILE");
        if (value != null && !value.trim().equals("")) {
            LogFileName = value;
            MemoryServerTrace.setMinTraceLevel(EnumTraceLevel.VERBOSE);
            ignoreAsserts = true;
        }
    }

    public static boolean IsTraceOptionEnabled(EnumTraceLevel traceLevel) {
        boolean result = false;
        switch (traceLevel) {
            case ERRORS: {
                result = IsTraceErrorsEnabled || DSLogger.getLogger().isEnabled();
                break;
            }
            case WARNINGS: {
                result = IsTraceWarningsEnabled || DSLogger.getLogger().isEnabled();
                break;
            }
            case TRANSACTIONS: {
                result = IsTraceTransactionsEnabled;
                break;
            }
            case EVENTS: {
                result = IsTraceEventsEnabled || DSLogger.getLogger().isEnabled();
                break;
            }
            case INFO: {
                result = IsTraceInfoEnabled;
                break;
            }
            case VERBOSE: {
                result = IsTraceVerboseEnabled;
                break;
            }
            case OBJECT_LIFECYCLE: {
                result = IsTraceObjectLifecycleEnabled;
            }
        }
        return result;
    }

    public static void setLog(Object log) {
    }

    public static void setMinTraceLevel(EnumTraceLevel traceLevel) {
        if (traceLevel.compareTo(EnumTraceLevel.VERBOSE) == 0) {
            IsTraceVerboseEnabled = true;
            IsTraceInfoEnabled = true;
            IsTraceEventsEnabled = true;
            IsTraceTransactionsEnabled = true;
            IsTraceWarningsEnabled = true;
            IsTraceErrorsEnabled = true;
        }
        if (traceLevel.compareTo(EnumTraceLevel.INFO) == 0) {
            IsTraceVerboseEnabled = false;
            IsTraceInfoEnabled = true;
            IsTraceEventsEnabled = true;
            IsTraceTransactionsEnabled = true;
            IsTraceWarningsEnabled = true;
            IsTraceErrorsEnabled = true;
        }
        if (traceLevel.compareTo(EnumTraceLevel.EVENTS) == 0) {
            IsTraceVerboseEnabled = false;
            IsTraceInfoEnabled = false;
            IsTraceEventsEnabled = true;
            IsTraceTransactionsEnabled = true;
            IsTraceWarningsEnabled = true;
            IsTraceErrorsEnabled = true;
        }
        if (traceLevel.compareTo(EnumTraceLevel.TRANSACTIONS) == 0) {
            IsTraceVerboseEnabled = false;
            IsTraceInfoEnabled = false;
            IsTraceEventsEnabled = false;
            IsTraceTransactionsEnabled = true;
            IsTraceWarningsEnabled = true;
            IsTraceErrorsEnabled = true;
        }
        if (traceLevel.compareTo(EnumTraceLevel.WARNINGS) == 0) {
            IsTraceVerboseEnabled = false;
            IsTraceInfoEnabled = false;
            IsTraceEventsEnabled = false;
            IsTraceTransactionsEnabled = false;
            IsTraceWarningsEnabled = true;
            IsTraceErrorsEnabled = true;
        }
        if (traceLevel.compareTo(EnumTraceLevel.ERRORS) == 0) {
            IsTraceVerboseEnabled = false;
            IsTraceInfoEnabled = false;
            IsTraceEventsEnabled = false;
            IsTraceTransactionsEnabled = false;
            IsTraceWarningsEnabled = false;
            IsTraceErrorsEnabled = true;
        }
        if (traceLevel.compareTo(EnumTraceLevel.NONE) == 0) {
            IsTraceVerboseEnabled = false;
            IsTraceInfoEnabled = false;
            IsTraceEventsEnabled = false;
            IsTraceTransactionsEnabled = false;
            IsTraceWarningsEnabled = false;
            IsTraceErrorsEnabled = false;
        }
    }

    public static void logException(String strMessage, String strSenderName, Exception ex, ITargetDeviceInfo targetInfo) {
        MemoryServerTrace.logToDSLogger(targetInfo, EnumTraceLevel.ERRORS, strMessage, strSenderName);
    }

    public static void logError(String strMessage, String strSenderName, ITargetDeviceInfo targetInfo) {
        MemoryServerTrace.logToDSLogger(targetInfo, EnumTraceLevel.ERRORS, strMessage, strSenderName);
    }

    public static void logWarning(String strMessage, String strSenderName, ITargetDeviceInfo targetInfo) {
        MemoryServerTrace.logToDSLogger(targetInfo, EnumTraceLevel.WARNINGS, strMessage, strSenderName);
    }

    public static void logTransaction(String strMessage, String strSenderName, ITargetDeviceInfo targetInfo) {
        MemoryServerTrace.logToDSLogger(targetInfo, EnumTraceLevel.WARNINGS, strMessage, strSenderName);
    }

    public static void logEvent(String strMessage, String strSenderName, ITargetDeviceInfo targetInfo) {
        MemoryServerTrace.logToDSLogger(targetInfo, EnumTraceLevel.EVENTS, strMessage, strSenderName);
    }

    public static void logInfo(String strMessage, String strSenderName, ITargetDeviceInfo targetInfo) {
        MemoryServerTrace.logToDSLogger(targetInfo, EnumTraceLevel.INFO, strMessage, strSenderName);
    }

    public static void logVerbose(String strMessage, String strSenderName, ITargetDeviceInfo targetInfo) {
        MemoryServerTrace.logToDSLogger(targetInfo, EnumTraceLevel.VERBOSE, strMessage, strSenderName);
    }

    public static void logLifecycle(String strMessage, String strSenderName, ITargetDeviceInfo targetInfo) {
        MemoryServerTrace.logToDSLogger(targetInfo, EnumTraceLevel.OBJECT_LIFECYCLE, strMessage, strSenderName);
    }

    public static void drawLineOfDashes() {
        MemoryServerTrace.logString("-------------------------------------------------------------------");
    }

    public static void log(boolean raiseAssert, EnumTraceLevel traceLevel, boolean drawLineOfDashes, String strMessage, String strSenderName, Exception ex, String strTargetDescription) {
    }

    public static void logString(EnumTraceLevel traceLevel, String strTargetName, String strSenderName, String str, Exception ex) {
    }

    public static void logString(String str) {
        MemoryServerTrace.logToDSLogger(null, EnumTraceLevel.INFO, str, "Cache View");
    }

    public static void closeLogs() {
        if (logFileOutputStream != null) {
            try {
                logFileOutputStream.close();
            }
            catch (IOException e) {
                System.out.print("Exception closing log output file:" + e.getMessage() + "\n");
                e.printStackTrace();
            }
        }
        logFileOutputStream = null;
        LogFileName = "";
    }

    private static void logToDSLogger(ITargetDeviceInfo targetInfo, EnumTraceLevel traceLevel, String str, String sender) {
        Integer level;
        IDspTask dspTask = null;
        if (targetInfo instanceof TargetDeviceInfo) {
            dspTask = ((TargetDeviceInfo)targetInfo).getDspTask();
        }
        if ((level = TraceLevelToDSLoggerLevelMap.get((Object)traceLevel)) != null && level != -1) {
            String stringToLog = sender + " : " + str;
            if (DSLogger.getLogger().isEnabled()) {
                DSLogger.getLogger().log(dspTask, DSLoggerTypes.LogComponent.LOG_JAVA_MEMORY_SERVER, level.intValue(), TraceLevelToDSLoggerTypeMap.get((Object)traceLevel), stringToLog);
            }
        }
    }

    static {
        TraceLevelToDSLoggerLevelMap.put(EnumTraceLevel.NONE, -1);
        TraceLevelToDSLoggerLevelMap.put(EnumTraceLevel.ERRORS, 3);
        TraceLevelToDSLoggerLevelMap.put(EnumTraceLevel.WARNINGS, 3);
        TraceLevelToDSLoggerLevelMap.put(EnumTraceLevel.EVENTS, 3);
        TraceLevelToDSLoggerLevelMap.put(EnumTraceLevel.INFO, 3);
        TraceLevelToDSLoggerLevelMap.put(EnumTraceLevel.VERBOSE, -1);
        TraceLevelToDSLoggerLevelMap.put(EnumTraceLevel.OBJECT_LIFECYCLE, -1);
        TraceLevelToDSLoggerTypeMap = new HashMap();
        TraceLevelToDSLoggerTypeMap.put(EnumTraceLevel.ERRORS, DSLoggerTypes.LogMessageType.LOG_ERROR);
        TraceLevelToDSLoggerTypeMap.put(EnumTraceLevel.WARNINGS, DSLoggerTypes.LogMessageType.LOG_WARNING);
        TraceLevelToDSLoggerTypeMap.put(EnumTraceLevel.EVENTS, DSLoggerTypes.LogMessageType.LOG_INFORMATION);
        TraceLevelToDSLoggerTypeMap.put(EnumTraceLevel.INFO, DSLoggerTypes.LogMessageType.LOG_INFORMATION);
        TraceLevelToDSLoggerTypeMap.put(EnumTraceLevel.NONE, DSLoggerTypes.LogMessageType.LOG_INFORMATION);
        TraceLevelToDSLoggerTypeMap.put(EnumTraceLevel.VERBOSE, DSLoggerTypes.LogMessageType.LOG_INFORMATION);
        TraceLevelToDSLoggerTypeMap.put(EnumTraceLevel.OBJECT_LIFECYCLE, DSLoggerTypes.LogMessageType.LOG_INFORMATION);
    }
}

