/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver;

import com.ti.ccstudio.debug.memoryserver.RequestDspValue;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryRequestStates;
import com.ti.ccstudio.debug.memoryserver.interfaces.IMemoryRequestParameters;
import com.ti.ccstudio.debug.memoryserver.memoryhierarchy.MemLevelInfoHdlr;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.MemoryRequestDescriptor;
import com.ti.debug.engine.IDspMemory;
import com.ti.debug.engine.IDspTask;
import com.ti.debug.engine.IDspValue;
import com.ti.debug.engine.IMemoryAccess;
import com.ti.debug.engine.events.data.IMemoryAccessEventData;
import com.ti.debug.engine.events.types.IObjectEventListener;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class MemoryWrite {
    private static final ExecutorService pool = Executors.newFixedThreadPool(2);
    RequestDspValue requestDspValue;

    public MemoryWrite(long writeAddress, String writeData, IMemoryRequestParameters memRequestParams, MemoryRequestDescriptor requestDesc, IDspTask dspTask, MemLevelInfoHdlr memLevelInfo) {
        this.requestDspValue = new RequestDspValue(dspTask, memRequestParams, writeData);
        this.createMemoryWriteRequest(writeAddress, dspTask, memRequestParams, requestDesc, memLevelInfo);
    }

    private void createMemoryWriteRequest(long writeAddress, IDspTask dspTask, IMemoryRequestParameters memRequestParams, final MemoryRequestDescriptor requestDesc, MemLevelInfoHdlr memLevelInfo) {
        IDspMemory memoryObj = null;
        IMemoryAccess access = dspTask.getMemoryAccess();
        IDspValue dspValue = this.requestDspValue.getDspValue();
        memoryObj = access.createDspMemory(access.createDspValue(IDspValue.Type.UDATA64, writeAddress), this.requestDspValue.getDataSizeInMaus(), memRequestParams.getPageNumber());
        memoryObj.setDspValue(dspValue, 0);
        int memAccess = memLevelInfo.calculateMemAccessIdFlags(memRequestParams.getMemoryView(), 0);
        memoryObj.getIDspMemory2().setMemoryAccessLevel(memAccess);
        access.requestMemoryWrite(memoryObj, (IObjectEventListener)new IObjectEventListener<IMemoryAccessEventData>(){

            public void onEvent(IMemoryAccessEventData data) {
                final boolean aborted = data.wasRequestAborted();
                pool.execute(new Runnable(){

                    @Override
                    public void run() {
                        requestDesc.setRequestStatus(aborted ? EnumMemoryRequestStates.REQUEST_ABORTED : EnumMemoryRequestStates.REQUEST_COMPLETE);
                        requestDesc.notifyClient();
                    }
                });
            }
        });
    }

    public long getNextAdrs(long adrs) {
        return adrs + (long)this.requestDspValue.getDataSizeInMaus();
    }
}

