/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver;

import com.ti.ccstudio.debug.memoryserver.enums.EnumDspValueType;
import com.ti.ccstudio.debug.memoryserver.enums.EnumStringFormatStyle;
import com.ti.ccstudio.debug.memoryserver.interfaces.IMemoryRequestParameters;
import com.ti.ccstudio.debug.memoryserver.util.BaseConverter;
import com.ti.debug.engine.IDspTask;
import com.ti.debug.engine.IDspValue;
import com.ti.debug.engine.impl.DspValue;

public class RequestDspValue {
    private int formattedDataSizeInMaus = -1;
    private IDspValue wrappedDspValue = null;

    public RequestDspValue(IDspTask dspTask, IMemoryRequestParameters params) {
        this(dspTask, params, null);
    }

    public RequestDspValue(IDspTask dspTask, IMemoryRequestParameters params, String data) {
        this.wrappedDspValue = dspTask.getMemoryAccess().createDspValue(IDspValue.Type.INT, 0L);
        if (data != null) {
            this.wrappedDspValue.parseString(RequestDspValue.cleanData(data, params.getDSPStringFormat(), params.getDSPValueType()));
        }
        IDspValue.Type type = DspValue.translateToDspValueTypeEnum((int)params.getDSPValueType().getInt());
        this.wrappedDspValue.typeCast(type, (int)params.getQValue());
        this.formattedDataSizeInMaus = this.wrappedDspValue.sizeOf2(params.getPageNumber());
    }

    public int getDataSizeInMaus() {
        return this.formattedDataSizeInMaus;
    }

    public IDspValue getDspValue() {
        return this.wrappedDspValue;
    }

    private static String cleanData(String data, EnumStringFormatStyle style, EnumDspValueType type) {
        String cleanWriteData = data.trim();
        boolean isValidWriteData = true;
        switch (style) {
            case REAL: 
            case SCIENTIFIC: {
                if (type != EnumDspValueType.DSP_IEEE_DOUBLE && type != EnumDspValueType.DSP_DOUBLE && type != EnumDspValueType.DSP_LDOUBLE) break;
                cleanWriteData = cleanWriteData + "d";
                break;
            }
            case CHARACTER: 
            case PACKED_CHAR: {
                cleanWriteData = "0x" + Long.toHexString(BaseConverter.fromCharStringToULong(cleanWriteData));
                break;
            }
            case BINARY: {
                if (cleanWriteData.endsWith("b")) {
                    cleanWriteData = cleanWriteData.substring(0, cleanWriteData.length() - 1);
                }
                if (!(isValidWriteData = BaseConverter.isBin(cleanWriteData))) break;
                cleanWriteData = "0x" + Long.toHexString(BaseConverter.fromBinStringToULong(cleanWriteData));
                break;
            }
            case OCTAL: {
                isValidWriteData = BaseConverter.isOct(cleanWriteData);
                if (!isValidWriteData) break;
                cleanWriteData = "0x" + Long.toHexString(BaseConverter.fromOctStringToULong(cleanWriteData));
                break;
            }
            case TI_STYLE_HEX: {
                cleanWriteData = cleanWriteData.replace("0x", "");
                cleanWriteData = "0x" + cleanWriteData;
                break;
            }
        }
        if (!isValidWriteData) {
            throw new IllegalArgumentException(" Unable to parse data : " + data);
        }
        return cleanWriteData.toLowerCase();
    }
}

