/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.analyzers;

import com.ti.ccstudio.debug.memoryserver.MemoryRead;
import com.ti.ccstudio.debug.memoryserver.MemoryServer;
import com.ti.ccstudio.debug.memoryserver.analyzers.IMemoryAnalyzer;
import com.ti.ccstudio.debug.memoryserver.analyzers.MemoryAnalysisDescriptor;
import com.ti.ccstudio.debug.memoryserver.memoryhierarchy.MemoryHierarchyHandler;
import com.ti.ccstudio.debug.memoryserver.memoryhierarchy.MemoryTypeDescriptor;
import com.ti.ccstudio.debug.memoryserver.memoryinfoitems.MemoryItem;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.MemoryRequestDescriptor;
import com.ti.ccstudio.debug.memoryserver.target.TargetHandler;
import java.util.ArrayList;
import java.util.List;

public class MemoryAnalyzeDifferences
implements IMemoryAnalyzer {
    private MemoryRequestDescriptor myReq = null;
    protected MemoryServer memoryServer = null;
    protected TargetHandler targetHdlr = null;
    protected short primaryAddressSpaceId = 0;
    protected boolean analyzeDataMemory = false;
    protected boolean analyzeProgramMemory = true;
    private short ownersMemoryPageNum = 0;
    private String strAnalysisResultPreamble = "Different values in memory hierarchy:";
    private boolean isEnabledByDefault = false;
    protected String shortDescription = "Memory Differences";
    protected String longDescription = "Compares the contents of mapped memory with the value stored in cache and highlights addresses where the two are different";

    public short getOwnersMemoryPageNum() {
        return this.ownersMemoryPageNum;
    }

    public void setOwnersMemoryPageNum(short value) {
        this.ownersMemoryPageNum = value;
    }

    public String getStrAnalysisResultPreamble() {
        return this.strAnalysisResultPreamble;
    }

    public void setStrAnalysisResultPreamble(String value) {
        this.strAnalysisResultPreamble = value;
    }

    @Override
    public boolean isEnabledByDefault() {
        return this.isEnabledByDefault;
    }

    @Override
    public void setIsEnabledByDefault(boolean value) {
        this.isEnabledByDefault = value;
    }

    @Override
    public void config(TargetHandler target, MemoryServer memServer) {
        this.targetHdlr = target;
        this.memoryServer = memServer;
        if (this.myReq == null) {
            this.myReq = (MemoryRequestDescriptor)this.memoryServer.getTargetAccessRequestQueue().getRequestDescriptorFactory().createInstance();
        }
    }

    @Override
    public boolean canBeEnabled() {
        MemoryHierarchyHandler memHierarchyHdlr = null;
        int numInvolvedLevelsInMemHierarchy = 0;
        boolean result = false;
        if (this.targetHdlr.getInfo().getNumMemoryPages() > 1) {
            memHierarchyHdlr = this.memoryServer.getMemoryHierarchyHandler(this.primaryAddressSpaceId);
            numInvolvedLevelsInMemHierarchy = memHierarchyHdlr.getListOfMemoryViews().size();
            if (numInvolvedLevelsInMemHierarchy > 1) {
                result = true;
            }
        } else {
            memHierarchyHdlr = this.memoryServer.getMemoryHierarchyHandler((short)0);
            for (MemoryTypeDescriptor memType : memHierarchyHdlr.getListOfMemoryLevels()) {
                if (this.analyzeDataMemory) {
                    if (!memType.isDataMemory()) continue;
                    ++numInvolvedLevelsInMemHierarchy;
                    continue;
                }
                if (!this.analyzeProgramMemory || !memType.isProgramMemory()) continue;
                ++numInvolvedLevelsInMemHierarchy;
            }
            if (numInvolvedLevelsInMemHierarchy > 1) {
                result = true;
            }
        }
        return result;
    }

    @Override
    public boolean isCacheTagRamInfoNeededForAnalysis() {
        return false;
    }

    @Override
    public boolean isTargetMemoryPageInvolvedInAnalysis(short memPageNum, short requestedMemPageNum) {
        boolean result = false;
        int numInvolvedLevelsInMemHierarchy = 0;
        MemoryHierarchyHandler memHierarchyHdlr = this.memoryServer.getMemoryHierarchyHandler(memPageNum);
        for (MemoryTypeDescriptor memType : memHierarchyHdlr.getListOfMemoryLevels()) {
            if (this.analyzeDataMemory) {
                if (!memType.isDataMemory()) continue;
                ++numInvolvedLevelsInMemHierarchy;
                continue;
            }
            if (!this.analyzeProgramMemory || !memType.isProgramMemory()) continue;
            ++numInvolvedLevelsInMemHierarchy;
        }
        if (numInvolvedLevelsInMemHierarchy > 0) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean isMemoryViewInvolvedInAnalysis(int viewIndex, short requestedMemPageNum) {
        return true;
    }

    @Override
    public boolean isAdrsHighlightingRequired(long targetAdrs, MemoryRequestDescriptor req, String[] analysisResult) {
        analysisResult[0] = "";
        boolean result = false;
        MemoryRead memoryRead = req.getReadRequest();
        ArrayList<MemoryAnalysisDescriptor> listOfValues = new ArrayList<MemoryAnalysisDescriptor>();
        List<MemoryTypeDescriptor> memLevels = memoryRead.getListOfMemoryViews();
        int formattedDataIndex = memoryRead.getFormattedDataIndex(targetAdrs);
        for (int index = 1; index < memLevels.size(); ++index) {
            MemoryItem item;
            MemoryTypeDescriptor memLevel = memLevels.get(index);
            if ((!this.analyzeDataMemory || !memLevel.isDataMemory()) && (!this.analyzeProgramMemory || !memLevel.isProgramMemory()) || !memoryRead.populateMemoryItem(formattedDataIndex, item = new MemoryItem(), index, false)) continue;
            String value = item.getDataValue();
            MemoryAnalysisDescriptor memLevelValueDescriptor = new MemoryAnalysisDescriptor(value, memLevel, "", null);
            listOfValues.add(memLevelValueDescriptor);
        }
        if (listOfValues.size() > 0) {
            int numDifferences = 0;
            String val = ((MemoryAnalysisDescriptor)listOfValues.get(listOfValues.size() - 1)).getDataValue();
            for (MemoryAnalysisDescriptor memLevelValueObj : listOfValues) {
                if (memLevelValueObj.getDataValue().equals(val)) continue;
                result = true;
                analysisResult[0] = numDifferences == 0 ? this.getStrAnalysisResultPreamble() : analysisResult[0] + ", ";
                ++numDifferences;
                analysisResult[0] = analysisResult[0] + memLevelValueObj.getMemType().getLevelName();
            }
        }
        return result;
    }

    @Override
    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String value) {
        this.shortDescription = value;
    }

    @Override
    public String getLongDescription() {
        return this.longDescription;
    }

    public void setLongDescription(String value) {
        this.longDescription = value;
    }

    @Override
    public String getToolTipText() {
        return this.shortDescription + ": Check to enable this analyzer.  Uncheck to reduce display time";
    }
}

