/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.analyzers;

import com.ti.ccstudio.debug.memoryserver.MemoryServer;
import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.memoryhierarchy.MemoryHierarchyHandler;
import com.ti.ccstudio.debug.memoryserver.memoryhierarchy.MemoryTypeDescriptor;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.MemoryRequestDescriptor;
import com.ti.ccstudio.debug.memoryserver.target.TargetHandler;

public abstract class MemoryAnalyzerCacheLineState {
    protected MemoryServer memoryServer = null;
    protected TargetHandler targetHdlr = null;
    private String strAnalysisResultPreamble = "";
    protected String shortDescription = "Cache Line Status";
    protected String longDescription = "Highlights addresses that are cached and indicates the status of the cache lines (dirty, LRU)";
    private boolean isEnabledByDefault = false;

    public abstract boolean isMemTypeInvolvedInAnalysis(MemoryTypeDescriptor var1);

    public abstract boolean isAdrsToBeHighlighted(MemoryTypeDescriptor var1, long var2);

    public String getStrAnalysisResultPreamble() {
        return this.strAnalysisResultPreamble;
    }

    public void setStrAnalysisResultPreamble(String value) {
        this.strAnalysisResultPreamble = value;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String value) {
        this.shortDescription = value;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public void setLongDescription(String value) {
        this.longDescription = value;
    }

    public String getToolTipText() {
        return "Check to enable this analyzer.  Uncheck to reduce display time";
    }

    public void config(TargetHandler target, MemoryServer memServer) {
        this.targetHdlr = target;
        this.memoryServer = memServer;
    }

    public boolean isEnabledByDefault() {
        return this.isEnabledByDefault;
    }

    public void setIsEnabledByDefault(boolean value) {
        this.isEnabledByDefault = value;
    }

    public boolean canBeEnabled() {
        boolean result = false;
        for (short memPageNum = 0; memPageNum < this.targetHdlr.getInfo().getNumMemoryPages(); memPageNum = (short)(memPageNum + 1)) {
            MemoryHierarchyHandler memHierarchyHdlr = this.memoryServer.getMemoryHierarchyHandler(memPageNum);
            for (MemoryTypeDescriptor memType : memHierarchyHdlr.getListOfTargetCaches()) {
                if (!this.isMemTypeInvolvedInAnalysis(memType)) continue;
                result = true;
                break;
            }
            if (result) break;
        }
        return result;
    }

    public boolean isMemoryViewInvolvedInAnalysis(int viewIndex, short requestedMemPageNum) {
        boolean result = false;
        MemoryHierarchyHandler memHierarchyHdlr = this.memoryServer.getMemoryHierarchyHandler(requestedMemPageNum);
        MemoryTypeDescriptor memType = memHierarchyHdlr.getListOfMemoryViews().get(viewIndex);
        if (this.isMemTypeInvolvedInAnalysis(memType)) {
            result = true;
        }
        return result;
    }

    public boolean isCacheTagRamInfoNeededForAnalysis() {
        return true;
    }

    public boolean isTargetMemoryPageInvolvedInAnalysis(short memPageNum, short requestedMemPageNum) {
        boolean result = false;
        if (memPageNum == requestedMemPageNum) {
            result = true;
        }
        return result;
    }

    public boolean isAdrsHighlightingRequired(long targetAdrs, MemoryRequestDescriptor req, String[] analysisResult) {
        boolean result;
        block5: {
            result = false;
            short memPageNumber = req.getTargetMemoryPageNumber();
            analysisResult[0] = this.getStrAnalysisResultPreamble();
            MemoryHierarchyHandler memHierarchyHdlr = this.memoryServer.getMemoryHierarchyHandler(memPageNumber);
            try {
                if (this.isTargetMemoryPageInvolvedInAnalysis(memPageNumber, memPageNumber)) {
                    for (MemoryTypeDescriptor cacheMemType : memHierarchyHdlr.getListOfTargetCaches()) {
                        if (!this.isMemTypeInvolvedInAnalysis(cacheMemType) || !this.isAdrsToBeHighlighted(cacheMemType, targetAdrs)) continue;
                        result = true;
                        analysisResult[0] = analysisResult[0] + cacheMemType.getLevelName() + " ";
                    }
                }
            }
            catch (Exception e) {
                if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block5;
                MemoryServerTrace.logException(e.getMessage(), "MemoryAnalyzerCacheLineState.isAdrsHighlightingRequired", e, this.targetHdlr.getInfo());
            }
        }
        if (!result) {
            analysisResult[0] = "";
        }
        return result;
    }
}

