/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.analyzers;

import com.ti.ccstudio.debug.memoryserver.analyzers.IMemoryAnalyzer;
import com.ti.ccstudio.debug.memoryserver.analyzers.MemoryAnalyzerCacheLineState;
import com.ti.ccstudio.debug.memoryserver.memoryhierarchy.MemoryTypeDescriptor;

public class MemoryAnalyzerDirtyBits
extends MemoryAnalyzerCacheLineState
implements IMemoryAnalyzer {
    public MemoryAnalyzerDirtyBits() {
        this.setShortDescription("Dirty Cache Lines");
        this.setLongDescription("Highlights cached memory addresses that have been marked as dirty");
        this.setIsEnabledByDefault(true);
        this.setStrAnalysisResultPreamble("");
    }

    @Override
    public boolean isAdrsToBeHighlighted(MemoryTypeDescriptor memType, long adrs) {
        boolean result = false;
        if (this.isMemTypeInvolvedInAnalysis(memType) && memType.isCacheEnabled() && memType.getCacheTagRamHandler() != null && memType.getCacheTagRamHandler().isCacheLineDirty(adrs)) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean isMemTypeInvolvedInAnalysis(MemoryTypeDescriptor memType) {
        boolean result = false;
        if (memType.isCacheTagRamDecodingSupported() && memType.getCacheTagRamHandler() != null && memType.getCacheTagRamHandler().isCacheDirtyBitAccessible()) {
            result = true;
        }
        return result;
    }
}

