/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.analyzers;

import com.ti.ccstudio.debug.memoryserver.MemoryServer;
import com.ti.ccstudio.debug.memoryserver.analyzers.IMemoryAnalyzer;
import com.ti.ccstudio.debug.memoryserver.analyzers.MemoryAnalyzeDataDifferences;
import com.ti.ccstudio.debug.memoryserver.analyzers.MemoryAnalyzeProgramDifferences;
import com.ti.ccstudio.debug.memoryserver.analyzers.MemoryAnalyzerDirtyBits;
import com.ti.ccstudio.debug.memoryserver.analyzers.MemoryAnalyzerLRU;
import com.ti.ccstudio.debug.memoryserver.target.TargetHandler;
import java.util.ArrayList;
import java.util.Iterator;

public class MemoryAnalyzerList
implements Iterable<IMemoryAnalyzer>,
Iterator<IMemoryAnalyzer> {
    private ArrayList<IMemoryAnalyzer> analyzerList;
    private MemoryServer owner;
    private TargetHandler target;
    private int currentIndex = -1;

    public MemoryAnalyzerList(MemoryServer owner, TargetHandler target) {
        this.owner = owner;
        this.target = target;
        this.analyzerList = new ArrayList();
        this.init();
    }

    public IMemoryAnalyzer get(int analyzerIndex) {
        if (analyzerIndex > this.analyzerList.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.analyzerList.get(analyzerIndex);
    }

    public int size() {
        return this.analyzerList.size();
    }

    public void init() {
        IMemoryAnalyzer analyzer = null;
        this.analyzerList.clear();
        analyzer = new MemoryAnalyzeProgramDifferences();
        analyzer.config(this.target, this.owner);
        if (analyzer.canBeEnabled()) {
            this.analyzerList.add(analyzer);
        }
        analyzer = new MemoryAnalyzeDataDifferences();
        analyzer.config(this.target, this.owner);
        if (analyzer.canBeEnabled()) {
            this.analyzerList.add(analyzer);
        }
        analyzer = new MemoryAnalyzerDirtyBits();
        analyzer.config(this.target, this.owner);
        if (analyzer.canBeEnabled()) {
            this.analyzerList.add(analyzer);
        }
        analyzer = new MemoryAnalyzerLRU();
        analyzer.config(this.target, this.owner);
        if (analyzer.canBeEnabled()) {
            this.analyzerList.add(analyzer);
        }
    }

    public void add(IMemoryAnalyzer analyzerObj) {
        this.analyzerList.add(analyzerObj);
    }

    public void remove(IMemoryAnalyzer analyzerObj) {
        this.analyzerList.remove(analyzerObj);
    }

    public void clear() {
        this.analyzerList.clear();
    }

    public void reset() {
        this.currentIndex = -1;
    }

    public IMemoryAnalyzer getCurrent() {
        IMemoryAnalyzer result = null;
        if (this.analyzerList.size() > this.currentIndex) {
            result = this.analyzerList.get(this.currentIndex);
        }
        return result;
    }

    public boolean moveNext() {
        boolean result = false;
        if (this.currentIndex + 1 < this.analyzerList.size()) {
            ++this.currentIndex;
            result = true;
        }
        return result;
    }

    @Override
    public Iterator<IMemoryAnalyzer> iterator() {
        this.reset();
        return this;
    }

    @Override
    public boolean hasNext() {
        boolean result = false;
        if (this.currentIndex < this.size() - 1) {
            result = true;
        }
        return result;
    }

    @Override
    public IMemoryAnalyzer next() {
        IMemoryAnalyzer result = null;
        if (this.hasNext()) {
            ++this.currentIndex;
            result = this.getCurrent();
        }
        return result;
    }

    @Override
    public void remove() {
        if (this.currentIndex >= 0 && this.currentIndex < this.analyzerList.size()) {
            this.analyzerList.remove(this.currentIndex);
            if (this.currentIndex >= this.analyzerList.size()) {
                this.currentIndex = this.analyzerList.size() - 1;
            }
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public void remove(int index) {
        if (index < 0 || index >= this.analyzerList.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.analyzerList.remove(index);
    }
}

