/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.configoptions;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.configoptions.ClientConfigOptionsFactory;
import com.ti.ccstudio.debug.memoryserver.configoptions.ConfigOption;
import com.ti.ccstudio.debug.memoryserver.configoptions.ConfigOptionList;
import com.ti.ccstudio.debug.memoryserver.configoptions.ConfigOption_MemoryAnalysisEnable;
import com.ti.ccstudio.debug.memoryserver.configoptions.ConfigOption_MemoryLevelEnable;
import com.ti.ccstudio.debug.memoryserver.configoptions.ConfigOption_MemoryLevelVisibilityOptionList;
import com.ti.ccstudio.debug.memoryserver.configoptions.ConfigOption_MmuBypassOptionList;
import com.ti.ccstudio.debug.memoryserver.configoptions.EnumMemoryLevelVisibilityMode;
import com.ti.ccstudio.debug.memoryserver.configoptions.IClientConfigOptions;
import com.ti.ccstudio.debug.memoryserver.configoptions.IConfigOption;
import com.ti.ccstudio.debug.memoryserver.configoptions.IConfigOptionList;
import com.ti.ccstudio.debug.memoryserver.enums.EnumAttributeTypeFlags;
import com.ti.ccstudio.debug.memoryserver.enums.EnumFactoryObjectStates;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.interfaces.IFactoryCreatedObject;
import com.ti.ccstudio.debug.memoryserver.interfaces.IRecyclingFactory;
import java.util.EnumSet;

public class ClientConfigOptions
extends ConfigOptionList
implements IConfigOptionList,
IFactoryCreatedObject,
IClientConfigOptions {
    private IRecyclingFactory factory = null;
    private String factoryObjectId = "";
    private EnumFactoryObjectStates factoryObjectState = EnumFactoryObjectStates.CREATED;
    private volatile boolean disposed = false;

    public ClientConfigOptions(String name) {
        super(name, null);
    }

    public ClientConfigOptions(ClientConfigOptions objToCopyFrom) {
        super(objToCopyFrom.getName(), (ConfigOption)objToCopyFrom);
        this.setOwner(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientConfigOptions clone() {
        ClientConfigOptions result = new ClientConfigOptions(this);
        ClientConfigOptions clientConfigOptions = this;
        synchronized (clientConfigOptions) {
            for (IConfigOption option : this) {
                result.add(option.clone(result));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMemoryAnalysisEnabled() {
        boolean result = false;
        ClientConfigOptions clientConfigOptions = this;
        synchronized (clientConfigOptions) {
            for (IConfigOption option : this) {
                if (!(option instanceof ConfigOption_MemoryAnalysisEnable)) continue;
                result = ((ConfigOption_MemoryAnalysisEnable)option).isMemoryAnalysisEnabled();
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIsMemoryAnalysisEnabled(boolean value) {
        ClientConfigOptions clientConfigOptions = this;
        synchronized (clientConfigOptions) {
            for (IConfigOption option : this) {
                if (!(option instanceof ConfigOption_MemoryAnalysisEnable)) continue;
                ((ConfigOption_MemoryAnalysisEnable)option).setIsMemoryAnalysisEnabled(value);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableProgramCacheVisibility() {
        ClientConfigOptions clientConfigOptions = this;
        synchronized (clientConfigOptions) {
            ConfigOption_MemoryLevelEnable memLevelEnableOption = null;
            ClientConfigOptions clientConfigOptions2 = this;
            synchronized (clientConfigOptions2) {
                for (IConfigOption cfgOption : this.getList()) {
                    if (!(cfgOption instanceof ConfigOption_MemoryLevelVisibilityOptionList)) continue;
                    for (IConfigOption option : cfgOption.getNestedConfigOptionList()) {
                        if (!(option instanceof ConfigOption_MemoryLevelEnable) || !(memLevelEnableOption = (ConfigOption_MemoryLevelEnable)option).isBypassed() || !memLevelEnableOption.isCache() || !memLevelEnableOption.getMemoryTypeDescriptor().isProgramMemory()) continue;
                        memLevelEnableOption.setIsOptionEnabled(true);
                        memLevelEnableOption.setIsBypassed(false);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IConfigOptionList getListOfMemoryAnalyzerOptions() {
        IConfigOptionList result = null;
        ClientConfigOptions clientConfigOptions = this;
        synchronized (clientConfigOptions) {
            for (IConfigOption option : this) {
                if (!(option instanceof ConfigOption_MemoryAnalysisEnable)) continue;
                result = ((ConfigOption_MemoryAnalysisEnable)option).getNestedConfigOptionList();
                break;
            }
        }
        return result;
    }

    @Override
    public EnumMemoryLevelVisibilityMode getMemoryLevelVisibilityMode() {
        EnumMemoryLevelVisibilityMode result = EnumMemoryLevelVisibilityMode.NONE;
        ConfigOption_MemoryLevelVisibilityOptionList memLevelVisOptionList = this.getMemLevelVisOptionList();
        if (memLevelVisOptionList != null) {
            result = memLevelVisOptionList.getSelectedVisibilityMode();
        }
        return result;
    }

    @Override
    public void setMemoryLevelVisibilityMode(EnumMemoryLevelVisibilityMode value) {
        ConfigOption_MemoryLevelVisibilityOptionList memLevelVisOptionList = this.getMemLevelVisOptionList();
        if (memLevelVisOptionList != null) {
            memLevelVisOptionList.setSelectedVisibilityMode(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigOption_MemoryLevelVisibilityOptionList getMemLevelVisOptionList() {
        ConfigOption_MemoryLevelVisibilityOptionList result = null;
        ClientConfigOptions clientConfigOptions = this;
        synchronized (clientConfigOptions) {
            for (IConfigOption option : this) {
                if (!(option instanceof ConfigOption_MemoryLevelVisibilityOptionList)) continue;
                result = (ConfigOption_MemoryLevelVisibilityOptionList)option;
                break;
            }
        }
        return result;
    }

    @Override
    public String getMemoryLevelVisibilityTooltipText() {
        ConfigOption_MemoryLevelVisibilityOptionList list = this.getMemLevelVisOptionList();
        return list.getTooltipText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMemoryLevelVisibilityEnabled() {
        boolean result = false;
        ClientConfigOptions clientConfigOptions = this;
        synchronized (clientConfigOptions) {
            for (IConfigOption option : this) {
                if (!(option instanceof ConfigOption_MemoryLevelVisibilityOptionList)) continue;
                result = ((ConfigOption_MemoryLevelVisibilityOptionList)option).isOptionEnabled();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVirtualMemorySupported() {
        boolean result = false;
        ClientConfigOptions clientConfigOptions = this;
        synchronized (clientConfigOptions) {
            for (IConfigOption option : this.getList()) {
                if (!(option instanceof ConfigOption_MmuBypassOptionList)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAnyLevelOfMemoryBypassed() {
        boolean result = false;
        ConfigOption_MemoryLevelEnable memLevelEnableOption = null;
        ClientConfigOptions clientConfigOptions = this;
        synchronized (clientConfigOptions) {
            for (IConfigOption option : this.getList()) {
                if (!(option instanceof ConfigOption_MemoryLevelEnable) || !(memLevelEnableOption = (ConfigOption_MemoryLevelEnable)option).isOptionEnabled() || !memLevelEnableOption.isBypassed()) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnumSet<EnumAttributeTypeFlags> getAttributeFlags() {
        EnumSet<EnumAttributeTypeFlags> result = EnumSet.of(EnumAttributeTypeFlags.LOCATION_IN_MEMORY_HIERARCHY);
        ClientConfigOptions clientConfigOptions = this;
        synchronized (clientConfigOptions) {
            for (IConfigOption option : this) {
                if (!(option instanceof ConfigOption_MemoryAnalysisEnable)) continue;
                result = ((ConfigOption_MemoryAnalysisEnable)option).getAttributeFlags();
            }
        }
        return result;
    }

    @Override
    public IRecyclingFactory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(IRecyclingFactory value) {
        this.factory = value;
    }

    @Override
    public String getFactoryObjectId() {
        return this.factoryObjectId;
    }

    @Override
    public void setFactoryObjectId(String value) {
        this.factoryObjectId = value;
    }

    @Override
    public String getFactoryObjectStatus() {
        return this.getName() + " : " + this.factoryObjectState.toString() + "(factoryObjectId = " + this.factoryObjectId + ")";
    }

    @Override
    public void setFactoryObjectState(EnumFactoryObjectStates value) {
        this.factoryObjectState = value;
    }

    @Override
    public void release() {
        this.factory.onRelease(this);
    }

    @Override
    public void getUpdatesFromFactory() {
        ClientConfigOptionsFactory factory = (ClientConfigOptionsFactory)this.getFactory();
        if (factory != null) {
            ClientConfigOptions newDefaults = factory.getDefaultClientConfigOptions();
            int numDefaultOptions = newDefaults.getList().size();
            for (int index = 0; index < numDefaultOptions; ++index) {
                ConfigOption newDefaultOption = (ConfigOption)newDefaults.getList().get(index);
                if (this.getList().size() <= index) {
                    this.getList().add(newDefaultOption.clone(this));
                    continue;
                }
                IConfigOption optionToUpdate = this.getList().get(index);
                if (optionToUpdate.getName().equalsIgnoreCase(newDefaultOption.getName()) && optionToUpdate.getConfigOptionType().compareTo(newDefaultOption.getConfigOptionType()) == 0) {
                    optionToUpdate.setDefaultValue(newDefaultOption);
                    continue;
                }
                this.getList().add(index, newDefaultOption.clone(this));
            }
            while (this.getList().size() > numDefaultOptions) {
                this.getList().remove(numDefaultOptions);
            }
        } else {
            throw new NullPointerException("null Factory object in " + this.getName());
        }
    }

    public void setFactoryDefaults() {
        ClientConfigOptionsFactory factory = (ClientConfigOptionsFactory)this.getFactory();
        if (factory == null) {
            throw new NullPointerException("null Factory object in " + this.getName());
        }
        factory.setDefaultClientConfigOptions(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        String result = "";
        ClientConfigOptions clientConfigOptions = this;
        synchronized (clientConfigOptions) {
            for (IConfigOption option : this) {
                result = result + option.toString() + "\n";
            }
        }
        return result;
    }

    @Override
    public void dispose(IRecyclingFactory factory) {
        if (factory == this.getFactory()) {
            this.dispose(true);
        } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
            MemoryServerTrace.logError("Attempt to dispose of IFactoryCreatedObject by a caller that was not the factory that created it", "ClientConfigOptions.dispose", null);
        }
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    protected synchronized void dispose(boolean disposing) {
        if (this.disposed || disposing) {
            // empty if block
        }
        this.disposed = true;
    }
}

