/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.configoptions;

import com.ti.ccstudio.debug.memoryserver.MemoryServer;
import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.analyzers.IMemoryAnalyzer;
import com.ti.ccstudio.debug.memoryserver.analyzers.MemoryAnalyzerList;
import com.ti.ccstudio.debug.memoryserver.configoptions.ClientConfigOptions;
import com.ti.ccstudio.debug.memoryserver.configoptions.ConfigOption;
import com.ti.ccstudio.debug.memoryserver.configoptions.ConfigOptionList;
import com.ti.ccstudio.debug.memoryserver.configoptions.ConfigOption_Boolean;
import com.ti.ccstudio.debug.memoryserver.configoptions.ConfigOption_CacheBoundaryMarkerOptionList;
import com.ti.ccstudio.debug.memoryserver.configoptions.ConfigOption_MemoryAnalysisEnable;
import com.ti.ccstudio.debug.memoryserver.configoptions.ConfigOption_MemoryLevelEnable;
import com.ti.ccstudio.debug.memoryserver.configoptions.ConfigOption_MemoryLevelVisibilityOptionList;
import com.ti.ccstudio.debug.memoryserver.configoptions.ConfigOption_MmuBypassOptionList;
import com.ti.ccstudio.debug.memoryserver.configoptions.IConfigOption;
import com.ti.ccstudio.debug.memoryserver.enums.EnumFactoryObjectStates;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.interfaces.IFactoryCreatedObject;
import com.ti.ccstudio.debug.memoryserver.interfaces.IFactoryObjectCreator;
import com.ti.ccstudio.debug.memoryserver.interfaces.ITargetHandler;
import com.ti.ccstudio.debug.memoryserver.memoryhierarchy.MemoryTypeDescriptor;
import com.ti.ccstudio.debug.memoryserver.util.RecyclingFactory;
import java.util.ArrayList;
import java.util.Vector;

public class ClientConfigOptionsFactory
extends RecyclingFactory
implements IFactoryObjectCreator {
    private MemoryServer memoryServer = null;
    private ITargetHandler targetHdlr = null;
    private String targetName = "";
    private final Vector<IConfigOption> list = new Vector();
    private boolean isMemoryAnalysisSupported = false;
    private boolean isVirtualMemorySupported = false;
    private boolean isCacheTagRamSupported = false;
    private ClientConfigOptions defaultClientConfigOptions = null;
    private int factoryObjID = 0;

    public ClientConfigOptionsFactory(String name, MemoryServer memoryServer, ITargetHandler targetHdlr) {
        super(name, null);
        this.memoryServer = memoryServer;
        this.targetHdlr = targetHdlr;
        this.targetName = targetHdlr.getInfo().getStrTargetDescription();
    }

    public Vector<IConfigOption> getConfigOptionList() {
        return this.list;
    }

    public boolean isMemoryLevelVisibilitySupported() {
        boolean result = false;
        if (this.memoryServer != null && !this.memoryServer.isDisposed()) {
            result = this.memoryServer.isMemoryLevelVisibilitySupported();
        }
        return result;
    }

    public boolean isMemoryAnalysisSupported() {
        return this.isMemoryAnalysisSupported;
    }

    public boolean isVirtualMemorySupported() {
        return this.isVirtualMemorySupported;
    }

    public boolean isCacheTagRamSupported() {
        return this.isCacheTagRamSupported;
    }

    public void config(boolean isMemoryAnalysisSupported, ArrayList<MemoryTypeDescriptor> listOfMemoryLevels, ArrayList<MemoryTypeDescriptor> listOfCaches, MemoryAnalyzerList memoryAnalyzerList) {
        super.setFactoryObjectCreator(this);
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
            MemoryServerTrace.logInfo("config called [...", "ClientConfigOptions.config()", this.targetHdlr.getInfo());
        }
        this.isMemoryAnalysisSupported = !this.isMemoryLevelVisibilitySupported() ? false : isMemoryAnalysisSupported;
        this.isVirtualMemorySupported = this.memoryServer.isMmuBypassSupported();
        ClientConfigOptions newListOfOptions = new ClientConfigOptions(this.targetName);
        newListOfOptions.setFactory(this);
        ConfigOptionList memLevelEnableList = null;
        int rank = 0;
        if (this.isMemoryLevelVisibilitySupported()) {
            memLevelEnableList = new ConfigOptionList(this.targetName + " Memory Level Enables", (ConfigOption)newListOfOptions);
            for (MemoryTypeDescriptor memType : listOfMemoryLevels) {
                if (memType.isCacheTagRamDecodingSupported()) {
                    this.isCacheTagRamSupported = true;
                }
                memLevelEnableList.add(new ConfigOption_MemoryLevelEnable(memType, rank++, memType.isBypassedByDefault(), "Configuration", 0, memType.getMemoryLevelToolTipText(), memLevelEnableList));
            }
            newListOfOptions.add(new ConfigOption_MemoryLevelVisibilityOptionList(newListOfOptions, memLevelEnableList));
            newListOfOptions.add(new ConfigOption_CacheBoundaryMarkerOptionList(newListOfOptions, listOfCaches));
        }
        if (this.isVirtualMemorySupported) {
            newListOfOptions.add(new ConfigOption_MmuBypassOptionList(newListOfOptions, true));
        }
        if (this.isMemoryAnalysisSupported) {
            ConfigOptionList listOfMemoryAnalyzerOptions = new ConfigOptionList("List of Memory Analyzers", (ConfigOption)newListOfOptions);
            int analyzerRank = 0;
            for (IMemoryAnalyzer analyzer : memoryAnalyzerList) {
                if (!analyzer.canBeEnabled()) continue;
                ConfigOption_Boolean analyzerOption = new ConfigOption_Boolean(analyzer.getShortDescription(), analyzerRank++, analyzer.isEnabledByDefault(), "Memory Analysis", 0, analyzer.getLongDescription(), (ConfigOption)listOfMemoryAnalyzerOptions, null, analyzer.isEnabledByDefault());
                analyzerOption.setMemoryServerOwnedTagObject(analyzer);
                listOfMemoryAnalyzerOptions.getList().add(analyzerOption);
            }
            newListOfOptions.add(new ConfigOption_MemoryAnalysisEnable(newListOfOptions, listOfMemoryAnalyzerOptions, this.isCacheTagRamSupported));
        }
        this.setDefaultClientConfigOptions(newListOfOptions);
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
            MemoryServerTrace.logInfo(newListOfOptions.toString() + "\nconfig complete ...]", "ClientConfigOptions.config()", this.targetHdlr.getInfo());
        }
    }

    public void setDefaultClientConfigOptions(ClientConfigOptions objToGetDefaultsFrom) {
        this.defaultClientConfigOptions = objToGetDefaultsFrom.clone();
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
            String summary = "\n" + this.defaultClientConfigOptions.toString();
            MemoryServerTrace.logInfo(summary, "ClientConfigOptionsFactory.setDefaultClientConfigOptions", null);
        }
    }

    public ClientConfigOptions getDefaultClientConfigOptions() {
        return this.defaultClientConfigOptions;
    }

    @Override
    public IFactoryCreatedObject createObject() {
        ClientConfigOptions result = this.defaultClientConfigOptions.clone();
        result.setFactoryObjectId(Integer.toString(this.factoryObjID++));
        return result;
    }

    @Override
    public synchronized IFactoryCreatedObject createInstance() {
        IFactoryCreatedObject instance;
        if (this.freeQueue.size() > 0) {
            instance = (IFactoryCreatedObject)this.freeQueue.get(0);
            this.freeQueue.remove(instance);
            ((ClientConfigOptions)instance).getUpdatesFromFactory();
            this.inUseQueue.add(instance);
        } else {
            instance = this.createObject();
            instance.setFactoryObjectState(EnumFactoryObjectStates.CREATED);
            instance.setFactory(this);
            this.inUseQueue.add(instance);
        }
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.OBJECT_LIFECYCLE)) {
            MemoryServerTrace.logLifecycle(instance.getFactoryObjectStatus(), this.getName() + " Factory.CreateInstance", null);
        }
        instance.setFactoryObjectState(EnumFactoryObjectStates.IN_USE);
        return instance;
    }

    public boolean isMemoryAnalysisRequired() {
        boolean result = false;
        for (int index = 0; index < this.inUseQueue.size(); ++index) {
            IFactoryCreatedObject object = (IFactoryCreatedObject)this.inUseQueue.get(index);
            ClientConfigOptions configOptions = (ClientConfigOptions)object;
            if (!configOptions.isMemoryAnalysisEnabled() && !configOptions.isAnyLevelOfMemoryBypassed()) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public synchronized void onRelease(IFactoryCreatedObject factoryObj) {
        ClientConfigOptions clientConfigOptions = (ClientConfigOptions)factoryObj;
        clientConfigOptions.clear();
        super.onRelease(factoryObj);
    }
}

