/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.configoptions;

import com.ti.ccstudio.debug.memoryserver.configoptions.ConfigOptionList;
import com.ti.ccstudio.debug.memoryserver.configoptions.EnumConfigOptionType;
import com.ti.ccstudio.debug.memoryserver.configoptions.IConfigOption;
import com.ti.ccstudio.debug.memoryserver.configoptions.IConfigOptionList;

public abstract class ConfigOption
implements IConfigOption,
Cloneable {
    private String categoryName = "";
    private int categoryRank = 0;
    private EnumConfigOptionType configOptionType = EnumConfigOptionType.STRING;
    private String description = "";
    private String name = "";
    protected ConfigOptionList nestedConfigOptionList = null;
    protected ConfigOption owner = null;
    private int rank = 0;
    private Object tagObject = null;
    private Object memoryServerOwnedTagObject;
    private boolean isOptionEnabled = true;
    private boolean isEventNotificationDisabled = true;

    public ConfigOption(String configOptionName, EnumConfigOptionType configOptionType, int rank, String categoryName, int categoryRank, String description, ConfigOption owner, ConfigOptionList nestedConfigOptionList, boolean isOptionEnabled) {
        this.name = configOptionName;
        this.configOptionType = configOptionType;
        this.rank = rank;
        this.categoryName = categoryName;
        this.categoryRank = categoryRank;
        this.description = description;
        this.owner = owner;
        this.nestedConfigOptionList = nestedConfigOptionList;
        this.isOptionEnabled = isOptionEnabled;
    }

    @Override
    public abstract IConfigOption clone(IConfigOption var1);

    @Override
    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String value) {
        this.categoryName = value;
    }

    @Override
    public int getCategoryRank() {
        return this.categoryRank;
    }

    public void setCategoryRank(int value) {
        this.categoryRank = value;
    }

    @Override
    public EnumConfigOptionType getConfigOptionType() {
        return this.configOptionType;
    }

    public void setConfigOptionType(EnumConfigOptionType value) {
        this.configOptionType = value;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    @Override
    public IConfigOptionList getNestedConfigOptionList() {
        return this.nestedConfigOptionList;
    }

    public void setNestedConfigOptionList(IConfigOptionList value) {
        this.nestedConfigOptionList = (ConfigOptionList)value;
    }

    @Override
    public IConfigOption getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(IConfigOption value) {
        this.owner = (ConfigOption)value;
    }

    @Override
    public int getRank() {
        return this.rank;
    }

    @Override
    public void setRank(int value) {
        this.rank = value;
    }

    @Override
    public Object getTagObject() {
        return this.tagObject;
    }

    @Override
    public void setTagObject(Object value) {
        this.tagObject = value;
    }

    public Object getMemoryServerOwnedTagObject() {
        return this.memoryServerOwnedTagObject;
    }

    public void setMemoryServerOwnedTagObject(Object value) {
        this.memoryServerOwnedTagObject = value;
    }

    @Override
    public boolean isOptionEnabled() {
        return this.isOptionEnabled;
    }

    @Override
    public void setIsOptionEnabled(boolean value) {
        this.isOptionEnabled = value;
    }

    @Override
    public boolean isEventNotificationDisabled() {
        return this.isEventNotificationDisabled;
    }

    @Override
    public void setIsEventNotificationDisabled(boolean value) {
        this.isEventNotificationDisabled = value;
    }

    @Override
    public abstract boolean validate(Object var1, String[] var2);

    public abstract String getCurrentValueAsString();

    public abstract void setCurrentValueFromString(String var1);

    @Override
    public abstract void setCurrentValue(IConfigOption var1);

    @Override
    public abstract void setDefaultValue(IConfigOption var1);

    @Override
    public abstract boolean isCurrentValueEqualToDefault();

    @Override
    public String getTooltipText() {
        return this.getName() + ":" + this.getCurrentValueAsString();
    }

    @Override
    public boolean hasNestedConfigOptionList() {
        return this.nestedConfigOptionList != null;
    }

    @Override
    public String getXmlPropertyName() {
        String result = this.name.replace(" ", "%20");
        return result;
    }

    @Override
    public String getValueAsXmlString() {
        String result = this.getCurrentValueAsString().replace(" ", "%20");
        return result;
    }

    @Override
    public void setValueFromXmlString(String xmlString) {
        String newValue = xmlString.replace("%20", " ");
        this.setCurrentValueFromString(newValue);
    }

    @Override
    public abstract boolean isNestedConfigOptionListEnabled();

    public String toString() {
        String result = this.getName() + " [" + this.configOptionType.toString() + "], isOptionEnabled = " + Boolean.toString(this.isOptionEnabled()) + ", value=(" + this.getCurrentValueAsString() + ")";
        if (this.hasNestedConfigOptionList()) {
            result = result + "\n ...NestedConfigOptionList: {\n" + this.getNestedConfigOptionList().toString() + "}";
        }
        return result;
    }

    public void release() {
        this.setTagObject(null);
        this.setMemoryServerOwnedTagObject(null);
        if (this.hasNestedConfigOptionList()) {
            ((ConfigOptionList)this.getNestedConfigOptionList()).release();
            this.setNestedConfigOptionList(null);
        }
    }

    @Override
    public int compareTo(IConfigOption o) {
        int result = 0;
        if (this.rank > o.getRank()) {
            result = 1;
        } else if (this.rank < o.getRank()) {
            result = -1;
        }
        return result;
    }
}

