/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.configoptions;

import com.ti.ccstudio.debug.memoryserver.configoptions.ConfigOption;
import com.ti.ccstudio.debug.memoryserver.configoptions.EnumConfigOptionType;
import com.ti.ccstudio.debug.memoryserver.configoptions.IConfigOption;
import com.ti.ccstudio.debug.memoryserver.configoptions.IConfigOptionList;
import java.util.Iterator;
import java.util.Vector;

public class ConfigOptionList
extends ConfigOption
implements Iterator<IConfigOption>,
Iterable<IConfigOption>,
IConfigOptionList,
Cloneable {
    private final Vector<IConfigOption> list = new Vector();
    private int currentIndex = -1;
    private boolean isEventNotificationDisabled = true;

    public ConfigOptionList(String name, ConfigOption owner) {
        super(name, EnumConfigOptionType.CONFIG_OPTION_LIST, 0, "", 0, "", owner, null, true);
        if (owner != null) {
            this.setRank(owner.getRank());
            this.setCategoryName(owner.getCategoryName());
            this.setCategoryRank(owner.getCategoryRank());
            this.setDescription(owner.getDescription());
            this.setIsOptionEnabled(owner.isOptionEnabled());
        }
    }

    public ConfigOptionList(IConfigOptionList listToCopyFrom, ConfigOption owner) {
        super(listToCopyFrom.getName(), EnumConfigOptionType.CONFIG_OPTION_LIST, listToCopyFrom.getRank(), listToCopyFrom.getCategoryName(), listToCopyFrom.getCategoryRank(), listToCopyFrom.getDescription(), owner, null, listToCopyFrom.isOptionEnabled());
        this.setName(listToCopyFrom.getName());
        this.setOwner(owner);
        this.setMemoryServerOwnedTagObject(((ConfigOption)((Object)listToCopyFrom)).getMemoryServerOwnedTagObject());
    }

    @Override
    public IConfigOptionList clone(IConfigOption cloneOwner) {
        ConfigOptionList result = new ConfigOptionList(this, (ConfigOption)cloneOwner);
        for (IConfigOption option : this) {
            result.add(option.clone(cloneOwner));
        }
        result.setDefaultValues(this);
        result.setCurrentValues(this);
        if (this.hasNestedConfigOptionList()) {
            result.setNestedConfigOptionList(this.getNestedConfigOptionList().clone(result));
        }
        return result;
    }

    public Vector<IConfigOption> getList() {
        return this.list;
    }

    @Override
    public void add(IConfigOption item) {
        this.list.add(item);
    }

    @Override
    public IConfigOption get(int index) {
        IConfigOption result = null;
        if (index < 0 || index >= this.list.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        result = this.list.get(index);
        return result;
    }

    @Override
    public IConfigOption findByName(String name) {
        IConfigOption result = null;
        for (IConfigOption option : this.list) {
            if (!option.getName().equalsIgnoreCase(name)) continue;
            result = option;
            break;
        }
        return result;
    }

    @Override
    public IConfigOption findOptionByNameAndType(IConfigOption optionToSearchFor) {
        IConfigOption result = null;
        for (IConfigOption optionInThisList : this) {
            if (!optionInThisList.getName().equalsIgnoreCase(optionToSearchFor.getName()) || optionInThisList.getConfigOptionType() != optionToSearchFor.getConfigOptionType()) continue;
            result = optionInThisList;
        }
        return result;
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public void remove(int index) {
        this.list.remove(index);
    }

    private void reset() {
        this.currentIndex = -1;
    }

    @Override
    public boolean hasNext() {
        boolean result = false;
        if (this.currentIndex < this.list.size() - 1) {
            result = true;
        }
        return result;
    }

    @Override
    public IConfigOption next() {
        IConfigOption result = null;
        if (this.hasNext()) {
            ++this.currentIndex;
            result = this.list.get(this.currentIndex);
        }
        return result;
    }

    @Override
    public void remove() {
        if (this.currentIndex >= 0 && this.currentIndex < this.list.size()) {
            this.remove(this.currentIndex);
            if (this.currentIndex >= this.list.size()) {
                this.currentIndex = this.list.size() - 1;
            }
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    @Override
    public Iterator<IConfigOption> iterator() {
        this.reset();
        return this.list.iterator();
    }

    @Override
    public void setCurrentValues(IConfigOptionList listOfOptionsToGetValuesFrom) {
        for (IConfigOption option : this) {
            IConfigOption optionToCopy = listOfOptionsToGetValuesFrom.findOptionByNameAndType(option);
            if (optionToCopy == null) continue;
            option.setCurrentValue(option);
        }
    }

    @Override
    public void setDefaultValues(IConfigOptionList listOfOptionsToGetValuesFrom) {
        for (IConfigOption option : this) {
            IConfigOption optionToCopy = listOfOptionsToGetValuesFrom.findOptionByNameAndType(option);
            if (optionToCopy == null) continue;
            option.setDefaultValue(optionToCopy);
        }
    }

    @Override
    public EnumConfigOptionType getConfigOptionType() {
        return EnumConfigOptionType.CONFIG_OPTION_LIST;
    }

    @Override
    public boolean hasNestedConfigOptionList() {
        return this.nestedConfigOptionList != null;
    }

    @Override
    public boolean isNestedConfigOptionListEnabled() {
        return this.hasNestedConfigOptionList();
    }

    @Override
    public String getValueAsXmlString() {
        return null;
    }

    @Override
    public void setValueFromXmlString(String value) {
    }

    @Override
    public String getXmlPropertyName() {
        return this.getName().replace(" ", "%20");
    }

    @Override
    public boolean isCurrentValueEqualToDefault() {
        return true;
    }

    @Override
    public boolean isEventNotificationDisabled() {
        return this.isEventNotificationDisabled;
    }

    @Override
    public void setIsEventNotificationDisabled(boolean value) {
        this.isEventNotificationDisabled = value;
    }

    @Override
    public void setCurrentValue(IConfigOption anotherConfigOptionOfTheSameTypeToGetValueFrom) {
    }

    @Override
    public void setDefaultValue(IConfigOption anotherConfigOptionOfTheSameTypeToGetValueFrom) {
    }

    @Override
    public int compareTo(IConfigOption o) {
        int result = 0;
        if (this.getRank() > o.getRank()) {
            result = 1;
        } else if (this.getRank() < o.getRank()) {
            result = -1;
        }
        return result;
    }

    @Override
    public String getCurrentValueAsString() {
        return "";
    }

    @Override
    public void setCurrentValueFromString(String newValue) {
    }

    @Override
    public boolean validate(Object value, String[] errorString) {
        return true;
    }

    @Override
    public String toString() {
        String result = this.getName() + " [" + this.getConfigOptionType().toString() + "], isOptionEnabled = " + Boolean.toString(this.isOptionEnabled()) + "\n";
        int index = 0;
        for (IConfigOption option : this) {
            result = result + "item[" + Integer.toString(index++) + "]: " + option.toString() + "\n";
        }
        this.getCurrentValueAsString();
        if (this.hasNestedConfigOptionList()) {
            result = result + "\n ...NestedConfigOptionList: {\n" + this.getNestedConfigOptionList().toString() + "}";
        }
        return result;
    }

    @Override
    public void release() {
        for (IConfigOption option : this.list) {
            ((ConfigOption)option).release();
        }
        this.list.clear();
        super.release();
    }
}

