/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.configoptions;

import com.ti.ccstudio.debug.memoryserver.configoptions.ConfigOption;
import com.ti.ccstudio.debug.memoryserver.configoptions.ConfigOptionList;
import com.ti.ccstudio.debug.memoryserver.configoptions.EnumConfigOptionType;
import com.ti.ccstudio.debug.memoryserver.configoptions.IConfigOption;
import com.ti.ccstudio.debug.memoryserver.configoptions.IConfigOption_Boolean;

public class ConfigOption_Boolean
extends ConfigOption
implements IConfigOption_Boolean {
    protected boolean currentValue;
    protected boolean defaultValue;

    public ConfigOption_Boolean(String configOptionName, int rank, boolean defaultValue, String categoryName, int categoryRank, String description, ConfigOption owner, ConfigOptionList nestedListOfConfigOptions, boolean isOptionEnabled) {
        super(configOptionName, EnumConfigOptionType.BOOLEAN, rank, categoryName, categoryRank, description, owner, nestedListOfConfigOptions, isOptionEnabled);
        this.currentValue = defaultValue;
        this.defaultValue = defaultValue;
    }

    ConfigOption_Boolean(ConfigOption_Boolean objToCopyFrom, ConfigOption owner) {
        super(objToCopyFrom.getName(), EnumConfigOptionType.BOOLEAN, objToCopyFrom.getRank(), objToCopyFrom.getCategoryName(), objToCopyFrom.getCategoryRank(), objToCopyFrom.getDescription(), owner, null, objToCopyFrom.isOptionEnabled());
        this.setMemoryServerOwnedTagObject(objToCopyFrom.getMemoryServerOwnedTagObject());
        this.currentValue = objToCopyFrom.getCurrentValue();
        this.defaultValue = objToCopyFrom.getDefaultValue();
    }

    @Override
    public IConfigOption clone(IConfigOption cloneOwner) {
        ConfigOption_Boolean result = new ConfigOption_Boolean(this, (ConfigOption)cloneOwner);
        if (this.hasNestedConfigOptionList()) {
            result.setNestedConfigOptionList(this.getNestedConfigOptionList().clone(result));
        }
        result.setTagObject(this.getTagObject());
        return result;
    }

    @Override
    public boolean getCurrentValue() {
        return this.currentValue;
    }

    @Override
    public void setCurrentValue(boolean value) {
        this.currentValue = value;
    }

    @Override
    public boolean getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(boolean value) {
        this.defaultValue = value;
    }

    @Override
    public boolean validate(Object value, String[] errorString) {
        errorString[0] = "OK";
        boolean result = true;
        return result;
    }

    @Override
    public String getCurrentValueAsString() {
        String result = Boolean.toString(this.currentValue);
        return result;
    }

    @Override
    public void setCurrentValueFromString(String newValue) {
        boolean isNumeric = true;
        boolean result = false;
        try {
            long longValue = Long.parseLong(newValue);
            if (longValue != 0L) {
                result = true;
            }
        }
        catch (Exception e) {
            isNumeric = false;
        }
        if (!isNumeric) {
            try {
                result = Boolean.parseBoolean(newValue);
            }
            catch (Exception e) {
                result = false;
            }
        }
        this.currentValue = result;
    }

    @Override
    public boolean isCurrentValueEqualToDefault() {
        boolean result = this.defaultValue == this.currentValue;
        return result;
    }

    @Override
    public String getTooltipText() {
        String result = this.getName();
        return result;
    }

    @Override
    public boolean isNestedConfigOptionListEnabled() {
        boolean result = this.currentValue && this.isOptionEnabled() && this.hasNestedConfigOptionList();
        return result;
    }

    @Override
    public void setCurrentValue(IConfigOption optionToGetValueFrom) {
        if (optionToGetValueFrom instanceof ConfigOption_Boolean) {
            ConfigOption_Boolean booleanOptionToGetValueFrom = (ConfigOption_Boolean)optionToGetValueFrom;
            this.setIsOptionEnabled(booleanOptionToGetValueFrom.isOptionEnabled());
            this.setCurrentValue(booleanOptionToGetValueFrom.getCurrentValue());
            if (this.hasNestedConfigOptionList() && booleanOptionToGetValueFrom.hasNestedConfigOptionList()) {
                this.getNestedConfigOptionList().setCurrentValues(booleanOptionToGetValueFrom.getNestedConfigOptionList());
            }
        } else {
            throw new ClassCastException("ConfigOption_Boolean.setCurrentValue(" + optionToGetValueFrom.getConfigOptionType().toString() + ")");
        }
    }

    @Override
    public void setDefaultValue(IConfigOption optionToGetValueFrom) {
        if (optionToGetValueFrom instanceof ConfigOption_Boolean) {
            ConfigOption_Boolean booleanOptionToGetValueFrom = (ConfigOption_Boolean)optionToGetValueFrom;
            this.setDefaultValue(booleanOptionToGetValueFrom.getDefaultValue());
            if (this.hasNestedConfigOptionList() && booleanOptionToGetValueFrom.hasNestedConfigOptionList()) {
                this.getNestedConfigOptionList().setDefaultValues(booleanOptionToGetValueFrom.getNestedConfigOptionList());
            }
        } else {
            throw new ClassCastException("ConfigOption_Boolean.setDefaultValue(" + optionToGetValueFrom.getConfigOptionType().toString() + ")");
        }
    }
}

