/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.configoptions;

import com.ti.ccstudio.debug.memoryserver.configoptions.ConfigOption;
import com.ti.ccstudio.debug.memoryserver.configoptions.ConfigOptionList;
import com.ti.ccstudio.debug.memoryserver.configoptions.EnumConfigOptionType;
import com.ti.ccstudio.debug.memoryserver.configoptions.IConfigOption;
import com.ti.ccstudio.debug.memoryserver.configoptions.IConfigOption_ListOfStrings;
import java.util.ArrayList;

public class ConfigOption_ListOfStrings
extends ConfigOption
implements IConfigOption_ListOfStrings {
    private int currentIndex = 0;
    private int defaultIndex = 0;
    protected ArrayList<String> listOfStrings = null;

    public ConfigOption_ListOfStrings(String configOptionName, int rank, ArrayList<String> listOfStrings, int defaultIndex, String categoryName, int categoryRank, String description, ConfigOption owner, ConfigOptionList nestedListOfConfigOptions, boolean isOptionEnabled) {
        super(configOptionName, EnumConfigOptionType.LIST_OF_STRINGS, rank, categoryName, categoryRank, description, owner, nestedListOfConfigOptions, isOptionEnabled);
        this.currentIndex = defaultIndex;
        this.defaultIndex = defaultIndex;
        this.listOfStrings = new ArrayList();
        this.listOfStrings.addAll(listOfStrings);
    }

    ConfigOption_ListOfStrings(ConfigOption_ListOfStrings objToCopyFrom, ConfigOption owner) {
        super(objToCopyFrom.getName(), objToCopyFrom.getConfigOptionType(), objToCopyFrom.getRank(), objToCopyFrom.getCategoryName(), objToCopyFrom.getCategoryRank(), objToCopyFrom.getDescription(), owner, null, objToCopyFrom.isOptionEnabled());
        this.currentIndex = objToCopyFrom.getCurrentIndex();
        this.defaultIndex = objToCopyFrom.getDefaultIndex();
        this.setMemoryServerOwnedTagObject(objToCopyFrom.getMemoryServerOwnedTagObject());
        this.listOfStrings = new ArrayList();
        this.listOfStrings.addAll(objToCopyFrom.getListOfStrings());
    }

    @Override
    public IConfigOption clone(IConfigOption owner) {
        ConfigOption_ListOfStrings result = new ConfigOption_ListOfStrings(this, (ConfigOption)owner);
        if (this.hasNestedConfigOptionList()) {
            result.setNestedConfigOptionList(this.getNestedConfigOptionList().clone(result));
        }
        result.setTagObject(this.getTagObject());
        return result;
    }

    @Override
    public int getCurrentIndex() {
        return this.currentIndex;
    }

    @Override
    public boolean setCurrentIndex(int index, String[] errorString) {
        boolean result = this.validate(index, errorString);
        if (result) {
            this.currentIndex = index;
        }
        return result;
    }

    @Override
    public String getCurrentValueAsString() {
        return Integer.toString(this.getCurrentIndex());
    }

    @Override
    public int getDefaultIndex() {
        return this.defaultIndex;
    }

    public boolean setDefaultIndex(int index, String[] errorString) {
        boolean result = this.validate(index, errorString);
        if (result) {
            this.defaultIndex = index;
        }
        return result;
    }

    @Override
    public ArrayList<String> getListOfStrings() {
        return this.listOfStrings;
    }

    public void setListOfStrings(ArrayList<String> value) {
        this.listOfStrings = value;
    }

    @Override
    public boolean validate(Object value, String[] errorString) {
        errorString[0] = "OK";
        boolean result = true;
        if (value == null) {
            result = false;
            errorString[0] = "null value entered.";
        } else if (!(value instanceof Integer)) {
            result = false;
            errorString[0] = "Entered value is not an Integer (index into the list of strings)";
        } else {
            int index = (Integer)value;
            if (index < 0) {
                result = false;
                errorString[0] = "Index must be > 0";
            } else if (this.listOfStrings == null) {
                result = false;
                errorString[0] = "List of strings is null.";
            } else if (this.listOfStrings.size() == 0) {
                result = false;
                errorString[0] = "Empty list of strings";
            } else if (index >= this.listOfStrings.size()) {
                result = false;
                errorString[0] = "Index must be < " + Integer.toString(this.listOfStrings.size()) + " (number of items in list)";
            }
        }
        return result;
    }

    @Override
    public String getSelectedString() {
        String result = "";
        if (this.currentIndex < 0 || this.currentIndex >= this.listOfStrings.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        result = this.listOfStrings.get(this.currentIndex);
        return result;
    }

    @Override
    public void setCurrentValueFromString(String strIndex) {
        this.currentIndex = Integer.parseInt(strIndex);
    }

    @Override
    public boolean isCurrentValueEqualToDefault() {
        boolean result = this.defaultIndex == this.currentIndex;
        return result;
    }

    @Override
    public String getTooltipText() {
        return this.getName();
    }

    @Override
    public boolean isNestedConfigOptionListEnabled() {
        boolean result = this.hasNestedConfigOptionList();
        return result;
    }

    @Override
    public void setCurrentValue(IConfigOption optionToGetValueFrom) {
        if (optionToGetValueFrom instanceof ConfigOption_ListOfStrings) {
            ConfigOption_ListOfStrings option = (ConfigOption_ListOfStrings)optionToGetValueFrom;
            String[] errorString = new String[]{""};
            this.setCurrentIndex(option.getCurrentIndex(), errorString);
            this.setIsOptionEnabled(option.isOptionEnabled());
            if (this.hasNestedConfigOptionList() && option.hasNestedConfigOptionList()) {
                this.getNestedConfigOptionList().setCurrentValues(option.getNestedConfigOptionList());
            }
        } else {
            throw new ClassCastException("ConfigOption_ListOfStrings.setCurrentValue(" + optionToGetValueFrom.getConfigOptionType().toString() + ")");
        }
    }

    @Override
    public void setDefaultValue(IConfigOption optionToGetValueFrom) {
        String[] strErrorInfo = new String[]{""};
        if (optionToGetValueFrom instanceof ConfigOption_ListOfStrings) {
            ConfigOption_ListOfStrings option = (ConfigOption_ListOfStrings)optionToGetValueFrom;
            this.setDefaultIndex(option.getDefaultIndex(), strErrorInfo);
            if (this.hasNestedConfigOptionList() && option.hasNestedConfigOptionList()) {
                this.getNestedConfigOptionList().setDefaultValues(option.getNestedConfigOptionList());
            }
        } else {
            throw new ClassCastException("ConfigOption_ListOfStrings.setDefaultValue(" + optionToGetValueFrom.getConfigOptionType().toString() + ")");
        }
    }

    @Override
    public String toString() {
        String result = this.getName() + " [" + this.getConfigOptionType().toString() + "], isOptionEnabled = " + Boolean.toString(this.isOptionEnabled()) + ", value=(" + this.getCurrentValueAsString() + ")";
        result = result + "\n ...List of Strings = { ";
        int index = 0;
        for (String item : this.listOfStrings) {
            result = result + item;
            if (++index >= this.listOfStrings.size()) continue;
            result = result + ", ";
        }
        result = result + " }";
        if (this.hasNestedConfigOptionList()) {
            result = result + "\n ...NestedConfigOptionList: {\n" + this.getNestedConfigOptionList().toString() + "}";
        }
        return result;
    }

    @Override
    public String getDefaultStringInList() {
        String result = this.listOfStrings.get(this.currentIndex);
        return result;
    }
}

