/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.configoptions;

import com.ti.ccstudio.debug.memoryserver.configoptions.ConfigOption;
import com.ti.ccstudio.debug.memoryserver.configoptions.ConfigOptionList;
import com.ti.ccstudio.debug.memoryserver.configoptions.EnumConfigOptionType;
import com.ti.ccstudio.debug.memoryserver.configoptions.IConfigOption;
import com.ti.ccstudio.debug.memoryserver.configoptions.IConfigOption_Long;

public class ConfigOption_Long
extends ConfigOption
implements IConfigOption_Long {
    private long currentValue = 0L;
    private long defaultValue = 0L;
    private long minValue = 0L;
    private long maxValue = Long.MAX_VALUE;

    public ConfigOption_Long(String configOptionName, int rank, long defaultValue, long minValue, long maxValue, String categoryName, int categoryRank, String description, ConfigOption owner, ConfigOptionList nestedListOfConfigOptions, boolean isOptionEnabled) {
        super(configOptionName, EnumConfigOptionType.LONG, rank, categoryName, categoryRank, description, owner, nestedListOfConfigOptions, isOptionEnabled);
        this.defaultValue = defaultValue;
        this.currentValue = defaultValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    ConfigOption_Long(ConfigOption_Long objToCopyFrom, ConfigOption owner) {
        super(objToCopyFrom.getName(), objToCopyFrom.getConfigOptionType(), objToCopyFrom.getRank(), objToCopyFrom.getCategoryName(), objToCopyFrom.getCategoryRank(), objToCopyFrom.getDescription(), owner, null, objToCopyFrom.isOptionEnabled());
        this.defaultValue = objToCopyFrom.getDefaultValue();
        this.currentValue = objToCopyFrom.getCurrentValue();
        this.setMemoryServerOwnedTagObject(objToCopyFrom.getMemoryServerOwnedTagObject());
        this.minValue = objToCopyFrom.getMinValue();
        this.maxValue = objToCopyFrom.getMaxValue();
    }

    @Override
    public IConfigOption clone(IConfigOption cloneOwner) {
        ConfigOption_Long result = new ConfigOption_Long(this, (ConfigOption)cloneOwner);
        result.currentValue = this.getCurrentValue();
        if (this.hasNestedConfigOptionList()) {
            result.setNestedConfigOptionList(this.getNestedConfigOptionList().clone(result));
        }
        result.setTagObject(this.getTagObject());
        return result;
    }

    @Override
    public long getCurrentValue() {
        return this.currentValue;
    }

    @Override
    public boolean setCurrentValue(long value, String[] errorString) {
        boolean result = this.validate(value, errorString);
        if (result) {
            this.currentValue = value;
        }
        return result;
    }

    @Override
    public long getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(long value) {
        this.defaultValue = value;
    }

    @Override
    public long getMinValue() {
        return this.minValue;
    }

    public void setMinValue(long value) {
        this.minValue = value;
    }

    @Override
    public long getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(long value) {
        this.maxValue = value;
    }

    @Override
    public boolean validate(Object value, String[] errorString) {
        errorString[0] = "OK";
        boolean result = true;
        if (value == null || !(value instanceof Long)) {
            result = false;
            errorString[0] = "Entered value is not a Long.";
        } else {
            long longValue = (Long)value;
            if (longValue < this.minValue) {
                result = false;
                errorString[0] = "Value must be >= " + Long.toString(this.minValue) + " [0x" + Long.toHexString(this.minValue) + "]";
            } else if (longValue > this.maxValue) {
                result = false;
                errorString[0] = "Value must be <= " + Long.toString(this.maxValue) + " [0x" + Long.toHexString(this.maxValue) + "]";
            }
        }
        return result;
    }

    @Override
    public String getCurrentValueAsString() {
        String result = "";
        long longValue = this.currentValue;
        result = Long.toString(longValue) + " [0x" + Long.toHexString(longValue) + "]";
        return result;
    }

    @Override
    public void setCurrentValueFromString(String newValue) {
        if (newValue.indexOf("0x") >= 0) {
            String valueWithoutPrefix = newValue.substring(newValue.indexOf("0x"), newValue.length());
            this.currentValue = Long.parseLong(valueWithoutPrefix, 16);
        } else {
            this.currentValue = Long.parseLong(newValue);
        }
    }

    @Override
    public String getValueAsXmlString() {
        String result = "";
        long longValue = this.currentValue;
        result = Long.toString(longValue);
        return result;
    }

    @Override
    public boolean isCurrentValueEqualToDefault() {
        boolean result = this.defaultValue == this.currentValue;
        return result;
    }

    @Override
    public String getTooltipText() {
        return this.getName() + ":" + this.getCurrentValueAsString();
    }

    @Override
    public boolean isNestedConfigOptionListEnabled() {
        boolean result = this.hasNestedConfigOptionList();
        return result;
    }

    @Override
    public void setCurrentValue(IConfigOption optionToGetValueFrom) {
        if (optionToGetValueFrom instanceof ConfigOption_Long) {
            ConfigOption_Long longOptionToGetValueFrom = (ConfigOption_Long)optionToGetValueFrom;
            String[] errorString = new String[]{""};
            this.setCurrentValue(longOptionToGetValueFrom.getCurrentValue(), errorString);
            this.setIsOptionEnabled(longOptionToGetValueFrom.isOptionEnabled());
            if (this.hasNestedConfigOptionList() && longOptionToGetValueFrom.hasNestedConfigOptionList()) {
                this.getNestedConfigOptionList().setCurrentValues(longOptionToGetValueFrom.getNestedConfigOptionList());
            }
        } else {
            throw new ClassCastException("ConfigOption_Long.setCurrentValue(" + optionToGetValueFrom.getConfigOptionType().toString() + ")");
        }
    }

    @Override
    public void setDefaultValue(IConfigOption optionToGetValueFrom) {
        if (optionToGetValueFrom instanceof ConfigOption_Long) {
            ConfigOption_Long longOptionToGetValueFrom = (ConfigOption_Long)optionToGetValueFrom;
            this.setDefaultValue(longOptionToGetValueFrom.getDefaultValue());
            if (this.hasNestedConfigOptionList() && longOptionToGetValueFrom.hasNestedConfigOptionList()) {
                this.getNestedConfigOptionList().setDefaultValues(longOptionToGetValueFrom.getNestedConfigOptionList());
            }
        } else {
            throw new ClassCastException("ConfigOption_Long.setDefaultValue(" + optionToGetValueFrom.getConfigOptionType().toString() + ")");
        }
    }
}

