/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.configoptions;

import com.ti.ccstudio.debug.memoryserver.configoptions.ConfigOption;
import com.ti.ccstudio.debug.memoryserver.configoptions.ConfigOptionList;
import com.ti.ccstudio.debug.memoryserver.configoptions.ConfigOption_Boolean;
import com.ti.ccstudio.debug.memoryserver.configoptions.IConfigOption;
import com.ti.ccstudio.debug.memoryserver.configoptions.IConfigOption_Boolean;
import com.ti.ccstudio.debug.memoryserver.enums.EnumAttributeTypeFlags;
import java.util.EnumSet;

public class ConfigOption_MemoryAnalysisEnable
extends ConfigOption_Boolean
implements IConfigOption_Boolean {
    private boolean isCacheTagRamSupported = false;

    public ConfigOption_MemoryAnalysisEnable(ConfigOption owner, ConfigOptionList listOfMemoryAnalyzerOptions, boolean isCacheTagRamSupported) {
        super("Memory Analysis", 3, false, "Memory Analysis", 3, "", owner, listOfMemoryAnalyzerOptions, true);
        this.setDescription("When enabled, a selection of Memory Analyzers are made available to choose from which can be used to highlight a variety of potential cache coherency violation conditions.Disable to reduce the time it takes to update the display.");
    }

    public ConfigOption_MemoryAnalysisEnable(ConfigOption_MemoryAnalysisEnable objToCopyFrom, ConfigOption owner) {
        super(objToCopyFrom.getName(), objToCopyFrom.getRank(), objToCopyFrom.getDefaultValue(), objToCopyFrom.getCategoryName(), objToCopyFrom.getCategoryRank(), objToCopyFrom.getDescription(), owner, null, objToCopyFrom.isOptionEnabled());
        this.setCurrentValue(this.getDefaultValue());
        this.setMemoryServerOwnedTagObject(objToCopyFrom.getMemoryServerOwnedTagObject());
    }

    @Override
    public ConfigOption_MemoryAnalysisEnable clone(IConfigOption cloneOwner) {
        ConfigOption_MemoryAnalysisEnable result = new ConfigOption_MemoryAnalysisEnable(this, (ConfigOption)cloneOwner);
        result.setCurrentValue(this.getCurrentValue());
        if (this.hasNestedConfigOptionList()) {
            result.setNestedConfigOptionList(this.getNestedConfigOptionList().clone(result));
        }
        result.setTagObject(this.getTagObject());
        return result;
    }

    public EnumSet<EnumAttributeTypeFlags> getAttributeFlags() {
        EnumSet<EnumAttributeTypeFlags> result = EnumSet.of(EnumAttributeTypeFlags.LOCATION_IN_MEMORY_HIERARCHY);
        if (this.isMemoryAnalysisEnabled() && this.isCacheTagRamSupported) {
            result.add(EnumAttributeTypeFlags.CACHE_TAG_RAM_DETAILS);
        }
        return result;
    }

    public boolean isMemoryAnalysisEnabled() {
        boolean result = false;
        if (this.isOptionEnabled()) {
            result = this.getCurrentValue();
        }
        return result;
    }

    public void setIsMemoryAnalysisEnabled(boolean value) {
        this.currentValue = value;
        if (this.isOptionEnabled() && this.hasNestedConfigOptionList()) {
            for (IConfigOption option : this.getNestedConfigOptionList()) {
                option.setIsOptionEnabled(value);
            }
        }
    }

    @Override
    public void setCurrentValue(boolean value) {
        this.setIsMemoryAnalysisEnabled(value);
    }

    @Override
    public void setCurrentValueFromString(String newValue) {
        boolean value = Boolean.parseBoolean(newValue);
        this.setIsMemoryAnalysisEnabled(value);
    }

    @Override
    public void setCurrentValue(IConfigOption anotherConfigOptionOfTheSameTypeToGetValueFrom) {
        ConfigOption_Boolean otherOption = null;
        if (anotherConfigOptionOfTheSameTypeToGetValueFrom instanceof ConfigOption_Boolean) {
            otherOption = (ConfigOption_Boolean)anotherConfigOptionOfTheSameTypeToGetValueFrom;
            if (otherOption != null) {
                boolean value = otherOption.getCurrentValue();
                this.setIsMemoryAnalysisEnabled(value);
            }
        } else {
            throw new ClassCastException("ConfigOption_MemoryAnalysisEnable.setCurrentValue(" + anotherConfigOptionOfTheSameTypeToGetValueFrom.getConfigOptionType().toString() + ")");
        }
    }

    @Override
    public String getTooltipText() {
        return "Enables Memory Analysis";
    }

    public boolean isCacheTagRamSupported() {
        return this.isCacheTagRamSupported;
    }

    public void setIsCacheTagRamSupported(boolean value) {
        this.isCacheTagRamSupported = value;
    }
}

