/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.configoptions;

import com.ti.ccstudio.debug.memoryserver.configoptions.ConfigOption;
import com.ti.ccstudio.debug.memoryserver.configoptions.EnumConfigOptionType;
import com.ti.ccstudio.debug.memoryserver.configoptions.EnumMemoryLevelVisibilityMode;
import com.ti.ccstudio.debug.memoryserver.configoptions.IConfigOption;
import com.ti.ccstudio.debug.memoryserver.configoptions.IConfigOption_MemoryLevelEnable;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryLevelIndex;
import com.ti.ccstudio.debug.memoryserver.memoryhierarchy.MemoryTypeDescriptor;

public class ConfigOption_MemoryLevelEnable
extends ConfigOption
implements IConfigOption_MemoryLevelEnable {
    private boolean canBeBypassed = false;
    private boolean isBypassed = true;
    private boolean isBypassedByDefault = true;
    private boolean isCache = true;
    private MemoryTypeDescriptor memoryTypeDescriptor = null;
    private EnumMemoryLevelIndex memoryLevelIndex = EnumMemoryLevelIndex.NONE;
    private EnumMemoryLevelVisibilityMode memoryLevelVisibilityModeConfig = EnumMemoryLevelVisibilityMode.CACHE_VISIBILITY;

    public ConfigOption_MemoryLevelEnable(MemoryTypeDescriptor memType, int rank, boolean isBypassedByDefault, String categoryName, int categoryRank, String description, ConfigOption owner) {
        super(memType.getName(), EnumConfigOptionType.MEMORY_LEVEL_ENABLE, rank, categoryName, categoryRank, description, owner, null, true);
        this.memoryLevelIndex = memType.getMemoryLevelIndex();
        this.isCache = memType.isCache();
        this.canBeBypassed = memType.canBeBypassed();
        this.isBypassedByDefault = isBypassedByDefault;
        this.isBypassed = isBypassedByDefault;
        this.setMemoryTypeDescriptor(memType);
    }

    public ConfigOption_MemoryLevelEnable(ConfigOption_MemoryLevelEnable objToCopyFrom, ConfigOption owner) {
        super(objToCopyFrom.getName(), objToCopyFrom.getConfigOptionType(), objToCopyFrom.getRank(), objToCopyFrom.getCategoryName(), objToCopyFrom.getCategoryRank(), objToCopyFrom.getDescription(), owner, null, objToCopyFrom.isOptionEnabled());
        this.memoryLevelIndex = objToCopyFrom.getMemoryLevelIndex();
        this.setIsCache(objToCopyFrom.isCache());
        this.canBeBypassed = objToCopyFrom.canBeBypassed();
        this.setIsBypassedByDefault(objToCopyFrom.isBypassedByDefault());
        this.setIsBypassed(objToCopyFrom.isBypassed());
        this.setMemoryTypeDescriptor(objToCopyFrom.getMemoryTypeDescriptor());
        this.setMemoryServerOwnedTagObject(objToCopyFrom.getMemoryServerOwnedTagObject());
    }

    @Override
    public IConfigOption clone(IConfigOption cloneOwner) {
        ConfigOption_MemoryLevelEnable result = new ConfigOption_MemoryLevelEnable(this, (ConfigOption)cloneOwner);
        if (this.hasNestedConfigOptionList()) {
            result.setNestedConfigOptionList(this.getNestedConfigOptionList().clone(result));
        }
        result.setTagObject(this.getTagObject());
        return result;
    }

    @Override
    public boolean canBeBypassed() {
        return this.canBeBypassed;
    }

    @Override
    public boolean isBypassed() {
        return this.isBypassed;
    }

    @Override
    public void setIsBypassed(boolean value) {
        this.isBypassed = value;
    }

    @Override
    public boolean isBypassedByDefault() {
        return this.isBypassedByDefault;
    }

    public void setIsBypassedByDefault(boolean value) {
        this.isBypassedByDefault = value;
    }

    @Override
    public boolean isCache() {
        return this.isCache;
    }

    public void setIsCache(boolean value) {
        this.isCache = value;
    }

    @Override
    public MemoryTypeDescriptor getMemoryTypeDescriptor() {
        return this.memoryTypeDescriptor;
    }

    public void setMemoryTypeDescriptor(MemoryTypeDescriptor value) {
        this.memoryTypeDescriptor = value;
    }

    @Override
    public EnumMemoryLevelIndex getMemoryLevelIndex() {
        return this.memoryLevelIndex;
    }

    @Override
    public EnumMemoryLevelVisibilityMode getMemoryLevelVisibilityModeConfig() {
        return this.memoryLevelVisibilityModeConfig;
    }

    public void setMemoryLevelVisibilityModeConfig(EnumMemoryLevelVisibilityMode value) {
        this.memoryLevelVisibilityModeConfig = value;
        String name = this.getName();
        switch (value) {
            case NONE: 
            case CACHE_VISIBILITY: {
                this.setIsOptionEnabled(this.isCache());
                if (!this.isCache || name.indexOf(" Cache") >= 0) break;
                this.setName(name + " Cache");
                break;
            }
            case MEMORY_LEVEL_VISIBILITY: {
                this.setIsOptionEnabled(true);
                int index = name.indexOf(" Cache");
                if (index < 0) break;
                this.setName(name.substring(0, index));
            }
        }
    }

    @Override
    public boolean validate(Object value, String[] errorString) {
        errorString[0] = "OK";
        boolean result = true;
        if (value == null) {
            result = false;
            errorString[0] = "null value entered.";
        } else if (!(value instanceof Boolean)) {
            result = false;
            errorString[0] = "Entered value is not a Boolean value.";
        }
        return result;
    }

    @Override
    public String getCurrentValueAsString() {
        String result = "";
        if (this.isOptionEnabled() && this.isBypassed) {
            result = "Cache Bypassed";
        }
        return result;
    }

    @Override
    public void setCurrentValueFromString(String newValue) {
        this.isBypassed = newValue.equalsIgnoreCase("Cache Bypassed") ? this.canBeBypassed : false;
    }

    @Override
    public boolean isCurrentValueEqualToDefault() {
        boolean result = this.isBypassedByDefault == this.isBypassed;
        return result;
    }

    @Override
    public String getTooltipText() {
        String result = "";
        switch (this.memoryLevelVisibilityModeConfig) {
            case NONE: {
                result = this.getToolTipText_NoMemoryLevelVisibility();
                break;
            }
            case MEMORY_LEVEL_VISIBILITY: {
                result = this.getToolTipText_MemoryLevelVisibility();
                break;
            }
            case CACHE_VISIBILITY: {
                result = this.getToolTipText_CacheVisibility();
            }
        }
        return result;
    }

    private String getToolTipText_MemoryLevelVisibility() {
        String retval = "";
        if (this.isCache()) {
            retval = "When checked, " + this.getName() + " mapped memory and cache contents are displayed with this background color." + "\nWhen unchecked, the memory view bypasses the " + this.getName() + " cache contents and only mapped memory is displayed with this background color.";
        } else if (this.getName().length() > 0) {
            retval = this.getName() + " memory is displayed with this background color";
        }
        return retval;
    }

    public String getToolTipText_CacheVisibility() {
        String retval = "";
        if (this.isCache()) {
            retval = "When checked, " + this.getName() + " cache contents are displayed with this background color." + "\nWhen unchecked, the memory view bypasses the " + this.getName() + " cache contents.";
        }
        return retval;
    }

    public String getToolTipText_NoMemoryLevelVisibility() {
        String retval = "";
        if (this.isCache()) {
            retval = "When checked, " + this.getName() + " cache contents are displayed." + "\nWhen unchecked, the memory view bypasses the " + this.getName() + " cache contents.";
        }
        return retval;
    }

    @Override
    public boolean isNestedConfigOptionListEnabled() {
        return false;
    }

    @Override
    public void setCurrentValue(IConfigOption anotherConfigOptionOfTheSameType) {
        if (!(anotherConfigOptionOfTheSameType instanceof ConfigOption_MemoryLevelEnable)) {
            throw new ClassCastException("ConfigOption_MemoryLevelEnable.setCurrentValue(" + anotherConfigOptionOfTheSameType.getConfigOptionType().toString() + ")");
        }
        ConfigOption_MemoryLevelEnable option = (ConfigOption_MemoryLevelEnable)anotherConfigOptionOfTheSameType;
        this.setIsBypassed(option.isBypassed());
    }

    @Override
    public void setDefaultValue(IConfigOption anotherConfigOptionOfTheSameType) {
        if (!(anotherConfigOptionOfTheSameType instanceof ConfigOption_MemoryLevelEnable)) {
            throw new ClassCastException("ConfigOption_MemoryLevelEnable.setDefaultValue(" + anotherConfigOptionOfTheSameType.getConfigOptionType().toString() + ")");
        }
        ConfigOption_MemoryLevelEnable option = (ConfigOption_MemoryLevelEnable)anotherConfigOptionOfTheSameType;
        this.setIsBypassedByDefault(option.isBypassedByDefault());
    }

    @Override
    public String toString() {
        String result = super.toString() + ", canBeBypassed = " + Boolean.toString(this.canBeBypassed) + ", isBypassed=" + Boolean.toString(this.isBypassed) + ", isBypassedByDefault=" + Boolean.toString(this.isBypassedByDefault());
        return result;
    }
}

